/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Optics.xProvisioningError;
import cerent.cms.idl.OpticsTopology.xBusy;
import cerent.cms.idl.OpticsTopology.xCannotPerform;
import cerent.cms.model.ANS.ANSManager;
import cerent.cms.model.ANS.ANSSideInfo;
import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class InstWoMpModels
extends Model {
    private NodeModelDelegate nmd;
    private boolean inited = false;
    private static NodeSingletonFactory<InstWoMpModels> sfactory = new NodeSingletonFactory<InstWoMpModels>(InstWoMpModels.class);
    private ANSSideInfo[] instWoMpList;
    private ANSSideInfo infoRef;
    private ANSManager ansManager;
    private InstWoMpInfo instWoMpInfoRef;
    private EventDispatcher dispatcher;
    private boolean firstRetrieve;

    private InstWoMpModels(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(InstWoMpModels.class));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.instWoMpInfoRef = new InstWoMpInfo(this.nmd);
    }

    public static InstWoMpModels getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    protected void updateLocal() {
        super.updateLocal();
    }

    public synchronized void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("Got update from " + observable + " arg=" + object);
        }
        if (observable instanceof CmsObservable) {
            int n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
            switch (n) {
                case 1: {
                    this.setChanged();
                    this.notifyObservers();
                    break;
                }
            }
        }
    }

    public void init() {
        super.init0();
        if (!this.inited) {
            this.reloadModel();
            this.ansManager = this.nmd.getANSManager();
            this.dispatcher = this.nmd.getDispatcher();
            this.regObserver();
            this.inited = true;
        }
    }

    private void regObserver() {
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectDwdmAnsParCalc, 0, (Observer)this);
        }
    }

    private void delObserver() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmAnsParCalc, 0, (Observer)this);
            this.dispatcher = null;
        }
    }

    public void setFirstRetrieve(boolean bl) {
        this.firstRetrieve = bl;
    }

    public boolean getFirstRetrieve() {
        return this.firstRetrieve;
    }

    public int getNumLines() {
        try {
            this.instWoMpList = this.ansManager.getDefaultsAnsSideList();
        }
        catch (Exception exception) {
            this.db.println(exception.toString());
        }
        if (this.instWoMpList != null && this.getFirstRetrieve()) {
            return this.instWoMpList.length;
        }
        return 0;
    }

    public Object[] getGlobalInstData() {
        try {
            this.instWoMpList = this.ansManager.getDefaultsAnsSideList();
        }
        catch (Exception exception) {
            this.db.println(exception.toString());
        }
        return this.instWoMpList;
    }

    public String[] getInstData(int n) {
        return this.getInstDataBySide(n);
    }

    private String[] getInstDataBySide(int n) {
        String[] stringArray = null;
        try {
            this.instWoMpList = this.ansManager.getDefaultsAnsSideList();
        }
        catch (Exception exception) {
            this.db.println(exception.toString());
        }
        for (int i = 0; i < this.instWoMpList.length; ++i) {
            this.infoRef = this.instWoMpList[i];
            stringArray[0] = this.infoRef.getSide();
            stringArray[1] = this.infoRef.getResult();
            stringArray[2] = this.infoRef.getNotes();
            if (stringArray[0].equalsIgnoreCase(Integer.toString(n))) break;
        }
        return stringArray;
    }

    public void dispose() {
        super.dispose();
        this.inited = false;
        this.delObserver();
    }

    public void destroy() {
        super.destroy();
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public void executeAnsCal(String string) throws CannotPerform, Busy, ProvisionError {
        try {
            this.instWoMpInfoRef.set(Float.valueOf(Float.valueOf(string.trim()).floatValue()));
        }
        catch (xCannotPerform xCannotPerform2) {
            throw new CannotPerform("executeAnsCal Error");
        }
        catch (xBusy xBusy2) {
            throw new Busy("executeAnsCal Error");
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError("executeAnsCal Error");
        }
        catch (UserException userException) {
            KDebug.printStackTrace((Throwable)userException);
        }
    }

    private void reloadModel() {
    }

    private class InstWoMpInfo
    extends NonCachedValue {
        public InstWoMpInfo(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        protected void setValue(Object object) throws xCannotPerform, xBusy, xProvisioningError {
            int n = (int)(((Float)object).floatValue() * 10.0f);
            if (InstWoMpModels.this.db.on) {
                InstWoMpModels.this.db.println(this.getClass() + "::setValue");
            }
            this.node.getIorRepository().getDwdmOpticalSetupRef().calculateAnsParams(n);
        }

        public Object outer() {
            return InstWoMpModels.this;
        }
    }
}

