/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.General;
import cerent.cms.idl.If.eALSMode;
import cerent.cms.idl.If.sInterface;
import cerent.cms.model.AbstractPersistableModelState;
import cerent.cms.model.AccessCountPersistableCachedValue;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PersistableCachedValue;
import cerent.cms.model.event.AttributeValue;
import cerent.util.SDebug;
import java.util.ArrayList;
import org.omg.CORBA.UserException;

public class InterfaceAttrs
extends AbstractPersistableModelState {
    private HigherLayerIndexes higherLayerIndexes;
    private LowerLayerIndexes lowerLayerIndexes;
    private Alias alias;
    private Info info;
    private IsALSSupported isALSSupported;
    private ALSMode alsMode;
    private ALSRecoveryInt alsRecoveryInt;
    private ALSPulseWidth alsPulseWidth;
    private HasLaserBeenShutdown hasLaserBeenShutdown;

    public static int getCookie() {
        return 1;
    }

    public InterfaceAttrs(InterfaceModel interfaceModel) {
        INodeModel iNodeModel = interfaceModel == null ? null : interfaceModel.getNodeModel();
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)iNodeModel;
        this.alias = new Alias(nodeModelDelegate, "InterfaceModel.alias");
        this.info = new Info(nodeModelDelegate, "InterfaceModel.info");
        this.higherLayerIndexes = new HigherLayerIndexes(nodeModelDelegate, "InterfaceModel.higherLayerIndexes");
        this.lowerLayerIndexes = new LowerLayerIndexes(nodeModelDelegate, "InterfaceModel.lowerLayerIndexes");
        this.isALSSupported = new IsALSSupported("isALSSupported", nodeModelDelegate);
        this.alsMode = new ALSMode("alsMode", nodeModelDelegate);
        this.alsRecoveryInt = new ALSRecoveryInt("alsRecoveryInt", nodeModelDelegate);
        this.alsPulseWidth = new ALSPulseWidth("alsPulseWidth", nodeModelDelegate);
        this.hasLaserBeenShutdown = new HasLaserBeenShutdown("hasLaserBeenShutdown", nodeModelDelegate);
        if (interfaceModel != null) {
            this._linkModel(interfaceModel.getModelType(this), interfaceModel);
        }
    }

    public InterfaceAttrs() {
        this(null);
    }

    InterfaceModel getIFModel() {
        return (InterfaceModel)this.getModel();
    }

    General getIfRef() {
        InterfaceModel interfaceModel = this.getIFModel();
        return interfaceModel == null ? null : interfaceModel.getIfRef();
    }

    Alias getAlias() {
        return this.alias;
    }

    Info getInfo() {
        return this.info;
    }

    HigherLayerIndexes getHigherLayerIndexes() {
        return this.higherLayerIndexes;
    }

    LowerLayerIndexes getLowerLayerIndexes() {
        return this.lowerLayerIndexes;
    }

    IsALSSupported getIsALSSupported() {
        return this.isALSSupported;
    }

    ALSMode getAlsMode() {
        return this.alsMode;
    }

    ALSRecoveryInt getAlsRecoveryInt() {
        return this.alsRecoveryInt;
    }

    ALSPulseWidth getAlsPulseWidth() {
        return this.alsPulseWidth;
    }

    HasLaserBeenShutdown getHasLaserBeenShutdown() {
        return this.hasLaserBeenShutdown;
    }

    protected void updateAttributes(ArrayList arrayList, long l) {
        block3: for (AttributeValue attributeValue : arrayList) {
            switch (attributeValue.getName()) {
                case 0: {
                    this.getInfo().setValueExternally(attributeValue);
                    continue block3;
                }
            }
            this.update(l);
        }
        this.indicateWriteAccess(l);
    }

    protected boolean permitPcvUpdate(PersistableCachedValue persistableCachedValue) {
        return persistableCachedValue != this.higherLayerIndexes && persistableCachedValue != this.lowerLayerIndexes;
    }

    private class ALSMode
    extends AccessCountPersistableCachedValue {
        public ALSMode(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return InterfaceAttrs.this.getIfRef().getALSMode(InterfaceAttrs.this.getIndex());
        }

        protected void setValue(Object object) throws UserException {
            InterfaceAttrs.this.getIfRef().setALSMode(InterfaceAttrs.this.getIndex(), (eALSMode)object);
        }

        protected Class getObjectClass() {
            return eALSMode.class;
        }
    }

    private class ALSPulseWidth
    extends AccessCountPersistableCachedValue {
        public ALSPulseWidth(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(InterfaceAttrs.this.getIfRef().getALSRecoveryPulseWidth(InterfaceAttrs.this.getIndex()));
        }

        protected void setValue(Object object) throws UserException {
            InterfaceAttrs.this.getIfRef().setALSRecoveryPulseWidth(InterfaceAttrs.this.getIndex(), (Short)object);
        }

        protected Class getObjectClass() {
            return Short.class;
        }
    }

    private class ALSRecoveryInt
    extends AccessCountPersistableCachedValue {
        public ALSRecoveryInt(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(InterfaceAttrs.this.getIfRef().getALSRecoveryInterval(InterfaceAttrs.this.getIndex()));
        }

        protected void setValue(Object object) throws UserException {
            InterfaceAttrs.this.getIfRef().setALSRecoveryInterval(InterfaceAttrs.this.getIndex(), (Short)object);
        }

        protected Class getObjectClass() {
            return Short.class;
        }
    }

    private class Alias
    extends AccessCountPersistableCachedValue {
        public Alias(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            String string = InterfaceAttrs.this.getIfRef().getAlias(InterfaceAttrs.this.getIndex());
            SDebug sDebug = InterfaceAttrs.this.getDb();
            if (sDebug.on()) {
                sDebug.println("Alias.getValue(" + string + ")");
            }
            return string;
        }

        protected void setValue(Object object) throws UserException {
            SDebug sDebug = InterfaceAttrs.this.getDb();
            if (sDebug.on()) {
                sDebug.println("Alias.setValue(" + (String)object + ")");
            }
            InterfaceAttrs.this.getIfRef().setAlias(InterfaceAttrs.this.getIndex(), (String)object);
        }

        protected Class getObjectClass() {
            return String.class;
        }
    }

    private class HasLaserBeenShutdown
    extends AccessCountPersistableCachedValue {
        public HasLaserBeenShutdown(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(InterfaceAttrs.this.getIfRef().hasLaserBeenShutdown(InterfaceAttrs.this.getIndex()));
        }

        protected Class getObjectClass() {
            return Boolean.class;
        }
    }

    private class HigherLayerIndexes
    extends LayerIndexes {
        public HigherLayerIndexes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return InterfaceAttrs.this.getIfRef().getHigherLayer(InterfaceAttrs.this.getIndex());
        }
    }

    private class Info
    extends AccessCountPersistableCachedValue {
        public Info(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sInterface sInterface2 = InterfaceAttrs.this.getIfRef().getInfo(InterfaceAttrs.this.getIndex());
            SDebug sDebug = InterfaceAttrs.this.getDb();
            if (sDebug.on()) {
                sDebug.println("Info.getValue(" + sInterface2.descr + ")");
            }
            return sInterface2;
        }

        protected Object cloneValue() {
            sInterface sInterface2 = null;
            if (this.value != null) {
                sInterface sInterface3 = (sInterface)this.value;
                byte[] byArray = new byte[sInterface3.physAddr.length];
                System.arraycopy(sInterface3.physAddr, 0, byArray, 0, sInterface3.physAddr.length);
                sInterface2 = new sInterface(sInterface3.ifType, sInterface3.name, sInterface3.descr, sInterface3.ifSpeed, sInterface3.connectorPresent, sInterface3.portIndex, sInterface3.operStatus, sInterface3.adminState, sInterface3.lastChange, byArray, sInterface3.ifMtu, sInterface3.slotNumber, sInterface3.portNumber, sInterface3.muxIndex, sInterface3.ainsSoakTime, sInterface3.serviceState, sInterface3.facLoopbackAIS, sInterface3.termLoopbackAIS, sInterface3.shelfId);
            }
            return sInterface2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setValueExternally(AttributeValue attributeValue) {
            switch (attributeValue.getName()) {
                case 0: {
                    Info info = this;
                    synchronized (info) {
                        sInterface sInterface2 = (sInterface)this.value;
                        sInterface2.serviceState = (sServiceState)attributeValue.getValue();
                        break;
                    }
                }
            }
        }

        protected Class getObjectClass() {
            return sInterface.class;
        }
    }

    private class IsALSSupported
    extends AccessCountPersistableCachedValue {
        public IsALSSupported(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(InterfaceAttrs.this.getIfRef().isALSSupported(InterfaceAttrs.this.getIndex()));
        }

        protected Class getObjectClass() {
            return Boolean.class;
        }
    }

    private abstract class LayerIndexes
    extends AccessCountPersistableCachedValue {
        public LayerIndexes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object cloneValue() {
            int[] nArray = (int[])this.value;
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Class getObjectClass() {
            return int[].class;
        }
    }

    private class LowerLayerIndexes
    extends LayerIndexes {
        public LowerLayerIndexes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return InterfaceAttrs.this.getIfRef().getLowerLayer(InterfaceAttrs.this.getIndex());
        }
    }
}

