/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Common.sStsInfo;
import cerent.cms.idl.Ds123Media.sDs123Attributes;
import cerent.cms.idl.Dwdm.sClientLineAttributes;
import cerent.cms.idl.Dwdm.sGFPAttributes;
import cerent.cms.idl.Dwdm.sPassThruAttributes;
import cerent.cms.idl.Dwdm.sTrunkLineAttributes;
import cerent.cms.idl.EtherL2Media.sL2EtherAttributes;
import cerent.cms.idl.EtherMedia.sEtherAttributes;
import cerent.cms.idl.FCMedia.General;
import cerent.cms.idl.FCMedia.sFCAttributes;
import cerent.cms.idl.If.eIfType;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.Optics.sGeneralOpticsAttributes;
import cerent.cms.idl.Optics.sOchAllocationAttributes;
import cerent.cms.idl.Optics.sOpticalChannelAttributes;
import cerent.cms.idl.Optics.sOpticalLineAmplifierAttributes;
import cerent.cms.idl.Optics.sOpticalMultiplexSectionAttributes;
import cerent.cms.idl.SonetMedia.sSonetLineAttributes;
import cerent.cms.idl.SonetMedia.sStsAttributes;
import cerent.cms.idl.SonetMedia.sVtAttributes;
import cerent.cms.idl.SonetMedia.sVtInfo;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmOTULineModel;
import cerent.cms.model.DwdmPayloadLineModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EtherBackPlaneModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherMediaModel;
import cerent.cms.model.EtherPortModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.GfpLineModel;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.HdGePortModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IInterfaceModels;
import cerent.cms.model.IModelPersistenceConstants;
import cerent.cms.model.IModelPersistenceStrategy;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.L2scEtherLineModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.L2scPosLineModel;
import cerent.cms.model.ML2FastELineModel;
import cerent.cms.model.ML2GigELineModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.model.PersistableCachedValue;
import cerent.cms.model.PortModel;
import cerent.cms.model.RamanOpticsLineModel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmLoModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.util.KDebug;
import cerent.util.LongHolder;
import cerent.util.SDebug;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadWorker;
import cerent.util.threadpool.ThreadPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class InterfaceModels
extends Model
implements IInterfaceModels {
    private static boolean VERSION_2_1 = true;
    private static final long UNINITIALIZED_SEQ_NUM = -1L;
    private static final short NO_SLOT = -1;
    private static NodeSingletonFactory<InterfaceModels> sfactory = new NodeSingletonFactory<InterfaceModels>(InterfaceModels.class);
    private Object neHigherLayerModelsLock = new Object();
    private SDebug tdmHoDebug;
    private static final SDebug ifDb = new SDebug("IfRetriever");
    private NodeModelDelegate node;
    private String hostName;
    private EventDispatcher dispatcher;
    private Map ifModels = new HashMap();
    private Info info;
    private HashMap ifCache;
    protected int waitCount;
    private SonetLineInterfaces sonetIf;
    private TrunkLineInterfaces dwdmTrunkIf;
    private ClientLineInterfaces dwdmClientIf;
    private GFPInterfaces gfpIf;
    private DwdmPayloadInterfaces dwdmPayloadIf;
    private DwdmOTUInterfaces dwdmOTUIf;
    private Ds123LineInterfaces ds123If;
    private VtInterfaces vtIf;
    private StsInterfaces stsIf;
    private EtherInterfaces etherIf;
    private EtherL2Interfaces etherL2If;
    private FCInterfaces fcIf;
    private GetStsIndex getStsIndex;
    private GetVtIndex getVtIndex;
    private PosInterfaces posIf;
    private static final String IFS_DEBUG_KEY = "Ifs";

    public static InterfaceModels getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private InterfaceModels(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.setDebug(nodeModelDelegate.getChildDebug(InterfaceModels.class, Debug.class, this));
        this.tdmHoDebug = nodeModelDelegate.getChildDebug(TdmHoModel.class);
        this.index = 0;
        this.node = nodeModelDelegate;
        this.dispatcher = nodeModelDelegate.getDispatcher();
        this.hostName = nodeModelDelegate.getHostName();
        this.info = new Info(nodeModelDelegate, "InterfaceModels::info");
        this.sonetIf = new SonetLineInterfaces("InterfaceModels::SonetLineInterfaces");
        this.dwdmTrunkIf = new TrunkLineInterfaces("InterfaceModels::TrunkLineInterfaces");
        this.gfpIf = new GFPInterfaces("InterfaceModels.GFPInterfaces");
        this.dwdmPayloadIf = new DwdmPayloadInterfaces("InterfaceModels.DwdmPayloadInterfaces");
        this.dwdmOTUIf = new DwdmOTUInterfaces("InterfaceModels.DwdmOTUInterfaces");
        this.dwdmClientIf = new ClientLineInterfaces("InterfaceModels::ClientLineInterfaces");
        this.ds123If = new Ds123LineInterfaces("InterfaceModels::Ds123LineInterfaces");
        this.vtIf = new VtInterfaces("InterfaceModels::VtInterfaces");
        this.stsIf = new StsInterfaces("InterfaceModels::StsInterfaces");
        this.etherIf = new EtherInterfaces("InterfaceModels::EtherInterfaces");
        this.etherL2If = new EtherL2Interfaces("InterfaceModels::EtherL2Interfaces");
        this.fcIf = new FCInterfaces("InterfaceModels::FCInterfaces");
        this.getStsIndex = new GetStsIndex(nodeModelDelegate, "InterfaceModels::getStsIndex");
        this.getVtIndex = new GetVtIndex(nodeModelDelegate, "InterfaceModels::getVtIndex");
        this.posIf = new PosInterfaces("InterfaceModels::PosInterfaces");
        super.init0();
        if (nodeModelDelegate.db.getChild(IFS_DEBUG_KEY) == null) {
            new IfsDebug(nodeModelDelegate.db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getIfModels() {
        HashMap hashMap = null;
        Map map = this.ifModels;
        synchronized (map) {
            hashMap = new HashMap(this.ifModels);
        }
        return hashMap;
    }

    public IInterfaceModel findInterfaceModelInCache(IPortModel iPortModel) {
        return this.findInterfaceModelInCache((PortModel)iPortModel);
    }

    public IInterfaceModel getInterfaceModel(IPortModel iPortModel) {
        return this.getInterfaceModel((PortModel)iPortModel);
    }

    public IInterfaceModel getInterfaceModelByIndex(int n) throws NoSuchInterface {
        return this.getInterfaceModel(n);
    }

    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    protected NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    protected EventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public InterfaceModel findInterfaceModelInCache(PortModel portModel) {
        return this.findInterfaceModelInCache(portModel.getEntityIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InterfaceModel findInterfaceModelInCache(int n) {
        Integer n2 = new Integer(n);
        InterfaceModel interfaceModel = null;
        Map map = this.ifModels;
        synchronized (map) {
            if (this.ifModels.containsKey(n2)) {
                if (this.db.on()) {
                    this.db.fine("findInterfaceModelInCache(" + Integer.toHexString(n) + "): InterfaceModel in cache.");
                }
                interfaceModel = (InterfaceModel)this.ifModels.get(n2);
            }
        }
        if (this.db.on() && interfaceModel == null) {
            this.db.fine("findInterfaceModelInCache(" + Integer.toHexString(n) + "): InterfaceModel not in cache.");
        }
        return interfaceModel;
    }

    public Object getNeHigherLayerModelsLock() {
        return this.neHigherLayerModelsLock;
    }

    public synchronized InterfaceModel[] getAllInterfaceModels(ModuleModel moduleModel) {
        HashSet hashSet = new HashSet();
        List list = moduleModel.getDescendantsOfClassType(7);
        Iterator iterator = list.iterator();
        Collection<IInterfaceModel> collection = new ArrayList();
        while (iterator.hasNext()) {
            PortModel portModel = (PortModel)iterator.next();
            IInterfaceModel iInterfaceModel = portModel.getInterfaceModel();
            if (iInterfaceModel == null) continue;
            collection.add(iInterfaceModel);
        }
        hashSet.addAll(collection);
        do {
            collection = InterfaceModel.getHigherLayerModels(collection, moduleModel);
            hashSet.addAll(collection);
        } while (collection.size() != 0);
        return hashSet.toArray(new InterfaceModel[0]);
    }

    public synchronized InterfaceModel[] getAllInterfaceModelsExcept(ModuleModel moduleModel, Class clazz) {
        HashSet hashSet = new HashSet();
        List list = moduleModel.getDescendantsOfClassType(7);
        Iterator iterator = list.iterator();
        Collection<IInterfaceModel> collection = new ArrayList();
        while (iterator.hasNext()) {
            PortModel portModel = (PortModel)iterator.next();
            Object object = portModel.getInterfaceModel();
            if (object == null || clazz.isInstance(object)) continue;
            collection.add((IInterfaceModel)object);
        }
        hashSet.addAll(collection);
        do {
            collection = InterfaceModel.getHigherLayerModels(collection, moduleModel);
            for (Object object : collection) {
                if (clazz.isInstance(object)) continue;
                hashSet.add(object);
            }
        } while (collection.size() != 0);
        return hashSet.toArray(new InterfaceModel[0]);
    }

    public synchronized InterfaceModel getInterfaceModel(PortModel portModel) {
        InterfaceModel interfaceModel = this.findInterfaceModelInCache(portModel);
        if (interfaceModel == null) {
            long l = 0L;
            IModuleModel iModuleModel = portModel.getModuleModel();
            if (this.db.on()) {
                l = System.currentTimeMillis();
                this.db.fine("Time Before getAll " + l);
            }
            this.getAllInterfaces((IEntityModel)iModuleModel);
            if (this.db.on()) {
                this.db.fine("Total time for get all " + (System.currentTimeMillis() - l));
            }
            interfaceModel = this.findInterfaceModelInCache(portModel);
        }
        if (interfaceModel == null) {
            if (this.db.on) {
                this.db.finest("Tried Searching still can't find interface for " + portModel.getEqTypeName() + "!!");
            }
            return null;
        }
        this.notifyAll();
        return interfaceModel;
    }

    public InterfaceModel getInterfaceModel(int n) throws NoSuchInterface {
        return this.getInterfaceModel(n, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceModel getInterfaceModel(int n, long l) throws NoSuchInterface {
        Integer n2 = new Integer(n);
        String string = Integer.toHexString(n);
        InterfaceModel interfaceModel = null;
        if (this.db.on()) {
            this.db.fine("getInterfaceModel(" + string + "): entry");
        }
        Map map = this.ifModels;
        synchronized (map) {
            if (this.ifModels.containsKey(n2)) {
                if (this.db.on()) {
                    this.db.fine("getInterfaceModel(" + string + "): InterfaceModel in cache.");
                }
                interfaceModel = (InterfaceModel)this.ifModels.get(n2);
            }
        }
        if (interfaceModel != null) {
            return interfaceModel;
        }
        if (this.db.on()) {
            this.db.fine("getInterfaceModel(" + string + "): InterfaceModel not in cache. Creating a new model.");
        }
        return this.getNewInterfaceModel(n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterfaceModel getNewInterfaceModel(int n, long l) throws NoSuchInterface {
        Integer n2 = new Integer(n);
        String string = Integer.toHexString(n);
        sInterface sInterface2 = null;
        InterfaceModel interfaceModel = null;
        try {
            sInterface2 = (sInterface)this.info.get(n2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getNewInterfaceModel", userException);
        }
        interfaceModel = this.createInterfaceModel(sInterface2.ifType.value(), n);
        if (interfaceModel == null) {
            throw new NoSuchInterface("No interface model for " + sInterface2.ifType.value() + " with the index " + n + " can be found.");
        }
        Map map = this.ifModels;
        synchronized (map) {
            this.ifModels.put(n2, interfaceModel);
        }
        interfaceModel.handleIfModelInterconnect();
        if (this.db.on()) {
            this.db.fine("getNewInterfaceModel(): created " + interfaceModel);
        }
        interfaceModel.allAttributesIndicateWriteAccess(l);
        return interfaceModel;
    }

    private InterfaceModel createInterfaceModel(int n, int n2) {
        if (this.db.on()) {
            this.db.fine("createInterfaceModel( " + this.hostName + ", " + n + ", " + n2 + ")");
        }
        InterfaceModel interfaceModel = null;
        switch (n) {
            case 1: 
            case 12: 
            case 13: 
            case 14: {
                interfaceModel = new Ds1LineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 2: {
                interfaceModel = new Ds123LineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 5: {
                interfaceModel = new TdmLineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 7: {
                interfaceModel = new TdmLoModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 6: {
                interfaceModel = new TdmHoModel(this.getNodeModelDelegate(), n2, this.tdmHoDebug);
                break;
            }
            case 0: {
                interfaceModel = this.getEtherInterfaceModel(n2);
                break;
            }
            case 16: {
                interfaceModel = new DwdmCliLineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 17: {
                interfaceModel = new DwdmTrkLineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 18: {
                interfaceModel = new OpticsLineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 19: {
                interfaceModel = new OpticsAmplifiedLineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 21: {
                interfaceModel = new OpticsChannelModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 20: {
                interfaceModel = new OpticsMultiplexSectionModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 22: {
                interfaceModel = new FcmrLineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 24: 
            case 25: {
                interfaceModel = new DwdmPayloadLineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 23: {
                interfaceModel = new GfpLineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 28: {
                interfaceModel = new XPL2Layer2LineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 27: {
                interfaceModel = new DwdmOTULineModel(this.getNodeModelDelegate(), n2);
                break;
            }
            case 26: {
                interfaceModel = new OpticsOchTermModel(this.getNodeModelDelegate(), n2);
                break;
            }
            default: {
                if (!this.db.on()) break;
                this.db.fine("no specific type found for " + n);
                SDebug.printStackTrace((Throwable)new Exception());
            }
        }
        return interfaceModel;
    }

    private InterfaceModel[] getModels(int[] nArray) throws NoSuchInterface {
        InterfaceModel[] interfaceModelArray = new InterfaceModel[nArray.length];
        if (this.db.on()) {
            this.db.fine("getModels(): list.length = " + nArray.length);
        }
        for (int i = 0; i < nArray.length; ++i) {
            interfaceModelArray[i] = this.getInterfaceModel(nArray[i]);
            if (!this.db.on()) continue;
            this.db.fine("list[" + i + "] = " + Integer.toHexString(nArray[i]) + "\n    " + interfaceModelArray[i].toString() + "\n    ----------");
        }
        return interfaceModelArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        if (this.db.on()) {
            this.db.fine("remove(" + Integer.toHexString(n) + ")");
        }
        Map map = this.ifModels;
        synchronized (map) {
            this.ifModels.remove(new Integer(n));
        }
    }

    public void remove(InterfaceModel interfaceModel) {
        this.remove(interfaceModel.getIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findAllInSlot(IChassisModel iChassisModel, short s) {
        ArrayList arrayList;
        if (this.db.on()) {
            this.db.fine("findAllInSlot: slotNum = " + s + " shelfId = " + iChassisModel.getShelfId());
        }
        Object object = this.ifModels;
        synchronized (object) {
            arrayList = new ArrayList(this.ifModels.values());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            InterfaceModel interfaceModel = (InterfaceModel)object.next();
            if (interfaceModel.getSlotNum() == s && interfaceModel.getShelfNum() == iChassisModel.getShelfId()) continue;
            object.remove();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInterfaceModels() {
        try {
            this.db.println("InterfaceModel list for node \n\tIndex\tHigher\tLower\tDescription");
            ArrayList arrayList = new ArrayList();
            Map map = this.ifModels;
            synchronized (map) {
                arrayList.addAll(this.ifModels.values());
                Collections.sort(arrayList, new Comparator(){

                    public int compare(Object object, Object object2) {
                        if (object instanceof InterfaceModel) {
                            InterfaceModel interfaceModel = (InterfaceModel)object;
                            if (object2 instanceof InterfaceModel) {
                                InterfaceModel interfaceModel2 = (InterfaceModel)object2;
                                return new Integer(interfaceModel.getIndex()).compareTo(new Integer(interfaceModel2.getIndex()));
                            }
                            return 1;
                        }
                        return -1;
                    }
                });
            }
            for (InterfaceModel interfaceModel : arrayList) {
                int n = interfaceModel.getIndex();
                interfaceModel.updateLayerIndexes();
                int[] nArray = interfaceModel.getHigherLayerIndexes();
                int[] nArray2 = interfaceModel.getLowerLayerIndexes();
                this.db.print("\t" + Integer.toHexString(n));
                if (nArray != null && nArray.length > 0) {
                    this.db.print("\t" + Integer.toHexString(nArray[0]));
                } else {
                    this.db.print("\t");
                }
                if (nArray2 != null && nArray2.length > 0) {
                    this.db.print("\t" + Integer.toHexString(nArray2[0]));
                } else {
                    this.db.print("\t");
                }
                this.db.println("\t" + interfaceModel.toString());
            }
        }
        catch (Exception exception) {
            this.db.println("Caught unexpected Exception in InterfaceModels.dumpInterfaceModels...");
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAccessCounts() {
        try {
            this.db.println("InterfaceModel access counts for node ");
            Map map = this.ifModels;
            synchronized (map) {
                for (InterfaceModel interfaceModel : this.ifModels.values()) {
                    int n = interfaceModel.getIndex();
                    this.db.println(interfaceModel.getClass().getName() + " - " + n);
                    Iterator iterator = interfaceModel.getAttributeNames();
                    while (iterator.hasNext()) {
                        PersistableCachedValue persistableCachedValue;
                        long l;
                        String string = (String)iterator.next();
                        NonCachedValue nonCachedValue = (NonCachedValue)interfaceModel.getAttributeByName(string);
                        if (!(nonCachedValue instanceof PersistableCachedValue) || (l = (persistableCachedValue = (PersistableCachedValue)nonCachedValue).getAccessCount()) < 0L) continue;
                        this.db.println("  " + string + ": " + l);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.db.println("Caught unexpected Exception in InterfaceModels.dumpAccessCounts...");
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public void destroy() {
        super.destroy();
    }

    public void init() {
        super.init0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.db.on()) {
            this.db.fine("dispose(): local cache cleanup");
        }
        Map map = this.ifModels;
        synchronized (map) {
            Iterator iterator = this.ifModels.values().iterator();
            while (iterator.hasNext()) {
                InterfaceModel interfaceModel = (InterfaceModel)iterator.next();
                iterator.remove();
                interfaceModel.destroy();
            }
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAllInterfaces(IEntityModel iEntityModel) {
        if (iEntityModel == null) {
            if (this.db.isFinerEnabled()) {
                this.db.finer("card passed to getAllInterfaces was null");
            }
            return;
        }
        int n = NonCachedValue.getCounter();
        try {
            this.ifCache = new HashMap();
            this.waitCount = 0;
            ModuleModel moduleModel = (ModuleModel)iEntityModel.getModuleModel();
            if (moduleModel != null) {
                moduleModel.setInterfacesInited(true);
            } else if (this.db.on()) {
                this.db.fine("Unable call setInterfacesInited(true),becuase ModuleModel ref was null");
            }
            try {
                Set set = this.getRetrievers(iEntityModel);
                for (IfRetriever ifRetriever : set) {
                    ThreadPool.instance().enqueueClient((IActionClient)ifRetriever);
                }
                this.waitTillDone();
                this.secondParse();
                this.ifCache = null;
            }
            catch (Throwable throwable) {
                if (moduleModel != null) {
                    moduleModel.setInterfacesInited(false);
                } else if (this.db.on()) {
                    this.db.fine("Unable call setInterfacesInited(false),becuase ModuleModel ref was null");
                }
                if (this.db.on()) {
                    this.db.fine("Throwable caught in getAllInterface() on" + moduleModel.toString());
                    SDebug.printStackTrace((Throwable)throwable);
                }
            }
        }
        finally {
            NonCachedValue.setCounter(n);
        }
    }

    protected Set getRetrievers(IEntityModel iEntityModel) {
        int n = iEntityModel.getParent().getIndex();
        int n2 = iEntityModel.getEqType();
        HashSet<IfRetriever> hashSet = new HashSet<IfRetriever>();
        switch (iEntityModel.getEqType()) {
            case 62: 
            case 63: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 187: 
            case 221: 
            case 238: 
            case 283: 
            case 284: 
            case 285: {
                hashSet.add(new EthIfRetriever(n));
                break;
            }
            case 183: 
            case 184: 
            case 243: 
            case 282: {
                hashSet.add(new GfpIfRetriever(n));
            }
            case 120: 
            case 121: {
                hashSet.add(new DwdmPayloadIfRetriever(n));
            }
            case 181: {
                hashSet.add(new FCIfRetriever(n));
            }
            case 118: {
                hashSet.add(new EthIfRetriever(n));
            }
            case 119: 
            case 182: 
            case 276: {
                hashSet.add(new DwdmTrkIfRetriever(n));
                hashSet.add(new DwdmCliIfRetriever(n));
                hashSet.add(new SonetLineIfRetriever(n));
                break;
            }
            case 271: 
            case 272: {
                hashSet.add(new EthIfRetriever(n));
                hashSet.add(new EthL2IfRetriever(n));
                hashSet.add(new DwdmTrkIfRetriever(n));
                hashSet.add(new DwdmCliIfRetriever(n));
                hashSet.add(new SonetLineIfRetriever(n));
                if (n2 != 272) break;
                int n3 = iEntityModel.getIndex();
                hashSet.add(new Ds123IfRetriever(n3));
                break;
            }
            case 274: 
            case 275: {
                hashSet.add(new DwdmOTUIfRetriever(n));
                hashSet.add(new FCIfRetriever(n));
                hashSet.add(new EthIfRetriever(n));
                hashSet.add(new DwdmTrkIfRetriever(n));
                hashSet.add(new DwdmCliIfRetriever(n));
                hashSet.add(new SonetLineIfRetriever(n));
                break;
            }
            case 273: {
                hashSet.add(new GfpIfRetriever(n));
                hashSet.add(new EthIfRetriever(n));
                hashSet.add(new DwdmTrkIfRetriever(n));
                hashSet.add(new DwdmCliIfRetriever(n));
                hashSet.add(new SonetLineIfRetriever(n));
                break;
            }
            case 293: {
                hashSet.add(new DwdmPayloadIfRetriever(n));
                hashSet.add(new GfpIfRetriever(n));
                hashSet.add(new EthIfRetriever(n));
                hashSet.add(new DwdmTrkIfRetriever(n));
                hashSet.add(new DwdmCliIfRetriever(n));
                hashSet.add(new SonetLineIfRetriever(n));
                hashSet.add(new DwdmOTUIfRetriever(n));
                hashSet.add(new FCIfRetriever(n));
                break;
            }
            case 300: 
            case 301: {
                hashSet.add(new DwdmPayloadIfRetriever(n));
                hashSet.add(new EthIfRetriever(n));
                hashSet.add(new FCIfRetriever(n));
                hashSet.add(new DwdmTrkIfRetriever(n));
                hashSet.add(new SonetLineIfRetriever(n));
                break;
            }
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                hashSet.add(new AmplifiedLineIfRetriever(n));
                hashSet.add(new ChannelIfRetriever(n));
                hashSet.add(new LineIfRetriever(n));
                hashSet.add(new OMSIfRetriever(n));
                break;
            }
            case 249: 
            case 286: 
            case 298: 
            case 299: {
                hashSet.add(new LineIfRetriever(n));
                break;
            }
            case 266: 
            case 270: 
            case 297: {
                hashSet.add(new LineIfRetriever(n));
                hashSet.add(new OchTermIfRetriever(n));
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 191: 
            case 192: 
            case 241: 
            case 242: 
            case 263: 
            case 264: 
            case 265: 
            case 267: 
            case 268: 
            case 269: {
                hashSet.add(new ChannelIfRetriever(n));
                hashSet.add(new LineIfRetriever(n));
                hashSet.add(new OMSIfRetriever(n));
                break;
            }
            case 127: 
            case 128: {
                hashSet.add(new LineIfRetriever(n));
                hashSet.add(new SonetLineIfRetriever(n));
                break;
            }
            case 129: 
            case 130: 
            case 196: 
            case 239: 
            case 240: 
            case 277: 
            case 278: 
            case 281: 
            case 287: 
            case 321: {
                hashSet.add(new AmplifiedLineIfRetriever(n));
                hashSet.add(new LineIfRetriever(n));
                break;
            }
            case 294: 
            case 295: 
            case 296: {
                hashSet.add(new AmplifiedLineIfRetriever(n));
                hashSet.add(new LineIfRetriever(n));
                hashSet.add(new OchTermIfRetriever(n));
                break;
            }
            case 143: 
            case 144: {
                hashSet.add(new FCIfRetriever(n));
                break;
            }
            case 146: {
                hashSet.add(new AsapEthIfRetriever(n));
                hashSet.add(new AsapPosIfRetriever(n));
            }
            default: {
                hashSet.add(new SonetLineIfRetriever(n));
                IPlatform iPlatform = this.node.getPlatform();
                if (!iPlatform.suppressDsIface()) {
                    if (this.node.getSlotPolicy().needInterfaceTypeBasedDs123Ifs(n2)) {
                        hashSet.add(new XtcIfRetriever(n));
                    } else if (this.node.getSlotPolicy().needDs1Ifs(n2)) {
                        hashSet.add(new Ds1IfRetriever(n));
                    } else {
                        hashSet.add(new Ds123IfRetriever(n));
                    }
                }
                hashSet.add(new StsIfRetriever(n));
                if (!iPlatform.is600() && !iPlatform.is600SDH()) {
                    hashSet.add(new EthIfRetriever(n));
                }
                if (iPlatform.suppressVtIface()) break;
                hashSet.add(new VtIfRetriever(n));
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTillDone() {
        HashMap hashMap = this.ifCache;
        synchronized (hashMap) {
            while (this.waitCount != 0) {
                try {
                    this.ifCache.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.db.println("Exception in waitTillDone(): " + interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieverStarted() {
        HashMap hashMap = this.ifCache;
        synchronized (hashMap) {
            ++this.waitCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieverStopped(HashMap hashMap) {
        HashMap hashMap2 = this.ifCache;
        synchronized (hashMap2) {
            --this.waitCount;
            this.ifCache.putAll(hashMap);
            this.ifCache.notifyAll();
        }
    }

    private void secondParse() {
        for (InterfaceModel interfaceModel : this.ifCache.values()) {
            interfaceModel.handleIfModelInterconnect();
        }
    }

    protected InterfaceModel getEtherInterfaceModel(int n) {
        EntityModel entityModel;
        try {
            entityModel = (EntityModel)this.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                this.db.println("Failed to get entity model by ifIndex=" + n);
            }
            entityModel = null;
        }
        if (entityModel != null && entityModel instanceof HdGePortModel && entityModel.getEqType() == 63) {
            if (this.db.on()) {
                this.db.println("Creating HdgeLine for " + n);
            }
            return new HdGeLineModel(this.getNodeModelDelegate(), n);
        }
        if (entityModel != null && entityModel instanceof L2scPortModel && entityModel.getEqType() == 104) {
            if (this.db.on()) {
                this.db.println("Creating L2scEtherLine for " + n);
            }
            return new L2scEtherLineModel(this.getNodeModelDelegate(), n);
        }
        if (entityModel != null && entityModel instanceof L2scPortModel && entityModel.getEqType() == 105) {
            if (this.db.on()) {
                this.db.println("Creating L2scPosLine for " + n);
            }
            return new L2scPosLineModel(this.getNodeModelDelegate(), n);
        }
        if (entityModel != null && entityModel.getEqType() == 166) {
            if (this.db.on()) {
                this.db.println("Creating ML2FastELine for " + n);
            }
            return new ML2FastELineModel(this.getNodeModelDelegate(), n);
        }
        if (entityModel != null && entityModel.getEqType() == 230) {
            if (this.db.on()) {
                this.db.println("Creating ML2GigELineModel for " + n);
            }
            return new ML2GigELineModel(this.getNodeModelDelegate(), n);
        }
        if (entityModel != null && (entityModel.getEqType() == 165 || entityModel.getEqType() == 231)) {
            if (this.db.on()) {
                this.db.println("Creating ML2PosLine for " + n);
            }
            return new ML2PosLineModel(this.getNodeModelDelegate(), n);
        }
        if (entityModel != null && entityModel instanceof EtherPortModel) {
            if (this.db.on()) {
                this.db.println("Creating EtherLine for " + n);
            }
            return new EtherLineModel(this.getNodeModelDelegate(), n);
        }
        if (entityModel != null && (entityModel.getEqType() == 167 || entityModel.getEqType() == 316 || entityModel.getEqType() == 168 || entityModel.getEqType() == 168 || entityModel.getEqType() == 303)) {
            if (entityModel.getModuleModel() instanceof XPL2ModuleModel) {
                if (this.db.on()) {
                    this.db.println("Creating XPL2 EtherLine for " + n);
                }
                return new XPL2LineModel(this.getNodeModelDelegate(), n);
            }
            if (this.db.on()) {
                this.db.println("Creating DWDM EtherLine for " + n);
            }
            return new HdGeLineModel(this.getNodeModelDelegate(), n);
        }
        if (entityModel == null) {
            int n2 = n / 4096 * 4096 + 1;
            try {
                entityModel = (EntityModel)this.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n2);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    this.db.println("Failed to get entity model by index " + n);
                }
                entityModel = null;
            }
            if (entityModel.getEqType() == 271 || entityModel.getEqType() == 272) {
                return new XPL2LineModel(this.getNodeModelDelegate(), n);
            }
            if (entityModel != null && entityModel instanceof DwdmModuleModel) {
                if (this.db.on()) {
                    this.db.println("Creating DWDM EtherLine for " + n);
                }
                return new HdGeLineModel(this.getNodeModelDelegate(), n);
            }
        }
        if (this.db.on()) {
            this.db.println("Creating EtherBackplane for " + n);
        }
        return new EtherBackPlaneModel(this.getNodeModelDelegate(), n);
    }

    public IInterfaceModel getSts(IChassisModel iChassisModel, int n, int[] nArray, int n2) {
        IEntityModel iEntityModel = this.findPort(iChassisModel, n, nArray);
        if (iEntityModel != null) {
            IInterfaceModel iInterfaceModel = this.getLineModel((IPortModel)iEntityModel);
            return this.findSts((InterfaceModel)iInterfaceModel, n2);
        }
        return null;
    }

    protected IEntityModel findPort(IChassisModel iChassisModel, int n, int[] nArray) {
        try {
            IEntityModel iEntityModel = this.getNodeModelDelegate().getEntityTableModel().getPort(iChassisModel, n, nArray);
            return iEntityModel;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return null;
        }
    }

    protected IInterfaceModel findSts(InterfaceModel interfaceModel, int n) {
        InterfaceModel interfaceModel2 = null;
        InterfaceModel interfaceModel3 = interfaceModel2 = this.doesMatchSts(interfaceModel, n) ? interfaceModel : null;
        if (interfaceModel2 == null) {
            interfaceModel2 = this.findStsInHighers(interfaceModel, n);
        }
        return interfaceModel2;
    }

    IInterfaceModel findStsInHighers(InterfaceModel interfaceModel, int n) {
        InterfaceModel interfaceModel2;
        if (interfaceModel == null) {
            return null;
        }
        InterfaceModel[] interfaceModelArray = interfaceModel.getHigherLayerModels();
        IInterfaceModel iInterfaceModel = null;
        for (int i = 0; i < interfaceModelArray.length && (iInterfaceModel = this.findSts(interfaceModel2 = interfaceModelArray[i], n)) == null; ++i) {
        }
        return iInterfaceModel;
    }

    public IInterfaceModel getVt(IChassisModel iChassisModel, int n, int[] nArray, int n2, int n3) {
        InterfaceModel interfaceModel = (InterfaceModel)this.getSts(iChassisModel, n, nArray, n2);
        IInterfaceModel iInterfaceModel = null;
        iInterfaceModel = this.findVtInInterfaces(interfaceModel.getHigherLayerModels(), n3);
        if (iInterfaceModel == null) {
            iInterfaceModel = this.findVtInInterfaces(interfaceModel.getLowerLayerModels(), n3);
        }
        return iInterfaceModel;
    }

    IInterfaceModel findVtInInterfaces(InterfaceModel[] interfaceModelArray, int n) {
        InterfaceModel interfaceModel = null;
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            InterfaceModel interfaceModel2 = interfaceModelArray[i];
            if (!this.doesMatchVt(interfaceModel2, n)) continue;
            interfaceModel = interfaceModel2;
            break;
        }
        return interfaceModel;
    }

    public List getInterfacesInPort(IChassisModel iChassisModel, int n, int[] nArray) {
        IEntityModel iEntityModel = this.findPort(iChassisModel, n, nArray);
        ArrayList arrayList = new ArrayList();
        if (iEntityModel != null) {
            IInterfaceModel iInterfaceModel = this.getLineModel((IPortModel)iEntityModel);
            this.addAllHighers((InterfaceModel)iInterfaceModel, arrayList);
        }
        return arrayList;
    }

    void addAllHighers(InterfaceModel[] interfaceModelArray, List list) {
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            InterfaceModel interfaceModel = interfaceModelArray[i];
            this.addAllHighers(interfaceModel, list);
        }
    }

    void addAllHighers(InterfaceModel interfaceModel, List list) {
        list.add(interfaceModel);
        this.addAllHighers(interfaceModel.getHigherLayerModels(), list);
    }

    IInterfaceModel getLineModel(IPortModel iPortModel) {
        return this.getNodeModelDelegate().getIfModels().getInterfaceModel((PortModel)iPortModel);
    }

    boolean doesMatchSts(InterfaceModel interfaceModel, int n) {
        boolean bl;
        boolean bl2 = bl = interfaceModel != null && interfaceModel instanceof TdmHoModel;
        if (bl) {
            int n2 = ((TdmHoModel)interfaceModel).getStartingHoNumber();
            bl = n2 == n;
        }
        return bl;
    }

    boolean doesMatchVt(InterfaceModel interfaceModel, int n) {
        boolean bl;
        boolean bl2 = bl = interfaceModel != null && interfaceModel instanceof TdmLoModel;
        if (bl) {
            int n2 = ((TdmLoModel)interfaceModel).getStartingLoNumber();
            bl = n2 == n;
        }
        return bl;
    }

    public void update(Observable observable, Object object) {
    }

    private cerent.cms.idl.SonetMedia.General getSonetRef() {
        return this.getNodeModelDelegate().getIorRepository().getSonetRef();
    }

    private cerent.cms.idl.If.General getIfRef() {
        return this.getNodeModelDelegate().getIorRepository().getIfRef();
    }

    private cerent.cms.idl.Ds123Media.General getDs123Ref() {
        return this.getNodeModelDelegate().getIorRepository().getDs123Ref();
    }

    private cerent.cms.idl.EtherMedia.General getEtherMediaRef() {
        return this.getNodeModelDelegate().getIorRepository().getEtherMediaRef();
    }

    private cerent.cms.idl.EtherL2Media.General getEtherL2Ref() {
        return this.getNodeModelDelegate().getIorRepository().getEtherL2Ref();
    }

    private General getFCMediaRef() {
        return this.getNodeModelDelegate().getIorRepository().getFCMediaRef();
    }

    private UNKNOWN doUnknown(String string, UserException userException) {
        if (this.db.on()) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    public Integer getSTSIndex(sStsInfo sStsInfo2) throws NoSuchInterface {
        Integer n = null;
        try {
            n = (Integer)this.getStsIndex.get(sStsInfo2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getSTSIndex", userException);
        }
        return n;
    }

    public Integer getVTIndex(sVtInfo sVtInfo2) throws NoSuchInterface, UnsupportedOperation {
        Integer n = null;
        try {
            n = (Integer)this.getVtIndex.get(sVtInfo2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getVTIndex", userException);
        }
        return n;
    }

    public void deleteInterfaces(IChassisModel iChassisModel, PortModel portModel) {
        Collection collection = this.findAllInSlot(iChassisModel, (short)portModel.getSlot());
        for (InterfaceModel interfaceModel : collection) {
            if (interfaceModel == null) continue;
            try {
                PortModel portModel2 = (PortModel)interfaceModel.getPortModel();
                if (portModel2 != null && portModel2 != portModel) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                interfaceModel.delete();
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ SDebug access$800() {
        return ifDb;
    }

    private class AmplifiedLineIfRetriever
    extends IfRetriever {
        private sOpticalLineAmplifierAttributes[] lineAttr;
        private AmplifiedLineInterfaces ampLineIf;
        private static final String GETOPTICSATTRIBUTELIST = "AmplifiedOpticalLine::getOpticsInterfaceOnSlot";

        AmplifiedLineIfRetriever(int n) {
            super(n, "AmplifiedLine");
            this.ampLineIf = new AmplifiedLineInterfaces(GETOPTICSATTRIBUTELIST);
        }

        int getIfAttributes() {
            try {
                this.lineAttr = (sOpticalLineAmplifierAttributes[])this.ampLineIf.get(new Integer(this.slot));
                return this.lineAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.lineAttr[n].general.base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.lineAttr[n].general.base.info;
        }

        InterfaceModel createIfModel(int n) {
            return new OpticsAmplifiedLineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((OpticsAmplifiedLineModel)interfaceModel).setAttributes(this.lineAttr[n], l);
        }

        class AmplifiedLineInterfaces
        extends NonCachedValue {
            public AmplifiedLineInterfaces(String string) {
                super(InterfaceModels.this.node, string);
            }

            protected Object getValue(Object object) throws UserException {
                int n = (Integer)object;
                return InterfaceModels.this.getNodeModelDelegate().getIorRepository().getOpticsAmpliRef().getOpticsInterfacesOnSlot(n);
            }
        }
    }

    private class AsapEthIfRetriever
    extends IfRetriever {
        private sEtherAttributes[] etherAttr;

        AsapEthIfRetriever(int n) {
            super(n, "AsapEther");
        }

        int getIfAttributes() {
            try {
                this.etherAttr = (sEtherAttributes[])InterfaceModels.this.etherIf.get(new Integer(this.slot));
                return this.etherAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.etherAttr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.etherAttr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            if (!this.entityExists(this.etherAttr[n].base.ifIndex)) {
                return null;
            }
            if (this.db.on()) {
                this.db.fine("InterfaceModels::AsapEtherIfRetriever::createIfModel() creating AsapEtherLineModel, index = " + Integer.toHexString(this.etherAttr[n].base.ifIndex));
            }
            return new AsapEtherLineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((EtherMediaModel)interfaceModel).setAttributes(this.etherAttr[n], l);
        }
    }

    private class AsapPosIfRetriever
    extends IfRetriever {
        private sSonetLineAttributes[] lineAttr;

        AsapPosIfRetriever(int n) {
            super(n, "AsapPos");
        }

        int getIfAttributes() {
            try {
                this.lineAttr = (sSonetLineAttributes[])InterfaceModels.this.posIf.get(new Integer(this.slot));
                return this.lineAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.lineAttr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.lineAttr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            if (!this.entityExists(this.lineAttr[n].base.ifIndex)) {
                return null;
            }
            if (this.db.on()) {
                this.db.fine("InterfaceModels::AsapPosIfRetriever::createIfModel() creating AsapPosLineModel, index = " + Integer.toHexString(this.lineAttr[n].base.ifIndex));
            }
            return new AsapPosLineModel(InterfaceModels.this.getNodeModelDelegate(), this.lineAttr[n].base.ifIndex);
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((AsapPosLineModel)interfaceModel).setAttributes(this.lineAttr[n], l);
        }
    }

    private class ChannelIfRetriever
    extends IfRetriever {
        private sOpticalChannelAttributes[] lineAttr;
        private ChannelInterfaces chIf;
        private static final String CH_GETOPTICSATTRIBUTELIST = "OpticalChannel::getOpticsInterfaceOnSlot";

        ChannelIfRetriever(int n) {
            super(n, "Channel");
            this.chIf = new ChannelInterfaces(CH_GETOPTICSATTRIBUTELIST);
        }

        int getIfAttributes() {
            try {
                this.lineAttr = (sOpticalChannelAttributes[])this.chIf.get(new Integer(this.slot));
                return this.lineAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.lineAttr[n].general.base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.lineAttr[n].general.base.info;
        }

        InterfaceModel createIfModel(int n) {
            return new OpticsChannelModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((OpticsChannelModel)interfaceModel).setAttributes(this.lineAttr[n], l);
        }

        class ChannelInterfaces
        extends NonCachedValue {
            public ChannelInterfaces(String string) {
                super(InterfaceModels.this.node, string);
            }

            protected Object getValue(Object object) throws UserException {
                int n = (Integer)object;
                return InterfaceModels.this.getNodeModelDelegate().getIorRepository().getOpticsChannelRef().getOpticsInterfacesOnSlot(n);
            }
        }
    }

    private class ClientLineInterfaces
    extends NonCachedValue {
        public ClientLineInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getNodeModelDelegate().getIorRepository().getDwdmCliRef().getLineInterfacesOnSlot(n);
        }
    }

    public class Debug
    extends SDebug {
        public Debug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void countModelsWithStateInMemory() {
            if (InterfaceModels.this.ifModels == null) {
                return;
            }
            int n = 0;
            Map map = InterfaceModels.this.ifModels;
            synchronized (map) {
                for (Integer n2 : InterfaceModels.this.ifModels.keySet()) {
                    InterfaceModel interfaceModel = (InterfaceModel)InterfaceModels.this.ifModels.get(n2);
                    if (interfaceModel.getAttrFieldsInMemory(0) == 0) continue;
                    ++n;
                }
            }
            InterfaceModels.this.db.display("count: " + n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reportModelsWithStateInMemory() {
            if (InterfaceModels.this.ifModels == null) {
                return;
            }
            Map map = InterfaceModels.this.ifModels;
            synchronized (map) {
                for (Integer n : InterfaceModels.this.ifModels.keySet()) {
                    InterfaceModel interfaceModel = (InterfaceModel)InterfaceModels.this.ifModels.get(n);
                    int n2 = interfaceModel.getAttrFieldsInMemory(0);
                    if (n2 == 0) continue;
                    this.display(interfaceModel.getClass().getName() + " " + n + " 0x" + Integer.toHexString(n2));
                }
            }
        }
    }

    private class Ds123IfRetriever
    extends PersistIfRetriever {
        protected sDs123Attributes[] ds123Attr;

        Ds123IfRetriever(int n) {
            super(n, "DS123");
        }

        int getIfAttributes() {
            try {
                this.ds123Attr = (sDs123Attributes[])InterfaceModels.this.ds123If.get(new Integer(this.slot));
                return this.ds123Attr.length;
            }
            catch (BAD_PARAM bAD_PARAM) {
                this.db.println("Bad param calling getInterfacesOnSlot(" + Integer.toHexString(this.slot) + "): " + (Object)((Object)bAD_PARAM));
                SDebug.printStackTrace((Throwable)bAD_PARAM);
                throw bAD_PARAM;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.ds123Attr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.ds123Attr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            if (InterfaceModels.this.getNodeModel().getTdmProtocolTypeObj().isSonet()) {
                return new Ds123LineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
            }
            return InterfaceModels.this.createInterfaceModel(this.getIfInfo((int)n).ifType.value(), this.getIfIndex(n));
        }

        boolean canIfModelBeCreatedWithoutState() {
            return InterfaceModels.this.getNodeModel().getTdmProtocolTypeObj().isSonet();
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((Ds123LineModel)interfaceModel).setAttributes(this.ds123Attr[n], l);
        }

        int getExpectedPersistType() {
            return 5;
        }
    }

    private class Ds123LineInterfaces
    extends NonCachedValue {
        public Ds123LineInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getDs123Ref().getInterfacesOnSlot(n);
        }

        public Object outer() {
            return InterfaceModels.this;
        }
    }

    private class Ds1IfRetriever
    extends Ds123IfRetriever {
        Ds1IfRetriever(int n) {
            super(n);
        }

        InterfaceModel createIfModel(int n) {
            return new Ds1LineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }
    }

    private class DwdmCliIfRetriever
    extends IfRetriever {
        private sClientLineAttributes[] lineAttr;

        DwdmCliIfRetriever(int n) {
            super(n, "ClientLine");
        }

        int getIfAttributes() {
            try {
                this.lineAttr = (sClientLineAttributes[])InterfaceModels.this.dwdmClientIf.get(new Integer(this.slot));
                return this.lineAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.lineAttr[n].general.base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.lineAttr[n].general.base.info;
        }

        InterfaceModel createIfModel(int n) {
            return new DwdmCliLineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((DwdmCliLineModel)interfaceModel).setAttributes(this.lineAttr[n], l);
        }
    }

    private class DwdmOTUIfRetriever
    extends IfRetriever {
        private sTrunkLineAttributes[] payloadAttr;

        DwdmOTUIfRetriever(int n) {
            super(n, "DwdmOTULine");
        }

        int getIfAttributes() {
            try {
                this.payloadAttr = (sTrunkLineAttributes[])InterfaceModels.this.dwdmOTUIf.get(new Integer(this.slot));
                return this.payloadAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.payloadAttr[n].general.base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.payloadAttr[n].general.base.info;
        }

        InterfaceModel createIfModel(int n) {
            return new DwdmOTULineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((DwdmOTULineModel)interfaceModel).setAttributes(this.payloadAttr[n], l);
        }
    }

    private class DwdmOTUInterfaces
    extends NonCachedValue {
        public DwdmOTUInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getNodeModelDelegate().getIorRepository().getDwdmCliRef().getOTU2InterfacesOnSlot(n);
        }
    }

    private class DwdmPayloadIfRetriever
    extends IfRetriever {
        private sPassThruAttributes[] payloadAttr;

        DwdmPayloadIfRetriever(int n) {
            super(n, "DwdmPayloadLine");
        }

        int getIfAttributes() {
            try {
                this.payloadAttr = (sPassThruAttributes[])InterfaceModels.this.dwdmPayloadIf.get(new Integer(this.slot));
                return this.payloadAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.payloadAttr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.payloadAttr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            return new DwdmPayloadLineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((DwdmPayloadLineModel)interfaceModel).setAttributes(this.payloadAttr[n], l);
        }
    }

    private class DwdmPayloadInterfaces
    extends NonCachedValue {
        public DwdmPayloadInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getNodeModelDelegate().getIorRepository().getDwdmCliRef().getPassThruInterfacesOnSlot(n);
        }
    }

    private class DwdmTrkIfRetriever
    extends IfRetriever {
        private sTrunkLineAttributes[] lineAttr;

        DwdmTrkIfRetriever(int n) {
            super(n, "DwdmLine");
        }

        int getIfAttributes() {
            try {
                this.lineAttr = (sTrunkLineAttributes[])InterfaceModels.this.dwdmTrunkIf.get(new Integer(this.slot));
                return this.lineAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.lineAttr[n].general.base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.lineAttr[n].general.base.info;
        }

        InterfaceModel createIfModel(int n) {
            return new DwdmTrkLineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((DwdmTrkLineModel)interfaceModel).setAttributes(this.lineAttr[n], l);
        }
    }

    private class EthIfRetriever
    extends IfRetriever {
        private sEtherAttributes[] etherAttr;

        EthIfRetriever(int n) {
            super(n, "ETH");
        }

        int getIfAttributes() {
            try {
                this.etherAttr = (sEtherAttributes[])InterfaceModels.this.etherIf.get(new Integer(this.slot));
                return this.etherAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.etherAttr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.etherAttr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            return InterfaceModels.this.getEtherInterfaceModel(this.etherAttr[n].base.ifIndex);
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((EtherMediaModel)interfaceModel).setAttributes(this.etherAttr[n], l);
        }
    }

    private class EthL2IfRetriever
    extends IfRetriever {
        private sL2EtherAttributes[] etherAttr;

        EthL2IfRetriever(int n) {
            super(n, "ETHL2");
        }

        int getIfAttributes() {
            try {
                this.etherAttr = (sL2EtherAttributes[])InterfaceModels.this.etherL2If.get(new Integer(this.slot));
                return this.etherAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.etherAttr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.etherAttr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            return new XPL2Layer2LineModel(InterfaceModels.this.getNodeModelDelegate(), this.etherAttr[n].base.ifIndex);
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            interfaceModel.setAttributes(this.etherAttr[n].base, l);
        }
    }

    private class EtherInterfaces
    extends NonCachedValue {
        public EtherInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getEtherMediaRef().getInterfacesOnSlot(n);
        }

        public Object outer() {
            return InterfaceModels.this;
        }
    }

    private class EtherL2Interfaces
    extends NonCachedValue {
        public EtherL2Interfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getEtherL2Ref().getL2InterfacesOnSlot(n);
        }

        public Object outer() {
            return InterfaceModels.this;
        }
    }

    private class FCIfRetriever
    extends IfRetriever {
        private sFCAttributes[] fcAttr;

        FCIfRetriever(int n) {
            super(n, "FCLine");
        }

        int getIfAttributes() {
            try {
                if (this.db.on()) {
                    this.db.println("FCIfRetriever getting attrs for 0x" + Integer.toHexString(this.slot));
                }
                this.fcAttr = (sFCAttributes[])InterfaceModels.this.fcIf.get(new Integer(this.slot));
                return this.fcAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.fcAttr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.fcAttr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            return new FcmrLineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((FcmrLineModel)interfaceModel).setAttributes(this.fcAttr[n], l);
        }
    }

    private class FCInterfaces
    extends NonCachedValue {
        public FCInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getFCMediaRef().getInterfacesOnSlot(n);
        }

        public Object outer() {
            return InterfaceModels.this;
        }
    }

    private class GFPInterfaces
    extends NonCachedValue {
        public GFPInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getNodeModelDelegate().getIorRepository().getDwdmCliRef().getGFPInterfacesOnSlot(n);
        }
    }

    private class GetStsIndex
    extends NonCachedValue {
        public GetStsIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface {
            return new Integer(InterfaceModels.this.getNodeModelDelegate().getIorRepository().getSonetRef().getStsIndex((sStsInfo)object));
        }

        protected void setValue(Object object) {
        }

        public Object outer() {
            return InterfaceModels.this;
        }
    }

    private class GetVtIndex
    extends NonCachedValue {
        public GetVtIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xUnsupportedOperation {
            return new Integer(InterfaceModels.this.getNodeModelDelegate().getIorRepository().getSonetRef().getVtIndex((sVtInfo)object));
        }

        protected void setValue(Object object) {
        }

        public Object outer() {
            return InterfaceModels.this;
        }
    }

    private class GfpIfRetriever
    extends IfRetriever {
        private sGFPAttributes[] gfpAttr;

        GfpIfRetriever(int n) {
            super(n, "GFPLine");
        }

        int getIfAttributes() {
            try {
                this.gfpAttr = (sGFPAttributes[])InterfaceModels.this.gfpIf.get(new Integer(this.slot));
                return this.gfpAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.gfpAttr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.gfpAttr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            return new GfpLineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((GfpLineModel)interfaceModel).setAttributes(this.gfpAttr[n], l);
        }
    }

    protected abstract class IfRetriever
    implements IActionClient {
        protected final String ifName;
        protected boolean doStop;
        protected int slot;
        protected short slotNum;
        protected final SDebug db = InterfaceModels.access$800();
        private HashMap map = new HashMap();

        public IfRetriever(int n, String string) {
            this.ifName = string;
            this.slot = n;
            InterfaceModels.this.retrieverStarted();
        }

        public String toString() {
            return "IfRetriever " + this.ifName + " for slot: " + this.slot;
        }

        protected void init() {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)InterfaceModels.this.getNodeModel();
            EntityTableModel entityTableModel = nodeModelDelegate.getEntityTableModel();
            IEntityModel iEntityModel = null;
            try {
                iEntityModel = entityTableModel.getEntityModelByIndex(this.slot);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
            if (iEntityModel != null) {
                this.slotNum = (short)iEntityModel.getPositionInParent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() {
            this.init();
            NodeModelDelegate nodeModelDelegate = InterfaceModels.this.getNodeModelDelegate();
            IModelPersistenceStrategy iModelPersistenceStrategy = nodeModelDelegate.getModelPersistenceStrategy(InterfaceModel.class);
            boolean bl = iModelPersistenceStrategy.doesGetReallyPersisted(null);
            long l = -1L;
            try {
                int n;
                if (!bl) {
                    n = this.getIfAttributes();
                } else {
                    LongHolder longHolder = new LongHolder(l);
                    n = this.getIfAttributesWithStableSeqNum(longHolder);
                    l = longHolder.longValue();
                }
                for (int i = 0; i < n; ++i) {
                    if (this.doStop) {
                        break;
                    }
                    InterfaceModel interfaceModel = this.cacheIfModel(i);
                    if (interfaceModel == null) continue;
                    this.setAttributes(interfaceModel, i, l);
                    this.registerModel(interfaceModel.getIndex(), interfaceModel);
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
            catch (UNKNOWN uNKNOWN) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)uNKNOWN);
                }
            }
            catch (Exception exception) {
                this.db.println("Error: " + exception + " in InterfaceModels.IfRetriever::" + this.ifName);
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            finally {
                this._retrieverStopped();
            }
        }

        protected void _retrieverStopped() {
            InterfaceModels.this.retrieverStopped(this.map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected InterfaceModel cacheIfModel(int n) {
            InterfaceModel interfaceModel = InterfaceModels.this.findInterfaceModelInCache(this.getIfIndex(n));
            if (interfaceModel == null && (interfaceModel = this.createIfModel(n)) != null) {
                interfaceModel.setSlotNum(this.slotNum);
                Map map = InterfaceModels.this.ifModels;
                synchronized (map) {
                    InterfaceModels.this.ifModels.put(new Integer(interfaceModel.getIndex()), interfaceModel);
                }
            }
            return interfaceModel;
        }

        protected void registerModel(int n, InterfaceModel interfaceModel) {
            this.map.put(new Integer(n), interfaceModel);
        }

        public void failedAction(IThreadWorker iThreadWorker) {
        }

        public void dispose() {
            this.doStop = true;
        }

        abstract int getIfAttributes();

        abstract void setAttributes(InterfaceModel var1, int var2, long var3);

        abstract int getIfIndex(int var1);

        abstract sInterface getIfInfo(int var1);

        abstract InterfaceModel createIfModel(int var1);

        int getIfAttributesWithStableSeqNum(LongHolder longHolder) {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)InterfaceModels.this.getNodeModel();
            EntityTableModel entityTableModel = nodeModelDelegate.getEntityTableModel();
            IEntityModel iEntityModel = null;
            try {
                iEntityModel = entityTableModel.getEntityModelByIndex(this.slot);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
            ModuleModel moduleModel = null;
            if (iEntityModel != null && iEntityModel instanceof ModuleModel) {
                moduleModel = (ModuleModel)iEntityModel;
            }
            if (moduleModel == null) {
                return this.getIfAttributes();
            }
            int n = 0;
            int n2 = IModelPersistenceConstants.NE_RETRY_COUNT;
            long l = moduleModel.getLastInterfaceChange();
            for (int i = 0; i < n2; ++i) {
                n = this.getIfAttributes();
                long l2 = moduleModel.getLastInterfaceChange();
                if (l != l2) {
                    l = l2;
                    if (i >= IModelPersistenceConstants.NE_RETRY_COUNT) continue;
                    try {
                        Thread.sleep(IModelPersistenceConstants.NE_RETRY_DELAY);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                longHolder.setValue(l);
                break;
            }
            return n;
        }

        protected boolean entityExists(int n) {
            try {
                IEntityModel iEntityModel = InterfaceModels.this.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on) {
                    this.db.fine("InterfaceModels::IfRetriever::createIfModel() no such entity exp, index = " + Integer.toHexString(n));
                }
                return false;
            }
            return true;
        }
    }

    public class IfsDebug
    extends Debug {
        IfsDebug(KDebug kDebug) {
            super(kDebug, InterfaceModels.IFS_DEBUG_KEY);
        }

        public final void dump() {
            InterfaceModels.this.dumpInterfaceModels();
        }

        public final void accessCounts() {
            InterfaceModels.this.dumpAccessCounts();
        }
    }

    class Info
    extends NonCachedValue {
        public Info(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface {
            return InterfaceModels.this.getIfRef().getInfo((Integer)object);
        }

        protected void setValue(Object object) {
        }

        public Object outer() {
            return InterfaceModels.this;
        }
    }

    private class LineIfRetriever
    extends IfRetriever {
        private sGeneralOpticsAttributes[] lineAttr;
        private LineInterfaces lineIf;
        private static final String GETOPTICSATTRIBUTELIST = "OpticalLine::getOpticsInterfaceOnSlot";

        LineIfRetriever(int n) {
            super(n, "Line");
            this.lineIf = new LineInterfaces(GETOPTICSATTRIBUTELIST);
        }

        int getIfAttributes() {
            try {
                this.lineAttr = (sGeneralOpticsAttributes[])this.lineIf.get(new Integer(this.slot));
                return this.lineAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.lineAttr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.lineAttr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            OpticsLineModel opticsLineModel = new OpticsLineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
            try {
                if ((opticsLineModel.getFeatures() & 0x8000) == 32768) {
                    opticsLineModel = new RamanOpticsLineModel(opticsLineModel);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            return opticsLineModel;
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((OpticsLineModel)interfaceModel).setAttributes(this.lineAttr[n], l);
        }

        class LineInterfaces
        extends NonCachedValue {
            public LineInterfaces(String string) {
                super(InterfaceModels.this.node, string);
            }

            protected Object getValue(Object object) throws UserException {
                int n = (Integer)object;
                return InterfaceModels.this.getNodeModelDelegate().getIorRepository().getOpticsLineRef().getOpticsInterfacesOnSlot(n);
            }
        }
    }

    private class OMSIfRetriever
    extends IfRetriever {
        private sOpticalMultiplexSectionAttributes[] lineAttr;
        private OMSInterfaces omsIf;
        private static final String GETOPTICSATTRIBUTELIST = "OpticalMultiplexSection::getOpticsInterfaceOnSlot";

        OMSIfRetriever(int n) {
            super(n, "OMS");
            this.omsIf = new OMSInterfaces(GETOPTICSATTRIBUTELIST);
        }

        int getIfAttributes() {
            try {
                this.lineAttr = (sOpticalMultiplexSectionAttributes[])this.omsIf.get(new Integer(this.slot));
                return this.lineAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.lineAttr[n].general.base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.lineAttr[n].general.base.info;
        }

        InterfaceModel createIfModel(int n) {
            return new OpticsMultiplexSectionModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((OpticsMultiplexSectionModel)interfaceModel).setAttributes(this.lineAttr[n], l);
        }

        class OMSInterfaces
        extends NonCachedValue {
            public OMSInterfaces(String string) {
                super(InterfaceModels.this.node, string);
            }

            protected Object getValue(Object object) throws UserException {
                int n = (Integer)object;
                return InterfaceModels.this.getNodeModelDelegate().getIorRepository().getOpticsMuxRef().getOpticsInterfacesOnSlot(n);
            }
        }
    }

    private class OchTermIfRetriever
    extends IfRetriever {
        private sOchAllocationAttributes[] ochAttr;
        private OchTermInterfaces chIf;
        private static final String CH_GETOPTICSATTRIBUTELIST = "OchAllocation::getOpticsInterfacesOnSlot";

        OchTermIfRetriever(int n) {
            super(n, "Channel");
            this.chIf = new OchTermInterfaces(CH_GETOPTICSATTRIBUTELIST);
        }

        int getIfAttributes() {
            try {
                this.ochAttr = (sOchAllocationAttributes[])this.chIf.get(new Integer(this.slot));
                return this.ochAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.ochAttr[n].general.base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.ochAttr[n].general.base.info;
        }

        int getActualWavelength(int n) {
            return this.ochAttr[n].lambda.value();
        }

        int getIngressPort(int n) {
            return this.ochAttr[n].ingressPort;
        }

        int getPhysicalPort(int n) {
            return this.ochAttr[n].physicalPort;
        }

        InterfaceModel createIfModel(int n) {
            return new OpticsOchTermModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((OpticsOchTermModel)interfaceModel).setAttributes(this.ochAttr[n], l);
        }

        class OchTermInterfaces
        extends NonCachedValue {
            public OchTermInterfaces(String string) {
                super(InterfaceModels.this.node, string);
            }

            protected Object getValue(Object object) throws UserException {
                int n = (Integer)object;
                return InterfaceModels.this.getNodeModelDelegate().getIorRepository().getOchAllocationRef().getOpticsInterfacesOnSlot(n);
            }
        }
    }

    protected abstract class PersistIfRetriever
    extends IfRetriever {
        public PersistIfRetriever(int n, String string) {
            super(n, string);
        }

        int getExpectedPersistType() {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() {
            NodeModelDelegate nodeModelDelegate = InterfaceModels.this.getNodeModelDelegate();
            IModelPersistenceStrategy iModelPersistenceStrategy = nodeModelDelegate.getModelPersistenceStrategy(InterfaceModel.class);
            boolean bl = iModelPersistenceStrategy.doesGetReallyPersisted(null);
            if (!bl) {
                super.doAction();
                return;
            }
            this.init();
            if (this.db.on()) {
                this.db.println("now running: " + this.getClass().getName() + " for slot " + this.slotNum + " for thread: " + Thread.currentThread());
            }
            try {
                int n;
                int n2 = this.getExpectedPersistType();
                List list = !this.canIfModelBeCreatedWithoutState() ? null : InterfaceModel.getListOfModelIndiciesForSlot(InterfaceModels.this.getNodeModel(), this.slotNum, n2);
                int n3 = list == null ? 0 : list.size();
                long l = -1L;
                if (this.db.on()) {
                    this.db.println(this.getClass().getName() + " persistent attr count for slot " + this.slotNum + ": " + n3);
                }
                if (n3 == 0 || !this.canIfModelBeCreatedWithoutState()) {
                    LongHolder longHolder = new LongHolder(l);
                    n = this.getIfAttributesWithStableSeqNum(longHolder);
                    l = longHolder.longValue();
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + " for slot " + this.slotNum + " to rely-on ne for restoring state. Attribute count from the ne is: " + n + " - seq number is now: " + l);
                    }
                } else {
                    n = n3;
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + " for slot " + this.slotNum + " to rely-on persistent store for restoring state. Attribute count in the store is: " + n);
                    }
                }
                if (n3 == 0 || !this.canIfModelBeCreatedWithoutState()) {
                    for (int i = 0; i < n; ++i) {
                        InterfaceModel interfaceModel = this.cacheIfModel(i);
                        if (interfaceModel == null) continue;
                        this.setAttributes(interfaceModel, i, l);
                        this.registerModel(interfaceModel.getIndex(), interfaceModel);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        InterfaceModel interfaceModel = this.cacheIfModel(i);
                        if (interfaceModel == null) continue;
                        this.registerModel(interfaceModel.getIndex(), interfaceModel);
                    }
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
            catch (UNKNOWN uNKNOWN) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)uNKNOWN);
                }
            }
            catch (Exception exception) {
                this.db.println("Error: " + exception + " in InterfaceModels.IfRetriever::" + this.ifName);
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            finally {
                this._retrieverStopped();
            }
        }

        boolean canIfModelBeCreatedWithoutState() {
            return true;
        }

        abstract InterfaceModel createIfModel(int var1);

        abstract void setAttributes(InterfaceModel var1, int var2, long var3);
    }

    private class PosInterfaces
    extends NonCachedValue {
        public PosInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getSonetRef().getPosLineInterfacesOnSlot(n);
        }

        public Object outer() {
            return InterfaceModels.this;
        }
    }

    private class SonetLineIfRetriever
    extends PersistIfRetriever {
        private sSonetLineAttributes[] lineAttr;

        SonetLineIfRetriever(int n) {
            super(n, "SonetLine");
        }

        int getIfAttributes() {
            try {
                this.lineAttr = (sSonetLineAttributes[])InterfaceModels.this.sonetIf.get(new Integer(this.slot));
                return this.lineAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.lineAttr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.lineAttr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            if (!this.entityExists(this.getIfIndex(n))) {
                return null;
            }
            if (this.db.on) {
                this.db.fine("InterfaceModels::SonetLineIfRetriever::createIfModel() creating TdmLineModel, index = " + Integer.toHexString(this.lineAttr[n].base.ifIndex));
            }
            return new TdmLineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((TdmLineModel)interfaceModel).setAttributes(this.lineAttr[n], l);
        }

        int getExpectedPersistType() {
            return 4;
        }
    }

    private class SonetLineInterfaces
    extends NonCachedValue {
        public SonetLineInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getSonetRef().getLineInterfacesOnSlot(n);
        }

        public Object outer() {
            return InterfaceModels.this;
        }
    }

    protected class StsIfRetriever
    extends PersistIfRetriever {
        private sStsAttributes[] stsAttr;

        StsIfRetriever(int n) {
            super(n, "STS");
        }

        int getIfAttributes() {
            try {
                this.stsAttr = (sStsAttributes[])InterfaceModels.this.stsIf.get(new Integer(this.slot));
                return this.stsAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.stsAttr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.stsAttr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            if (this.db.on) {
                this.db.fine("InterfaceModels::StsIfRetriever::createIfModel() creating TdmHoModel, index = " + Integer.toHexString(this.stsAttr[n].base.ifIndex));
            }
            return new TdmHoModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n), InterfaceModels.this.tdmHoDebug);
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((TdmHoModel)interfaceModel).setAttributes(this.stsAttr[n], l);
        }

        int getExpectedPersistType() {
            return 2;
        }
    }

    private class StsInterfaces
    extends NonCachedValue {
        public StsInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getSonetRef().getStsInterfacesOnSlot(n);
        }

        public Object outer() {
            return InterfaceModels.this;
        }
    }

    private class TrunkLineInterfaces
    extends NonCachedValue {
        public TrunkLineInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return InterfaceModels.this.getNodeModelDelegate().getIorRepository().getDwdmTrkRef().getLineInterfacesOnSlot(n);
        }
    }

    private class VtIfRetriever
    extends PersistIfRetriever {
        private sVtAttributes[] vtAttr;

        VtIfRetriever(int n) {
            super(n, "VT");
            if (this.db.on) {
                this.db.fine("InterfaceModels::VtIfRetriever ctor creating retriever...");
            }
        }

        int getIfAttributes() {
            try {
                this.vtAttr = (sVtAttributes[])InterfaceModels.this.vtIf.get(new Integer(this.slot));
                return this.vtAttr.length;
            }
            catch (UserException userException) {
                throw InterfaceModels.this.doUnknown("getIfAttributes", userException);
            }
        }

        int getIfIndex(int n) {
            return this.vtAttr[n].base.ifIndex;
        }

        sInterface getIfInfo(int n) {
            return this.vtAttr[n].base.info;
        }

        InterfaceModel createIfModel(int n) {
            if (this.db.on) {
                this.db.fine("InterfaceModels::VtIfRetriever::createIfModel() creating TdmLoModel, index = " + Integer.toHexString(this.vtAttr[n].base.ifIndex));
            }
            return new TdmLoModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
        }

        void setAttributes(InterfaceModel interfaceModel, int n, long l) {
            ((TdmLoModel)interfaceModel).setAttributes(this.vtAttr[n], l);
        }

        int getExpectedPersistType() {
            return 3;
        }

        class VtInterfaces
        extends NonCachedValue {
            public VtInterfaces(String string) {
                super(InterfaceModels.this.node, string);
            }

            protected Object getValue(Object object) throws UserException {
                if (VtIfRetriever.this.db.on) {
                    VtIfRetriever.this.db.fine("VtInterfaces::getValue() inner, call getVtInterfacesOnSlot() ...");
                }
                int n = (Integer)object;
                return InterfaceModels.this.getSonetRef().getVtInterfacesOnSlot(n);
            }

            public Object outer() {
                return InterfaceModels.this;
            }
        }
    }

    private class VtInterfaces
    extends NonCachedValue {
        public VtInterfaces(String string) {
            super(InterfaceModels.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            if (InterfaceModels.this.db.on) {
                InterfaceModels.this.db.fine("VtInterfaces::getValue() outer, call getVtInterfacesOnSlot() ...");
            }
            int n = (Integer)object;
            return InterfaceModels.this.getSonetRef().getVtInterfacesOnSlot(n);
        }

        public Object outer() {
            return InterfaceModels.this;
        }
    }

    private class XtcIfRetriever
    extends Ds123IfRetriever {
        XtcIfRetriever(int n) {
            super(n);
        }

        InterfaceModel createIfModel(int n) {
            if (this.getIfInfo((int)n).ifType == eIfType.DS1) {
                return new Ds1LineModel(InterfaceModels.this.getNodeModelDelegate(), this.getIfIndex(n), this.getIfInfo(n));
            }
            return super.createIfModel(n);
        }
    }
}

