/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Epos.RPR;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.EtherMedia.General;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.IosModuleModel;
import cerent.cms.model.L2scEtherLineModel;
import cerent.cms.model.L2scEtherPortModel;
import cerent.cms.model.L2scLineModel;
import cerent.cms.model.L2scPortModel;
import cerent.cms.model.L2scPosLineModel;
import cerent.cms.model.L2scPosPortModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class L2scModuleModel
extends IosModuleModel {
    public L2scModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(L2scModuleModel.class));
    }

    public L2scModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, sDebug);
    }

    public List getConnectionsList() {
        LinkedList linkedList = new LinkedList();
        L2scPosPortModel[] l2scPosPortModelArray = null;
        l2scPosPortModelArray = this.getL2scPosPorts();
        if (l2scPosPortModelArray != null) {
            for (int i = 0; i < l2scPosPortModelArray.length; ++i) {
                List list = l2scPosPortModelArray[i].getConnectionsList();
                if (list == null) continue;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(iterator.next());
                }
            }
        }
        return linkedList;
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        L2scPortModel[] l2scPortModelArray = null;
        l2scPortModelArray = eEqType2 == null ? (this.getEqTypeEnum() == eEqType.MS_ISC_100T_CARD ? this.getChildrenOfType(eEqType.L2SC_ETHER_PORT).toArray(new L2scEtherPortModel[0]) : this.getDescendantsOfClassType(7).toArray(new L2scPortModel[0])) : (eEqType2.equals(eEqType.L2SC_ETHER_PORT) ? this.getChildrenOfType(eEqType2).toArray(new L2scEtherPortModel[0]) : (eEqType2.equals(eEqType.L2SC_POS_PORT) ? this.getChildrenOfType(eEqType2).toArray(new L2scPosPortModel[0]) : this.getDescendantsOfClassType(7).toArray(new L2scPortModel[0])));
        return l2scPortModelArray == null ? new L2scPortModel[]{} : l2scPortModelArray;
    }

    public L2scEtherPortModel[] getL2scEtherPorts() {
        return (L2scEtherPortModel[])this.getPortModels(eEqType.L2SC_ETHER_PORT);
    }

    public L2scPosPortModel[] getL2scPosPorts() {
        return (L2scPosPortModel[])this.getPortModels(eEqType.L2SC_POS_PORT);
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        PortModel[] portModelArray = this.getPortModels(eEqType2);
        L2scLineModel[] l2scLineModelArray = null;
        if (eEqType2.equals(eEqType.L2SC_ETHER_PORT)) {
            l2scLineModelArray = new L2scEtherLineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                l2scLineModelArray[i] = (L2scEtherLineModel)portModelArray[i].getInterfaceModel();
            }
        } else if (eEqType2.equals(eEqType.L2SC_POS_PORT)) {
            l2scLineModelArray = new L2scPosLineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                l2scLineModelArray[i] = (L2scPosLineModel)portModelArray[i].getInterfaceModel();
            }
        } else {
            l2scLineModelArray = new L2scLineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                l2scLineModelArray[i] = (L2scLineModel)portModelArray[i].getInterfaceModel();
            }
        }
        return l2scLineModelArray == null ? new InterfaceModel[]{} : l2scLineModelArray;
    }

    public L2scEtherLineModel[] getL2scEtherLines() {
        return (L2scEtherLineModel[])this.getLineModels(eEqType.L2SC_ETHER_PORT);
    }

    public L2scPosLineModel[] getL2scPosLines() {
        return (L2scPosLineModel[])this.getLineModels(eEqType.L2SC_POS_PORT);
    }

    public String toString() {
        return "L2sc" + super.toString();
    }

    protected RPR getRPRRef() {
        return this.getNodeModelDelegate().getIorRepository().getRPRRef();
    }

    protected General getEtherMediaRef() {
        return this.getNodeModelDelegate().getIorRepository().getEtherMediaRef();
    }

    public InterfaceModel[] getPathTraceLines() {
        return this.getLineModels(eEqType.L2SC_POS_PORT);
    }

    boolean isPortNumUnique(int n) {
        return false;
    }

    public boolean isComboModule() {
        return true;
    }

    public boolean supportsIOS() {
        return true;
    }

    public boolean isRPRMode() {
        boolean bl = false;
        if (this.supportsRPR() && this.getCardOperMode() == eCardOperMode.OPER_MODE_ML_802_17_RPR) {
            bl = true;
        }
        return bl;
    }

    public boolean supportsRPR() {
        boolean bl = false;
        int n = this.getEqType();
        if (n == 102 || n == 103 || n == 221) {
            bl = true;
        }
        return bl;
    }
}

