/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Dwdm.eGccRate;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhTermModel;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.Set;

public class LdccTermConnectionModel
extends AbstractTermConnectionModel {
    private static OhChannelType LDCC_TERM_CHANNEL = OhChannelType.LDCC_OBJ;
    private static OhChannelType LDCC_TUNNEL1_CHANNEL = OhChannelType.LDCC_TUNNEL1_OBJ;
    private static OhChannelType LDCC_TUNNEL2_CHANNEL = OhChannelType.LDCC_TUNNEL2_OBJ;
    private static OhChannelType LDCC_TUNNEL3_CHANNEL = OhChannelType.LDCC_TUNNEL3_OBJ;
    private static OhChannelType UDC_MS_CHANNEL = OhChannelType.UDC_MS_OBJ;
    private static NodeSingletonFactory<LdccTermConnectionModel> sfactory = new NodeSingletonFactory<LdccTermConnectionModel>(LdccTermConnectionModel.class);

    public static LdccTermConnectionModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private LdccTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        LdccTermConnectionModel ldccTermConnectionModel = (LdccTermConnectionModel)nodeModelDelegate.getLdccTermConnectionModel();
        ldccTermConnectionModel.init();
    }

    public boolean entityExistsInTerminations(IEntityModel iEntityModel) {
        return this.getTermModel(iEntityModel.getIndex()) != null;
    }

    public IEntityModel[] getTermCandidates() {
        Object object;
        Object object2;
        Object object3;
        HashSet<EntityModel> hashSet = new HashSet<EntityModel>();
        ElementModelsDelegate elementModelsDelegate = this.nmd.getElementModelsDelegate();
        if (this.nmd.getTdmProtocolTypeObj().isSonet()) {
            object3 = elementModelsDelegate.getNonProtectOpticalEntities();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                try {
                    object = (EntityModel)object2.next();
                    if (((EntityModel)object).getMediumType() != 1) continue;
                    if (this.db.on()) {
                        this.db.println("Found a Sonet port " + object + " adding ...");
                    }
                    hashSet.add((EntityModel)object);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        } else {
            hashSet.addAll(elementModelsDelegate.getNonProtectOpticalEntities());
        }
        object3 = hashSet.iterator();
        while (object3.hasNext()) {
            object2 = (IPortModel)object3.next();
            if (object2.getModuleModel().getEqType() != 273 || object2.getPortNum()[0] != 17) continue;
            object3.remove();
        }
        object2 = (OhConnectionModelsDelegate)this.nmd.getOhConnectionModels();
        hashSet.removeAll(((OhConnectionModelsDelegate)object2).getUsedOpticalPorts(LDCC_TERM_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object2).getUsedOpticalPorts(LDCC_TUNNEL1_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object2).getUsedOpticalPorts(LDCC_TUNNEL2_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object2).getUsedOpticalPorts(LDCC_TUNNEL3_CHANNEL));
        hashSet.removeAll(((OhConnectionModelsDelegate)object2).getUsedOpticalPorts(UDC_MS_CHANNEL));
        hashSet.removeAll(this.getNotSupportedTdmPorts(hashSet));
        hashSet.removeAll(this.dwdmNotAllowedPorts(hashSet, 4));
        object = this.excludeUcpTerms(hashSet);
        return object.toArray(new IEntityModel[0]);
    }

    protected String getTypeName() {
        return this.nmd.getTDMTerminology().getGeneralTerms(10);
    }

    public OhChannelType getChannelType(eGccRate eGccRate2) {
        return LDCC_TERM_CHANNEL;
    }

    protected boolean termQualifies(OhTermModel ohTermModel) {
        return ohTermModel.getChannelType() == 4 && !this.isGccTerm(ohTermModel) && !this.isOscTerm(ohTermModel);
    }

    private Set getNotSupportedTdmPorts(Set set) {
        HashSet<ITdmPortModel> hashSet = new HashSet<ITdmPortModel>();
        for (Object e : set) {
            ITdmPortModel iTdmPortModel;
            ITdmLineModel iTdmLineModel;
            if (!(e instanceof ITdmPortModel) || (iTdmLineModel = (iTdmPortModel = (ITdmPortModel)e).getITdmLineModel()).supportsOhChannel(4)) continue;
            hashSet.add(iTdmPortModel);
        }
        return hashSet;
    }
}

