/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Lmp.General;
import cerent.cms.idl.Lmp.sTELinkAttrs;
import cerent.cms.idl.Lmp.xLmpException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractLmpException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.ILmpCtrlChannelModel;
import cerent.cms.model.ILmpTeLinkModel;
import cerent.cms.model.ILmpTeLinkModels;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.ObjectMessageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LmpTeLinkModels
extends Model
implements ILmpTeLinkModels {
    private static NodeSingletonFactory<LmpTeLinkModels> sfactory = new NodeSingletonFactory<LmpTeLinkModels>(LmpTeLinkModels.class);
    private static final ObjectType _eventType = ObjectType.ObjectTELinkList;
    private static final int MIN_TEMP_CRS_ID = 10000;
    private Integer nextTempCrsId = 10000;
    private NodeModelDelegate _nmd;
    private EventDispatcher _dispatcher;
    private HashMap _models;
    private Create _create;
    private Get _get;
    private Delete _delete;
    private UserException _getException;

    private LmpTeLinkModels(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(LmpTeLinkModels.class));
        this._nmd = nodeModelDelegate;
        this._dispatcher = null;
        this._models = new HashMap();
        this._create = new Create(this._nmd, "Lmp::TeLinkManager::Create");
        this._get = new Get(this._nmd, "Lmp::TeLinkManager::Get");
        this._delete = new Delete(this._nmd, "Lmp::TeLinkManager::Delete");
        this._getException = null;
        this.index = 0;
    }

    General getLmpMgrRef() {
        return this._nmd.getIorRepository().getLmpMgrRef();
    }

    public INodeModel getNodeModel() {
        return this._nmd;
    }

    public void init() {
        if (this._dispatcher == null) {
            this._dispatcher = this._nmd.getDispatcher();
        }
        if (this._dispatcher != null) {
            this._dispatcher.addObserver(_eventType, 0, (Observer)this);
        }
        this.updateLocal();
        if (this.db.on()) {
            this.db.println("init(" + this + ")");
        }
        super.init0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() {
        ArrayList arrayList = new ArrayList();
        ArrayList<LmpTeLinkModel> arrayList2 = new ArrayList<LmpTeLinkModel>();
        Iterator iterator = this._models;
        synchronized (iterator) {
            try {
                this._get.update();
                int[] nArray = (int[])this._get.get();
                this._getException = null;
                HashSet hashSet = new HashSet(this._models.keySet());
                HashSet hashSet2 = new HashSet();
                for (int i = 0; i < nArray.length; ++i) {
                    Integer n = new Integer(nArray[i]);
                    if (hashSet.contains(n)) {
                        hashSet.remove(n);
                        continue;
                    }
                    hashSet2.add(n);
                }
                StringBuffer stringBuffer = null;
                if (this.db.on()) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append('-');
                }
                for (Integer n : hashSet) {
                    if (this.db.on()) {
                        stringBuffer.append(' ');
                        stringBuffer.append(n);
                    }
                    arrayList.add(this._models.remove(n));
                }
                if (this.db.on()) {
                    if (stringBuffer.length() > 1) {
                        this.db.println(stringBuffer.toString());
                    }
                    stringBuffer.setLength(0);
                    stringBuffer.append('+');
                }
                for (Integer n : hashSet2) {
                    LmpTeLinkModel lmpTeLinkModel = new LmpTeLinkModel(this._nmd, this, n);
                    if (this.db.on()) {
                        stringBuffer.append(' ');
                        stringBuffer.append(n);
                    }
                    arrayList2.add(lmpTeLinkModel);
                    this._models.put(n, lmpTeLinkModel);
                }
                if (this.db.on() && stringBuffer.length() > 1) {
                    this.db.println(stringBuffer.toString());
                }
            }
            catch (xLmpException xLmpException2) {
                this.db.println("Failed to get LMP TE links: " + (Object)((Object)xLmpException2));
                this._getException = xLmpException2;
            }
            catch (UserException userException) {
                this.db.println("Failed to get LMP TE links: " + (Object)((Object)userException));
                this._getException = userException;
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((LmpTeLinkModel)iterator.next()).destroy();
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ((LmpTeLinkModel)iterator.next()).init();
        }
        if (!arrayList2.isEmpty()) {
            this.setChanged();
            super.updateLocal();
        }
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(" + this + ")");
        }
        this.updateCache();
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update(" + this + ", arg=" + object + ", from=" + observable + ")");
        }
        if (observable instanceof CmsObservable && object instanceof ObjectMessageInfo) {
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            switch (objectMessageInfo.getUpdateType()) {
                case 2: {
                    this.updateLocal();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(_eventType, 0, (Observer)this);
            this._dispatcher = null;
        }
        this._get.dispose();
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            this._models.clear();
        }
        if (this.db.on()) {
            this.db.println("dispose(" + this + ")");
        }
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(" + this + ")");
        }
        super.destroy();
    }

    public int createTeLink(sTELinkAttrs sTELinkAttrs2) throws LmpException {
        try {
            return (Integer)this._create.get(sTELinkAttrs2);
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createTeLink", userException);
        }
    }

    public ILmpTeLinkModel getITeLink(int n) throws AbstractCmsNoSuchEntityException {
        return this.getTeLink(n);
    }

    public ILmpTeLinkModel[] getITeLinks() throws LmpException {
        return this.getTeLinks();
    }

    public ILmpTeLinkModel[] getITeLinksForCtrlChannel(ILmpCtrlChannelModel iLmpCtrlChannelModel) throws AbstractLmpException {
        IIpAddr iIpAddr = iLmpCtrlChannelModel.getIRemoteNodeId();
        ILmpTeLinkModel[] iLmpTeLinkModelArray = this.getITeLinks();
        LinkedList<ILmpTeLinkModel> linkedList = new LinkedList<ILmpTeLinkModel>();
        for (ILmpTeLinkModel iLmpTeLinkModel : iLmpTeLinkModelArray) {
            if (iLmpTeLinkModel.getIRemoteNodeId().compareTo((Object)iIpAddr) != 0) continue;
            linkedList.add(iLmpTeLinkModel);
        }
        return linkedList.toArray(new ILmpTeLinkModel[0]);
    }

    public LmpTeLinkModel[] getTeLinks() throws LmpException {
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            if (this._getException != null) {
                this.updateCache();
            }
            if (this._getException == null) {
                LmpTeLinkModel[] lmpTeLinkModelArray = this._models.values().toArray(new LmpTeLinkModel[this._models.size()]);
                if (this.db.on()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append('=');
                    for (int i = 0; i < lmpTeLinkModelArray.length; ++i) {
                        stringBuffer.append(' ');
                        stringBuffer.append(lmpTeLinkModelArray[i].getIndex());
                    }
                    this.db.println(stringBuffer.toString());
                }
                return lmpTeLinkModelArray;
            }
            if (this._getException instanceof xLmpException) {
                throw new LmpException((xLmpException)this._getException);
            }
            throw NodeModelDelegate.doUnknown(this.db, "getTeLinks", this._getException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LmpTeLinkModel getTeLink(int n) throws AbstractCmsNoSuchEntityException {
        LmpTeLinkModel lmpTeLinkModel;
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            lmpTeLinkModel = (LmpTeLinkModel)this._models.get(new Integer(n));
        }
        if (lmpTeLinkModel == null) {
            throw new CmsNoSuchEntityException("0x" + Integer.toHexString(n));
        }
        return lmpTeLinkModel;
    }

    public void deleteTeLink(int n) throws LmpException {
        try {
            this._delete.set(new Integer(n));
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "deleteTeLink", userException);
        }
    }

    void deleted(LmpTeLinkModel lmpTeLinkModel) {
        this.updateCache();
    }

    public static LmpTeLinkModels getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTempIdForCrsTe() {
        Integer n = this.nextTempCrsId;
        synchronized (n) {
            Integer n2 = this.nextTempCrsId;
            Integer n3 = this.nextTempCrsId = Integer.valueOf(this.nextTempCrsId + 1);
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTempCrsId(int n) {
        Integer n2 = this.nextTempCrsId;
        synchronized (n2) {
            if (n >= this.nextTempCrsId) {
                this.nextTempCrsId = n + 5;
            }
        }
    }

    public String toString() {
        return "LmpTeLinks#" + this.index;
    }

    private class Create
    extends NonCachedValue {
        public Create(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xLmpException {
            return new Integer(LmpTeLinkModels.this.getLmpMgrRef().createTELink((sTELinkAttrs)object));
        }

        public Object outer() {
            return LmpTeLinkModels.this;
        }
    }

    private class Delete
    extends NonCachedValue {
        public Delete(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xLmpException {
            LmpTeLinkModels.this.getLmpMgrRef().deleteTELink((Integer)object);
        }

        public Object outer() {
            return LmpTeLinkModels.this;
        }
    }

    private class Get
    extends CachedValue {
        public Get(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xLmpException {
            return LmpTeLinkModels.this.getLmpMgrRef().getTELinks();
        }

        public Object outer() {
            return LmpTeLinkModels.this;
        }
    }
}

