/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.SonetMedia.eVtPathWidth;
import cerent.cms.idl.SonetTopology.VtAdit;
import cerent.cms.idl.SonetTopology.sVtDef;
import cerent.cms.idl.SonetTopology.sVtPathInfo;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LoAditModel;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.HoLoFactory;
import cerent.util.ILoNum;
import cerent.util.SDebug;

public class LoDefModelFactory {
    private static final SDebug db = new SDebug("LoDefModelFactory");

    private LoDefModelFactory() {
    }

    public static ILoDefModel[] getILoDefModelArray(NodeModelDelegate nodeModelDelegate, sVtDef[] sVtDefArray) {
        ILoDefModel[] iLoDefModelArray = null;
        if (sVtDefArray == null) {
            return null;
        }
        iLoDefModelArray = new ILoDefModel[sVtDefArray.length];
        for (int i = 0; i < sVtDefArray.length; ++i) {
            try {
                iLoDefModelArray[i] = LoDefModelFactory.getILoDef(nodeModelDelegate, sVtDefArray[i]);
                continue;
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                db.println("CmsObjectNotExistException:" + (Object)((Object)cmsObjectNotExistException));
            }
        }
        return iLoDefModelArray;
    }

    public static sVtDef[] getVtDefArray(ILoDefModel[] iLoDefModelArray) {
        if (iLoDefModelArray == null) {
            return null;
        }
        sVtDef[] sVtDefArray = new sVtDef[iLoDefModelArray.length];
        for (int i = 0; i < iLoDefModelArray.length; ++i) {
            sVtDefArray[i] = LoDefModelFactory.getVtDef(iLoDefModelArray[i]);
        }
        return sVtDefArray;
    }

    public static sVtDef getVtDef(ILoDefModel iLoDefModel) {
        LoAditModel loAditModel = (LoAditModel)iLoDefModel.getLoAdit();
        return LoDefModelFactory.createVtDef(loAditModel.getVtAditRef(), loAditModel.getIndex(), iLoDefModel.getLoNum(), iLoDefModel.getLoPathWidth(), iLoDefModel.getPathIdentifier(), iLoDefModel.getPortIndex());
    }

    protected static sVtDef createVtDef(VtAdit vtAdit, int n, ILoNum iLoNum, int n2, short s, int n3) {
        short s2 = 0;
        short s3 = 0;
        if (iLoNum != null) {
            s2 = iLoNum.getIdlGroupNum();
            s3 = iLoNum.getIdlNumInGroup();
        }
        return new sVtDef(vtAdit, n, s2, s3, eVtPathWidth.from_int(n2), s, n3);
    }

    public static ILoDefModel getILoDef(NodeModelDelegate nodeModelDelegate, sVtDef sVtDef2) {
        LoAditModel loAditModel = (LoAditModel)((ConnectionModelsDelegate)nodeModelDelegate.getConnectionModels()).loAdits.get(sVtDef2.vtAditObjIndex);
        if (loAditModel == null) {
            if (db.on()) {
                db.println("Cannot find VtAdit Index = " + sVtDef2.vtAditObjIndex);
            }
            throw new CmsObjectNotExistException("A VT adit with the index " + sVtDef2.vtAditObjIndex + " cannot be found.");
        }
        return LoDefModelFactory.createLoDefModel(nodeModelDelegate, loAditModel, sVtDef2.vtGroupNum, sVtDef2.vtNum, sVtDef2.pathWidth.value(), sVtDef2.pathIdentifier, sVtDef2.port);
    }

    protected static ILoDefModel createLoDefModel(INodeModel iNodeModel, ILoAditModel iLoAditModel, int n, int n2, int n3, short s, int n4) {
        ICircuitSize iCircuitSize = CircuitSize.width2sizeOfLoCircuit((int)n3);
        int n5 = iLoAditModel.getHo().getStartingHo().getFramingType();
        ILoNum iLoNum = HoLoFactory.idlVtStruct2LoNum(n5, iCircuitSize.getEnum(), n, n2);
        return new LoDefModel(iNodeModel, iLoAditModel, iLoNum, n3, s, n4);
    }

    public static sVtPathInfo[] applyPathWidth2VtPathInfoArray(sVtPathInfo[] sVtPathInfoArray, eVtPathWidth eVtPathWidth2) {
        if (sVtPathInfoArray == null) {
            return null;
        }
        sVtPathInfo[] sVtPathInfoArray2 = new sVtPathInfo[sVtPathInfoArray.length];
        for (int i = 0; i < sVtPathInfoArray.length; ++i) {
            sVtPathInfoArray2[i] = LoDefModelFactory.applyPathWidth2VtPathInfo(sVtPathInfoArray[i], eVtPathWidth2);
        }
        return sVtPathInfoArray2;
    }

    public static sVtPathInfo applyPathWidth2VtPathInfo(sVtPathInfo sVtPathInfo2, eVtPathWidth eVtPathWidth2) {
        if (sVtPathInfo2.pathWidth.value() == 4) {
            return new sVtPathInfo(sVtPathInfo2.vtGroupNum, sVtPathInfo2.vtNum, eVtPathWidth2);
        }
        return new sVtPathInfo(sVtPathInfo2.vtGroupNum, sVtPathInfo2.vtNum, sVtPathInfo2.pathWidth);
    }
}

