/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOpticsModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.ui.DwdmSide;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;

public class OchPortsHelper {
    private static final SDebug db = new SDebug("OchPortsHelper");
    private static final String SIDE_PREFIX = "side ";

    private OchPortsHelper() {
    }

    public static boolean isAddPort(INodeModel iNodeModel, int n) {
        try {
            return OchPortsHelper.isAddPort(iNodeModel.getEntityTable().getEntityModelByIndex(n));
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return false;
        }
    }

    public static boolean isAddPort(IEntityModel iEntityModel) {
        int n = iEntityModel.getEqType();
        int n2 = iEntityModel.getModuleModel().getEqType();
        boolean bl = false;
        if (n2 == 131 || n2 == 242 || n2 == 191) {
            bl = true;
        } else if (n2 == 132 || n2 == 241 || n2 == 192) {
            bl = false;
        } else if (n2 == 133 || n == 141) {
            bl = iEntityModel.getEntityIndex() % 2 == 0;
        } else if (iEntityModel.getNodeModel().provides(Feature.PASSIVE_UNITS) && iEntityModel instanceof IOpticsPortModel) {
            bl = ((IOpticsPortModel)iEntityModel).isOchncAddPort();
        } else if (OchPortsHelper.isOchPort(iEntityModel)) {
            if (Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.OCH_TRAIL_PROVISIONING)) {
                IPortModel iPortModel = (IPortModel)iEntityModel;
                IOpticsModel iOpticsModel = (IOpticsModel)iPortModel.getInterfaceModel();
                bl = iOpticsModel.isPortTypeRX();
            } else {
                throw new FeatureNotSupported("IOpticsModel.isPortTypeRX() is not supported");
            }
        }
        if (db.on()) {
            db.println("isAddPort: " + iEntityModel + ", card " + iEntityModel.getModuleModel() + ", eqType " + n + ": " + bl);
        }
        return bl;
    }

    public static boolean isPortTypeRx(INodeModel iNodeModel, int n) {
        try {
            return OchPortsHelper.isPortTypeRx(iNodeModel.getEntityTable().getEntityModelByIndex(n));
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return false;
        }
    }

    public static boolean isPortTypeRx(IEntityModel iEntityModel) {
        int n = iEntityModel.getEqType();
        int n2 = iEntityModel.getModuleModel().getEqType();
        boolean bl = false;
        if (n2 == 131 || n2 == 242 || n2 == 191) {
            bl = true;
        } else if (n2 == 132 || n2 == 241 || n2 == 192) {
            bl = false;
        } else if (n2 == 133 || n == 141) {
            bl = iEntityModel.getEntityIndex() % 2 == 0;
        } else if (iEntityModel.getNodeModel().provides(Feature.PASSIVE_UNITS) && iEntityModel instanceof IOpticsPortModel) {
            bl = ((IOpticsPortModel)iEntityModel).isOptPortTypeRX();
        } else if (iEntityModel.getNodeModel().provides(Feature.OCH_TRAIL_PROVISIONING)) {
            IPortModel iPortModel = (IPortModel)iEntityModel;
            IOpticsModel iOpticsModel = (IOpticsModel)iPortModel.getInterfaceModel();
            bl = iOpticsModel.isPortTypeRX();
        } else {
            throw new FeatureNotSupported("IOpticsModel.isPortTypeRX() is not supported");
        }
        if (db.on()) {
            db.println("isPortTypeRx: " + iEntityModel + ", card " + iEntityModel.getModuleModel() + ", eqType " + n + ": " + bl);
        }
        return bl;
    }

    public static boolean isOpticPort(INodeModel iNodeModel, int n) {
        IEntityModel iEntityModel;
        boolean bl;
        block4: {
            bl = false;
            iEntityModel = null;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                if (iEntityModel instanceof IPortModel) {
                    IPortModel iPortModel = (IPortModel)iEntityModel;
                    bl = iPortModel.getNodeModel().provides(Feature.PASSIVE_UNITS) ? iPortModel instanceof IOpticsPortModel : iPortModel.getInterfaceModel() instanceof IOpticsModel;
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("isOpticPort: exception getting entity model" + exception);
            }
        }
        if (db.on()) {
            db.println("isOpticPort(" + iNodeModel.getName() + ", " + Integer.toHexString(n) + " [" + iEntityModel + "]: " + bl);
        }
        return bl;
    }

    public static boolean isOtsPort(INodeModel iNodeModel, int n) {
        boolean bl;
        block2: {
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                bl = OchPortsHelper.isOtsPort(iEntityModel);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("isOtsPort: exception getting entity model" + exception);
            }
        }
        return bl;
    }

    public static boolean isOtsPort(IEntityModel iEntityModel) {
        if (iEntityModel == null || !(iEntityModel instanceof IPortModel)) {
            return false;
        }
        int n = iEntityModel.getEqType();
        boolean bl = n == 142 || n == 140;
        try {
            if (iEntityModel.getNodeModel().provides(Feature.PASSIVE_UNITS) && iEntityModel instanceof IOpticsPortModel) {
                bl = ((IOpticsPortModel)iEntityModel).isLinePort();
            } else {
                IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
                if (iEntityModel.getNodeModel().provides(Feature.OPTICAL_SIDE) && iInterfaceModel instanceof IOpticsModel) {
                    IOpticsModel iOpticsModel = (IOpticsModel)iInterfaceModel;
                    try {
                        bl = iOpticsModel.isOtsPort();
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        db.warning("Cannot get if " + iEntityModel + " is OTS port: " + noSuchInterface.getMessage());
                    }
                }
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            db.warning("Cannot get if model for " + iEntityModel);
        }
        if (db.on()) {
            db.println("isOtsPort: " + iEntityModel + ", eqType " + n + ": " + bl);
        }
        return bl;
    }

    public static boolean isBandPort(IEntityModel iEntityModel) {
        if (iEntityModel == null || !(iEntityModel instanceof IPortModel)) {
            return false;
        }
        int n = iEntityModel.getEqType();
        boolean bl = n == 141;
        try {
            if (iEntityModel.getNodeModel().provides(Feature.PASSIVE_UNITS) && iEntityModel instanceof IOpticsPortModel) {
                bl = ((IOpticsPortModel)iEntityModel).isBandPort();
            } else {
                IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
                if (iEntityModel.getNodeModel().provides(Feature.OPTICAL_SIDE) && iInterfaceModel instanceof IOpticsModel) {
                    IOpticsModel iOpticsModel = (IOpticsModel)iInterfaceModel;
                    try {
                        bl = iOpticsModel.isOmsPort();
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        db.warning("Cannot get if " + iEntityModel + " is OTS port: " + noSuchInterface.getMessage());
                    }
                }
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            db.warning("Cannot get if model for " + iEntityModel);
        }
        if (db.on()) {
            db.println("isOtsPort: " + iEntityModel + ", eqType " + n + ": " + bl);
        }
        return bl;
    }

    public static boolean isOchPort(IEntityModel iEntityModel) {
        if (iEntityModel == null || !(iEntityModel instanceof IPortModel)) {
            return false;
        }
        int n = iEntityModel.getEqType();
        boolean bl = n == 139 || n == 141;
        try {
            if (iEntityModel.getNodeModel().provides(Feature.PASSIVE_UNITS) && iEntityModel instanceof IOpticsPortModel) {
                bl = ((IOpticsPortModel)iEntityModel).isOchncAddPort() || ((IOpticsPortModel)iEntityModel).isOchncDropPort();
            } else {
                IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
                if (iEntityModel.getNodeModel().provides(Feature.OPTICAL_SIDE) && iInterfaceModel instanceof IOpticsModel) {
                    IOpticsModel iOpticsModel = (IOpticsModel)iInterfaceModel;
                    try {
                        bl = iOpticsModel.isChannelPort();
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        db.warning("Cannot get if " + iEntityModel + " is channel port: " + noSuchInterface.getMessage());
                    }
                }
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            db.warning("Cannot get if model for " + iEntityModel);
        }
        if (db.on()) {
            db.println("isOchPort: " + iEntityModel + ", eqType " + n + ": " + bl);
        }
        return bl;
    }

    public static boolean isOchPort(INodeModel iNodeModel, int n) {
        boolean bl;
        block2: {
            bl = false;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                bl = OchPortsHelper.isOchPort(iEntityModel);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("isOchPort: exception getting entity model" + exception);
            }
        }
        return bl;
    }

    private static int getSideForOCH(IEntityModel iEntityModel) {
        if (db.on()) {
            db.println("Looking for side for OCH port " + iEntityModel);
        }
        int n = 0;
        try {
            if (iEntityModel.getNodeModel().provides(Feature.PASSIVE_UNITS) && iEntityModel instanceof IOpticsPortModel) {
                n = ((IOpticsPortModel)iEntityModel).getSide();
            } else {
                IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
                if (iEntityModel.getNodeModel().provides(Feature.OPTICAL_SIDE) && iInterfaceModel instanceof IOpticsModel) {
                    IOpticsModel iOpticsModel = (IOpticsModel)iInterfaceModel;
                    if (db.on()) {
                        db.println("Found IOpticsModel");
                    }
                    try {
                        n = iOpticsModel.getSide();
                    }
                    catch (Exception exception) {
                        db.warning("Cannot get side of " + iEntityModel + ": " + exception.getMessage());
                    }
                }
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            db.warning("Cannot get if model for " + iEntityModel);
        }
        return n;
    }

    private static int getSideForOts(IEntityModel iEntityModel) {
        if (db.on()) {
            db.println("Looking for side for OTS port " + iEntityModel);
        }
        int n = 0;
        if (iEntityModel.getNodeModel().provides(Feature.OPTICAL_SIDE)) {
            ISideModel[] iSideModelArray = iEntityModel.getNodeModel().getSideModels().getSides();
            int n2 = iEntityModel.getEntityIndex();
            for (int i = 0; i < iSideModelArray.length; ++i) {
                ISideModel iSideModel = iSideModelArray[i];
                if (iSideModel.getLineIn() != n2 && iSideModel.getLineOut() != n2) continue;
                if (db.on()) {
                    db.println("Found matching side " + iSideModel);
                }
                n = iSideModel.getId();
                break;
            }
        }
        if (n == 0) {
            n = OchPortsHelper.getSideForOCH(iEntityModel);
        }
        return n;
    }

    public static int getSide(IEntityModel iEntityModel) {
        if (db.on()) {
            db.println("Looking for side for port " + iEntityModel);
        }
        int n = 0;
        if (OchPortsHelper.isOchPort(iEntityModel)) {
            n = OchPortsHelper.getSideForOCH(iEntityModel);
        } else if (OchPortsHelper.isOtsPort(iEntityModel)) {
            n = OchPortsHelper.getSideForOts(iEntityModel);
        }
        if (db.on()) {
            db.println("Side is" + n + "(" + DwdmSide.getSideFromOffset(n) + ")");
        }
        return n;
    }

    public static String getSideString(IEntityModel iEntityModel, SideStringType sideStringType) {
        StringBuilder stringBuilder = new StringBuilder();
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        if (iNodeModel.provides(Feature.OPTICAL_SIDE)) {
            if (sideStringType == SideStringType.CommaSeparated) {
                stringBuilder.append(", ").append(SIDE_PREFIX);
            } else if (sideStringType == SideStringType.SlashSeparated) {
                stringBuilder.append("/");
            }
            int n = 0;
            if (iEntityModel instanceof IOpticsPortModel) {
                n = ((IOpticsPortModel)iEntityModel).getSide();
                stringBuilder.append(DwdmSide.getSideFromOffset(n));
            } else if (OchPortsHelper.isOtsPort(iEntityModel)) {
                n = OchPortsHelper.getSideForOts(iEntityModel);
                stringBuilder.append(DwdmSide.getSideFromOffset(n));
            } else if (OchPortsHelper.isOchPort(iEntityModel)) {
                n = OchPortsHelper.getSideForOCH(iEntityModel);
                stringBuilder.append(DwdmSide.getSideFromOffset(n));
            } else {
                return "";
            }
        }
        return stringBuilder.toString();
    }

    public static IOpticsPortModel[] getAllOpticsPorts(INodeModel iNodeModel) {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        if (iNodeModel.provides(Feature.PASSIVE_UNITS)) {
            List list = iNodeModel.getEntityTable().getPortEntities();
            for (IEntityModel iEntityModel : list) {
                if (!(iEntityModel instanceof IOpticsPortModel)) continue;
                arrayList.add(iEntityModel);
            }
        }
        return arrayList.toArray(new IOpticsPortModel[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SideStringType {
        NullSeparated,
        CommaSeparated,
        SlashSeparated;

    }
}

