/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvOpticsCardModel;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.eObflStatus;
import cerent.cms.idl.Equipment.sObflInfo;
import cerent.cms.idl.Optics.ALS_SUPPORTED;
import cerent.cms.idl.Optics.eLaserStatus;
import cerent.cms.idl.Optics.eOSRIStatus;
import cerent.cms.idl.Optics.eOpticalAmplifierControlMode;
import cerent.cms.idl.Optics.eOpticalAmplifierRole;
import cerent.cms.idl.OpticsTopology.sOpticalPatchCord;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IDwdmPatchordManager;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.OscTermConnectionModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.RamanOpticsLineModel;
import cerent.cms.model.SettingDisabled;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.view.fv.helper.OpticalPatchCord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.omg.CORBA.UserException;

public class OpticsModuleModel
extends ModuleModel
implements IFvOpticsCardModel,
ALS_SUPPORTED,
IDwdmPatchordManager {
    static final byte LINE = 0;
    static final byte AMPLIFIED_LINE = 1;
    static final byte MULTIPLEX_SECTION = 2;
    static final byte CHANNEL = 3;
    static final byte COM_TX_LINE = 4;
    public static final byte BST_ALS_INTERFACE_INDEX = 5;
    public static final byte PRE_ALS_INTERFACE_INDEX = 1;
    private boolean isLaserSupportedInited = false;
    private boolean isOpticsLinePowerSupportedInited = false;
    private boolean isOpticsLineVOASupportedInited = false;
    private boolean isOpticsAmplifiedLinePowerSupportedInited = false;
    private boolean isOpticsChannelPowerSupportedInited = false;
    private boolean isOpticsChannelAddPowerSupportedInited = false;
    private boolean isOpticsChannelVOASupportedInited = false;
    private boolean isOMSPowerSupportedInited = false;
    private boolean laserSupportedValue = false;
    private boolean opticsLinePowerSupportedValue = false;
    private boolean opticsLineVOASupportedValue = false;
    private boolean opticsAmplifiedLinePowerSupportedValue = false;
    private boolean opticsChannelPowerSupportedValue = false;
    private boolean opticsChannelAddPowerSupportedValue = false;
    private boolean opticsChannelVOASupportedValue = false;
    private boolean oMSPowerSupportedValue = false;
    private boolean evenWavelength = false;
    private OFBLInfo obflInfo;
    private OBFLStart obflStart;
    public static int ALL_OSRI_INTERFACES = -1;
    private ConnectionsPerPort connectionsPerPort = new ConnectionsPerPort();

    public OpticsModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(OpticsModuleModel.class));
    }

    public OpticsModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, sDebug);
        this.obflInfo = new OFBLInfo(this.node, "OpticsModuleModel.getOBFLInfo");
        this.obflStart = new OBFLStart(this.node, "OpticsModuleModel.startOBFL");
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        portModelArray = OpticsPortModel.isPortSupported(eEqType2) ? this.getChildrenOfType(eEqType2).toArray(new OpticsPortModel[0]) : (eEqType2 == eEqType.OC3_PORT ? this.getChildrenOfType(eEqType2).toArray(new TdmPortModel[0]) : super.getPortModels(eEqType2));
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public boolean isOpticsCard() {
        return true;
    }

    public eOpticalAmplifierRole getAmpliRole() throws NoSuchInterface, WrongInterfaceType {
        OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.getOpticsAmplifiedLineModels();
        if (opticsAmplifiedLineModelArray.length > 0) {
            return opticsAmplifiedLineModelArray[0].getAmpliRole();
        }
        return eOpticalAmplifierRole.NO_AMPLI;
    }

    public void setAmpliRole(eOpticalAmplifierRole eOpticalAmplifierRole2) throws ConfigError, WrongInterfaceType, NoSuchInterface, SettingDisabled {
        OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.getOpticsAmplifiedLineModels();
        if (opticsAmplifiedLineModelArray.length > 0) {
            opticsAmplifiedLineModelArray[0].setAmpliRole(eOpticalAmplifierRole2);
        }
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        PortModel[] portModelArray = this.getPortModels(eEqType2);
        InterfaceModel[] interfaceModelArray = null;
        if (eEqType2 == eEqType.OC3_PORT) {
            interfaceModelArray = new TdmLineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                interfaceModelArray[i] = (TdmLineModel)portModelArray[i].getInterfaceModel();
            }
        } else {
            interfaceModelArray = super.getLineModels(eEqType2);
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    public OpticsPortModel[] getOpticsChildren() {
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>();
        for (eEqType eEqType2 : OpticsPortModel.getSupportePortTypes()) {
            arrayList.addAll(Arrays.asList(this.getPortModels(eEqType2)));
        }
        return arrayList.toArray(new OpticsPortModel[0]);
    }

    public TdmPortModel[] getOC3Children() {
        return (TdmPortModel[])this.getPortModels(eEqType.OC3_PORT);
    }

    protected Vector getOpticsModels(byte by) {
        Vector<AbstractOpticsLineModel> vector = new Vector<AbstractOpticsLineModel>();
        OpticsPortModel[] opticsPortModelArray = this.getOpticsChildren();
        block10: for (int i = 0; i < opticsPortModelArray.length; ++i) {
            switch (by) {
                case 0: {
                    if (!(opticsPortModelArray[i].getOpticsLineModel() instanceof OpticsLineModel)) continue block10;
                    vector.add(opticsPortModelArray[i].getOpticsLineModel());
                    continue block10;
                }
                case 4: {
                    if (!(opticsPortModelArray[i].getOpticsLineModel() instanceof OpticsLineModel)) continue block10;
                    try {
                        if (opticsPortModelArray[i].getOptPortType() != OpticalPortType.OUT_COM) continue block10;
                        vector.add(opticsPortModelArray[i].getOpticsLineModel());
                    }
                    catch (WrongPortType wrongPortType) {
                        if (!this.db.on()) continue block10;
                        SDebug.printStackTrace((Throwable)wrongPortType);
                    }
                    catch (NoSuchEquipment noSuchEquipment) {
                        if (!this.db.on()) continue block10;
                        SDebug.printStackTrace((Throwable)noSuchEquipment);
                    }
                    continue block10;
                }
                case 1: {
                    if (!(opticsPortModelArray[i].getOpticsLineModel() instanceof OpticsAmplifiedLineModel)) continue block10;
                    vector.add(opticsPortModelArray[i].getOpticsLineModel());
                    continue block10;
                }
                case 2: {
                    if (!(opticsPortModelArray[i].getOpticsLineModel() instanceof OpticsMultiplexSectionModel)) continue block10;
                    vector.add(opticsPortModelArray[i].getOpticsLineModel());
                    continue block10;
                }
                case 3: {
                    if (!(opticsPortModelArray[i].getOpticsLineModel() instanceof OpticsChannelModel)) continue block10;
                    vector.add(opticsPortModelArray[i].getOpticsLineModel());
                }
            }
        }
        return vector;
    }

    public OpticsLineModel[] getOpticsLineModels() {
        return this.getOpticsModels((byte)0).toArray(new OpticsLineModel[0]);
    }

    public OpticsLineModel[] getComTxLineModels() {
        return this.getOpticsModels((byte)4).toArray(new OpticsLineModel[0]);
    }

    public OpticsLineModel[] getOTSSupportingPM() {
        OpticsLineModel[] opticsLineModelArray = this.getOpticsLineModels();
        ArrayList<OpticsLineModel> arrayList = new ArrayList<OpticsLineModel>();
        for (int i = 0; i < opticsLineModelArray.length; ++i) {
            if (!opticsLineModelArray[i].isPMSupported()) continue;
            arrayList.add(opticsLineModelArray[i]);
        }
        return arrayList.toArray(new OpticsLineModel[0]);
    }

    public OpticsAmplifiedLineModel[] getAOTSSupportingPM() {
        OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.getOpticsAmplifiedLineModels();
        ArrayList<OpticsAmplifiedLineModel> arrayList = new ArrayList<OpticsAmplifiedLineModel>();
        for (int i = 0; i < opticsAmplifiedLineModelArray.length; ++i) {
            if (!opticsAmplifiedLineModelArray[i].isPMSupported()) continue;
            arrayList.add(opticsAmplifiedLineModelArray[i]);
        }
        return arrayList.toArray(new OpticsAmplifiedLineModel[0]);
    }

    public OpticsAmplifiedLineModel[] getOpticsAmplifiedLineModels() {
        return this.getOpticsModels((byte)1).toArray(new OpticsAmplifiedLineModel[0]);
    }

    public AbstractOpticsLineModel[] getLinesSupportingChanelPower() {
        InterfaceModel[] interfaceModelArray = this.node.getIfModels().getAllInterfaceModels(this);
        ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            try {
                if ((((AbstractOpticsLineModel)interfaceModelArray[i]).getFeatures() & 0x20000) != 131072) continue;
                ArrayList arrayList2 = new ArrayList();
                arrayList.add(interfaceModelArray[i]);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return arrayList.toArray(new AbstractOpticsLineModel[0]);
    }

    public AbstractOpticsLineModel[] getOpticsRamanLineModels(boolean bl) {
        Vector vector = this.getOpticsModels((byte)0);
        Vector<OpticsLineModel> vector2 = new Vector<OpticsLineModel>();
        for (OpticsLineModel opticsLineModel : vector) {
            if (bl) {
                if (!(opticsLineModel instanceof RamanOpticsLineModel)) continue;
                vector2.add(opticsLineModel);
                continue;
            }
            if (opticsLineModel instanceof RamanOpticsLineModel) continue;
            vector2.add(opticsLineModel);
        }
        if (bl) {
            return vector2.toArray(new RamanOpticsLineModel[0]);
        }
        return vector2.toArray(new OpticsLineModel[0]);
    }

    public OpticsChannelModel[] getOpticsChannelModels() {
        return this.getOpticsModels((byte)3).toArray(new OpticsChannelModel[0]);
    }

    public OpticsMultiplexSectionModel[] getOpticsOMSModels() {
        return this.getOpticsModels((byte)2).toArray(new OpticsMultiplexSectionModel[0]);
    }

    public boolean isOpticsLinePowerSupported() {
        if (!this.isOpticsLinePowerSupportedInited) {
            this.opticsLinePowerSupportedValue = this.opticsLinePowerSupportedInit();
            this.isOpticsLinePowerSupportedInited = true;
        }
        return this.opticsLinePowerSupportedValue;
    }

    public boolean isOpticsLineVOASupported() {
        if (!this.isOpticsLineVOASupportedInited) {
            this.opticsLineVOASupportedValue = this.opticsLineVOASupportedInit();
            this.isOpticsLineVOASupportedInited = true;
        }
        return this.opticsLineVOASupportedValue;
    }

    public boolean isOpticsAmplifiedLinePowerSupported() {
        if (!this.isOpticsAmplifiedLinePowerSupportedInited) {
            this.opticsAmplifiedLinePowerSupportedValue = this.opticsAmplifiedLinePowerSupportedInit();
            this.isOpticsAmplifiedLinePowerSupportedInited = true;
        }
        return this.opticsAmplifiedLinePowerSupportedValue;
    }

    public boolean isOpticsChannelPowerSupported() {
        if (!this.isOpticsChannelPowerSupportedInited) {
            this.opticsChannelPowerSupportedValue = this.opticsChannelPowerSupportedInit();
            this.isOpticsChannelPowerSupportedInited = true;
        }
        return this.opticsChannelPowerSupportedValue;
    }

    public boolean isOpticsChannelAddPowerSupported() {
        if (!this.isOpticsChannelAddPowerSupportedInited) {
            this.opticsChannelAddPowerSupportedValue = this.opticsChannelAddPowerSupportedInit();
            this.isOpticsChannelAddPowerSupportedInited = true;
        }
        return this.opticsChannelAddPowerSupportedValue;
    }

    public boolean isOpticsChannelVOASupported() {
        if (!this.isOpticsChannelVOASupportedInited) {
            this.opticsChannelVOASupportedValue = this.opticsChannelVOASupportedInit();
            this.isOpticsChannelVOASupportedInited = true;
        }
        return this.opticsChannelVOASupportedValue;
    }

    public boolean isOMSPowerSupported() {
        if (!this.isOMSPowerSupportedInited) {
            this.oMSPowerSupportedValue = this.oMSPowerSupportedInit();
            this.isOMSPowerSupportedInited = true;
        }
        return this.oMSPowerSupportedValue;
    }

    public boolean isLaserSupported() {
        if (!this.isLaserSupportedInited) {
            this.laserSupportedValue = this.laserSupportedInit();
            this.isLaserSupportedInited = true;
        }
        return this.laserSupportedValue;
    }

    private boolean opticsLinePowerSupportedInit() {
        OpticsLineModel[] opticsLineModelArray = this.getOpticsModels((byte)0).toArray(new OpticsLineModel[0]);
        for (int i = 0; i < opticsLineModelArray.length; ++i) {
            try {
                if ((opticsLineModelArray[i].getFeatures() & 0x20) != 32) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private boolean opticsLineVOASupportedInit() {
        OpticsLineModel[] opticsLineModelArray = this.getOpticsModels((byte)0).toArray(new OpticsLineModel[0]);
        for (int i = 0; i < opticsLineModelArray.length; ++i) {
            try {
                if ((opticsLineModelArray[i].getFeatures() & 1) != 1) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private boolean opticsAmplifiedLinePowerSupportedInit() {
        OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.getOpticsModels((byte)1).toArray(new OpticsAmplifiedLineModel[0]);
        for (int i = 0; i < opticsAmplifiedLineModelArray.length; ++i) {
            try {
                if ((opticsAmplifiedLineModelArray[i].getFeatures() & 0x20) != 32) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private boolean opticsChannelPowerSupportedInit() {
        OpticsChannelModel[] opticsChannelModelArray = this.getOpticsModels((byte)3).toArray(new OpticsChannelModel[0]);
        for (int i = 0; i < opticsChannelModelArray.length; ++i) {
            try {
                if ((opticsChannelModelArray[i].getFeatures() & 0x20) != 32) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private boolean opticsChannelAddPowerSupportedInit() {
        OpticsChannelModel[] opticsChannelModelArray = this.getOpticsModels((byte)3).toArray(new OpticsChannelModel[0]);
        for (int i = 0; i < opticsChannelModelArray.length; ++i) {
            try {
                if ((opticsChannelModelArray[i].getFeatures() & 0x10) != 16) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    private boolean opticsChannelVOASupportedInit() {
        OpticsChannelModel[] opticsChannelModelArray = this.getOpticsModels((byte)3).toArray(new OpticsChannelModel[0]);
        for (int i = 0; i < opticsChannelModelArray.length; ++i) {
            try {
                if ((opticsChannelModelArray[i].getFeatures() & 1) != 1) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public boolean isAmpliWithBoosterRole() {
        boolean bl;
        block4: {
            bl = false;
            try {
                bl = eOpticalAmplifierRole.BST_AMPLI == this.getAmpliRole();
            }
            catch (NoSuchInterface noSuchInterface) {
                if (this.db.on()) {
                    this.db.println("NoSuchInterface " + (Object)((Object)noSuchInterface));
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) break block4;
                this.db.println("WrongInterface" + (Object)((Object)wrongInterfaceType));
            }
        }
        return bl;
    }

    public boolean isAmplitWithPreRole() {
        boolean bl;
        block4: {
            bl = false;
            try {
                bl = eOpticalAmplifierRole.PRE_AMPLI == this.getAmpliRole();
            }
            catch (NoSuchInterface noSuchInterface) {
                if (this.db.on()) {
                    this.db.println("NoSuchInterface " + (Object)((Object)noSuchInterface));
                }
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) break block4;
                this.db.println("WrongInterface" + (Object)((Object)wrongInterfaceType));
            }
        }
        return bl;
    }

    public boolean oMSPowerSupportedInit() {
        OpticsMultiplexSectionModel[] opticsMultiplexSectionModelArray = this.getOpticsModels((byte)2).toArray(new OpticsMultiplexSectionModel[0]);
        for (int i = 0; i < opticsMultiplexSectionModelArray.length; ++i) {
            try {
                if ((opticsMultiplexSectionModelArray[i].getFeatures() & 0x20) != 32) continue;
                return true;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public AbstractOpticsLineModel[] getALSInterfaces() {
        ArrayList<AbstractOpticsLineModel> arrayList = new ArrayList<AbstractOpticsLineModel>();
        OpticsPortModel[] opticsPortModelArray = this.getOpticsChildren();
        for (int i = 0; i < opticsPortModelArray.length; ++i) {
            try {
                if ((opticsPortModelArray[i].getFeatures() & 2) != 2) continue;
                arrayList.add(opticsPortModelArray[i].getOpticsLineModel());
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return arrayList.toArray(new AbstractOpticsLineModel[0]);
    }

    private boolean laserSupportedInit() {
        OpticsPortModel[] opticsPortModelArray = this.getOpticsChildren();
        int n = 0;
        while (n < opticsPortModelArray.length) {
            try {
                if ((opticsPortModelArray[n].getFeatures() & 0x80) == 128) {
                    return true;
                }
                ++n;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return false;
    }

    public TdmLineModel[] getTdmLineModels() {
        return (TdmLineModel[])this.getLineModels(eEqType.OC3_PORT);
    }

    public eLaserStatus getLaserStatus(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported {
        AbstractOpticsLineModel[] abstractOpticsLineModelArray = this.getALSInterfaces();
        if (abstractOpticsLineModelArray != null) {
            return abstractOpticsLineModelArray[n].getLaserStatus();
        }
        return null;
    }

    public void setOSRIStatus(eOSRIStatus eOSRIStatus2, int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported {
        AbstractOpticsLineModel[] abstractOpticsLineModelArray = this.getALSInterfaces();
        if (n > ALL_OSRI_INTERFACES) {
            if (abstractOpticsLineModelArray[n] != null) {
                abstractOpticsLineModelArray[n].setOSRIStatus(eOSRIStatus2);
            }
        } else {
            for (int i = 0; i < abstractOpticsLineModelArray.length; ++i) {
                abstractOpticsLineModelArray[i].setOSRIStatus(eOSRIStatus2);
            }
        }
    }

    public eOSRIStatus getOSRIStatus(int n) throws NoSuchInterface, WrongInterfaceType, FeatureUnsupported {
        AbstractOpticsLineModel[] abstractOpticsLineModelArray = this.getALSInterfaces();
        if (abstractOpticsLineModelArray[n] != null) {
            return abstractOpticsLineModelArray[n].getOSRIStatus();
        }
        return null;
    }

    public eOpticalAmplifierControlMode getControlMode() throws NoSuchInterface, WrongInterfaceType {
        OpticsAmplifiedLineModel[] opticsAmplifiedLineModelArray = this.getOpticsAmplifiedLineModels();
        if (opticsAmplifiedLineModelArray.length > 0) {
            return opticsAmplifiedLineModelArray[0].getControlMode();
        }
        return null;
    }

    public String toString() {
        return "OpticsModuleModel" + super.toString();
    }

    public List getConnectionsList() {
        HashSet hashSet = new HashSet();
        OpticsPortModel[] opticsPortModelArray = this.getOpticsChildren();
        if (opticsPortModelArray != null) {
            for (int i = 0; i < opticsPortModelArray.length; ++i) {
                List list = this.getOchConnectionModels(opticsPortModelArray[i].getEntityIndex());
                hashSet.addAll(list);
            }
        }
        return new LinkedList(hashSet);
    }

    public boolean hasOSCMOC3UsedPorts() {
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        return ((OscTermConnectionModel)nodeModelDelegate.getOscTermConnectionModel()).hasUsedOc3Ports(this);
    }

    public boolean hasDWDMPatchCord() {
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        if (this.parent != null) {
            int n = this.parent.getIndex();
            return nodeModelDelegate.getOpticalPatchCordModel().hasCardDWDMOpticalPatch(n);
        }
        return false;
    }

    public sOpticalPatchCord[] getDWDMPatchCords() throws NumberFormatException, FeatureUnsupported, NoSuchInterface {
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        if (this.parent != null) {
            int n = this.parent.getIndex();
            return nodeModelDelegate.getOpticalPatchCordModel().getOptLinkModelByCard(new Integer(n));
        }
        return null;
    }

    public boolean isEvenWavelengthCard() {
        boolean bl = false;
        try {
            int n = this.getOpticsChannelModels()[0].getExpectedWaveLength();
            if (n == 84 || n == 93) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.db.on) {
            this.db.println("old :" + this.evenWavelength + "new : " + bl);
        }
        if (this.evenWavelength != bl) {
            this.evenWavelength = bl;
        }
        return bl;
    }

    public String getWavelengthType() {
        return this.isEvenWavelengthCard() ? "E" : "O";
    }

    public String getEqTypeName() {
        String string = super.getEqTypeName();
        if (this.getEqType() == 263 || this.getEqType() == 264) {
            string = string + this.getWavelengthType();
        }
        return string;
    }

    public void init() {
        this.connectionsPerPort.init();
        super.init();
    }

    public void dispose() {
        this.connectionsPerPort.dispose();
        super.dispose();
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(): entry");
        }
        super.updateLocal();
        if (this.db.on()) {
            this.db.println("updateLocal(): exit");
        }
    }

    public List getOchConnectionModels(int n) {
        return this.connectionsPerPort.getOchConnectionModels(n);
    }

    public int getSide() {
        int n = 0;
        OpticsLineModel[] opticsLineModelArray = this.getOpticsLineModels();
        if (opticsLineModelArray.length > 0) {
            try {
                n = opticsLineModelArray[0].getSide();
            }
            catch (NoSuchInterface noSuchInterface) {
                noSuchInterface.printStackTrace();
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                wrongInterfaceType.printStackTrace();
            }
            catch (InternalCommError internalCommError) {
                internalCommError.printStackTrace();
            }
        }
        return n;
    }

    public InterfaceModel[] getAllInterfacesButOchTerm() {
        return this.node.getIfModels().getAllInterfaceModelsExcept(this, OpticsOchTermModel.class);
    }

    public OpticsOchTermModel[] getOchTermWithIngressPort() {
        Collection collection = InterfaceModel.getHigherLayerModels(this.getInterfaceSupportingOch(), 1, this);
        for (OpticsOchTermModel opticsOchTermModel : collection) {
            try {
                opticsOchTermModel.initConnectionModel();
            }
            catch (FeatureUnsupported featureUnsupported) {
                SDebug.printStackTrace((Throwable)featureUnsupported);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        return collection.toArray(new OpticsOchTermModel[0]);
    }

    public OpticsOchTermModel[] getOchTerm() {
        OpticsPortModel[] opticsPortModelArray;
        HashSet<InterfaceModel> hashSet = new HashSet<InterfaceModel>();
        for (OpticsPortModel opticsPortModel : opticsPortModelArray = this.getOpticsChildren()) {
            InterfaceModel[] interfaceModelArray;
            for (InterfaceModel interfaceModel : interfaceModelArray = ((AbstractOpticsLineModel)opticsPortModel.getInterfaceModel()).getHigherLayerModels()) {
                if (!(interfaceModel instanceof OpticsOchTermModel)) continue;
                hashSet.add(interfaceModel);
            }
        }
        return hashSet.toArray(new OpticsOchTermModel[0]);
    }

    public AbstractOpticsLineModel[] getInterfaceSupportingOch() {
        OpticsPortModel[] opticsPortModelArray;
        ArrayList<AbstractOpticsLineModel> arrayList = new ArrayList<AbstractOpticsLineModel>();
        for (OpticsPortModel opticsPortModel : opticsPortModelArray = this.getOpticsChildren()) {
            AbstractOpticsLineModel abstractOpticsLineModel = (AbstractOpticsLineModel)opticsPortModel.getInterfaceModel();
            if (abstractOpticsLineModel.isOCHTERMSupported()) {
                arrayList.add(abstractOpticsLineModel);
            }
            Collections.sort(arrayList);
        }
        return arrayList.toArray(new AbstractOpticsLineModel[0]);
    }

    public AbstractOpticsLineModel[] getAllOpticsInterfaces() {
        OpticsPortModel[] opticsPortModelArray;
        ArrayList<AbstractOpticsLineModel> arrayList = new ArrayList<AbstractOpticsLineModel>();
        for (OpticsPortModel opticsPortModel : opticsPortModelArray = this.getOpticsChildren()) {
            arrayList.add((AbstractOpticsLineModel)opticsPortModel.getInterfaceModel());
        }
        return arrayList.toArray(new AbstractOpticsLineModel[0]);
    }

    public sOpticalPatchCord[] getAllDWDMPatchCords() throws NumberFormatException, FeatureUnsupported, NoSuchInterface {
        return this.getDWDMPatchCords();
    }

    public OpticalPatchCord[] getAllOpticalPatchCords() throws NumberFormatException, FeatureUnsupported, NoSuchInterface {
        sOpticalPatchCord[] sOpticalPatchCordArray = this.getDWDMPatchCords();
        OpticalPatchCord[] opticalPatchCordArray = new OpticalPatchCord[sOpticalPatchCordArray.length];
        for (int i = 0; i < sOpticalPatchCordArray.length; ++i) {
            sOpticalPatchCord sOpticalPatchCord2 = sOpticalPatchCordArray[i];
            int n = sOpticalPatchCord2.type.value();
            int n2 = sOpticalPatchCord2.creationType.value();
            int n3 = sOpticalPatchCord2.bandId.value();
            opticalPatchCordArray[i] = new OpticalPatchCord(sOpticalPatchCord2.creationTime, sOpticalPatchCord2.index, sOpticalPatchCord2.from, sOpticalPatchCord2.to, n, n2, n3, sOpticalPatchCord2.lambda.value());
        }
        return opticalPatchCordArray;
    }

    public sObflInfo getOBFLInfo() {
        sObflInfo sObflInfo2 = null;
        try {
            sObflInfo2 = (sObflInfo)this.obflInfo.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return sObflInfo2;
    }

    public boolean isOFBLSupported() {
        return this.getOBFLInfo().status != eObflStatus.OBFL_UNSUPPORTED;
    }

    public void startOFBL() {
        try {
            this.obflStart.set(eModuleOp.START_OBFL_SNAPSHOT);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    private class ConnectionsPerPort
    implements IObserver {
        private Map<Integer, List> connectionsPerPort = new HashMap<Integer, List>();

        private ConnectionsPerPort() {
        }

        void init() {
            OpticsModuleModel.this.getNodeModel().getConnectionModels().addObserver((IObserver)this);
        }

        void dispose() {
            OpticsModuleModel.this.getNodeModel().getConnectionModels().deleteObserver((IObserver)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getOchConnectionModels(int n) {
            Map<Integer, List> map = this.connectionsPerPort;
            synchronized (map) {
                List list = this.connectionsPerPort.get(n);
                if (list == null) {
                    list = OpticsModuleModel.this.getNodeModel().getConnectionModels().getOchConnectionModels(n);
                    this.connectionsPerPort.put(n, list);
                }
                return list;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(IObservable iObservable, Object object) {
            if (iObservable instanceof IConnectionModels) {
                Map<Integer, List> map = this.connectionsPerPort;
                synchronized (map) {
                    this.connectionsPerPort.clear();
                }
            }
        }
    }

    private class OBFLStart
    extends NonCachedValue {
        public OBFLStart(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            OpticsModuleModel.this.getCardModuleRef().doCommand(OpticsModuleModel.this.entityIndex, (eModuleOp)object);
        }
    }

    private class OFBLInfo
    extends NonCachedValue {
        private OFBLInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OpticsModuleModel.this.getCardModuleRef().getObflInfo(OpticsModuleModel.this.entityIndex);
        }
    }
}

