/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.sShelfInfoSubset;
import cerent.cms.idl.Equipment.sShelfPosition;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.EntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.ShelfInfo;
import cerent.cms.model.ShelfInfoFactory;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.Observable;

public class PassiveChassisModel
extends Model
implements IShelfViewModel {
    final NodeModelDelegate nmd;
    final ChassisModels cms;
    final short size;
    short rackNum;
    short rackPos;
    final int shelfId;
    private final PassiveModuleModel[] children;
    private PassiveModuleModel inner;

    static short getRUOccupied(eEqType eEqType2) {
        if (eEqType2.equals(eEqType.PASSIVE_DCU) || eEqType2.equals(eEqType.PASSIVE_PP_4_SMR)) {
            return 1;
        }
        return 2;
    }

    public static int getNumberOfSlots(eEqType eEqType2) {
        if (eEqType2.equals(eEqType.PASSIVE_DCU)) {
            return 2;
        }
        return 1;
    }

    public PassiveChassisModel(NodeModelDelegate nodeModelDelegate, int n, short s, short s2, short s3, short s4) {
        super(nodeModelDelegate.getChildDebug(PassiveChassisModel.class));
        this.nmd = nodeModelDelegate;
        this.cms = nodeModelDelegate.getChassisModelsInstance();
        this.shelfId = n;
        this.rackNum = s;
        this.rackPos = s2;
        this.size = s3;
        this.children = new PassiveModuleModel[s4];
    }

    public void dispose() {
        this.cms.update((Observable)((Object)this), 0);
        super.dispose();
    }

    public void update(Observable observable, Object object) {
        int n = -1;
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        if (observable instanceof PassiveModuleModel) {
            switch (n) {
                case 2: {
                    if (((PassiveModuleModel)((Object)observable)).isInnerUnit()) {
                        this.inner = (PassiveModuleModel)((Object)observable);
                        break;
                    }
                    int n2 = ((PassiveModuleModel)((Object)observable)).getSlotPosition();
                    this.children[n2 - 1] = (PassiveModuleModel)((Object)observable);
                    break;
                }
                case 0: {
                    for (int i = 0; i < this.children.length; ++i) {
                        if (this.children[i] != observable) continue;
                        this.children[i] = null;
                        break;
                    }
                    if (this.inner != observable) break;
                    this.inner = null;
                }
            }
            if (this.isEmpty()) {
                this.dispose();
            } else {
                this.setChanged();
                super.updateLocal();
            }
        }
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    public IPlatform getPlatform() {
        return this.nmd.getPlatform();
    }

    public short getRUOccupied() {
        return this.size;
    }

    public short getRackNumber() {
        try {
            sShelfInfoSubset sShelfInfoSubset2 = this.cms.getShelfInfoForChassis(this);
            return sShelfInfoSubset2.position.rackNumber;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return 0;
        }
    }

    public short getRackPosition() {
        try {
            sShelfInfoSubset sShelfInfoSubset2 = this.cms.getShelfInfoForChassis(this);
            return sShelfInfoSubset2.position.positionInRack;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return 0;
        }
    }

    public String getRackLocation() {
        if (this.nmd.isMultishelf()) {
            StringBuilder stringBuilder = new StringBuilder();
            short s = this.getRackNumber();
            if (s != 0) {
                stringBuilder.append("[R");
                stringBuilder.append(s);
                stringBuilder.append(",P");
                stringBuilder.append(this.getRackPosition());
                stringBuilder.append("]");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public sShelfPosition getInternalPosition() {
        return new sShelfPosition(this.rackNum, this.rackPos);
    }

    public void setInternalPosition(sShelfPosition sShelfPosition2) {
        if (this.rackNum != sShelfPosition2.rackNumber || this.rackPos != sShelfPosition2.positionInRack) {
            this.rackNum = sShelfPosition2.rackNumber;
            this.rackPos = sShelfPosition2.positionInRack;
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == null) continue;
                try {
                    this.children[i].setPosition(this.rackNum, this.rackPos, (short)(i + 1));
                    continue;
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (this.inner != null) {
                try {
                    this.inner.setPosition(this.rackNum, this.rackPos, (short)1);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            this.setChanged();
            super.updateLocal();
        }
    }

    public int getShelfId() {
        return this.shelfId;
    }

    public int getShelfIndex() {
        return this.shelfId;
    }

    public ShelfInfo getShelfInfo() {
        try {
            sShelfInfoSubset sShelfInfoSubset2 = this.cms.getShelfInfoForChassis(this);
            return ShelfInfoFactory.getShelfInfo((short)this.shelfId, sShelfInfoSubset2.position.rackNumber, sShelfInfoSubset2.position.positionInRack, this, this.nmd.isMultishelf());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return null;
        }
    }

    public int getShelfType() {
        return 324;
    }

    public String getShelfTypeName() {
        return EntityModel.eqType2Name(null, 324);
    }

    public TDMTerminology getTDMTerminology() {
        return this.nmd.getTDMTerminology();
    }

    public void unprovision() throws ProvisionError, ResourceInUse {
        int n;
        for (n = 0; n < this.children.length; ++n) {
            if (this.children[n] == null || !this.children[n].isInUse()) continue;
            throw new ResourceInUse("Passive unit in use " + this.children[n]);
        }
        if (this.inner != null && this.inner.isInUse()) {
            throw new ResourceInUse("Passive unit in use " + this.inner);
        }
        for (n = 0; n < this.children.length; ++n) {
            if (this.children[n] == null) continue;
            this.children[n].unprovision();
            this.children[n] = null;
        }
        if (this.inner != null) {
            this.inner.unprovision();
        }
        this.dispose();
    }

    public int getNumberOfSlots() {
        return this.children.length;
    }

    public PassiveModuleModel getChildOfSlotNumber(int n) {
        for (PassiveModuleModel passiveModuleModel : this.children) {
            if (passiveModuleModel == null || passiveModuleModel.getSlotPosition() != n) continue;
            return passiveModuleModel;
        }
        return null;
    }

    public PassiveModuleModel getChildOfEqType(eEqType eEqType2) {
        for (PassiveModuleModel passiveModuleModel : this.children) {
            if (passiveModuleModel == null || !passiveModuleModel.getEqTypeEnum().equals(eEqType2)) continue;
            return passiveModuleModel;
        }
        return null;
    }

    public PassiveModuleModel getInnerChild() {
        return this.inner;
    }

    private boolean isEmpty() {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null) continue;
            return false;
        }
        return this.inner == null;
    }

    public String toString() {
        return "PASSIVE CHASSIS @" + this.rackNum + "/" + this.rackPos + " Size " + this.size;
    }
}

