/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.ProtectionGroup;
import cerent.cms.idl.Equipment.eProtectionType;
import cerent.cms.idl.Equipment.sProtGroupListElem;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.omg.CORBA.UserException;

public class ProtectionGroupModels
extends Model {
    NodeModelDelegate node;
    Map pgs = new HashMap();
    private EntityIndex entityIndex = null;
    private Name name = null;
    private ProtectType protectType = null;
    private MainModules mainModules = null;
    private EventDispatcher dispatcher;
    private static NodeSingletonFactory<ProtectionGroupModels> sfactory = new NodeSingletonFactory<ProtectionGroupModels>(ProtectionGroupModels.class);

    public static ProtectionGroupModels getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private ProtectionGroupModels(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.setDebug(nodeModelDelegate.getChildDebug(ProtectionGroupModels.class, ProtectionGroupModelsDebug.class, this));
        this.node = nodeModelDelegate;
        this.index = 0;
        this.entityIndex = new EntityIndex(nodeModelDelegate, "ProtectionGroupModels.entityIndex");
        this.name = new Name(nodeModelDelegate, "ProtectionGroupModels.name");
        this.protectType = new ProtectType(nodeModelDelegate, "ProtectionGroupModels.protectType");
        this.mainModules = new MainModules(nodeModelDelegate, "ProtectiongroupModels.mainModules");
        this.dispatcher = null;
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("init()");
        }
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectProtectionGroupList, 0, (Observer)this);
        }
        this.discoverProtectionGroups();
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Collection collection;
        if (this.db.on()) {
            this.db.println("dispose(): entry");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectProtectionGroupList, 0, (Observer)this);
        }
        Object object = this;
        synchronized (object) {
            collection = this.pgs.values();
            this.pgs = new HashMap();
        }
        if (this.db.on()) {
            this.db.println("dispose(): Delete PGModel from Collection");
        }
        object = collection.iterator();
        while (object.hasNext()) {
            ((ProtectionGroupModel)object.next()).destroy();
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public ProtectionGroupModel getProtectionGroupModel(int n) {
        if (this.db.on()) {
            this.db.println("getProtectionGroupModel(" + Integer.toHexString(n) + ")");
        }
        return (ProtectionGroupModel)this.pgs.get(new Integer(n));
    }

    private ProtectionGroupModel makeProtectionGroupModel(ProtectionGroup protectionGroup, String string, eProtectionType eProtectionType2, ModuleModel moduleModel, ModuleModel[] moduleModelArray) {
        if (this.db.on()) {
            this.db.println("makeProtectionGroupModel(...) entry");
        }
        ProtectionGroupModel protectionGroupModel = new ProtectionGroupModel(protectionGroup, string, eProtectionType2, moduleModel, moduleModelArray);
        this.pgs.put(new Integer(protectionGroupModel.getIndex()), protectionGroupModel);
        if (this.db.on()) {
            this.db.println("makeProtectionGroupModel(...) exit    newModel = " + protectionGroupModel);
        }
        return protectionGroupModel;
    }

    public ProtectionGroupModel makeProtectionGroupModel(ProtectionGroup protectionGroup) {
        try {
            ModuleModel moduleModel;
            int n;
            String string;
            block13: {
                string = (String)this.name.get(protectionGroup);
                if (this.db.on) {
                    this.db.println("makeProtectionGroupModel(pgRef): entry");
                    this.db.println("     name = " + string);
                }
                n = (Integer)this.entityIndex.get(protectionGroup);
                if (this.db.on) {
                    this.db.println("     entityIndex = " + Integer.toHexString(n));
                    this.db.println("     node = " + this.node);
                }
                try {
                    if (this.db.on()) {
                        this.db.println("     node.getEntityTableModel()getEntityModelByIndex(entityIndex) = " + this.node.getEntityTableModel().getEntityModelByIndex(n));
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) break block13;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            try {
                moduleModel = (ModuleModel)this.node.getEntityTableModel().getEntityModelByIndex(n);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                return null;
            }
            int[] nArray = (int[])this.mainModules.get(protectionGroup);
            int n2 = nArray.length;
            LinkedList<ModuleModel> linkedList = new LinkedList<ModuleModel>();
            for (int i = 0; i < n2; ++i) {
                n = nArray[i];
                try {
                    linkedList.add((ModuleModel)this.node.getEntityTableModel().getEntityModelByIndex(n));
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            ModuleModel[] moduleModelArray = new ModuleModel[linkedList.size()];
            moduleModelArray = linkedList.toArray(moduleModelArray);
            eProtectionType eProtectionType2 = (eProtectionType)this.protectType.get(protectionGroup);
            return this.makeProtectionGroupModel(protectionGroup, string, eProtectionType2, moduleModel, moduleModelArray);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public ProtectionGroupModel[] getProtectionGroupModelArray() {
        if (this.db.on()) {
            this.db.println("getProtectionGroupModelArray()");
        }
        return this.pgs.values().toArray(new ProtectionGroupModel[0]);
    }

    public ProtectionGroupModel[] getProtectionGroupModelArray(IChassisModel iChassisModel) {
        this.db.fine("getProtectionGroupModelArray(" + iChassisModel + ")");
        HashSet<ProtectionGroupModel> hashSet = new HashSet<ProtectionGroupModel>();
        for (ProtectionGroupModel protectionGroupModel : this.pgs.values()) {
            ModuleModel moduleModel = (ModuleModel)protectionGroupModel.getProtectModuleModel();
            if (moduleModel == null || moduleModel.getChassis() != iChassisModel) continue;
            hashSet.add(protectionGroupModel);
        }
        return hashSet.toArray(new ProtectionGroupModel[hashSet.size()]);
    }

    protected void remove(int n) {
        if (this.db.on()) {
            this.db.println("remove(" + Integer.toHexString(n) + "): entry");
        }
        this.internalRemove(n);
        this.updateStructure();
        if (this.db.on()) {
            this.db.println("remove(" + Integer.toHexString(n) + "): exit");
        }
    }

    private void internalRemove(int n) {
        Integer n2 = new Integer(n);
        if (this.pgs != null && this.pgs.containsKey(n2)) {
            ProtectionGroupModel protectionGroupModel = (ProtectionGroupModel)this.pgs.get(n2);
            this.pgs.remove(n2);
            if (protectionGroupModel != null) {
                protectionGroupModel.destroy();
            }
        }
    }

    private synchronized void updateStructure() {
        Iterator iterator;
        HashSet<Integer> hashSet;
        Set set;
        HashMap<Integer, ProtectionGroup> hashMap;
        sProtGroupListElem[] sProtGroupListElemArray;
        block29: {
            sProtGroupListElemArray = null;
            hashMap = new HashMap<Integer, ProtectionGroup>();
            set = this.pgs.keySet();
            hashSet = new HashSet<Integer>();
            if (this.db.on()) {
                this.db.println("--------- updateStructure() entry -----------");
            }
            sProtGroupListElemArray = null;
            try {
                sProtGroupListElemArray = this.node.getEntityTableModel().getProtectionGroupList();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.db.on()) break block29;
                this.printStackTrace((Exception)((Object)abstractCmsIOException));
            }
        }
        if (this.db.on()) {
            if (this.db.on()) {
                this.db.println("    ProtectionGroup indexes:");
            }
            if (sProtGroupListElemArray.length > 0) {
                String string = "    ";
                string = string + Integer.toHexString(sProtGroupListElemArray[0].protModuleIdx);
                for (int i = 1; i < sProtGroupListElemArray.length; ++i) {
                    string = string + ", ";
                    string = string + Integer.toHexString(sProtGroupListElemArray[i].protModuleIdx);
                }
                if (this.db.on()) {
                    this.db.println(string);
                }
            }
            if (this.db.on()) {
                this.db.println("");
            }
        }
        for (int i = 0; i < sProtGroupListElemArray.length; ++i) {
            Integer n = new Integer(sProtGroupListElemArray[i].protModuleIdx);
            hashSet.add(n);
            hashMap.put(n, sProtGroupListElemArray[i].protGroup);
        }
        HashSet hashSet2 = new HashSet(hashSet);
        hashSet2.removeAll(set);
        if (this.db.on()) {
            if (this.db.on()) {
                this.db.println("addedPgs:");
            }
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                if (!this.db.on()) continue;
                this.db.println("    " + Integer.toHexString((Integer)iterator.next()));
            }
        }
        HashSet hashSet3 = new HashSet(set);
        hashSet3.removeAll(hashSet);
        if (this.db.on()) {
            if (this.db.on()) {
                this.db.println("deletedPgs:");
            }
            iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                if (!this.db.on()) continue;
                this.db.println("    " + Integer.toHexString((Integer)iterator.next()));
            }
        }
        int n = hashSet2.size();
        int n2 = hashSet3.size();
        if (this.db.on()) {
            this.db.println("Added " + n + " Protection Groups, and deleted " + n2 + " Protection Groups.");
        }
        if (n > 0 || n2 > 0) {
            if (n2 > 0) {
                iterator = hashSet3.iterator();
                while (iterator.hasNext()) {
                    int n3 = (Integer)iterator.next();
                    if (this.db.on()) {
                        this.db.println("DELETING Protection Group #" + Integer.toHexString(n3));
                    }
                    this.internalRemove(n3);
                }
                this.setChanged();
            }
            if (n > 0) {
                iterator = hashSet2.iterator();
                while (iterator.hasNext()) {
                    ProtectionGroup protectionGroup;
                    ProtectionGroupModel protectionGroupModel;
                    int n4 = (Integer)iterator.next();
                    if (this.db.on()) {
                        this.db.println("ADDING Protection Group #" + Integer.toHexString(n4));
                    }
                    if ((protectionGroupModel = this.getProtectionGroupModel(n4)) != null || (protectionGroup = (ProtectionGroup)hashMap.get(new Integer(n4))) == null) continue;
                    protectionGroupModel = this.makeProtectionGroupModel(protectionGroup);
                }
                this.setChanged();
            }
            if (this.db.on()) {
                this.db.println("--------- updateStructure() exit --------");
            }
        } else if (this.db.on()) {
            this.db.println("--------- updateStructure() exit [no changes to structure] ------------");
        }
        if (this.hasChanged() && this.db.on()) {
            this.db.println("updateStructure(): Will notifyObservers(ADDED)");
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        if (this.db.on()) {
            this.db.println("updateStructure(): exit");
        }
    }

    public void discoverProtectionGroups() {
        if (this.db.on()) {
            this.db.println("discoverProtectionGroups: entry");
        }
        sProtGroupListElem[] sProtGroupListElemArray = null;
        try {
            sProtGroupListElemArray = this.node.getEntityTableModel().getProtectionGroupList();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                this.db.println("Caught AbstractCmsIOException");
            }
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        for (int i = 0; i < sProtGroupListElemArray.length; ++i) {
            ProtectionGroup protectionGroup;
            if (sProtGroupListElemArray[i] == null || (protectionGroup = sProtGroupListElemArray[i].protGroup) == null) continue;
            if (this.db.on()) {
                this.db.println("     node = " + this.node);
                this.db.println("     node.getProtectionGroupModels() = " + this.node.getProtectionGroupModels());
            }
            this.makeProtectionGroupModel(protectionGroup);
        }
        if (this.db.on()) {
            this.db.println("discoverProtectionGroups: exit");
        }
    }

    public void update(Observable observable, Object object) {
        block13: {
            block12: {
                if (this.db.on()) {
                    this.db.println("update(): entry");
                }
                if (!(observable instanceof CmsObservable)) break block12;
                int n = ((IObjectMessageInfo)object).getUpdateType();
                if (this.db.on()) {
                    this.db.println("update(): this=" + this.toString() + ", From=" + observable + ", arg=" + EnumStrings.getStrings(eUpdateType.class)[n]);
                }
                switch (n) {
                    case 0: {
                        if (this.db.on()) {
                            this.db.println("update(): DELETED should not have occurred.");
                            break;
                        }
                        break block13;
                    }
                    case 1: {
                        if (this.db.on()) {
                            this.db.println("update(): CHANGED should not have occurred.");
                            break;
                        }
                        break block13;
                    }
                    case 2: {
                        if (this.db.on()) {
                            this.db.println("update(): ADDED");
                        }
                        this.updateStructure();
                        break;
                    }
                }
                break block13;
            }
            if (this.db.on()) {
                this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
            }
        }
        if (this.db.on()) {
            this.db.println("update(): exit");
        }
    }

    public String toString() {
        return "ProtectionGroupModels";
    }

    class EntityIndex
    extends NonCachedValue {
        public EntityIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return new Integer(((ProtectionGroup)object).protectModule());
        }

        public Object outer() {
            return ProtectionGroupModels.this;
        }
    }

    class MainModules
    extends NonCachedValue {
        public MainModules(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ((ProtectionGroup)object).mainModules();
        }

        public Object outer() {
            return ProtectionGroupModels.this;
        }
    }

    class Name
    extends NonCachedValue {
        public Name(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ((ProtectionGroup)object).name();
        }

        public Object outer() {
            return ProtectionGroupModels.this;
        }
    }

    class ProtectType
    extends NonCachedValue {
        public ProtectType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ((ProtectionGroup)object).protectType();
        }

        public Object outer() {
            return ProtectionGroupModels.this;
        }
    }

    public class ProtectionGroupModelsDebug
    extends SDebug {
        public ProtectionGroupModelsDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void dump() {
            ProtectionGroupModels.this.db.println(ProtectionGroupModels.this.node.dbName() + " protection groups:");
            Iterator iterator = ProtectionGroupModels.this.pgs.values().iterator();
            while (iterator.hasNext()) {
                ProtectionGroupModels.this.db.println("\t" + iterator.next());
            }
        }
    }
}

