/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.sEtherMacAddr;
import cerent.cms.idl.Epos.eRPRTopoRing;
import cerent.cms.idl.Epos.eRPRTopoStability;
import cerent.cms.idl.Epos.sRPRStationData;
import cerent.cms.idl.Epos.sRPRTopoRing;
import cerent.cms.idl.Epos.sRPRTopoStation;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EtherMacAddrFactory;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRprConstants;
import cerent.cms.model.IRprModel;
import cerent.cms.model.IRprTopoPeers;
import cerent.cms.model.IRprTopoStation;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RprTopoPeers;
import cerent.cms.model.RprTopoStation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.Observable;
import org.omg.CORBA.UserException;

public class RprModel
extends Model
implements IRprModel,
IRprConstants {
    private GetRPRStationbySpan getRPRStationbySpan;
    private GetRPRLocalStationTopo getRPRLocalStationTopo;
    private GetRPRRingTopo getRPRRingTopo;
    private NodeModelDelegate nmd;
    private static NodeSingletonFactory<RprModel> sfactory = new NodeSingletonFactory<RprModel>(RprModel.class);

    public static RprModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private RprModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(RprModel.class));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.getRPRStationbySpan = new GetRPRStationbySpan(nodeModelDelegate, "RprModel::getRPRStationbySpan");
        this.getRPRLocalStationTopo = new GetRPRLocalStationTopo(nodeModelDelegate, "RprModel::getRPRLocalStationTopo");
        this.getRPRRingTopo = new GetRPRRingTopo(nodeModelDelegate, "RprModel::getRPRRingTopo");
    }

    public sRPRStationData getRPRStationbySpan(int n) throws NoSuchInterface, WrongInterfaceType {
        try {
            Integer n2 = new Integer(n);
            return (sRPRStationData)this.getRPRStationbySpan.get(n2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            this.db.println("user exception in getRPRStationbySpan");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sRPRTopoStation getRPRLocalStationTopo(int n) throws EMCProvisionError {
        try {
            Integer n2 = new Integer(n);
            return (sRPRTopoStation)this.getRPRLocalStationTopo.get(n2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
        }
        catch (UserException userException) {
            this.db.println("user exception in getRPRStationbySpan");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sRPRTopoRing getRPRRingTopo(int n) throws EMCProvisionError {
        try {
            Integer n2 = new Integer(n);
            return (sRPRTopoRing)this.getRPRRingTopo.get(n2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.nmd.getPlatform());
        }
        catch (UserException userException) {
            this.db.println("user exception in getRPRLocalStationTopo");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IRprTopoStation getRprTopoStation(PortModel portModel) throws NoSuchInterface, WrongInterfaceType, ProvisionError {
        return this.getRprTopoStation(portModel.getEntityIndex());
    }

    public IRprTopoStation getRprTopoStation(int n) throws NoSuchInterface, WrongInterfaceType, EMCProvisionError {
        sRPRStationData sRPRStationData2 = this.getRPRStationbySpan(n);
        sRPRTopoStation sRPRTopoStation2 = this.getRPRLocalStationTopo(sRPRStationData2.rprStationIndex);
        byte[] byArray = new byte[6];
        sEtherMacAddr sEtherMacAddr2 = new sEtherMacAddr(byArray);
        for (int i = 0; i < 6; ++i) {
            sEtherMacAddr2.addr[i] = (byte)sRPRTopoStation2.stationMAC.MACAddr[i];
        }
        String string = "Checksum, Self:" + Integer.toHexString(sRPRTopoStation2.stationChksm.checksum) + ",E:" + Integer.toHexString(sRPRTopoStation2.neighborChksm[0].checksum) + ",W:" + Integer.toHexString(sRPRTopoStation2.neighborChksm[1].checksum);
        boolean bl = false;
        if (sRPRTopoStation2.ringTopo == eRPRTopoRing.CLOSED) {
            bl = true;
        }
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        for (int i = 0; i < 2; ++i) {
            nArray[i] = sRPRTopoStation2.selfDetectedRequests[i].value();
            nArray2[i] = sRPRTopoStation2.remoteRequests[i].value();
        }
        RprTopoStation rprTopoStation = new RprTopoStation(EtherMacAddrFactory.getIEtherMacAddr(sEtherMacAddr2), this.getStability(sRPRTopoStation2.ringStability), this.getWrapPref(sRPRTopoStation2.wrapPrefSet), this.getJumboString(sRPRTopoStation2.jumboPrefSet), this.getJumboString(sRPRTopoStation2.ringJumboSet), string, bl, nArray, nArray2);
        return rprTopoStation;
    }

    private String getStability(eRPRTopoStability eRPRTopoStability2) {
        switch (eRPRTopoStability2.value()) {
            case 0: {
                return "Stable";
            }
            case 1: {
                return "Unstable";
            }
        }
        return "Unknown";
    }

    private String getWrapPref(boolean bl) {
        if (bl) {
            return "Wrapping";
        }
        return "Steering";
    }

    private String getJumboString(boolean bl) {
        if (bl) {
            return "Jumbo";
        }
        return "No Jumbo";
    }

    public IRprTopoPeers getRprTopoPeers(PortModel portModel) throws ProvisionError, NoSuchInterface, WrongInterfaceType {
        return this.getRprTopoPeers(portModel.getEntityIndex());
    }

    public IRprTopoPeers getRprTopoPeers(int n) throws EMCProvisionError, NoSuchInterface, WrongInterfaceType {
        sRPRStationData sRPRStationData2 = this.getRPRStationbySpan(n);
        sRPRTopoRing sRPRTopoRing2 = this.getRPRRingTopo(sRPRStationData2.rprStationIndex);
        RprTopoPeers rprTopoPeers = new RprTopoPeers(sRPRTopoRing2);
        return rprTopoPeers;
    }

    public void init() {
        super.init0();
    }

    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    public void update(Observable observable, Object object) {
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("RprModel::dispose");
        }
        super.dispose();
    }

    class GetRPRLocalStationTopo
    extends NonCachedValue {
        public GetRPRLocalStationTopo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return this.node.getIorRepository().getRPRRef().getRPRLocalStationTopo(n);
        }

        public Object outer() {
            return RprModel.this;
        }
    }

    class GetRPRRingTopo
    extends NonCachedValue {
        public GetRPRRingTopo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return this.node.getIorRepository().getRPRRef().getRPRRingTopo(n);
        }

        public Object outer() {
            return RprModel.this;
        }
    }

    class GetRPRStationbySpan
    extends NonCachedValue {
        public GetRPRStationbySpan(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return this.node.getIorRepository().getRPRRef().getRPRStationBySpan(n);
        }

        public Object outer() {
            return RprModel.this;
        }
    }
}

