/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.util.SDebug;
import cerent.util.SvlanRange;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.StringTokenizer;

public class SVlanList {
    private static final SvlanRange[] RANGE_ARRAY_TEMPLATE = new SvlanRange[0];
    public static final int MAX_NUM_SVLANS = 4093;
    private BitSet bs;
    private short[] svlans;
    private SvlanRange[] ranges;
    private static SDebug db = new SDebug("SVlanList");

    public SVlanList() {
        this.bs = SVlanList.createBitSet();
        this.svlans = new short[0];
    }

    public SVlanList(String string) {
        this.bs = SVlanList.createBitSet();
        this.init(string);
    }

    public SVlanList(SVlanList sVlanList) {
        this.init(sVlanList.svlans.length, sVlanList.bs);
    }

    private void init(String string) {
        if (string == null) {
            string = "";
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            int n3;
            block11: {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
                n3 = -1;
                n2 = -1;
                if (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    try {
                        if (string3.equals("*")) {
                            this.bs.set(0, 4093);
                            n = 4093;
                            break;
                        }
                        n2 = n3 = Integer.parseInt(string3);
                        if (!stringTokenizer2.hasMoreTokens()) break block11;
                        string3 = stringTokenizer2.nextToken();
                        try {
                            if (string3.equals("*")) {
                                this.bs.set(0, 4093);
                                n = 4093;
                                break;
                            }
                            n2 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("Not a number");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Not a number");
                    }
                }
            }
            if (n3 > 0) {
                for (int i = n3; i <= n2; ++i) {
                    int n4 = i - 1;
                    if (this.bs.get(n4)) continue;
                    ++n;
                    this.bs.set(n4);
                }
                continue;
            }
            throw new IllegalArgumentException("Zero not admitted");
        }
        this.init(n, this.bs);
    }

    private void init(int n, BitSet bitSet) {
        if (bitSet.length() > 4093) {
            throw new IllegalArgumentException("BitSet must be exactly: 4093 in size");
        }
        if (this.bs == null) {
            this.bs = new BitSet(bitSet.size());
            this.bs.or(bitSet);
        }
        this.svlans = new short[n];
        int n2 = this.bs.nextSetBit(0);
        int n3 = 0;
        while (n2 >= 0 && n3 < n) {
            short s = (short)(n2 + 1);
            this.svlans[n3++] = s;
            n2 = this.bs.nextSetBit(n2 + 1);
        }
        this.ranges = null;
    }

    private static int getCount(BitSet bitSet) {
        int n = 0;
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            ++n;
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        return n;
    }

    public boolean isAllSvlans() {
        return this.svlans != null && this.svlans.length == 4093;
    }

    public static BitSet createBitSet() {
        return new BitSet(4093);
    }

    public void or(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        if (this.bs.length() > 4093) {
            throw new IllegalArgumentException("BitSet must be exactly: 4093 in size");
        }
        this.bs.or(bitSet);
        this.init(SVlanList.getCount(this.bs), this.bs);
    }

    public void andNot(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        if (this.bs.length() > 4093) {
            throw new IllegalArgumentException("BitSet must be exactly: 4093 in size");
        }
        this.bs.andNot(bitSet);
        this.init(SVlanList.getCount(this.bs), this.bs);
    }

    public void and(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        if (this.bs.length() > 4093) {
            throw new IllegalArgumentException("BitSet must be exactly: 4093 in size");
        }
        this.bs.and(bitSet);
        this.init(SVlanList.getCount(this.bs), this.bs);
    }

    public short[] getSvlans() {
        return this.svlans;
    }

    public BitSet getBitSet() {
        return this.bs;
    }

    public SvlanRange[] getRanges() {
        SvlanRange svlanRange;
        if (this.ranges != null) {
            return this.ranges;
        }
        if (this.svlans.length == 0) {
            return RANGE_ARRAY_TEMPLATE;
        }
        ArrayList<SvlanRange> arrayList = new ArrayList<SvlanRange>();
        int n = this.svlans[0];
        int n2 = this.svlans[0];
        for (int i = 1; i < this.svlans.length; ++i) {
            int n3 = this.svlans[i];
            if (n3 == n2 + 1) {
                ++n2;
                continue;
            }
            svlanRange = new SvlanRange((short)n, (short)n2);
            arrayList.add(svlanRange);
            n = n3;
            n2 = n3;
        }
        svlanRange = new SvlanRange((short)n, (short)n2);
        arrayList.add(svlanRange);
        this.ranges = arrayList.toArray(RANGE_ARRAY_TEMPLATE);
        return this.ranges;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = this.svlans.length;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            int n4 = this.svlans[i];
            if (n4 > n3 + 1) {
                if (n2 >= 0) {
                    if (bl) {
                        stringBuilder.append(",");
                    }
                    bl = true;
                    stringBuilder.append(Integer.toString(n2));
                    if (n3 > n2) {
                        stringBuilder.append("-");
                        stringBuilder.append(Integer.toString(n3));
                    }
                }
                n3 = n2 = n4;
                continue;
            }
            ++n3;
        }
        if (bl) {
            stringBuilder.append(",");
        }
        if (n2 >= 0) {
            stringBuilder.append(Integer.toString(n2));
            if (n3 > n2) {
                stringBuilder.append("-");
                stringBuilder.append(Integer.toString(n3));
            }
        }
        return (string = stringBuilder.toString()).length() == 0 ? "empty" : string;
    }

    public int hashCode() {
        return this.bs.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof SVlanList) {
            SVlanList sVlanList = (SVlanList)object;
            bl = this.bs.equals(sVlanList.bs);
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        String string = "1,2-3,4";
        SVlanList sVlanList = new SVlanList("1,2-3,4");
        System.out.println("list1(" + string + "): " + sVlanList);
        string = "1,3,4";
        SVlanList sVlanList2 = new SVlanList("1,3,4");
        System.out.println("list2(" + string + "): " + sVlanList2);
        string = "1";
        SVlanList sVlanList3 = new SVlanList("1");
        System.out.println("list3(" + string + "): " + sVlanList3);
        string = "1-2";
        SVlanList sVlanList4 = new SVlanList("1-2");
        System.out.println("list4(" + string + "): " + sVlanList4);
        string = "1,3-6,6-7";
        SVlanList sVlanList5 = new SVlanList("1,3-6,6-7");
        System.out.println("list5(" + string + "): " + sVlanList5);
        string = "1,3-6,5-7";
        SVlanList sVlanList6 = new SVlanList("1,3-6,5-7");
        System.out.println("list6(" + string + "): " + sVlanList6);
        string = "1,3-4,5-4";
        SVlanList sVlanList7 = new SVlanList("1,3-4,5-4");
        System.out.println("list7(" + string + "): " + sVlanList7);
        string = "";
        SVlanList sVlanList8 = new SVlanList("");
        System.out.println("list8(" + string + "): " + sVlanList8);
        string = "1,3-b,5-4";
        SVlanList sVlanList9 = new SVlanList("1,3-b,5-4");
        System.out.println("list9(" + string + "): " + sVlanList9);
        string = "1-8";
        SVlanList sVlanList10 = new SVlanList("1-8");
        System.out.println("list10(" + string + "): " + sVlanList10);
        SvlanRange[] svlanRangeArray = sVlanList10.getRanges();
        System.out.println("list10(" + string + "): # of ranges " + svlanRangeArray.length);
        for (int i = 0; i < svlanRangeArray.length; ++i) {
            System.out.println("  " + svlanRangeArray[i]);
        }
        String string2 = "1-4,6-8";
        SVlanList sVlanList11 = new SVlanList("1-4,6-8");
        System.out.println("list11(" + string2 + "): " + sVlanList11);
        svlanRangeArray = sVlanList11.getRanges();
        System.out.println("list11(" + string + "): # of ranges " + svlanRangeArray.length);
        for (int i = 0; i < svlanRangeArray.length; ++i) {
            System.out.println("  " + svlanRangeArray[i]);
        }
        sVlanList10.andNot(sVlanList11.getBitSet());
        System.out.println("list10-list11: " + sVlanList10);
        sVlanList10.or(sVlanList11.getBitSet());
        System.out.println("list10+list11: " + sVlanList10);
        string = "*";
        SVlanList sVlanList12 = new SVlanList("*");
        System.out.println("list12(" + string + "): " + sVlanList12);
        string = "*,8";
        SVlanList sVlanList13 = new SVlanList("*,8");
        System.out.println("list13(" + string + "): " + sVlanList13);
        string = "*-8";
        SVlanList sVlanList14 = new SVlanList("*-8");
        System.out.println("list14(" + string + "): " + sVlanList14);
        string = "8-*";
        SVlanList sVlanList15 = new SVlanList("8-*");
        System.out.println("list15(" + string + "): " + sVlanList15);
    }
}

