/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IBucketSize;
import cerent.cms.model.IROSVlanProfile;
import cerent.cms.model.ISVlanProfile;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;

public class SVlanProfile
implements ISVlanProfile {
    public static final int MAX_NAME_LENGTH = 32;
    static final String committedInfoRatePropName = "Committed Info Rate";
    static final String peakInfoRatePropName = "Peak Info Rate";
    static final String committedBurstSizePropName = "Committed Burst Size";
    static final String peakBurstSizePropName = "Peak Burst Size";
    private static String[] BucketNames = EnumStrings.getStrings(IBucketSize.class);
    private static Comparable[] SortedBucketSizeValues = EnumStrings.getRange(IBucketSize.class);
    private static Integer _BucketSizeLow = (Integer)SortedBucketSizeValues[0];
    private static Integer BucketSizeLow = new Integer(_BucketSizeLow + 1);
    private static Integer BucketSizeHigh = (Integer)SortedBucketSizeValues[1];
    private int index;
    private String origName;
    private String name;
    private short committedInfoRate;
    private int committedBurstSize;
    private short peakInfoRate;
    private int peakBurstSize;
    private boolean couplingFlag;
    private boolean colorMode;
    private boolean linkIntegrity;

    protected SVlanProfile() {
    }

    public SVlanProfile(int n, String string, short s, int n2, short s2, int n3, boolean bl, boolean bl2, boolean bl3) {
        SVlanProfile.checkName(string);
        this.checkPercent(s, committedInfoRatePropName);
        this.checkPercent(s2, peakInfoRatePropName);
        this.checkBucketSizeEnum(n2, committedBurstSizePropName);
        this.checkBucketSizeEnum(n3, peakBurstSizePropName);
        this.index = n;
        this.name = string;
        this.committedInfoRate = s;
        this.committedBurstSize = n2;
        this.peakInfoRate = s2;
        this.peakBurstSize = n3;
        this.linkIntegrity = bl3;
    }

    public SVlanProfile(String string) {
        SVlanProfile.checkName(string);
        this.name = string;
        this.committedInfoRate = (short)100;
        this.peakInfoRate = (short)100;
        this.committedBurstSize = 1;
        this.peakBurstSize = 1;
    }

    public SVlanProfile(ISVlanProfile iSVlanProfile) {
        this(iSVlanProfile.getIndex(), iSVlanProfile.getName(), iSVlanProfile.getCommittedInfoRate(), iSVlanProfile.getCommittedBurstSize(), iSVlanProfile.getPeakInfoRate(), iSVlanProfile.getPeakBurstSize(), iSVlanProfile.getCouplingFlag(), iSVlanProfile.getColorMode(), iSVlanProfile.getLinkIntegrity());
        this.origName = iSVlanProfile.getOrigName();
    }

    public SVlanProfile(ISVlanProfile iSVlanProfile, String string) {
        this(iSVlanProfile);
        this.name = string;
    }

    public SVlanProfile(int n, IROSVlanProfile iROSVlanProfile) {
        this(n, iROSVlanProfile.getName(), iROSVlanProfile.getCommittedInfoRate(), iROSVlanProfile.getCommittedBurstSize(), iROSVlanProfile.getPeakInfoRate(), iROSVlanProfile.getPeakBurstSize(), iROSVlanProfile.getCouplingFlag(), iROSVlanProfile.getColorMode(), iROSVlanProfile.getLinkIntegrity());
    }

    public static void checkName(String string) {
        if (string != null && string.length() > 32) {
            throw new IllegalArgumentException("SVLAN Profile names must not exceed 32 characters in length");
        }
        if (string != null && string.equals("Defaults")) {
            throw new IllegalArgumentException("An SVLAN Profile name must not be the default profile name");
        }
    }

    private void checkPercent(short s, String string) {
        if (s < 0 || s > 100) {
            throw new IllegalArgumentException("SVLAN Profile percentage: " + string + " must be in the range of 0..100");
        }
    }

    private void checkBucketSizeEnum(int n, String string) {
        Integer n2 = new Integer(n);
        if (BucketSizeLow.compareTo(n2) > 0 || BucketSizeHigh.compareTo(n2) < 0) {
            String string2 = _BucketSizeLow <= n && n <= BucketSizeHigh ? BucketNames[n] + "(" + n + ")" : Integer.toString(n);
            throw new IllegalArgumentException("SVLAN Profile " + string + " of bucket size: " + string2 + " must be one of the valid eBucketSize enum values in the range: " + BucketNames[BucketSizeLow] + "-" + BucketNames[BucketSizeHigh]);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getOrigName() {
        return this.origName;
    }

    public short getCommittedInfoRate() {
        return this.committedInfoRate;
    }

    public int getCommittedBurstSize() {
        return this.committedBurstSize;
    }

    public short getPeakInfoRate() {
        return this.peakInfoRate;
    }

    public int getPeakBurstSize() {
        return this.peakBurstSize;
    }

    public boolean getCouplingFlag() {
        return this.couplingFlag;
    }

    public boolean getColorMode() {
        return this.colorMode;
    }

    public boolean getLinkIntegrity() {
        return this.linkIntegrity;
    }

    public void setName(String string) {
        SVlanProfile.checkName(string);
        if (this.origName == null) {
            this.origName = this.name;
        }
        this.name = string;
    }

    public void clearOrigName() {
        this.origName = null;
    }

    public void setCommittedInfoRate(short s) {
        this.checkPercent(s, committedInfoRatePropName);
        this.committedInfoRate = s;
    }

    public void setCommittedBurstSize(int n) {
        this.checkBucketSizeEnum(n, committedBurstSizePropName);
        this.committedBurstSize = n;
    }

    public void setPeakInfoRate(short s) {
        this.checkPercent(s, peakInfoRatePropName);
        this.peakInfoRate = s;
    }

    public void setPeakBurstSize(int n) {
        this.checkBucketSizeEnum(n, peakBurstSizePropName);
        this.peakBurstSize = n;
    }

    public void setCouplingFlag(boolean bl) {
    }

    public void setColorMode(boolean bl) {
    }

    public void setLinkIntegrity(boolean bl) {
        this.linkIntegrity = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("- \"");
        stringBuilder.append(this.name);
        if (this.origName != null) {
            stringBuilder.append("/");
            stringBuilder.append(this.origName);
        }
        stringBuilder.append("\"");
        stringBuilder.append("; cir: " + this.committedInfoRate);
        stringBuilder.append("; cbs: " + this.committedBurstSize);
        stringBuilder.append("; pir: " + this.peakInfoRate);
        stringBuilder.append("; pbs: " + this.peakBurstSize);
        stringBuilder.append("; cf: " + this.couplingFlag);
        stringBuilder.append("; cm: " + this.colorMode);
        stringBuilder.append("; li: " + this.linkIntegrity);
        return stringBuilder.toString();
    }

    protected static int compareString(String string, String string2) {
        int n;
        int n2 = n = string == string2 ? 0 : -1;
        if (n != 0) {
            n = string == null ? (string2 == null ? 0 : 1) : string.compareTo(string2);
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof ISVlanProfile ? this.compareTo((IROSVlanProfile)((ISVlanProfile)object)) == 0 : false;
        return bl;
    }

    public int hashCode() {
        int n = 0;
        n = 13 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 13 * n + this.committedInfoRate;
        n = 13 * n + this.committedBurstSize;
        n = 13 * n + this.peakInfoRate;
        n = 13 * n + this.peakBurstSize;
        n = 13 * n + (this.couplingFlag ? 1 : 0);
        n = 13 * n + (this.colorMode ? 1 : 0);
        n = 13 * n + (this.linkIntegrity ? 1 : 0);
        return n;
    }

    public int compareTo(IROSVlanProfile iROSVlanProfile) {
        int n;
        int n2 = n = this == iROSVlanProfile ? 0 : -1;
        if (iROSVlanProfile == null) {
            n = -1;
        } else if (n != 0) {
            n = SVlanProfile.compareString(this.name, iROSVlanProfile.getName());
            if (n != 0) {
                return n;
            }
            n = ComparisonUtil.compare((int)this.committedInfoRate, (int)iROSVlanProfile.getCommittedInfoRate());
            if (n != 0) {
                return n;
            }
            n = ComparisonUtil.compare((int)this.committedBurstSize, (int)iROSVlanProfile.getCommittedBurstSize());
            if (n != 0) {
                return n;
            }
            n = ComparisonUtil.compare((int)this.peakInfoRate, (int)iROSVlanProfile.getPeakInfoRate());
            if (n != 0) {
                return n;
            }
            n = ComparisonUtil.compare((int)this.peakBurstSize, (int)iROSVlanProfile.getPeakBurstSize());
            if (n != 0) {
                return n;
            }
            n = ComparisonUtil.compare((boolean)this.couplingFlag, (boolean)iROSVlanProfile.getCouplingFlag());
            if (n != 0) {
                return n;
            }
            n = ComparisonUtil.compare((boolean)this.colorMode, (boolean)iROSVlanProfile.getColorMode());
            if (n != 0) {
                return n;
            }
            n = ComparisonUtil.compare((boolean)this.linkIntegrity, (boolean)iROSVlanProfile.getLinkIntegrity());
            if (n != 0) {
                return n;
            }
        }
        return n;
    }

    public Object clone() {
        return new SVlanProfile(this);
    }
}

