/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.ISecurityPolicy;
import cerent.cms.model.SecurityLevel;
import java.util.HashMap;

public class SecurityPolicy
implements ISecurityPolicy {
    private static final int IDLE_TIMEOUT_IDX = 0;
    private static final int PASSWD_EXPR_IDX = 1;
    private static final int WARNING_EXPR_IDX = 2;
    private static final int LAST_IDX = 3;
    private HashMap secAttributesMap;
    private int lockoutThreshold;
    private boolean manualUnlock;
    private int lockoutDuration;
    private int passwordReuseThreshold;
    private int passwordDuration;
    private boolean singleSessionPerUser;
    private boolean forcePasswordChange;
    private boolean passwordFlippingPolicyEnforced;
    private int passwordFlippingPolicyThreshold;
    private boolean passwordExprPolicyEnabled;
    private boolean disableInactiveUserPolicyEnabled;
    private int maxInactiveDaysBeforeDisable;
    private short minChangedCharsInPwd;
    private boolean preventSuperUserDisabledPolicy;
    private boolean reverseUserIdAllowed;
    private short minimumLength = (short)-1;
    private short identicalConsecutiveCharactersAllowed;
    private short maximumLength;
    private int minimumRequiredCharacters;

    public SecurityPolicy() {
        this.secAttributesMap = new HashMap();
    }

    public void setLockoutThreshold(int n) {
        this.lockoutThreshold = n;
    }

    public int getLockoutThreshold() {
        return this.lockoutThreshold;
    }

    public void setManualUnlock(boolean bl) {
        this.manualUnlock = bl;
    }

    public boolean isManualUnlock() {
        return this.manualUnlock;
    }

    public void setLockoutDuration(int n) {
        this.lockoutDuration = n;
    }

    public int getLockoutDuration() {
        return this.lockoutDuration;
    }

    public void setPasswordReuseThreshold(int n) {
        this.passwordReuseThreshold = n;
    }

    public int getPasswordReuseThreshold() {
        return this.passwordReuseThreshold;
    }

    public void setPasswordDuration(int n) {
        this.passwordDuration = n;
    }

    public int getPasswordDuration() {
        return this.passwordDuration;
    }

    public void setSingleSessionPerUser(boolean bl) {
        this.singleSessionPerUser = bl;
    }

    public boolean isSingleSessionPerUser() {
        return this.singleSessionPerUser;
    }

    public void setIdleTimeout(int n, int n2) {
        this.getAttributes((SecurityLevel)SecurityLevel.from_int((int)n))[0] = n2;
    }

    public int getIdleTimeout(int n) {
        return this.getIdleTimeout(SecurityLevel.from_int((int)n));
    }

    public int getIdleTimeout(SecurityLevel securityLevel) {
        return this.getAttributes(securityLevel)[0];
    }

    public boolean getForcePasswordChange() {
        return this.forcePasswordChange;
    }

    public void setForcePasswordChange(boolean bl) {
        this.forcePasswordChange = bl;
    }

    public boolean getPasswordFlippingPolicyEnabled() {
        return this.passwordFlippingPolicyEnforced;
    }

    public void setPasswordFlippingPolicyEnabled(boolean bl) {
        this.passwordFlippingPolicyEnforced = bl;
    }

    public int getPasswordFlippingPolicyThreshold() {
        return this.passwordFlippingPolicyThreshold;
    }

    public void setPasswordFlippingPolicyThreshold(int n) {
        this.passwordFlippingPolicyThreshold = n;
    }

    public boolean isPasswordExprPolicyEnabled() {
        return this.passwordExprPolicyEnabled;
    }

    public void setPasswordExprPolicyEnabled(boolean bl) {
        this.passwordExprPolicyEnabled = bl;
    }

    public int getPasswordExprPeriod(int n) {
        return this.getAttributes(SecurityLevel.from_int((int)n))[1];
    }

    public int getPasswordExprWarningPeriod(int n) {
        return this.getAttributes(SecurityLevel.from_int((int)n))[2];
    }

    public void setPasswordExprPolicy(int n, int n2, int n3) {
        int[] nArray = this.getAttributes(SecurityLevel.from_int((int)n));
        nArray[1] = n2;
        nArray[2] = n3;
    }

    public void setDisableInactiveUserPolicyEnabled(boolean bl) {
        this.disableInactiveUserPolicyEnabled = bl;
    }

    public boolean getDisableInactiveUserPolicyEnabled() {
        return this.disableInactiveUserPolicyEnabled;
    }

    public int getMaxInactiveDaysBeforeDisable() {
        return this.maxInactiveDaysBeforeDisable;
    }

    public void setMaxInactiveDaysBeforeDisable(int n) {
        this.maxInactiveDaysBeforeDisable = n;
    }

    private int[] getAttributes(SecurityLevel securityLevel) {
        int[] nArray = (int[])this.secAttributesMap.get(securityLevel);
        if (nArray == null) {
            nArray = new int[3];
            this.secAttributesMap.put(securityLevel, nArray);
        }
        return nArray;
    }

    public short getMinChangedCharsInPwd() {
        return this.minChangedCharsInPwd;
    }

    public void setMinChangedCharsInPwd(short s) {
        this.minChangedCharsInPwd = s;
    }

    public void setPreventSuperUserDisabledPolicy(boolean bl) {
        this.preventSuperUserDisabledPolicy = bl;
    }

    public boolean getPreventSuperUserDisabledPolicy() {
        return this.preventSuperUserDisabledPolicy;
    }

    public boolean getReverseUserIdAllowed() {
        return this.reverseUserIdAllowed;
    }

    public void setReverseUserIdAllowed(boolean bl) {
        this.reverseUserIdAllowed = bl;
    }

    public short getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(short s) {
        this.minimumLength = s;
    }

    public short getIdenticalConsecutiveCharactersAllowed() {
        return this.identicalConsecutiveCharactersAllowed;
    }

    public void setIdenticalConsecutiveCharactersAllowed(short s) {
        this.identicalConsecutiveCharactersAllowed = s;
    }

    public short getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(short s) {
        this.maximumLength = s;
    }

    public int getMinimumRequiredCharacters() {
        return this.minimumRequiredCharacters;
    }

    public void setMinimumRequiredCharacters(int n) {
        this.minimumRequiredCharacters = n;
    }
}

