/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.ServerTrail.Trail;
import cerent.cms.idl.ServerTrail.TrailCTP;
import cerent.cms.idl.ServerTrail.sServerTrailId;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IServerTrailEnd;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ServerTrailLinkId;
import cerent.cms.model.event.IObjectMessageInfo;
import java.util.Observable;

public abstract class ServerTrailEnd
extends Model
implements IServerTrailEnd {
    protected NodeModelDelegate node;
    protected TrailCTP trailCTPRef;
    protected ServerTrailLinkId trailId;
    protected String peerIpAddr;
    protected String srlgId;
    protected int trailProtectionType;
    protected int trailSize;
    protected int numberOfTrails;
    protected boolean isSource;

    public ServerTrailEnd(NodeModelDelegate nodeModelDelegate, TrailCTP trailCTP) {
        super(nodeModelDelegate.getChildDebug(ServerTrailEnd.class));
        this.node = nodeModelDelegate;
        this.trailCTPRef = trailCTP;
        sServerTrailId sServerTrailId2 = trailCTP.getTrailCTPData().trailId;
        this.trailId = new ServerTrailLinkId(sServerTrailId2.nodeId, sServerTrailId2.uniqueId);
        this.peerIpAddr = trailCTP.getTrailCTPData().peerTrailIpAddr;
        this.srlgId = trailCTP.getTrailCTPData().sharedResourceLinkGroupId;
        this.trailProtectionType = trailCTP.getTrailCTPData().protType.value();
        this.trailSize = trailCTP.getTrailCTPData().trailSize.value();
        this.numberOfTrails = trailCTP.getTrailCTPData().numTrails;
        this.isSource = trailCTP.getTrailCTPData().isSource;
    }

    public abstract boolean delete();

    public abstract boolean inUse();

    public INodeModel getNodeModel() {
        return this.node;
    }

    public IServerTrailLinkId getServerTrailLinkId() {
        return this.trailId;
    }

    public String getPeerIpAddr() {
        return this.peerIpAddr;
    }

    public String getSharedRiskLinkGroup() {
        return this.srlgId;
    }

    public int getProtectionType() {
        return this.trailProtectionType;
    }

    public int getTrailSize() {
        return this.trailSize;
    }

    public int getNumberOfTrails() {
        return this.numberOfTrails;
    }

    public boolean isSource() {
        return this.isSource;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof IServerTrailEnd) {
            IServerTrailEnd iServerTrailEnd = (IServerTrailEnd)object;
            bl = this.getServerTrailLinkId().equals(iServerTrailEnd.getServerTrailLinkId());
        }
        return bl;
    }

    public static final String ipToString(IIpAddr iIpAddr) {
        byte[] byArray = iIpAddr.getAddr();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < byArray.length; ++i) {
            if (bl && byArray[i] == 0) continue;
            bl = false;
            stringBuffer.append(Integer.toString(byArray[i] & 0xFF));
            if (i + 1 >= byArray.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            int n2 = ((IObjectMessageInfo)object).getObjectType();
            if (n == 0) {
                this.setChanged();
                this.notifyObservers(ModelUpdateType.DELETED);
            }
        }
    }

    private Trail getServerTrailRef() {
        return this.node.getIorRepository().getServerTrailRef();
    }
}

