/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.xInvalidCircuitName;
import cerent.cms.idl.EtherL2Media.SvlanCircuits;
import cerent.cms.idl.EtherL2Media.sSvlanConnectionItem;
import cerent.cms.idl.EtherMedia.xBusy;
import cerent.cms.idl.EtherMedia.xInvalidPath;
import cerent.cms.idl.EtherMedia.xPathInUse;
import cerent.cms.idl.EtherMedia.xWrongNumberOfPaths;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ErrorMsgFormatter;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISvlanCircuitModels;
import cerent.cms.model.ISvlanConnectionModel;
import cerent.cms.model.ISvlanPathDefModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PathInUse;
import cerent.cms.model.SvlanConnectionModel;
import cerent.cms.model.SvlanConnections;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongNumberOfPaths;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.SvlanRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.omg.CORBA.UserException;

public class SvlanCircuitModelsDelegate
extends Model
implements ISvlanCircuitModels {
    protected NodeModelDelegate node;
    private static NodeSingletonFactory<SvlanCircuitModelsDelegate> sfactory = new NodeSingletonFactory<SvlanCircuitModelsDelegate>(SvlanCircuitModelsDelegate.class);
    private static final String SVLAN_DEBUG_KEY = "SvlanCircuitModels";
    private CreateSvlanConnection createSvlanConnection;
    private DeleteSvlanConnection deleteSvlanConnection;
    private AvailEntitiesForSvlan availEntForSvlan;
    private AddRemoveSvlanConnPath addRemoveSvlanConnPath;
    private SvlanAvailableForPort isSvlanAvailable;
    SvlanConnections svlanConnections;

    private static CTCUserException toUserException(xProvisionError xProvisionError2) {
        return ErrorMsgFormatter.getEquipmentProvisionError(xProvisionError2, null);
    }

    public static SvlanCircuitModelsDelegate getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private SvlanCircuitModelsDelegate(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.node = nodeModelDelegate;
        if (this.db == null) {
            this.db = new SvlanCktDebug(nodeModelDelegate.db);
        }
        this.createSvlanConnection = new CreateSvlanConnection(nodeModelDelegate, "SvlanCircuitModels.createSvlanConnection");
        this.availEntForSvlan = new AvailEntitiesForSvlan(nodeModelDelegate, "SvlanCircuitModels.AvailEntitiesForSvlan");
        this.isSvlanAvailable = new SvlanAvailableForPort(nodeModelDelegate, "SvlanCircuitModels.SvlanAvailableForPort");
        this.deleteSvlanConnection = new DeleteSvlanConnection(nodeModelDelegate, "SvlanCircuitModels.DeleteSvlanConnection");
        this.addRemoveSvlanConnPath = new AddRemoveSvlanConnPath(nodeModelDelegate, "SvlanCircuitModels.AddRemoveSvlanConnPath");
        this.svlanConnections = new SvlanConnections(this);
    }

    public void init() {
        if (this.db.on()) {
            this.db.println("SvlanCircuitModels: init entry");
        }
        super.init0();
        this.svlanConnections.init();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
        if (this.db.on()) {
            this.db.println(this.node.dbName() + " init() exit");
        }
    }

    public SvlanConnectionModel add(sSvlanConnectionItem sSvlanConnectionItem2) {
        return this.svlanConnections.add(sSvlanConnectionItem2);
    }

    public ISvlanConnectionModel createSvlanConnection(ISvlanPathDefModel[] iSvlanPathDefModelArray, String string, boolean bl) throws PathInUse, InvalidPath, InvalidCircuitName, WrongNumberOfPaths, WrongInterfaceType, NoSuchInterface, CTCUserException {
        try {
            int[] nArray = new int[iSvlanPathDefModelArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = iSvlanPathDefModelArray[i].getPortEntityIdx();
            }
            Object[] objectArray = new Object[]{nArray, new Short(iSvlanPathDefModelArray[0].getSvlan()), string, new Boolean(bl)};
            sSvlanConnectionItem sSvlanConnectionItem2 = (sSvlanConnectionItem)this.createSvlanConnection.get(objectArray);
            return this.add(sSvlanConnectionItem2);
        }
        catch (xPathInUse xPathInUse2) {
            throw new PathInUse((UserException)xPathInUse2);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xInvalidCircuitName xInvalidCircuitName2) {
            throw new InvalidCircuitName((UserException)xInvalidCircuitName2);
        }
        catch (xWrongNumberOfPaths xWrongNumberOfPaths2) {
            throw new WrongNumberOfPaths((UserException)xWrongNumberOfPaths2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xProvisionError xProvisionError2) {
            throw SvlanCircuitModelsDelegate.toUserException(xProvisionError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "SvlanCircuitModelsDelegate::createSvlanConnection", userException);
        }
    }

    public void deleteSvlanConnection(ISvlanConnectionModel iSvlanConnectionModel) throws WrongInterfaceType, InvalidPath, Busy {
        try {
            ISvlanPathDefModel[] iSvlanPathDefModelArray = iSvlanConnectionModel.getPaths();
            int[] nArray = new int[iSvlanPathDefModelArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = iSvlanPathDefModelArray[i].getPortEntityIdx();
            }
            Object[] objectArray = new Object[]{nArray, new Short(iSvlanConnectionModel.getSvlan()), Boolean.FALSE};
            this.deleteSvlanConnection.set(objectArray);
            this.svlanConnections.remove(iSvlanConnectionModel);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new InvalidPath((UserException)xProvisionError2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new WrongInterfaceType((UserException)xNoSuchInterface2);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "SvlanCircuitModelsDelegate::deleteSvlanConnection", userException);
        }
    }

    public void addRemoveSvlanConnPath(ISvlanPathDefModel[] iSvlanPathDefModelArray, ISvlanPathDefModel iSvlanPathDefModel, boolean bl) throws CTCUserException {
        try {
            int[] nArray = new int[iSvlanPathDefModelArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = iSvlanPathDefModelArray[i].getPortEntityIdx();
            }
            int[] nArray2 = new int[]{iSvlanPathDefModel.getPortEntityIdx()};
            Object[] objectArray = new Object[5];
            objectArray[0] = nArray;
            if (bl) {
                objectArray[1] = new int[0];
                objectArray[2] = nArray2;
            } else {
                objectArray[1] = nArray2;
                objectArray[2] = new int[0];
            }
            objectArray[3] = new Short(iSvlanPathDefModelArray[0].getSvlan());
            objectArray[4] = Boolean.FALSE;
            this.addRemoveSvlanConnPath.set(objectArray);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisionError xProvisionError2) {
            throw SvlanCircuitModelsDelegate.toUserException(xProvisionError2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "SvlanCircuitModelsDelegate::addRemoneSvlanConnPath", userException);
        }
    }

    public IEntityModel[] getAvailEntitiesForSvlanCkt(short s, boolean bl, boolean bl2) {
        try {
            Object[] objectArray = new Object[]{new Short(s), new Boolean(bl), new Boolean(bl2)};
            Integer[] integerArray = (Integer[])this.availEntForSvlan.get(objectArray);
            if (integerArray != null) {
                ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
                for (int i = 0; i < integerArray.length; ++i) {
                    EntityModel entityModel;
                    try {
                        entityModel = (EntityModel)this.node.getEntityTableModel().getEntityModelByIndex(integerArray[i]);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        this.db.println("SvlanCircuitModels::getAvailEntitiesForSvlanCkt Cannot find index in cache " + integerArray[i]);
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        continue;
                    }
                    arrayList.add(entityModel);
                }
                return arrayList.toArray(new IEntityModel[integerArray.length]);
            }
            if (this.db.on()) {
                this.db.println("No Entites for the path Width");
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return new IEntityModel[0];
    }

    public boolean isSvlanAvailable(int n, short s, boolean bl) throws WrongInterfaceType, NoSuchInterface {
        Object[] objectArray = new Object[]{new Integer(n), new Short(s), new Boolean(bl)};
        Boolean bl2 = false;
        try {
            bl2 = (Boolean)this.isSvlanAvailable.get(objectArray);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "isSvlanAvailable", userException);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSvlanConnectionModels(SvlanRange[] svlanRangeArray) {
        List list = new ArrayList();
        if (this.svlanConnections != null) {
            SvlanConnections svlanConnections = this.svlanConnections;
            synchronized (svlanConnections) {
                list = this.svlanConnections.getConnectionModels(svlanRangeArray);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSvlanConnectionModels(int n) {
        List list = new ArrayList();
        if (this.svlanConnections != null) {
            SvlanConnections svlanConnections = this.svlanConnections;
            synchronized (svlanConnections) {
                list = this.svlanConnections.getConnectionModels(n);
            }
        }
        return list;
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy()");
        }
        super.destroy();
        this.node = null;
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose()");
        }
        this.svlanConnections.dispose();
        super.dispose();
    }

    public SvlanCircuits getSvlanCircuitRef() {
        return this.node.getIorRepository().getSvlanCircuitsRef();
    }

    public void update(Observable observable, Object object) {
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    private class AddRemoveSvlanConnPath
    extends NonCachedValue {
        public AddRemoveSvlanConnPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            SvlanCircuitModelsDelegate.this.getSvlanCircuitRef().addRemoveSvlanConnectionLegs((int[])objectArray[0], (int[])objectArray[1], (int[])objectArray[2], (Short)objectArray[3], (Boolean)objectArray[4]);
        }
    }

    private class AvailEntitiesForSvlan
    extends NonCachedValue {
        public AvailEntitiesForSvlan(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int[] nArray = SvlanCircuitModelsDelegate.this.getSvlanCircuitRef().getAvailableEntitiesForSvlan((Short)objectArray[0], (Boolean)objectArray[1], (Boolean)objectArray[2]);
            Integer[] integerArray = new Integer[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                integerArray[i] = new Integer(nArray[i]);
            }
            return integerArray;
        }
    }

    private class CreateSvlanConnection
    extends NonCachedValue {
        public CreateSvlanConnection(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xProvisionError, xNoSuchInterface, xPathInUse, xWrongNumberOfPaths, xInvalidCircuitName, xInvalidPath {
            Object[] objectArray = (Object[])object;
            return SvlanCircuitModelsDelegate.this.getSvlanCircuitRef().createSvlanConnection((int[])objectArray[0], (Short)objectArray[1], (String)objectArray[2], (Boolean)objectArray[3]);
        }
    }

    private class DeleteSvlanConnection
    extends NonCachedValue {
        public DeleteSvlanConnection(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xInvalidPath, xBusy, xProvisionError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            SvlanCircuitModelsDelegate.this.getSvlanCircuitRef().deleteSvlanConnection((int[])objectArray[0], (Short)objectArray[1], (Boolean)objectArray[2]);
        }
    }

    private class SvlanAvailableForPort
    extends NonCachedValue {
        public SvlanAvailableForPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            boolean bl = SvlanCircuitModelsDelegate.this.getSvlanCircuitRef().isSvlanAvailable((Integer)objectArray[0], (Short)objectArray[1], (Boolean)objectArray[2]);
            return new Boolean(bl);
        }
    }

    public class SvlanCktDebug
    extends SDebug {
        public SvlanCktDebug(SDebug sDebug) {
            super((KDebug)sDebug, SvlanCircuitModelsDelegate.SVLAN_DEBUG_KEY);
        }

        public final void dumpSvlan() {
            SvlanCircuitModelsDelegate.this.svlanConnections.printConnectionString(this);
        }
    }
}

