/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.ITdmModuleModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class TdmModuleModel
extends ModuleModel
implements ITdmModuleModel {
    public TdmModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2);
        this.index = n;
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        PortModel[] portModelArray = this.getPortModels(eEqType2);
        InterfaceModel[] interfaceModelArray = new TdmLineModel[portModelArray.length];
        for (int i = 0; i < portModelArray.length; ++i) {
            interfaceModelArray[i] = (TdmLineModel)portModelArray[i].getInterfaceModel();
        }
        return interfaceModelArray;
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        portModelArray = eEqType2 != null ? this.getChildrenOfType(eEqType2).toArray(new TdmPortModel[0]) : this.getDescendantsOfClassType(7).toArray(new TdmPortModel[0]);
        return portModelArray == null ? new TdmPortModel[]{} : portModelArray;
    }

    public List getConnectionsList() {
        LinkedList linkedList = new LinkedList();
        PortModel[] portModelArray = this.getPortModels();
        for (int i = 0; i < portModelArray.length; ++i) {
            linkedList.addAll(portModelArray[i].getConnectionsList());
        }
        return linkedList;
    }

    public boolean hasOhCircuits() {
        HashSet<TdmPortModel> hashSet = new HashSet<TdmPortModel>();
        hashSet.addAll(Arrays.asList((TdmPortModel[])this.getPortModels()));
        HashSet hashSet2 = new HashSet();
        OhConnectionModelsDelegate ohConnectionModelsDelegate = this.getChassis().getOhConnectionModels();
        ArrayList arrayList = new ArrayList(ohConnectionModelsDelegate.getOhTerms().getConnectionModels(this.getChassis()));
        arrayList.addAll(ohConnectionModelsDelegate.getOhXcons().getConnectionModels(this.getChassis()));
        for (ConnectionModel connectionModel : arrayList) {
            hashSet2.addAll(connectionModel.getPortModels());
        }
        hashSet2.retainAll(hashSet);
        return !hashSet2.isEmpty();
    }

    public TdmLineModel[] getTdmLineModels() {
        TdmPortModel[] tdmPortModelArray = this.getDescendantsOfClassType(7).toArray(new TdmPortModel[0]);
        TdmLineModel[] tdmLineModelArray = new TdmLineModel[tdmPortModelArray.length];
        try {
            for (int i = 0; i < tdmPortModelArray.length; ++i) {
                tdmLineModelArray[i] = tdmPortModelArray[i].getTdmLineModel();
            }
        }
        catch (Exception exception) {
            this.db.println("Error in getting interface lines" + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        return tdmLineModelArray;
    }

    public String toString() {
        return "Tdm" + super.toString();
    }

    public boolean supportsRxEqualization() {
        int n = this.getEqType();
        return n == 12 || n == 13;
    }

    public boolean supportsAls() {
        boolean bl = false;
        IPlatform iPlatform = ((NodeModelDelegate)this.getNodeModel()).getPlatform();
        if (iPlatform.is600SDH()) {
            bl = true;
        } else {
            switch (this.getEqType()) {
                case 60: 
                case 106: {
                    bl = true;
                    break;
                }
                case 11: {
                    String string = this.getMfgData().name;
                    if (string == null || string.indexOf("OC48") == -1 || string.indexOf("ELR") == -1) break;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    public boolean supportsLoopbackAis() {
        boolean bl = false;
        IPlatform iPlatform = ((NodeModelDelegate)this.getNodeModel()).getPlatform();
        int n = this.getEqType();
        if ((iPlatform.is454() || iPlatform.is455()) && (n == 12 || n == 9 || n == 106 || n == 85 || n == 60 || this.isOC48AS())) {
            bl = true;
        }
        return bl;
    }

    private boolean isOC48AS() {
        boolean bl = false;
        switch (this.getEqType()) {
            case 11: {
                String string = this.getMfgData().name;
                if (string == null || string.indexOf("OC48") == -1 || string.indexOf("AS") == -1) break;
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

