/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IVlanInfo;
import cerent.util.ComparisonUtil;
import java.util.StringTokenizer;

public class VlanInfo
implements IVlanInfo,
Comparable {
    private static final int MIN_VLAN_ID = 0;
    private static final int MAX_VLAN_ID = 4095;
    private static final String PARSE_ERROR_MSG = "An error occurred while parsing the import string. ";
    protected short vlanId = (short)-1;
    protected String vlanName = "";
    private boolean protection;
    private boolean macLearning;
    private boolean igmp;
    private boolean igmpFastLeave;
    private boolean igmpSuppression;
    private boolean vlanSelect;

    public VlanInfo() {
    }

    public VlanInfo(short s, String string) {
        this.vlanId = s;
        this.vlanName = string;
    }

    public VlanInfo(short s, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.vlanId = s;
        this.vlanName = string;
        this.protection = bl;
        this.macLearning = bl2;
        this.igmp = bl3;
        this.igmpFastLeave = bl4;
        this.igmpSuppression = bl5;
    }

    public VlanInfo(short s, String string, boolean bl) {
        this.vlanId = s;
        this.vlanName = string;
        this.protection = bl;
    }

    public short getVlanId() {
        return this.vlanId;
    }

    public void setVlanId(short s) {
        this.vlanId = s;
    }

    public String getVlanName() {
        return this.vlanName;
    }

    public void setVlanName(String string) {
        this.vlanName = string;
    }

    public boolean isVlanProtected() {
        return this.protection;
    }

    public void setVlanProtection(boolean bl) {
        this.protection = bl;
    }

    public boolean isMacLearning() {
        return this.macLearning;
    }

    public void setMacLearning(boolean bl) {
        this.macLearning = bl;
    }

    public boolean isIgmp() {
        return this.igmp;
    }

    public void setIgmp(boolean bl) {
        this.igmp = bl;
    }

    public boolean isIgmpFastLeave() {
        return this.igmpFastLeave;
    }

    public void setIgmpFastLeave(boolean bl) {
        this.igmpFastLeave = bl;
    }

    public boolean isIgmpSuppression() {
        return this.igmpSuppression;
    }

    public void setIgmpSuppression(boolean bl) {
        this.igmpSuppression = bl;
    }

    public boolean isValid() {
        return this.vlanId > 0 && this.vlanId < 4095;
    }

    public String getAttributesAsString() {
        return this.vlanId + ", " + this.vlanName + ", " + this.protection + ", " + this.macLearning + ", " + this.igmp + ", " + this.igmpFastLeave + ", " + this.igmpSuppression;
    }

    public String toString() {
        return "SVLAN: " + this.vlanId + ", Name: " + this.vlanName + ", Prot: " + this.protection + ", Mac Learning: " + this.macLearning + ", Igmp: " + this.igmp + ", Igmp FastLeave: " + this.igmpFastLeave + ", Igmp Suppression: " + this.igmpSuppression;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IVlanInfo)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        IVlanInfo iVlanInfo = (IVlanInfo)object;
        return this.vlanId == iVlanInfo.getVlanId() && this.vlanName.equals(iVlanInfo.getVlanName()) && this.protection == iVlanInfo.isVlanProtected() && this.macLearning == iVlanInfo.isMacLearning() && this.igmp == iVlanInfo.isIgmp() && this.igmpFastLeave == iVlanInfo.isIgmpFastLeave() && this.igmpSuppression == iVlanInfo.isIgmpSuppression();
    }

    public int hashCode() {
        int n = this.vlanId;
        n = 13 * n + this.vlanName.hashCode();
        n = 13 * n + VlanInfo.hash(this.protection);
        n = 13 * n + VlanInfo.hash(this.macLearning);
        n = 13 * n + VlanInfo.hash(this.igmp);
        n = 13 * n + VlanInfo.hash(this.igmpFastLeave);
        n = 13 * n + VlanInfo.hash(this.igmpSuppression);
        return n;
    }

    private static int hash(boolean bl) {
        return bl ? 1 : 0;
    }

    public int compareTo(Object object) {
        IVlanInfo iVlanInfo = (IVlanInfo)object;
        return ComparisonUtil.compare((int)this.vlanId, (int)iVlanInfo.getVlanId());
    }

    public boolean isVlanSelect() {
        return this.vlanSelect;
    }

    public void setVlanSelect(boolean bl) {
        this.vlanSelect = bl;
    }

    public static IVlanInfo vlanFromImportString(String string) throws Exception {
        if (string == null) {
            throw new Exception("An error occurred while parsing the import string.  A null string was found.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken().trim();
        String string3 = stringTokenizer.nextToken().trim();
        String string4 = stringTokenizer.nextToken().trim();
        String string5 = stringTokenizer.nextToken().trim();
        String string6 = stringTokenizer.nextToken().trim();
        String string7 = stringTokenizer.nextToken().trim();
        String string8 = stringTokenizer.nextToken().trim();
        if (string3.equals("null")) {
            string3 = null;
        }
        return new VlanInfo(Short.valueOf(string2), string3, Boolean.valueOf(string4), Boolean.valueOf(string5), Boolean.valueOf(string6), Boolean.valueOf(string7), Boolean.valueOf(string8));
    }
}

