/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.fv.IFvAlarmStatus;
import cerent.cms.fv.IFvAlarmStore;
import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.idl.OpticsTopology.sOpticalPatchCord;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchPatchCord;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OptLinkModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.AbstractAlarmStore;
import cerent.cms.model.event.AbstractEventStore;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.ICardAlarmStore;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Set;

public class ElementAlarmStore
extends AbstractAlarmStore
implements ICardAlarmStore,
IFvAlarmStore {
    private String PROP_KEY = "ctc.";
    private static final String PROP_TR_LOWATER = "node.tr.lowater";
    private static final String PROP_TR_HIWATER = "node.tr.hiwater";
    private static final String PROP_MIN_TR_HIWATER = "node.tr.minhiwater";
    private static final int DEF_TR_LOWATER = 25;
    private static final int DEF_TR_HIWATER = 50;
    private static final int DEF_MIN_TR_HIWATER = 20;
    boolean isComboCard;
    protected HashMap alarmStatusContainer;
    protected int portCountUsers = 0;
    private ElementAlarmStore parentStore;
    private NodeModelDelegate nodeModel;
    private int trCount;
    private int trLoWater;
    private int trHiWater;
    private int minTrHiWater;

    public ElementAlarmStore(NodeModelDelegate nodeModelDelegate, String string) {
        this(nodeModelDelegate, string, null);
    }

    private ElementAlarmStore(String string, ElementAlarmStore elementAlarmStore) {
        this(null, string, elementAlarmStore);
    }

    private ElementAlarmStore(NodeModelDelegate nodeModelDelegate, String string, ElementAlarmStore elementAlarmStore) {
        super(string);
        this.nodeModel = nodeModelDelegate;
        this.parentStore = elementAlarmStore;
        this.PROP_KEY = this.PROP_KEY + this.getNodeModelDelegate().getPlatform().getPlatformName();
        this.trLoWater = Preferences.instance().getInt(this.PROP_KEY, PROP_TR_LOWATER, 25);
        this.trHiWater = Preferences.instance().getInt(this.PROP_KEY, PROP_TR_HIWATER, 50);
        this.minTrHiWater = Preferences.instance().getInt(this.PROP_KEY, PROP_MIN_TR_HIWATER, 20);
        this.isComboCard = false;
        this.alarmStatusContainer = null;
        this.db = this.parentStore == null ? new AbstractAlarmStore.AsDebug(this, nodeModelDelegate.getDebug(), this.name) : new AbstractAlarmStore.AsDebug(this, this.parentStore.getDebug(), this.name);
        if (this.trHiWater < this.minTrHiWater) {
            this.trHiWater = this.minTrHiWater;
        }
        if (this.trLoWater >= this.trHiWater) {
            this.trLoWater = this.trHiWater / 2;
        }
        this.db.info("PROP_TR_LOWATER = " + this.trLoWater + ", PROP_TR_HIWATER = " + this.trHiWater);
    }

    protected NodeModelDelegate getNodeModelDelegate() {
        return this.parentStore != null ? this.parentStore.getNodeModelDelegate() : this.nodeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvents(ArrayList object) {
        Set set = null;
        ElementAlarmStore elementAlarmStore = this;
        synchronized (elementAlarmStore) {
            int n;
            Object object22;
            int n2;
            Object object3;
            int n3 = ((ArrayList)object).size();
            this.db.info(this.name + " adding " + n3 + " events");
            int n4 = this.trCount;
            if (this.db.isFineEnabled()) {
                this.db.fine("***********addEvents() Begins************");
                this.db.fine("addEvents(): anyEvtArray STARTS :");
                object3 = ((ArrayList)object).iterator();
                while (object3.hasNext()) {
                    EventInfo eventInfo = (EventInfo)object3.next();
                    this.db.fine(eventInfo.toString());
                }
                this.db.fine("addEvents(): anyEvtArray ENDS :");
                this.db.fine("addEvents(): arrayList STARTS:");
                for (EventInfo eventInfo : this.arrayList) {
                    this.db.fine(eventInfo.toString());
                }
                this.db.fine("addEvents(): arrayList ENDS:");
                this.db.fine("addEvents(): filteredArrayList STARTS:");
                for (EventInfo eventInfo : this.filteredArrayList) {
                    this.db.fine(eventInfo.toString());
                }
                this.db.fine("addEvents(): arrayList ENDS:");
            }
            object3 = null;
            for (n2 = 0; n2 < n3; ++n2) {
                ElementAlarmStore elementAlarmStore2;
                object22 = (EventInfo)((ArrayList)object).get(n2);
                n = object22.getShelfId();
                int n5 = object22.getSlot();
                if (n5 != 0) {
                    elementAlarmStore2 = (ElementAlarmStore)this.getCardAlarmStore(n, n5);
                    object3 = elementAlarmStore2.storeEvent((EventInfo)object22);
                    this.manageSideEvent((EventInfo)object22);
                    if (this.nodeModel.isMultishelf()) {
                        ElementAlarmStore elementAlarmStore3 = this.getShelfAlarmStore(n);
                        object3 = elementAlarmStore3.correlateAlarm((EventInfo)object22, (EventInfo)object3);
                    }
                    object3 = this.correlateAlarm((EventInfo)object22, (EventInfo)object3);
                } else if (this.nodeModel.isMultishelf() && n != 0) {
                    elementAlarmStore2 = this.getShelfAlarmStore(n);
                    object3 = elementAlarmStore2.storeEvent((EventInfo)object22);
                    object3 = this.correlateAlarm((EventInfo)object22, (EventInfo)object3);
                } else {
                    object3 = this.storeEvent((EventInfo)object22);
                }
                object22.setCorrelated((EventInfo)object3);
                if (!this.db.on()) continue;
                this.db.fine("addEvent:" + object22 + " corl=" + object3);
            }
            if (this.trCount > this.trHiWater) {
                n2 = this.trCount - this.trLoWater;
                set = this.removeTransient(n2);
                this.trCount = this.trLoWater;
                if ((n2 -= n4) > 0) {
                    object22 = new ArrayList(((ArrayList)object).size());
                    this.db.info("TR discarded from new array=" + n2);
                    for (n = 0; n < ((ArrayList)object).size(); ++n) {
                        EventInfo eventInfo = (EventInfo)((ArrayList)object).get(n);
                        if (n2 > 0 && eventInfo.getState() == 'T') {
                            --n2;
                            continue;
                        }
                        ((ArrayList)object22).add(eventInfo);
                    }
                    object = object22;
                }
            }
            if (set != null && this.children != null) {
                for (Object object22 : this.children.values()) {
                    ((AbstractAlarmStore)object22).removeAlarms(set);
                }
            }
            if (this.db.isFineEnabled()) {
                this.db.fine("addEvents(): BEFORE  LEAVING the method");
                this.db.fine("addEvents(): arrayList STARTS:");
                for (Object object22 : this.arrayList) {
                    this.db.fine(object22.toString());
                }
                this.db.fine("addEvents(): arrayList ENDS:");
                this.db.fine("addEvents(): filteredArrayList STARTS:");
                for (Object object22 : this.filteredArrayList) {
                    this.db.fine(object22.toString());
                }
                this.db.fine("addEvents(): shortArrayList ENDS:");
                this.db.fine("***********addEvents() Ends**************");
            }
        }
        if (set != null) {
            this.storeObservable.setChanged();
            this.storeObservable.notifyObservers(set);
            this.fireBulkDataSourceChanged();
        }
        if (((ArrayList)object).size() > 0) {
            this.storeObservable.setChanged();
            this.storeObservable.notifyObservers(object);
        }
        this.updateView();
    }

    private ElementAlarmStore getChildStore(Object object, String string) {
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.getChild(object);
        if (elementAlarmStore == null) {
            elementAlarmStore = (ElementAlarmStore)this.createChild(object, string);
        }
        return elementAlarmStore;
    }

    public ElementAlarmStore getShelfAlarmStore(int n) {
        String string = "Shelf-" + n;
        String string2 = String.valueOf(n);
        ElementAlarmStore elementAlarmStore = this.getChildStore(string2, string);
        return elementAlarmStore;
    }

    public ElementAlarmStore getSidesAlarmStore() {
        return this.getChildStore("Side", "Side");
    }

    public ElementAlarmStore getSideAlarmStore(String string) {
        String string2;
        String string3 = string2 = "Side-" + string;
        ElementAlarmStore elementAlarmStore = null;
        ElementAlarmStore elementAlarmStore2 = this.getChildStore("Side", "Side");
        elementAlarmStore = elementAlarmStore2.getChildStore(string3, string2);
        return elementAlarmStore;
    }

    public ICardAlarmStore getCardAlarmStore(int n) {
        return this.getCardAlarmStore(1, n);
    }

    public ICardAlarmStore getCardAlarmStore(int n, int n2) {
        ElementAlarmStore elementAlarmStore;
        String string = "Slot-" + n2;
        if (n > 1 || this.nodeModel.isMultishelf()) {
            String string2 = String.valueOf(n) + "-" + String.valueOf(n2);
            elementAlarmStore = (ElementAlarmStore)this.getChild(string2);
            if (elementAlarmStore == null) {
                ElementAlarmStore elementAlarmStore2 = this.getShelfAlarmStore(n);
                elementAlarmStore = elementAlarmStore2.getChildStore(string2, string);
            }
        } else {
            String string3 = String.valueOf(n2);
            elementAlarmStore = this.getChildStore(string3, string);
        }
        return elementAlarmStore;
    }

    public void manageSideEvent(EventInfo eventInfo) {
        IEntityModel iEntityModel = null;
        int n = 0;
        try {
            Object object;
            block17: {
                iEntityModel = this.nodeModel.getEntityTableModel().getEntityModelByIndex(eventInfo.getIndex());
                IModuleModel iModuleModel = iEntityModel.getModuleModel();
                if (iModuleModel instanceof OpticsModuleModel) {
                    n = ((OpticsModuleModel)iModuleModel).getSide();
                } else {
                    if (iModuleModel instanceof DwdmModuleModel) {
                        try {
                            object = ((DwdmModuleModel)iModuleModel).getDWDMPatchCords();
                            if (((sOpticalPatchCord[])object).length == 0) {
                                return;
                            }
                            try {
                                OptLinkModel optLinkModel = this.nodeModel.getOpticalPatchCordModel().getOptLinkModelByIndex(((sOpticalPatchCord)object[0]).index);
                                try {
                                    n = optLinkModel.getFromOpticsSideId();
                                    break block17;
                                }
                                catch (Exception exception) {
                                    try {
                                        n = optLinkModel.getToOpticsSideId();
                                        break block17;
                                    }
                                    catch (Exception exception2) {
                                        return;
                                    }
                                }
                            }
                            catch (NoSuchPatchCord noSuchPatchCord) {
                                return;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            return;
                        }
                        catch (FeatureUnsupported featureUnsupported) {
                            return;
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            return;
                        }
                    }
                    return;
                }
            }
            object = this.getSideAlarmStore(DwdmSide.getSideLabelFromOffset(n));
            if (object != null) {
                ((AbstractAlarmStore)object).storeEvent(eventInfo);
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return;
        }
    }

    public void getPendingAlarms() throws AbstractCmsIOException {
        this.getNodeModelDelegate().synchronizeAlarm();
    }

    public void enablePortAlarmsStatus(IFvCardModel iFvCardModel) {
        this.enablePortAlarmsStatus((IModuleModel)iFvCardModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enablePortAlarmsStatus(IModuleModel iModuleModel) {
        if (iModuleModel != null) {
            this.isComboCard = ((ModuleModel)iModuleModel).isComboModule();
        } else {
            this.db.println("enablePortAlarmsStatus called with null");
            SDebug.printStackTrace((Throwable)new Exception());
        }
        this.db.info(this.name + " combo=" + this.isComboCard + " module=(" + iModuleModel + ")");
        ElementAlarmStore elementAlarmStore = this;
        synchronized (elementAlarmStore) {
            if (this.alarmStatusContainer == null) {
                this.alarmStatusContainer = new HashMap();
            } else {
                this.alarmStatusContainer.clear();
            }
            this.db.info(this.name + " entering enablePortAlarmsStatus filter-count=" + this.filteredArrayList.size() + " alarm-count=" + this.arrayList.size());
            for (int i = 0; i < this.arrayList.size(); ++i) {
                EventInfo eventInfo = (EventInfo)this.arrayList.get(i);
                if (eventInfo.getState() != 'R') continue;
                this.updatePortAlarmStatus(eventInfo);
            }
            ++this.portCountUsers;
            if (this.db.isInfoEnabled()) {
                Set set = this.alarmStatusContainer.entrySet();
                this.db.println("Alarm Status (" + set.size() + "):");
                for (Map.Entry entry : set) {
                    this.db.println("  " + entry.getKey() + " (" + entry.getValue() + ")");
                }
            }
            this.db.info(this.name + " exiting enablePortAlarmsStatus filter-count=" + this.filteredArrayList.size() + " alarm-count=" + this.arrayList.size() + " " + this.getNodeModelDelegate().getHostName() + " users=" + this.portCountUsers);
        }
    }

    public synchronized void disablePortAlarmsStatus() {
        if (this.portCountUsers > 0) {
            --this.portCountUsers;
        }
        this.db.info(this.name + " disablePortAlarmsStatus " + this.getNodeModelDelegate().getHostName() + " users=" + this.portCountUsers);
        if (this.portCountUsers == 0) {
            this.resetPortAlarmStatus(true);
        }
    }

    public synchronized IAlarmStatus getEntityAlarmStatus(IEntityModel iEntityModel) {
        if (iEntityModel == null) {
            return null;
        }
        int n = iEntityModel.getEqType();
        int[] nArray = null;
        if (iEntityModel instanceof PortModel) {
            nArray = ((PortModel)iEntityModel).getPortNum();
        } else if (iEntityModel instanceof PluggableModel) {
            nArray = ((PluggableModel)iEntityModel).getHierarchyNums();
        } else {
            nArray = new int[]{};
            if (this.db.on()) {
                this.db.println(this.name + " invalid model: " + iEntityModel);
            }
        }
        return this.getEntityAlarmStatus(n, nArray);
    }

    private synchronized AlarmStatus getEntityAlarmStatus(int n, int[] nArray) {
        AlarmStatus alarmStatus = null;
        if (this.alarmStatusContainer != null) {
            Set set;
            String string = this.makeAlarmStatusContainerKey(n, nArray);
            if (this.alarmStatusContainer.containsKey(string)) {
                alarmStatus = (AlarmStatus)this.alarmStatusContainer.get(string);
            } else if (this.db.isFineEnabled() && (set = this.alarmStatusContainer.entrySet()).size() > 0) {
                this.db.fine("Can't match " + string + " with " + set.size() + " entries:");
                for (Map.Entry entry : set) {
                    this.db.fine("  " + entry.getKey() + " (" + entry.getValue() + ")");
                }
            }
            if (this.db.isFineEnabled()) {
                this.db.fine(this.name + " alarm status for equipment=" + n + " entity=" + PortHelper.getConcatenatedString((int[])nArray) + " combo=" + this.isComboCard + " alarm-status=" + alarmStatus + " container-size=" + this.alarmStatusContainer.size());
            }
        } else if (this.db.isFineEnabled()) {
            this.db.fine(this.name + " Null alarm status container, eqType=" + n + " entity=" + PortHelper.getConcatenatedString((int[])nArray));
        }
        return alarmStatus;
    }

    public synchronized IAlarmStatus getPortAlarmStatus(int n, int n2) {
        AlarmStatus alarmStatus = null;
        if (this.alarmStatusContainer != null) {
            String string = this.makeAlarmStatusContainerKey(n, new int[]{n2});
            if (this.alarmStatusContainer.containsKey(string)) {
                alarmStatus = (AlarmStatus)this.alarmStatusContainer.get(string);
            }
            this.db.info(this.name + " no alarm status for equipment=" + n + " port=" + n2 + " combo=" + this.isComboCard + " container-size=" + this.alarmStatusContainer.size());
        } else {
            this.db.info(this.name + " Null alarm status container, eqType=" + n + " port=" + n2);
        }
        return alarmStatus;
    }

    public void removeClearedAlarms() {
        super.removeClearedAlarms();
        this.storeObservable.setChanged();
        this.storeObservable.notifyObservers(new Object[]{DELETE_CLEARED_ALARM_BUTTON, new Integer(this.getNodeModelDelegate().getNodeId())});
    }

    public void reset() {
        this.flushAlarmStore();
    }

    public void flushAlarmStore() {
        super.flushStore();
        this.storeObservable.setChanged();
        this.storeObservable.notifyObservers(new Object[]{SYNC_ALARM_BUTTON, new Integer(this.getNodeModelDelegate().getNodeId())});
        this.updateView();
    }

    protected synchronized void transientAdded() {
        if (this.parentStore == null) {
            ++this.trCount;
        }
    }

    private synchronized Set removeTransient(int n) {
        ArrayList arrayList = new ArrayList(this.arrayList.size());
        HashSet<EventInfo> hashSet = new HashSet<EventInfo>();
        this.db.info("Transient current=" + this.trCount + " discarding=" + n);
        for (int i = 0; i < this.arrayList.size(); ++i) {
            EventInfo eventInfo = (EventInfo)this.arrayList.get(i);
            if (n > 0 && eventInfo.getState() == 'T') {
                hashSet.add(eventInfo);
                --n;
                continue;
            }
            arrayList.add(this.arrayList.get(i));
        }
        this.arrayList.clear();
        this.arrayList = arrayList;
        return hashSet;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n.equals(DELETE_CLEARED_ALARM_BUTTON)) {
                this.db.info(this.name + " update: removeClearedAlarms()");
                super.removeClearedAlarms();
            } else if (n.equals(SYNC_ALARM_BUTTON)) {
                this.db.info(this.name + " update: SYNC (flushStore)");
                super.flushStore();
            }
        }
    }

    protected AbstractEventStore createInstance(String string) {
        return new ElementAlarmStore(null, string, this);
    }

    protected void localUpdateStatus(EventInfo eventInfo) {
        this.db.info(this.name + " localUpdateStatus");
        this.updatePortAlarmStatus(eventInfo);
    }

    protected void localFlushStore() {
        if (this.alarmStatusContainer != null) {
            this.alarmStatusContainer.clear();
        }
        super.localFlushStore();
        this.trCount = 0;
    }

    private synchronized void resetPortAlarmStatus(boolean bl) {
        if (this.alarmStatusContainer != null) {
            this.alarmStatusContainer.clear();
            if (bl) {
                this.alarmStatusContainer = null;
            }
        }
        this.db.info(this.name + " Resetting port alarm status " + this.getNodeModelDelegate().getHostName());
    }

    private String makeAlarmStatusContainerKey(int n, int[] nArray) {
        String string = PortHelper.getConcatenatedString((int[])nArray);
        if (this.isComboCard) {
            return n + "-" + string;
        }
        return string;
    }

    protected synchronized void updatePortAlarmStatus(EventInfo eventInfo) {
        int[] nArray = eventInfo.getEntityHierarchyNum();
        if (this.alarmStatusContainer != null && nArray.length != 0) {
            int n = eventInfo.getPortType();
            AlarmStatus alarmStatus = this.getEntityAlarmStatus(n, nArray);
            if (alarmStatus == null) {
                String string = this.makeAlarmStatusContainerKey(n, nArray);
                this.db.info(this.name + " creating key " + string);
                alarmStatus = new AlarmStatus();
                this.alarmStatusContainer.put(string, alarmStatus);
            } else if (this.db.isInfoEnabled()) {
                this.db.fine(this.name + " reusing key " + PortHelper.getConcatenatedString((int[])nArray));
            }
            if (eventInfo.getState() == 'R') {
                alarmStatus.incrementSeverity(eventInfo.getSeverity());
            } else if (eventInfo.getState() == 'C') {
                alarmStatus.decrementSeverity(eventInfo.getSeverity());
            }
        } else if (this.db.isInfoEnabled() && this.alarmStatusContainer == null && this.parentStore != null && eventInfo.getPort() > 0) {
            this.db.info(this.name + " Null alarmStatusContainer, alarm on port=" + PortHelper.getConcatenatedString((int[])nArray));
        }
    }

    public ElementAlarmStore getParentStore() {
        return this.parentStore;
    }

    public void destroy() {
        this.db.info("destroy(): arrayList size=" + this.arrayList.size());
        this.storeObservable.setChanged();
        this.storeObservable.notifyObservers(new Object[]{ModelUpdateType.DELETED, new ArrayList(this.arrayList)});
        super.destroy();
        this.alarmStatusContainer = null;
    }

    public IFvAlarmStatus getIFvEntityAlarmStatus(IFvPortModel iFvPortModel) {
        return this.getEntityAlarmStatus((IEntityModel)iFvPortModel);
    }

    public IFvAlarmStore getIFvCardAlarmStore(int n, int n2) {
        return (IFvAlarmStore)this.getCardAlarmStore(n, n2);
    }

    public IFvAlarmStore getIFvSideAlarmStore(String string) {
        return this.getSideAlarmStore(string);
    }
}

