/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.model.ENMSUpdate;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.AbstractEventStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.StoreObservable;
import cerent.util.Preferences;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Observable;

public class ElementEventStore
extends AbstractEventStore
implements PropertyChangeListener {
    private String currentlyViewedKey = "";
    private static String PROP_HISTORY_MAX = "nodehistory.max";
    protected static final int DEFAULT_HI_WATER = 500;
    protected int globalStoreHighWater = 500;
    private ElementEventStore parentStore;
    private NodeModelDelegate nodeModel;

    public ElementEventStore(NodeModelDelegate nodeModelDelegate, String string) {
        this.nodeModel = nodeModelDelegate;
        this.name = string;
        this.storeObservable = new StoreObservable(this.name);
        this.parentStore = null;
        this.db = new AbstractEventStore.EsDebug(nodeModelDelegate.getDebug(), this.name);
        this.init();
    }

    private ElementEventStore(String string, ElementEventStore elementEventStore) {
        this.nodeModel = null;
        this.name = string;
        this.storeObservable = new StoreObservable(this.name);
        this.parentStore = elementEventStore;
        this.db = new AbstractEventStore.EsDebug(this.parentStore.getDebug(), this.name);
        this.init();
    }

    protected NodeModelDelegate getNodeModelDelegate() {
        return this.parentStore != null ? this.parentStore.getNodeModelDelegate() : this.nodeModel;
    }

    private ElementEventStore getChildStore(Object object, String string) {
        ElementEventStore elementEventStore = (ElementEventStore)this.getChild(object);
        if (elementEventStore == null) {
            elementEventStore = (ElementEventStore)this.createChild(object, string);
        }
        return elementEventStore;
    }

    public ElementEventStore getShelfEventStore(int n) {
        String string = "Shelf-" + n;
        String string2 = this.getShelfStoreKey(n);
        boolean bl = false;
        if (!string2.equals(this.currentlyViewedKey)) {
            this.removeChild(this.currentlyViewedKey);
            bl = true;
        }
        this.currentlyViewedKey = string2;
        ElementEventStore elementEventStore = this.getChildStore(string2, string);
        if (bl) {
            this.fillShelfStore(n, elementEventStore, this);
        }
        return elementEventStore;
    }

    public ElementEventStore getCardEventStore(int n) {
        return this.getCardEventStore(1, n);
    }

    public ElementEventStore getCardEventStore(int n, int n2) {
        ElementEventStore elementEventStore;
        String string = "Slot-" + n2;
        boolean bl = false;
        if (n > 1 || this.nodeModel.isMultishelf()) {
            String string2 = this.getShelfSlotStoreKey(n, n2);
            if (!string2.equals(this.currentlyViewedKey)) {
                this.removeChild(this.currentlyViewedKey);
                bl = true;
            }
            this.currentlyViewedKey = string2;
            elementEventStore = (ElementEventStore)this.getChild(string2);
            if (elementEventStore == null) {
                ElementEventStore elementEventStore2 = this.getShelfEventStore(n);
                elementEventStore = elementEventStore2.getChildStore(string2, string);
                if (bl) {
                    this.fillSlotStore(n2, elementEventStore, elementEventStore2);
                }
            }
        } else {
            String string3 = this.getSlotStoreKey(n2);
            if (!string3.equals(this.currentlyViewedKey)) {
                this.removeChild(this.currentlyViewedKey);
                bl = true;
            }
            this.currentlyViewedKey = string3;
            elementEventStore = this.getChildStore(string3, string);
            if (bl) {
                this.fillSlotStore(n2, elementEventStore, this);
            }
        }
        return elementEventStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvents(ArrayList arrayList) {
        ElementEventStore elementEventStore = this;
        synchronized (elementEventStore) {
            Object object;
            int n;
            int n2 = arrayList.size();
            if (n2 <= 0) {
                return;
            }
            int n3 = 0;
            boolean bl = false;
            int n4 = this.getRowCount();
            if (this.db.on()) {
                this.db.println("processEvents(): currentCount: " + n4 + ", incomingCount: " + n2 + ", threshold: " + this.globalStoreHighWater + ", lowWater: " + this.getLowWater());
            }
            if (n4 + n2 > this.globalStoreHighWater) {
                if (n2 >= this.globalStoreHighWater) {
                    this.flushStore();
                    n3 = n2 - this.getLowWater();
                } else if (n2 >= this.getLowWater()) {
                    this.flushStore();
                } else {
                    int n5;
                    n = this.getLowWater() - n2;
                    object = new ArrayList();
                    for (int i = n5 = n4 - n; i < n4; ++i) {
                        ((ArrayList)object).add(this.arrayList.get(i));
                    }
                    this.flushStore();
                    for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                        EventInfo eventInfo = (EventInfo)((ArrayList)object).get(i);
                        this.storeEvent(eventInfo);
                        this.storeChildEvent(eventInfo);
                    }
                    Object var10_15 = null;
                }
                if (this.db.on()) {
                    this.db.println("clipping is going on !! startIndex " + n3);
                }
            }
            for (n = 0; n < n2; ++n) {
                object = (EventInfo)arrayList.get(n);
                this.storeEvent((EventInfo)object);
                this.storeChildEvent((EventInfo)object);
                if (!this.db.on()) continue;
                this.db.println(this.name + " " + object);
            }
        }
        if (this.db.isFineEnabled()) {
            this.db.fine("***********Sending EventInfos to CTM************");
            this.db.fine("anyEvtArray STARTS :");
            for (EventInfo eventInfo : arrayList) {
                this.db.fine(eventInfo.toString() + "$$$event.sequence number =  " + eventInfo.getSequenceNumber() + "    event.getCOrrelated:" + eventInfo.getCorrelated());
            }
            this.db.fine("*************CTM EventInfo printing(): anyEvtArray ENDS :");
        }
        this.storeObservable.setChanged();
        this.storeObservable.notifyObservers(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            EventInfo eventInfo = (EventInfo)arrayList.get(i);
            eventInfo.setCorrelated(null);
        }
        this.updateView();
    }

    private void storeChildEvent(EventInfo eventInfo) {
        String string;
        AbstractEventStore abstractEventStore;
        int n = eventInfo.getShelfId();
        int n2 = eventInfo.getSlot();
        if (eventInfo.getSlot() > 0) {
            if (this.nodeModel.isMultishelf()) {
                String string2 = this.getShelfStoreKey(n);
                AbstractEventStore abstractEventStore2 = this.getChild(string2);
                if (abstractEventStore2 != null) {
                    abstractEventStore2.storeEvent(eventInfo);
                    string2 = this.getShelfSlotStoreKey(n, n2);
                    AbstractEventStore abstractEventStore3 = this.getChild(string2);
                    if (abstractEventStore3 == null) {
                        abstractEventStore3 = abstractEventStore2.getChild(string2);
                    }
                    if (abstractEventStore3 != null) {
                        abstractEventStore3.storeEvent(eventInfo);
                    }
                }
            } else {
                String string3 = this.getSlotStoreKey(n2);
                AbstractEventStore abstractEventStore4 = this.getChild(string3);
                if (abstractEventStore4 != null) {
                    abstractEventStore4.storeEvent(eventInfo);
                }
            }
        } else if (this.nodeModel.isMultishelf() && n != 0 && (abstractEventStore = this.getChild(string = this.getShelfStoreKey(n))) != null) {
            abstractEventStore.storeEvent(eventInfo);
        }
    }

    public void update(Observable observable, Object object) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals(PROP_HISTORY_MAX)) {
            try {
                int n = Integer.parseInt(this.prefs.getProperty("ctc", PROP_HISTORY_MAX, ""));
                if (n > 0) {
                    this.globalStoreHighWater = n;
                    this.db.config("globalStoreHighWater changed to " + this.globalStoreHighWater);
                }
            }
            catch (Exception exception) {
                this.db.warning("Exception in propertyChange(): " + exception);
            }
        }
    }

    public void init() {
        this.prefs = Preferences.instance();
        this.prefs.addPropertyChangeListener((PropertyChangeListener)this);
        try {
            int n = Integer.parseInt(this.prefs.getProperty("ctc", PROP_HISTORY_MAX, null));
            if (n > 0) {
                this.globalStoreHighWater = n;
                this.db.config("globalStoreHighWater changed to " + this.globalStoreHighWater);
            }
        }
        catch (Exception exception) {
            this.prefs.setProperty("ctc", PROP_HISTORY_MAX, String.valueOf(this.globalStoreHighWater));
        }
    }

    public void destroy() {
        super.destroy();
        if (this.prefs != null) {
            this.prefs.removePropertyChangeListener((PropertyChangeListener)this);
            this.prefs = null;
        }
    }

    public void sendReregisterNotification() {
        int n = this.getNodeModelDelegate().getNodeId();
        ENMSUpdate eNMSUpdate = new ENMSUpdate(n, new Integer(0));
        if (this.db.on()) {
            this.db.println("sending notification for reregister");
        }
        this.storeObservable.setChanged();
        this.storeObservable.notifyObservers(eNMSUpdate);
    }

    protected int getHighWater() {
        return this.globalStoreHighWater;
    }

    protected int getLowWater() {
        return this.globalStoreHighWater / 2;
    }

    protected AbstractEventStore createInstance(String string) {
        return new ElementEventStore(string, this);
    }

    private synchronized void fillSlotStore(int n, ElementEventStore elementEventStore, ElementEventStore elementEventStore2) {
        for (EventInfo eventInfo : elementEventStore2.getAllObjects()) {
            if (eventInfo.getSlot() != n) continue;
            elementEventStore.storeEvent(eventInfo);
        }
    }

    private synchronized void fillShelfStore(int n, ElementEventStore elementEventStore, ElementEventStore elementEventStore2) {
        for (EventInfo eventInfo : elementEventStore2.getAllObjects()) {
            if (eventInfo.getShelfId() != n) continue;
            elementEventStore.storeEvent(eventInfo);
        }
    }

    private String getShelfStoreKey(int n) {
        return String.valueOf(n);
    }

    private String getShelfSlotStoreKey(int n, int n2) {
        return String.valueOf(n) + "-" + String.valueOf(n2);
    }

    private String getSlotStoreKey(int n) {
        return String.valueOf(n);
    }
}

