/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.model.INodeModel;
import cerent.cms.model.event.AbstractEventStore;
import cerent.cms.model.event.EventInfo;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.UObservable;
import cerent.util.matcher.AbstractMatcher;
import cerent.util.matcher.AndMatcher;
import cerent.util.matcher.BooleanFieldMatcher;
import cerent.util.matcher.LongFieldMatcher;
import cerent.util.matcher.NotMatcher;
import cerent.util.matcher.OrMatcher;
import cerent.util.matcher.StringFieldMatcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;

public class EventFilter
extends UObservable
implements Observer {
    public static final int ALARM_FILTER = 1;
    public static final int CONDITION_FILTER = 2;
    public static final int HISTORY_FILTER = 3;
    public static final String PREFS_ALARM_FILTER = "ALARM_FILTER";
    public static final String PREFS_CONDITION_FILTER = "CONDITION_FILTER";
    public static final String PREFS_HISTORY_FILTER = "HISTORY_FILTER";
    public static final String PREFS_TIME_FILTER_ENABLED = "TIME_FILTER_ENABLED";
    public static final String PREFS_IS_FILTER_ACTIVE = "IS_FILTER_ACTIVE";
    public static final String PREFS_IS_INITIAL_DEFAULT = "IS_INITIAL_DEFAULT";
    private INodeModel[] nodeModels = null;
    private AbstractEventStore eventStore = null;
    private ArrayList matcherList = new ArrayList();
    private long id = System.currentTimeMillis();
    private int type = -1;
    private boolean isEnabled = false;
    private boolean isActive = false;
    private String neType = "15600";
    private String name = "";
    private static SDebug db = new SDebug("EventFilter");
    protected static SeverityAccessor sevAccessor = new SeverityAccessor();
    protected static SAAccessor saAccessor = new SAAccessor();
    protected static TimeAccessor timeAccessor = new TimeAccessor();
    protected static ConditionAccessor condAccessor = new ConditionAccessor();

    public EventFilter(String string, AbstractEventStore abstractEventStore, int n) {
        this.name = string;
        this.eventStore = abstractEventStore;
        this.type = n;
        if (db.on()) {
            db.println("EventFilter:Name: " + this.name + "\tEventType: " + this.type);
        }
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
        Preferences.instance().setBoolean(this.getPreference(), PREFS_IS_FILTER_ACTIVE, bl);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setType(int n) {
        this.type = n;
        this.initializeFilter(this.getPreference());
    }

    public int getType() {
        return this.type;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public void setNodeModel(INodeModel[] iNodeModelArray) {
        this.nodeModels = iNodeModelArray;
    }

    public INodeModel[] getNodeModel() {
        return this.nodeModels;
    }

    public String getPreference() {
        if (this.type == 1) {
            return PREFS_ALARM_FILTER;
        }
        if (this.type == 2) {
            return PREFS_CONDITION_FILTER;
        }
        return PREFS_HISTORY_FILTER;
    }

    public AbstractEventStore getEventStore() {
        return this.eventStore;
    }

    public void update(Observable observable, Object object) {
    }

    public void addMatcher(AbstractMatcher abstractMatcher) {
        this.matcherList.add(abstractMatcher);
        this.setEnabled(this.matcherList.size() > 0);
    }

    public void removeMatcher(AbstractMatcher abstractMatcher) {
        this.matcherList.remove(abstractMatcher);
    }

    public void removeMatcher(int n) {
        if (n >= 0 && n <= this.matcherList.size()) {
            this.matcherList.remove(n);
        }
    }

    public void refreshCriteria() {
        block4: {
            if (db.on()) {
                db.println("EventFilter:refreshCriteria:BEGIN");
            }
            try {
                AbstractMatcher abstractMatcher = this.readSeverityFromPreferences();
                AbstractMatcher abstractMatcher2 = this.readTimeFromPreferences();
                AbstractMatcher abstractMatcher3 = this.readConditionFromPreferences();
                AbstractMatcher abstractMatcher4 = this.readSAFromPreferences();
                this.buildAndSetMatchers(abstractMatcher, abstractMatcher2, abstractMatcher3, abstractMatcher4);
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("EventFilter:refreshCriteria:Exception");
            }
        }
        if (db.on()) {
            db.println("EventFilter:refreshCriteria:END");
        }
    }

    public AbstractMatcher readSeverityFromPreferences() {
        AbstractMatcher abstractMatcher;
        block10: {
            if (db.on()) {
                db.println("EventFilter:readSeverityFromPreferences:BEGIN");
            }
            ArrayList<AbstractMatcher> arrayList = new ArrayList<AbstractMatcher>();
            abstractMatcher = null;
            try {
                Preferences preferences = Preferences.instance();
                String string = preferences.getProperty(this.getPreference(), "KEY_CR", null);
                String string2 = preferences.getProperty(this.getPreference(), "KEY_MJ", null);
                String string3 = preferences.getProperty(this.getPreference(), "KEY_MN", null);
                String string4 = preferences.getProperty(this.getPreference(), "KEY_NA", null);
                String string5 = preferences.getProperty(this.getPreference(), "KEY_NR", null);
                if (string != null && string.trim().equals("1")) {
                    arrayList.add(this.createSeverityMatcher(new Integer(4)));
                }
                if (string2 != null && string2.trim().equals("1")) {
                    arrayList.add(this.createSeverityMatcher(new Integer(3)));
                }
                if (string3 != null && string3.trim().equals("1")) {
                    arrayList.add(this.createSeverityMatcher(new Integer(2)));
                }
                if (string4 != null && string4.trim().equals("1")) {
                    arrayList.add(this.createSeverityMatcher(new Integer(1)));
                }
                if (string5 != null && string5.trim().equals("1")) {
                    arrayList.add(this.createSeverityMatcher(new Integer(0)));
                }
                if (arrayList.size() > 0) {
                    abstractMatcher = this.createOrMatcher(arrayList);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block10;
                db.println("EventFilter:readySeverityFromPreferences:Exception");
            }
        }
        if (db.on()) {
            db.println("EventFilter:readSeverityFromPreferences:END");
        }
        return abstractMatcher;
    }

    public AbstractMatcher readSAFromPreferences() {
        AbstractMatcher abstractMatcher;
        block9: {
            if (db.on()) {
                db.println("EventFilter:readSAFromPreferences:BEGIN");
            }
            ArrayList<AbstractMatcher> arrayList = new ArrayList<AbstractMatcher>();
            abstractMatcher = null;
            try {
                Preferences preferences = Preferences.instance();
                String string = preferences.getProperty(this.getPreference(), "KEY_SA", null);
                String string2 = preferences.getProperty(this.getPreference(), "KEY_NSA", null);
                if (string2 != null && string != null && string2.trim().equals("1") && string.trim().equals("1")) {
                    ArrayList arrayList2 = new ArrayList();
                    arrayList.add(this.createSAMatcher(true));
                    arrayList.add(this.createSAMatcher(false));
                    abstractMatcher = this.createOrMatcher(arrayList);
                } else if (string != null && string.trim().equals("1")) {
                    abstractMatcher = this.createSAMatcher(true);
                } else if (string2 != null && string2.trim().equals("1")) {
                    abstractMatcher = this.createSAMatcher(false);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block9;
                db.println("EventFilter:readySAFromPreferences:Exception");
            }
        }
        if (db.on()) {
            db.println("EventFilter:readSAFromPreferences:END");
        }
        return abstractMatcher;
    }

    public AbstractMatcher readConditionFromPreferences() {
        AbstractMatcher abstractMatcher;
        block5: {
            if (db.on()) {
                db.println("EventFilter:readConditionFromPreferences:END");
            }
            abstractMatcher = null;
            try {
                Preferences preferences = Preferences.instance();
                String[] stringArray = preferences.getPropertyArray(this.getPreference(), "KEY_SUPPRESS_COND", null);
                if (stringArray != null) {
                    abstractMatcher = this.createConditionMatcher(stringArray);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("EventFilter:readConditionFromPreferences:Exception");
            }
        }
        if (db.on()) {
            db.println("EventFilter:readConditionFromPreferences:END");
        }
        return abstractMatcher;
    }

    public AbstractMatcher readTimeFromPreferences() {
        AbstractMatcher abstractMatcher;
        block5: {
            if (db.on()) {
                db.println("EventFilter:readTimeFromPreferences:BEGIN");
            }
            abstractMatcher = null;
            try {
                Preferences preferences = Preferences.instance();
                boolean bl = preferences.getBoolean(this.getPreference(), PREFS_TIME_FILTER_ENABLED, false);
                if (bl) {
                    String string = preferences.getProperty(this.getPreference(), "KEY_FROM_MON", "");
                    String string2 = preferences.getProperty(this.getPreference(), "KEY_FROM_DAY", "");
                    String string3 = preferences.getProperty(this.getPreference(), "KEY_FROM_YEAR", "");
                    String string4 = preferences.getProperty(this.getPreference(), "KEY_FROM_HOUR", "");
                    String string5 = preferences.getProperty(this.getPreference(), "KEY_FROM_MIN", "");
                    String string6 = preferences.getProperty(this.getPreference(), "KEY_FROM_SEC", "");
                    String string7 = preferences.getProperty(this.getPreference(), "KEY_TO_MON", "");
                    String string8 = preferences.getProperty(this.getPreference(), "KEY_TO_DAY", "");
                    String string9 = preferences.getProperty(this.getPreference(), "KEY_TO_YEAR", "");
                    String string10 = preferences.getProperty(this.getPreference(), "KEY_TO_HOUR", "");
                    String string11 = preferences.getProperty(this.getPreference(), "KEY_TO_MIN", "");
                    String string12 = preferences.getProperty(this.getPreference(), "KEY_TO_SEC", "");
                    long l = EventFilter.convertStringDateToLong(string3, string, string2, string4, string5, string6);
                    long l2 = EventFilter.convertStringDateToLong(string9, string7, string8, string10, string11, string12);
                    abstractMatcher = this.createTimeMatcher(new Long(l), new Long(l2));
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("EventFilter:readTimeFromPreferences:Exception");
            }
        }
        if (db.on()) {
            db.println("EventFilter:readTimeFromPreferences:END");
        }
        return abstractMatcher;
    }

    public void setMatchers(ArrayList arrayList) {
        if (db.on()) {
            db.println("EventFilter:setMatchers:BEGIN: Number of matchers: " + arrayList.size());
        }
        this.matcherList.clear();
        this.matcherList = arrayList;
        boolean bl = Preferences.instance().getBoolean(this.getPreference(), PREFS_IS_FILTER_ACTIVE, true);
        this.setEnabled(true);
        this.setActive(bl);
        if (this.eventStore != null) {
            this.eventStore.flushFilteredData();
        }
        this.setChanged();
        this.notifyObservers(bl);
        if (db.on()) {
            db.println("EventFilter:setMatchers:END:notify client: " + bl);
        }
    }

    public AbstractMatcher getMatcherFor(int n) {
        return (AbstractMatcher)this.matcherList.get(n);
    }

    public ArrayList getMatchers() {
        return this.matcherList;
    }

    public ArrayList getConditions() {
        block9: {
            if (db.on()) {
                db.println("EventFilter:getConditions:BEGIN");
            }
            try {
                if (this.nodeModels != null) {
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    String string = "";
                    String string2 = "";
                    String string3 = "";
                    if (db.on()) {
                        db.println("EventFilter:getConditions: Number of nodes: " + this.nodeModels.length);
                    }
                    for (int i = 0; i < this.nodeModels.length; ++i) {
                        if (this.nodeModels[i] == null) continue;
                        if (!this.nodeModels[i].isInited()) {
                            if (!db.on()) continue;
                            db.println("EventFilter:getConditions: node " + this.nodeModels[i] + " is NOT inited, ignore");
                            continue;
                        }
                        string3 = this.nodeModels[i].getNeType();
                        string2 = CtcHttpRetriever.getSwVersion((String)this.nodeModels[i].getHostName());
                        string = string3 + string2;
                        if (arrayList3.contains(string)) {
                            if (!db.on()) continue;
                            db.println("EventFilter:getConditions: " + string + " already exist, ignore");
                            continue;
                        }
                        arrayList3.add(string);
                        arrayList = this.nodeModels[i].getAlarmConditionList();
                        this.trimDuplicateCondition(arrayList2, arrayList);
                    }
                    if (db.on()) {
                        db.println("EventFilter:getConditions:END: total conditions: " + arrayList2.size());
                    }
                    return arrayList2;
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block9;
                db.println("EventFilter:getConditions:Exception");
            }
        }
        return new ArrayList();
    }

    public int size() {
        return this.matcherList.size();
    }

    public AbstractMatcher createSAMatcher(boolean bl) {
        BooleanFieldMatcher booleanFieldMatcher;
        block2: {
            booleanFieldMatcher = null;
            try {
                booleanFieldMatcher = new BooleanFieldMatcher("getSrvAffecting", (BooleanFieldMatcher.IAccessor)saAccessor, null);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("EventFilter:createSAMatcher:Exception");
            }
        }
        return booleanFieldMatcher;
    }

    public AbstractMatcher createSeverityMatcher(Object object) {
        LongFieldMatcher longFieldMatcher;
        block2: {
            longFieldMatcher = null;
            try {
                longFieldMatcher = new LongFieldMatcher("", ((Integer)object).intValue(), (LongFieldMatcher.IAccessor)sevAccessor, null);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("EventFilter:createSeverityMatcher:Exception");
            }
        }
        return longFieldMatcher;
    }

    public AbstractMatcher createTimeMatcher(Object object, Object object2) {
        LongFieldMatcher longFieldMatcher;
        block2: {
            longFieldMatcher = null;
            try {
                long l = (Long)object;
                long l2 = (Long)object2;
                longFieldMatcher = new LongFieldMatcher("", l, l2, (LongFieldMatcher.IAccessor)timeAccessor, null);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("EventFilter:createTimeMatcher:Exception");
            }
        }
        return longFieldMatcher;
    }

    public AbstractMatcher createTimeMatcher(long l) {
        long l2 = System.currentTimeMillis();
        if (l2 < l) {
            throw new IllegalArgumentException("The duration was invalid.");
        }
        return this.createTimeMatcher(new Long(l), new Long(l2));
    }

    public AbstractMatcher createConditionMatcher(Object[] objectArray) {
        AbstractMatcher abstractMatcher;
        block4: {
            abstractMatcher = null;
            try {
                String string = "";
                int n = objectArray.length;
                ArrayList<AbstractMatcher> arrayList = new ArrayList<AbstractMatcher>();
                for (int i = 0; i < n; ++i) {
                    string = (String)objectArray[i];
                    arrayList.add(this.createConditionMatcher(string.trim()));
                }
                if (arrayList.size() > 0) {
                    abstractMatcher = this.createAndMatcher(arrayList);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("EventFilter:createConditionMatcher:Exception");
            }
        }
        return abstractMatcher;
    }

    public AbstractMatcher createConditionMatcher(Object object) {
        StringFieldMatcher stringFieldMatcher = new StringFieldMatcher("", (String)object, 1, true, (StringFieldMatcher.IAccessor)condAccessor, null);
        return new NotMatcher("", (AbstractMatcher)stringFieldMatcher);
    }

    public AbstractMatcher createOrMatcher(ArrayList arrayList) {
        OrMatcher orMatcher;
        block2: {
            orMatcher = null;
            try {
                orMatcher = new OrMatcher("", arrayList.toArray(new AbstractMatcher[arrayList.size()]));
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("EventFilter:createOrMatcher:Exception");
            }
        }
        return orMatcher;
    }

    public AbstractMatcher createAndMatcher(ArrayList arrayList) {
        AndMatcher andMatcher;
        block2: {
            andMatcher = null;
            try {
                andMatcher = new AndMatcher("", arrayList.toArray(new AbstractMatcher[arrayList.size()]));
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("EventFilter:createAndMatcher:Exception");
            }
        }
        return andMatcher;
    }

    public boolean doesMatch(EventInfo eventInfo) {
        if (eventInfo == null) {
            return false;
        }
        AbstractMatcher abstractMatcher = null;
        int n = 0;
        int n2 = this.matcherList.size();
        if (n < n2) {
            abstractMatcher = (AbstractMatcher)this.matcherList.get(n);
            return abstractMatcher.doesMatch((Object)eventInfo);
        }
        return false;
    }

    private void trimDuplicateCondition(ArrayList arrayList, ArrayList arrayList2) {
        block3: {
            try {
                String string = null;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    string = (String)arrayList2.get(i);
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("EventFilter:trimDuplicateCondition:Exception");
            }
        }
    }

    public void buildAndSetMatchers(AbstractMatcher abstractMatcher, AbstractMatcher abstractMatcher2, AbstractMatcher abstractMatcher3, AbstractMatcher abstractMatcher4) {
        if (db.on()) {
            db.println("EventFilter:buildAndSetMatchers:BEGIN");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (abstractMatcher != null) {
            arrayList.add(abstractMatcher);
        }
        if (abstractMatcher2 != null) {
            arrayList.add(abstractMatcher2);
        }
        if (abstractMatcher3 != null) {
            arrayList.add(abstractMatcher3);
        }
        if (abstractMatcher4 != null) {
            arrayList.add(abstractMatcher4);
        }
        ArrayList<Object> arrayList2 = null;
        if (arrayList.size() <= 1) {
            arrayList2 = arrayList;
        } else {
            arrayList2 = new ArrayList();
            arrayList2.add(new AndMatcher("", arrayList.toArray(new AbstractMatcher[arrayList.size()])));
        }
        this.setMatchers(arrayList2);
        if (db.on()) {
            db.println("EventFilter:buildAndSetMatchers:END");
        }
    }

    public void initializeFilter(String string) {
        boolean bl = Preferences.instance().getBoolean(string, PREFS_IS_INITIAL_DEFAULT, true);
        if (db.on()) {
            db.println("EventFilter:initializeFilter:key: " + string + "\tInitial: " + bl);
        }
        if (bl) {
            Preferences.instance().setProperty(string, "KEY_CR", "1");
            Preferences.instance().setProperty(string, "KEY_MJ", "1");
            Preferences.instance().setProperty(string, "KEY_MN", "1");
            if (this.getType() == 2) {
                Preferences.instance().setProperty(string, "KEY_NA", "1");
                Preferences.instance().setProperty(string, "KEY_NR", "1");
            }
            Preferences.instance().setBoolean(string, PREFS_IS_INITIAL_DEFAULT, false);
        }
    }

    public static long convertStringDateToLong(String string, String string2, String string3, String string4, String string5, String string6) {
        Calendar calendar;
        block9: {
            if (db.on()) {
                db.println("EventFilter:convertStringDateToLong: data \tyear: " + string + "\tmon: " + string2 + "\tday: " + string3 + "\thour: " + string4 + "\tmin: " + string5 + "\tsec: " + string6);
            }
            calendar = null;
            try {
                if (string.length() <= 2) {
                    string = "20" + string;
                }
                if (string2.length() < 2) {
                    string2 = "0" + string2;
                }
                if (string3.length() < 2) {
                    string3 = "0" + string3;
                }
                if (string4.length() < 2) {
                    string4 = "0" + string4;
                }
                if (string5.length() < 2) {
                    string5 = "0" + string5;
                }
                if (string6.length() < 2) {
                    string6 = "0" + string6;
                }
                calendar = new GregorianCalendar(Integer.parseInt(string), Integer.parseInt(string2) - 1, Integer.parseInt(string3), Integer.parseInt(string4), Integer.parseInt(string5), Integer.parseInt(string6));
            }
            catch (Exception exception) {
                if (!db.on()) break block9;
                db.println("EventFilter:convertStringDateToLong:Exception");
            }
        }
        return calendar.getTime().getTime();
    }

    public static boolean useNeTimeZone() {
        boolean bl = false;
        try {
            String string = Preferences.instance().getProperty("ctc", "useNeTimeZone", "");
            if (string.trim().equals("true") || string.trim().equals("1")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void dispose() {
        this.eventStore = null;
        this.matcherList.clear();
        if (this.nodeModels != null) {
            for (int i = 0; i < this.nodeModels.length; ++i) {
                this.nodeModels[i] = null;
            }
        }
    }

    protected static class ConditionAccessor
    implements StringFieldMatcher.IAccessor,
    Serializable {
        protected ConditionAccessor() {
        }

        public String getAttribute(Object object) {
            try {
                return ((EventInfo)object).getCondCode();
            }
            catch (Exception exception) {
                db;
                SDebug.printStackTrace((Throwable)exception);
                return "";
            }
        }
    }

    protected static class SAAccessor
    implements BooleanFieldMatcher.IAccessor,
    Serializable {
        protected SAAccessor() {
        }

        public boolean getAttribute(Object object) {
            boolean bl = false;
            try {
                bl = ((EventInfo)object).getSrvAffecting();
            }
            catch (Exception exception) {
                db;
                SDebug.printStackTrace((Throwable)exception);
            }
            return bl;
        }
    }

    protected static class SeverityAccessor
    implements LongFieldMatcher.IAccessor,
    Serializable {
        protected SeverityAccessor() {
        }

        public long getAttribute(Object object) {
            try {
                return ((EventInfo)object).getSeverity();
            }
            catch (Exception exception) {
                db;
                SDebug.printStackTrace((Throwable)exception);
                return -1L;
            }
        }
    }

    protected static class TimeAccessor
    implements LongFieldMatcher.IAccessor,
    Serializable {
        protected TimeAccessor() {
        }

        public long getAttribute(Object object) {
            if (EventFilter.useNeTimeZone()) {
                return this.getNeDate(((EventInfo)object).getNeDate());
            }
            return ((EventInfo)object).getTimeStamp();
        }

        private long getNeDate(String string) {
            long l = -1L;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "/");
                StringTokenizer stringTokenizer3 = new StringTokenizer(stringTokenizer.nextToken(), ":");
                String string2 = stringTokenizer2.nextToken();
                String string3 = stringTokenizer2.nextToken();
                String string4 = stringTokenizer2.nextToken();
                String string5 = stringTokenizer3.nextToken();
                String string6 = stringTokenizer3.nextToken();
                String string7 = stringTokenizer3.nextToken();
                l = EventFilter.convertStringDateToLong(string4, string2, string3, string5, string6, string7);
            }
            catch (Exception exception) {
                db;
                SDebug.printStackTrace((Throwable)exception);
            }
            return l;
        }
    }
}

