/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Ucp.sTnaAddr;
import cerent.cms.idl.UcpCircuits.sCircuitTermination;
import cerent.cms.idl.UcpCircuits.xNoSuchCircuitTermination;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.NoSuchCircuitTermination;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ucp.AbstractUcpCircuitModel;
import cerent.cms.model.ucp.ITnaAddr;
import cerent.cms.model.ucp.IUcpCircuitTerminationModel;
import cerent.cms.model.ucp.TnaAddrFactory;
import cerent.cms.model.ucp.UcpCircuitTerminations;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class UcpCircuitTerminationModel
extends AbstractUcpCircuitModel
implements IUcpCircuitTerminationModel {
    private int nindex;
    private DeleteTermination deleteTermination;
    private TerminationInfo terminationInfo;
    private CktId cktId;
    private UcpCircuitTerminations parent;
    private int termInterface;
    private sTnaAddr origTna;

    public UcpCircuitTerminationModel(NodeModelDelegate nodeModelDelegate, UcpCircuitTerminations ucpCircuitTerminations, sCircuitTermination sCircuitTermination2, SDebug sDebug) {
        super(nodeModelDelegate, sCircuitTermination2.objIndex, sCircuitTermination2.circuitId, sCircuitTermination2.cktSize, sCircuitTermination2.state, sCircuitTermination2.label, nodeModelDelegate.getChildDebug(UcpCircuitTerminationModel.class));
        this.nindex = this.index;
        this.parent = ucpCircuitTerminations;
        this.termInterface = sCircuitTermination2.termInterface;
        this.origTna = sCircuitTermination2.origTna;
        this.deleteTermination = new DeleteTermination(nodeModelDelegate, "UcpCircuitTerminationModel::deleteTermination");
        this.terminationInfo = new TerminationInfo(nodeModelDelegate, "UcpCircuitTerminationModel::terminationInfo");
        this.cktId = new CktId(nodeModelDelegate, "UcpCircuitTerminationModel::circuitId");
    }

    public int getTerminationInterface() {
        return this.termInterface;
    }

    public ITnaAddr getOriginTna() {
        return TnaAddrFactory.getITnaAddr(this.origTna);
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectUcpTermination;
    }

    protected void removeFromParent() {
        if (this.parent != null && this.node != null) {
            this.parent.remove(this);
        }
    }

    public void updateLocal() {
        sCircuitTermination sCircuitTermination2 = null;
        try {
            sCircuitTermination2 = (sCircuitTermination)this.terminationInfo.get();
            this.circuitId = sCircuitTermination2.circuitId;
            this.cktSize = sCircuitTermination2.cktSize;
            this.state = sCircuitTermination2.state;
            this.label = sCircuitTermination2.label;
            this.termInterface = sCircuitTermination2.termInterface;
            this.origTna = sCircuitTermination2.origTna;
        }
        catch (xNoSuchCircuitTermination xNoSuchCircuitTermination2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchCircuitTermination2));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        super.updateLocal();
    }

    public void delete() throws NoSuchCircuitTermination {
        try {
            Object[] objectArray = new Object[]{new Integer(this.index)};
            this.deleteTermination.set(objectArray);
            if (this.parent != null && this.node != null) {
                this.parent.remove(this);
            }
            this.dispose();
        }
        catch (xNoSuchCircuitTermination xNoSuchCircuitTermination2) {
            throw new NoSuchCircuitTermination(AnnotatedException.getString((Exception)((Object)xNoSuchCircuitTermination2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setCircuitId(ICircuitId iCircuitId) {
        try {
            Object[] objectArray = new Object[]{new Integer(this.index), CircuitIdFactory.getCircuitId(iCircuitId)};
            this.cktId.set(objectArray);
        }
        catch (xNoSuchCircuitTermination xNoSuchCircuitTermination2) {
            SDebug.printStackTrace((Throwable)((Object)xNoSuchCircuitTermination2));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    protected void printString(SDebug sDebug) {
        super.printString(sDebug);
        sDebug.println("nIndex: " + this.nindex + " termIf: " + this.termInterface);
        sDebug.print("OrigTna:: ");
        if (this.origTna.type.value() == 0) {
            sDebug.println("Type: IPV4 IpAddr: " + this.origTna.ipAddr.addr);
        } else if (this.origTna.type.value() == 1) {
            sDebug.println("Type: IPV6 IpAddr: " + this.origTna.ipAddr.addr);
        } else if (this.origTna.type.value() == 2) {
            sDebug.println("Type: NSAP NsapAddr: " + this.origTna.nsap.addr);
        } else {
            sDebug.println("Type: UNKNOWN");
        }
    }

    private class CktId
    extends NonCachedValue {
        public CktId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getUcpCircuitTerminationsRef().setCircuitId((Integer)objectArray[0], (sCircuitId)objectArray[1]);
        }

        public Object outer() {
            return UcpCircuitTerminationModel.this;
        }
    }

    private class DeleteTermination
    extends NonCachedValue {
        public DeleteTermination(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getUcpCircuitTerminationsRef().delete((Integer)objectArray[0]);
        }

        public Object outer() {
            return UcpCircuitTerminationModel.this;
        }
    }

    private class TerminationInfo
    extends NonCachedValue {
        public TerminationInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getUcpCircuitTerminationsRef().get(UcpCircuitTerminationModel.this.nindex);
        }

        public Object outer() {
            return UcpCircuitTerminationModel.this;
        }
    }
}

