/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmApcModels;
import cerent.cms.model.NoConditionsToRun;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NotSupportedRequest;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class APCCorrectionPane
extends AbstractPane
implements ActionListener {
    protected static final String APC_TB = "Force APC Correction";
    protected JButton apcButton;
    protected boolean inited = false;
    protected static final SDebug db = new SDebug("APCCorrectionPane");

    public APCCorrectionPane(String string, TabbedView tabbedView, OpticsModuleModel opticsModuleModel) {
        super(string, opticsModuleModel, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        this.init();
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        if (this.inited) {
            return;
        }
        this.inited = true;
        JPanel jPanel = APCCorrectionPane.createVerticalPanel(null);
        this.add(jPanel);
        jPanel.add(Box.createVerticalStrut(10));
        this.apcButton = new JButton(APC_TB);
        this.apcButton.addActionListener(this);
        this.apcButton.setDefaultCapable(false);
        this.apcButton.setAlignmentX(0.5f);
        jPanel.add(this.apcButton);
        this.enableComponent(this.apcButton, this.uiModel, SecurityLevel.SUPERUSER);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        jPanel2.add(jPanel);
        this.setLayout(new BorderLayout());
        this.add(jPanel2, "North");
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.MaintApcCorrectionPane);
        this.add(Box.createVerticalGlue(), "Center");
        this.add(cSHelpButtonPane, "South");
        if (db.on()) {
            db.println("init: finish");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block7: {
            int n;
            Object object = actionEvent.getSource();
            if (object == this.apcButton && (n = CerentDialog.questionDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (String)"Forcing an APC correction might cause traffic loss.\nCisco recommends that you contact Cisco technical support before you proceed.\nDo you want to continue?", (String)"APC Info", (int)0)) == 0) {
                try {
                    OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.getUiModel();
                    NodeModelDelegate nodeModelDelegate = opticsModuleModel.getNodeModelDelegate();
                    DwdmApcModels.getInstance(nodeModelDelegate).runAPCCorrSkipOverride(opticsModuleModel.getShelfId(), opticsModuleModel.getSlot());
                    CerentDialog.infoDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (String)"The APC Correction Skipped Override feature has been correctly launched.", (String)"APC Info");
                }
                catch (CannotPerform cannotPerform) {
                    CerentDialog.errorDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (String)ErrorMsg.getString((EID)EMC.EID_APC_CORRECTION_FAILS));
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)cannotPerform);
                    }
                }
                catch (NoConditionsToRun noConditionsToRun) {
                    CerentDialog.errorDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (String)ErrorMsg.getString((EID)EMC.EID_APC_CORRECTION_DISABLED));
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)noConditionsToRun);
                    }
                }
                catch (NotSupportedRequest notSupportedRequest) {
                    CerentDialog.errorDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this)), (String)ErrorMsg.getString((EID)EMC.EID_APC_CORRECTION_UNSUPPORTED));
                    if (!db.on()) break block7;
                    SDebug.printStackTrace((Throwable)notSupportedRequest);
                }
            }
        }
    }

    public void enteringPage() {
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() throws Exception {
    }
}

