/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.Attribute;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnsupportedCardOperMode;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractCardProvPane
extends NodeProvPane
implements ActionListener {
    protected static final String errMsg = "Card is in use";
    protected static final String warnMsg = "This action will reboot the card. Any unsaved configuration changes will be lost unless a write command is issued via CLI. Continue?";
    protected static final String warnTitle = "Card will reboot.";
    protected JComboBox modeCB = null;
    protected ModuleModel model = (ModuleModel)this.getParentView().getUiModel();

    public AbstractCardProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        JPanel jPanel = new JPanel(new FlowLayout(0, 10, 10));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(new JLabel("Mode: "));
        this.modeCB = new JComboBox<Attribute>(this.getModeChoices());
        Dimension dimension = new Dimension(100, 20);
        this.modeCB.setPreferredSize(dimension);
        this.modeCB.setMinimumSize(dimension);
        this.modeCB.setMaximumSize(dimension);
        this.modeCB.addActionListener(this);
        this.enableComponent(this.modeCB);
        jPanel.add(this.modeCB);
        this.add(jPanel);
    }

    protected abstract Attribute[] getModeChoices();

    public abstract CSHelpID getHelpID();

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            db.severe("Null actionPerformed source");
            return;
        }
        this.setDirty();
    }

    protected boolean changeMode() {
        boolean bl = true;
        if (this.model.getState() != eEqState.NOT_PRESENT) {
            bl = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)warnMsg, (String)warnTitle);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChangesToModel() throws Exception {
        eCardOperMode eCardOperMode2 = this.getCardModeFromCB();
        if (eCardOperMode2 != this.model.getCardOperMode()) {
            if (!this.changeMode()) {
                this.refresh();
                return;
            }
            try {
                this.model.setCardOperMode(eCardOperMode2);
            }
            catch (ResourceInUse resourceInUse) {
                db.fine("Resoure in use " + resourceInUse.toString());
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_BLOCKED_BY_CKTS_PARAM_1, (Object)errMsg);
                this.refresh();
            }
            catch (ProvisionError provisionError) {
                db.fine("ProvisionError " + provisionError.toString());
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_PROVISION_ERROR);
                this.refresh();
            }
            catch (UnsupportedCardOperMode unsupportedCardOperMode) {
                Object object = this.modeCB.getSelectedItem();
                db.fine("UnsupportedCardOperMode " + unsupportedCardOperMode.toString());
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNSUPPORTED_CARD_OPER_MODE_PARAM_1, (Object)object.toString());
                this.refresh();
            }
            catch (CTCUserException cTCUserException) {
                db.fine("CTCUserException " + cTCUserException.toString());
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_APPLY_CHANGES);
                this.refresh();
            }
            finally {
                this.setDirty(false);
            }
        }
    }

    protected Attribute[] getAttributeFor(String string) {
        return ElementDefaults.getAttributeMap(this.model).getAttributeArray(string);
    }

    protected Attribute getAttributeValFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.model).getAttributeForVal(string, n);
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.registerWithModel();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        this.unRegisterWithModel();
    }

    public void destroy() {
        this.unRegisterWithModel();
        super.destroy();
    }

    private void unRegisterWithModel() {
        this.model.deleteObserver((Observer)((Object)this));
    }

    private eCardOperMode getCardModeFromCB() {
        return eCardOperMode.from_int(((Attribute)this.modeCB.getSelectedItem()).getIntValue());
    }
}

