/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public abstract class AbstractPluginHolderPane
extends AbstractPane {
    private static final String PROP_PREF = "ctc.defaults";
    private static final String PROP_DIVIDER = ".divider";
    private PluginHolderCompListener compListener = new PluginHolderCompListener();
    protected Pane selectorPane;
    protected Pane pluginPane;
    private INodeModel.AbstractConnectionNotifier pluginNotifier;
    private String pluginDomainItem;
    private JSplitPane splitPane;
    private JPanel buttonPanel;
    private INodeModel nodeModel;
    private static final JPanel EMPTY_PANEL = new JPanel();
    private static final JPanel DISCONNECTED_PANEL = new JPanel(new BorderLayout());

    public AbstractPluginHolderPane(String string, TabbedView tabbedView, SDebug sDebug) {
        this(string, null, tabbedView, sDebug);
    }

    public AbstractPluginHolderPane(String string, SDebug sDebug) {
        this(string, null, null, sDebug);
    }

    public AbstractPluginHolderPane(String string, IModel iModel, TabbedView tabbedView, SDebug sDebug) {
        super(string, iModel, tabbedView);
        this.initializeLayout();
    }

    public void enteringPage() throws Exception {
        this.selectorPane.enteringPage();
    }

    public void leavingPage() throws Exception {
        this.selectorPane.leavingPage();
        if (this.pluginPane != null) {
            this.pluginPane.leavingPage();
        }
        int n = this.splitPane.getDividerLocation() * 100 / (this.splitPane.getWidth() - this.splitPane.getDividerSize()) + 1;
        Preferences.instance().setInt(PROP_PREF, this.makeDividerProp(), n);
        TablePropertyMgr.setColumnPrefs(this.table, ((Object)((Object)this)).getClass().getName());
    }

    public void destroy() {
        if (db.on()) {
            db.println("destroy");
        }
        this.selectorPane.destroy();
        super.destroy();
    }

    public void dispose() {
        if (db.on()) {
            db.println("dispose");
        }
        ((AbstractPane)this.selectorPane).dispose();
        if (this.pluginPane != null) {
            try {
                this.removePlugin();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ((AbstractPane)this.pluginPane).dispose();
        }
        super.dispose();
    }

    public void refresh() throws Exception {
        this.selectorPane.refresh();
    }

    public void setPluginPane(INodeModel iNodeModel, String string, Pane pane) throws Exception {
        this.removePlugin();
        this.nodeModel = iNodeModel;
        this.pluginDomainItem = string;
        this.pluginPane = pane;
        this.initPlugin();
    }

    public void setDisconnectedPane() throws Exception {
        this.removePlugin();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.pluginDomainItem));
        jPanel.add((Component)DISCONNECTED_PANEL, "Center");
        this.splitPane.setRightComponent(jPanel);
    }

    private void removePlugin() throws Exception {
        if (db.on()) {
            db.println("Removing plugin: " + (this.pluginPane == null ? "null" : this.pluginPane.getName()));
        }
        if (this.pluginPane != null) {
            this.pluginPane.setShowing(false);
            if (this.pluginNotifier != null) {
                this.pluginNotifier.deleteObserver((Observer)((Object)this));
            }
        }
    }

    private void initPlugin() throws Exception {
        if (db.on()) {
            db.println("Init'ing plugin: " + (this.pluginPane == null ? "null" : this.pluginPane.getName()));
        }
        if (this.pluginPane == null) {
            this.splitPane.setRightComponent(EMPTY_PANEL);
        } else {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(this.pluginDomainItem));
            jPanel.add((Component)this.pluginPane, "Center");
            this.splitPane.setRightComponent(jPanel);
            this.pluginPane.setShowing(true);
            this.pluginNotifier = this.getConnectionNotifier();
            if (this.pluginNotifier != null) {
                if (db.on()) {
                    db.println("Observing connection notifier");
                }
                this.pluginNotifier.addObserver((Observer)((Object)this));
            } else if (db.on()) {
                db.println("No connection notifier to observe");
            }
        }
    }

    private void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(1);
        this.selectorPane = this.getSelectorPane();
        this.splitPane.setLeftComponent((Component)this.selectorPane);
        this.splitPane.setRightComponent(EMPTY_PANEL);
        this.add(this.splitPane, "Center");
        this.addButtonPanel();
        this.splitPane.addComponentListener(this.compListener);
    }

    protected void addButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = this.getButtonPanel();
            this.add(this.buttonPanel, "South");
        }
    }

    private JPanel getButtonPanel() {
        CSHelpButtonPane cSHelpButtonPane = null;
        if (this.getHelpID() != null) {
            cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        }
        return cSHelpButtonPane;
    }

    public void addComponentToButtonPanel(Component component) {
        ((CSHelpButtonPane)this.buttonPanel).addLeft(component);
        this.buttonPanel.updateUI();
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Received update: ob = " + observable + ", arg = " + object);
        }
        if (observable instanceof INodeModel.AbstractConnectionNotifier) {
            if (this.nodeModel.getConnectionState()) {
                try {
                    this.setPluginPane(this.nodeModel, this.pluginDomainItem, this.pluginPane);
                }
                catch (Exception exception) {
                    KDebug.printStackTrace((Throwable)exception);
                }
            } else {
                try {
                    this.setDisconnectedPane();
                }
                catch (Exception exception) {
                    KDebug.printStackTrace((Throwable)exception);
                }
            }
        } else {
            super.update(observable, object);
        }
    }

    private String makeDividerProp() {
        return this.getName() + PROP_DIVIDER;
    }

    public abstract Pane getSelectorPane();

    public abstract INodeModel.AbstractConnectionNotifier getConnectionNotifier();

    static {
        DISCONNECTED_PANEL.add((Component)new JLabel("Node Disconnected"), "North");
    }

    class PluginHolderCompListener
    extends ComponentAdapter {
        PluginHolderCompListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            int n = Preferences.instance().getInt(AbstractPluginHolderPane.PROP_PREF, AbstractPluginHolderPane.this.makeDividerProp(), 0);
            if (n == 0) {
                AbstractPluginHolderPane.this.splitPane.setDividerLocation(-1);
            } else {
                AbstractPluginHolderPane.this.splitPane.setDividerLocation((double)n / 100.0);
            }
            AbstractPluginHolderPane.this.splitPane.removeComponentListener(this);
        }
    }
}

