/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class AbstractRetrievalPane
extends AbstractPane
implements ActionListener,
Runnable {
    private JLabel refreshL;
    private JButton refreshB;
    private String refreshLabelText;

    public AbstractRetrievalPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        this.setDefaultPrivilegeLevel(SecurityLevel.RETRIEVE);
    }

    protected JPanel createButtonPanel(JPanel jPanel) {
        return this.createButtonPanel(true, jPanel);
    }

    protected JPanel createButtonPanel(boolean bl, JPanel jPanel) {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        if (jPanel != null) {
            cSHelpButtonPane.addLeft(jPanel);
        }
        this.refreshB = new JButton("Refresh");
        this.refreshB.addActionListener(this);
        if (bl) {
            cSHelpButtonPane.addLeft(this.refreshB);
        }
        this.refreshL = new JLabel(" ");
        cSHelpButtonPane.addLeft(this.refreshL);
        return cSHelpButtonPane;
    }

    public void run() {
        this.refreshL.setText(this.refreshLabelText);
    }

    public void updateRefreshLabel() {
        this.refreshLabelText = "Refreshed: " + AbstractRetrievalPane.getFormattedDateTime(new Date());
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public abstract void refreshFromModel() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        try {
            this.setCursor(3);
            this.refreshFromModel();
            this.updateRefreshLabel();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH_PANE);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH_PANE);
        }
        finally {
            this.setCursor(0);
        }
    }

    protected void handleRefreshException(Exception exception) {
        db.severe("actionPerformed() : " + exception);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.refreshB)) {
            try {
                this.refresh();
            }
            catch (Exception exception) {
                this.handleRefreshException(exception);
            }
        }
    }

    public void enteringPage() throws Exception {
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.refresh();
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }
}

