/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.CardInventoryRowObject;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class CardInventoryColumnRenderer
extends AbstractColumnRenderer {
    public static final int PORT_NUM = 0;
    public static final int PROV_TYPE = 1;
    public static final int ACTUAL_TYPE = 2;
    public static final int HW_PART_NUM = 3;
    public static final int HW_REVISION = 4;
    public static final int SERIAL_NUM = 5;
    public static final int CLEI_CODE = 6;
    public static final int VENDOR_ID = 7;
    public static final int PRODUCT_ID = 8;
    public static final int VERSION_ID = 9;
    private static final String[] columnNames = new String[]{"Port", "Eqpt Type", "Actual Eqpt Type", "HW Part #", "HW Rev", "Serial #", "CLEI Code", "Vendor Id", "Product Id", "Version Id"};
    private static final int numColumns = columnNames.length;
    private static final int[] columnWidths = new int[]{75, 100, 100, 75, 50, 75, 65, 75, 75, 75};
    private JLabel label;
    private int mode;
    private static final EmptyBorder emptyBorder = new EmptyBorder(0, 5, 0, 2);
    private static final SDebug db = new SDebug("CardInventoryColumnRenderer");

    public CardInventoryColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(this.alignment);
        this.label.setOpaque(true);
        this.label.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.label.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
        this.label.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
        CardInventoryRowObject cardInventoryRowObject = (CardInventoryRowObject)object;
        if (cardInventoryRowObject == null) {
            this.label.setText("<null info>");
            return this.label;
        }
        String string = "???";
        switch (this.mode) {
            case 0: {
                string = cardInventoryRowObject.portNum;
                break;
            }
            case 1: {
                string = cardInventoryRowObject.eqType;
                break;
            }
            case 2: {
                string = cardInventoryRowObject.mfgData.name;
                break;
            }
            case 3: {
                string = cardInventoryRowObject.mfgData.partNumber;
                break;
            }
            case 4: {
                string = cardInventoryRowObject.mfgData.revision;
                break;
            }
            case 5: {
                string = cardInventoryRowObject.mfgData.serialNumber;
                break;
            }
            case 6: {
                string = cardInventoryRowObject.mfgData.cleiCode;
                break;
            }
            case 7: {
                string = cardInventoryRowObject.mfgData.applicationFileName;
                break;
            }
            case 8: {
                string = cardInventoryRowObject.mfgData.productId;
                break;
            }
            case 9: {
                string = cardInventoryRowObject.mfgData.versionId;
            }
        }
        if (this.isValidText(string)) {
            this.label.setText(string);
        } else {
            db.warning(columnNames[this.mode] + " text '" + string + "' not displayed.");
        }
        return this.label;
    }

    public static ColumnRenderer[] createColumnRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            columnRendererArray[i] = new CardInventoryColumnRenderer(i, columnNames[i], columnWidths[i], true, i == 0 ? 0 : 2);
        }
        return columnRendererArray;
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        CardInventoryRowObject cardInventoryRowObject = (CardInventoryRowObject)object;
        CardInventoryRowObject cardInventoryRowObject2 = (CardInventoryRowObject)object2;
        switch (n) {
            case 0: {
                n2 = ComparisonUtil.compare((Integer)CardInventoryColumnRenderer.getInteger(cardInventoryRowObject.portNum), (Integer)CardInventoryColumnRenderer.getInteger(cardInventoryRowObject2.portNum));
                break;
            }
            case 1: {
                n2 = cardInventoryRowObject.eqType.compareTo(cardInventoryRowObject2.eqType);
                break;
            }
            case 2: {
                n2 = cardInventoryRowObject.mfgData.name.compareTo(cardInventoryRowObject2.mfgData.name);
                break;
            }
            case 3: {
                n2 = cardInventoryRowObject.mfgData.partNumber.compareTo(cardInventoryRowObject2.mfgData.partNumber);
                break;
            }
            case 4: {
                n2 = cardInventoryRowObject.mfgData.revision.compareTo(cardInventoryRowObject2.mfgData.revision);
                break;
            }
            case 5: {
                n2 = cardInventoryRowObject.mfgData.serialNumber.compareTo(cardInventoryRowObject2.mfgData.serialNumber);
                break;
            }
            case 6: {
                n2 = cardInventoryRowObject.mfgData.cleiCode.compareTo(cardInventoryRowObject2.mfgData.cleiCode);
                break;
            }
            case 7: {
                n2 = cardInventoryRowObject.mfgData.applicationFileName.compareTo(cardInventoryRowObject2.mfgData.applicationFileName);
                break;
            }
            case 8: {
                n2 = cardInventoryRowObject.mfgData.productId.compareTo(cardInventoryRowObject2.mfgData.productId);
                break;
            }
            case 9: {
                n2 = cardInventoryRowObject.mfgData.versionId.compareTo(cardInventoryRowObject2.mfgData.versionId);
            }
        }
        return n2;
    }

    private static Integer getInteger(String string) {
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new Integer(0);
        }
    }

    private boolean isValidText(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isISOControl(c) || Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }
}

