/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.Ds3xmModuleModel;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.GfpLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.L2scPosLineModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.VitalStatsPane;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.helper.SlotHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.UObservable;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public class CardVitalStatsPane
extends VitalStatsPane
implements Observer {
    private ModuleModel moduleM;
    private NodeModelDelegate nodeModel;
    private String sideStr = null;
    private String cardName = null;
    private String nodeName = null;
    private String shelfName = null;
    private int slotNo;
    private PortModel[] portModels = null;
    private InterfaceModel[] lineModels = null;
    private EntityCellRenderer myPortRenderer;
    private TDMTerminology terms;
    private UObservable tvObs;
    private static final SDebug db = new SDebug("CardVitalStatsPane");

    public CardVitalStatsPane(ModuleModel moduleModel, UObservable uObservable) {
        super((IAlarmStore)null);
        this.moduleM = moduleModel;
        this.moduleM.addObserver(this);
        this.nodeModel = moduleModel.getNodeModelDelegate();
        this.terms = this.nodeModel.getTDMTerminology();
        this.nodeModel.addObserver(this);
        this.nodeName = this.nodeModel.getName();
        int n = moduleModel.getChassis().getShelfId();
        this.shelfName = Integer.toString(n);
        this.slotNo = moduleModel.getSlot();
        this.cardName = moduleModel instanceof DwdmModuleModel ? ((DwdmModuleModel)moduleModel).getEqLabel() : EntityModel.eqType2Name(this.terms, moduleModel.getEqType());
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.nodeModel.getElementAlarmStore();
        ElementAlarmStore elementAlarmStore2 = (ElementAlarmStore)elementAlarmStore.getCardAlarmStore(n, this.slotNo);
        this.setAlarmStore(elementAlarmStore2);
        this.myPortRenderer = new EntityCellRenderer();
        if (uObservable != null) {
            this.tvObs = uObservable;
            db.fine("Adding " + this + "as observer of " + this.tvObs);
            this.tvObs.addObserver((Observer)this);
        }
        this.populateInterfaces();
        this.refreshText();
    }

    private void refreshText() {
        block13: {
            this.nodeName = this.nodeModel.getName();
            String string = this.moduleM.getEqTypeName();
            if (this.moduleM.getEqType() == 263 || this.moduleM.getEqType() == 264) {
                string = this.moduleM.getEqLabel();
            }
            if (this.nodeModel.isMultishelf()) {
                this.shelfName = Integer.toString(this.moduleM.getChassis().getShelfId());
                this.setTitle(this.nodeName + " Shelf " + this.shelfName + ", Slot " + this.slotNo + " " + string);
            } else {
                this.setTitle(this.nodeName + " Slot " + this.slotNo + " " + string);
            }
            try {
                String string2;
                StringBuffer stringBuffer = new StringBuffer();
                if (!string.equals("")) {
                    stringBuffer.append("Eqpt: " + string + "\n");
                }
                if (!(string2 = this.getStateString()).equals("")) {
                    stringBuffer.append("Status: " + this.getProtectString() + string2 + "\n");
                }
                stringBuffer.append("Service State: " + this.moduleM.getServiceSt().toString(this.terms) + "\n");
                if (string.contains("WXC") || this.moduleM.getEqType() == 295) {
                    if (this.moduleM.getEqType() == 297) {
                        stringBuffer.append("Operational Mode: ");
                        stringBuffer.append(ElementDefaults.getAttributeMap(this.moduleM).getAttributeForVal("Wxc80CardMode", this.moduleM.getCardOperMode().value()));
                        stringBuffer.append("\n");
                    }
                    int n = ((OpticsModuleModel)this.moduleM).getOpticsLineModels()[0].getSide();
                    this.sideStr = new String("Side:" + DwdmSide.getSideFromOffset(n) + "\n");
                    stringBuffer.append(this.sideStr);
                }
                if (this.moduleM.getEqType() == 286) {
                    stringBuffer.append("Operational Mode: ");
                    stringBuffer.append(ElementDefaults.getAttributeMap(this.moduleM).getAttributeForVal("PsmCardMode", this.moduleM.getCardOperMode().value()));
                    stringBuffer.append("\n");
                }
                if (this.moduleM instanceof DwdmModuleModel) {
                    stringBuffer.append(this.getDwdmState());
                } else {
                    stringBuffer.append(this.getPortStateString());
                }
                this.setText(stringBuffer.toString());
            }
            catch (Exception exception) {
                db.println("Caught exception in refreshText()");
                if (!db.on()) break block13;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this.moduleM.getEqType() != 271 && this.moduleM.getEqType() != 272) {
            this.textArea.setCaretPosition(0);
        }
    }

    private boolean isOptical(InterfaceModel interfaceModel) {
        boolean bl = false;
        if (interfaceModel instanceof TdmLineModel) {
            IPortModel iPortModel;
            try {
                iPortModel = interfaceModel.getPortModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                iPortModel = null;
            }
            if (iPortModel instanceof TdmPortModel) {
                bl = ((TdmPortModel)iPortModel).isOptical();
            }
        }
        return bl;
    }

    private String getPortStateString() {
        StringBuffer stringBuffer;
        block12: {
            stringBuffer = new StringBuffer();
            int n = this.moduleM.getEqType();
            if (n == 145 && (((Ds3xmModuleModel)this.moduleM).isOneForNProtectModule() || ((Ds3xmModuleModel)this.moduleM).isOneForOneProtectModule())) {
                return stringBuffer.toString();
            }
            try {
                stringBuffer.append("\n");
                for (int i = 0; i < this.lineModels.length; ++i) {
                    if (this.lineModels[i] == null) {
                        db.fine("getPortStateString: Got a null InterfaceModel at " + i + ", port = " + this.portModels[i].toString());
                        continue;
                    }
                    if (n != 238) {
                        stringBuffer.append("Port " + PortHelper.getPortNumAndTypeString((IPortModel)this.lineModels[i].getPortModel(), (boolean)false, (boolean)true));
                        stringBuffer.append(this.getPortType(this.lineModels[i]));
                        stringBuffer.append(":" + this.terms.getTermForServiceState(this.lineModels[i].getPortModel().getServiceStateType()));
                    } else if (!(this.lineModels[i] instanceof L2scPosLineModel)) {
                        stringBuffer.append("Port " + PortHelper.getPortNumAndTypeString((IPortModel)this.lineModels[i].getPortModel(), (boolean)false, (boolean)true));
                        stringBuffer.append(this.getPortType(this.lineModels[i]));
                        stringBuffer.append(":" + this.terms.getTermForServiceState(this.lineModels[i].getPortModel().getServiceStateType()));
                    }
                    if (n != 248 && this.isOptical(this.lineModels[i])) {
                        TdmLineModel tdmLineModel = (TdmLineModel)this.lineModels[i];
                        switch (this.lineModels[i].getAdminState()) {
                            case 0: 
                            case 2: 
                            case 3: {
                                stringBuffer.append(this.myPortRenderer.getSonetLineProtectionDescription(tdmLineModel, false));
                                break;
                            }
                        }
                    }
                    stringBuffer.append("\n");
                }
            }
            catch (Exception exception) {
                db.println("Caught exception in getOCNPortStateString");
                if (!db.on()) break block12;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return stringBuffer.toString();
    }

    private void populateInterfaces() {
        PortModel[] portModelArray = this.moduleM.getPortModels();
        this.clearLineModels();
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>();
        ArrayList<InterfaceModel> arrayList2 = new ArrayList<InterfaceModel>();
        for (int i = 0; i < portModelArray.length; ++i) {
            InterfaceModel interfaceModel = null;
            try {
                interfaceModel = (InterfaceModel)portModelArray[i].getInterfaceModel();
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                continue;
            }
            if (interfaceModel == null) continue;
            arrayList.add(portModelArray[i]);
            arrayList2.add(interfaceModel);
            interfaceModel.addObserver(this);
        }
        this.portModels = arrayList.toArray(new PortModel[arrayList.size()]);
        this.lineModels = arrayList2.toArray(new InterfaceModel[arrayList2.size()]);
    }

    private String getDwdmState() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.getFramingType());
        stringBuffer.append(this.getTermMode());
        stringBuffer.append(this.getRegenPeerSlot());
        stringBuffer.append(this.getCardOperMode());
        stringBuffer.append(this.getDwdmPortStateString());
        return stringBuffer.toString();
    }

    private String getFramingType() {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = new StringBuffer("");
            if (this.moduleM.getEqType() == 120 || this.moduleM.getEqType() == 121) {
                try {
                    if (this.lineModels.length > 0 && this.moduleM instanceof DwdmModuleModel) {
                        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.moduleM;
                        DwdmTrkLineModel dwdmTrkLineModel = dwdmModuleModel.getFirstTrunkLine();
                        Attribute attribute = ElementDefaults.getAttributeMap(dwdmModuleModel).getAttributeForVal("declTXP25GFramingType", EntityCellRenderer.mapPayloadType(dwdmTrkLineModel.getDataRate()));
                        stringBuffer.append("Framing Type: ");
                        stringBuffer.append(attribute);
                        stringBuffer.append("\n");
                    }
                }
                catch (Exception exception) {
                    db.println("Caught exception in getFramingType");
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getTermMode() {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = new StringBuffer("");
            int n = this.moduleM.getEqType();
            if (n != 183 && n != 184 && n != 243 && n != 282 && n != 273 && n != 272 && n != 293 && n != 271) {
                try {
                    if (this.lineModels.length > 0 && this.moduleM instanceof DwdmModuleModel) {
                        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.moduleM;
                        stringBuffer.append("Term Mode: ");
                        stringBuffer.append(this.myPortRenderer.getTermMode(dwdmModuleModel.getFirstTrunkLine()));
                        stringBuffer.append("\n");
                    }
                }
                catch (Exception exception) {
                    db.println("Caught exception in getTermMode");
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String getRegenPeerSlot() {
        StringBuffer stringBuffer;
        block10: {
            stringBuffer = new StringBuffer("");
            int n = 0;
            try {
                int n2 = this.moduleM.getEqType();
                if (n2 == 273) {
                    n = ((DwdmModuleModel)this.moduleM).getAdmPeerGroupInfo().peerIndex;
                    if (n > 0) {
                        stringBuffer.append("ADM Group Peer Slot: " + SlotHelper.getSlotNumString((INodeModel)this.nodeModel, (int)n));
                        stringBuffer.append("\n");
                    }
                } else if (n2 != 183 && n2 != 184 && n2 != 243 && n2 != 282) {
                    IEntityModel iEntityModel = null;
                    for (int i = 0; i < this.lineModels.length; ++i) {
                        if (!(this.lineModels[i] instanceof DwdmTrkLineModel)) continue;
                        DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.lineModels[i];
                        iEntityModel = dwdmTrkLineModel.getRegenPeer();
                        break;
                    }
                    if (iEntityModel != null) {
                        stringBuffer.append("Regeneration Peer: ");
                        if (this.nodeModel.isMultishelf()) {
                            stringBuffer.append(iEntityModel.getShelfId() + "-" + iEntityModel.getSlot());
                        } else {
                            stringBuffer.append(iEntityModel.getSlot());
                        }
                        stringBuffer.append("\n");
                    }
                }
            }
            catch (Exception exception) {
                db.println("Caught exception in getRegenPeerSlot");
                if (!db.on()) break block10;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return stringBuffer.toString();
    }

    private String getCardOperMode() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.moduleM.getEqType();
        if (n == 183 || n == 184) {
            stringBuffer.append("Operational Mode: ");
            stringBuffer.append(ElementDefaults.getAttributeMap(this.moduleM).getAttributeForVal("mxpMr25GCardMode", this.moduleM.getCardOperMode().value()));
            stringBuffer.append("\n");
        } else if (n == 243 || n == 282) {
            stringBuffer.append("Operational Mode: ");
            stringBuffer.append(ElementDefaults.getAttributeMap(this.moduleM).getAttributeForVal("mxpMr10DMECardMode", this.moduleM.getCardOperMode().value()));
            stringBuffer.append("\n");
        } else if (this.moduleM.getEqType() == 272) {
            stringBuffer.append("Operational Mode: ");
            stringBuffer.append(ElementDefaults.getAttributeMap(this.moduleM).getAttributeForVal("XpCardMode", this.moduleM.getCardOperMode().value()));
            stringBuffer.append("\n");
        } else if (this.moduleM.getEqType() == 271) {
            stringBuffer.append("Operational Mode: ");
            stringBuffer.append(ElementDefaults.getAttributeMap(this.moduleM).getAttributeForVal("Xp10CardMode", this.moduleM.getCardOperMode().value()));
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String getDwdmPortStateString() {
        StringBuffer stringBuffer;
        block6: {
            stringBuffer = new StringBuffer();
            try {
                stringBuffer.append("\n");
                for (int i = 0; i < this.lineModels.length; ++i) {
                    InterfaceModel[] interfaceModelArray;
                    if (this.lineModels[i] instanceof DwdmCliLineModel || (interfaceModelArray = this.lineModels[i].getLowerLayerModels()) != null && interfaceModelArray.length > 0 && interfaceModelArray[0] instanceof DwdmTrkLineModel) continue;
                    stringBuffer.append("Port " + PortHelper.getPortNumAndTypeString((IPortModel)this.lineModels[i].getPortModel(), (boolean)false, (boolean)false));
                    stringBuffer.append(":" + this.lineModels[i].getServiceSt().toString(this.terms));
                    switch (this.lineModels[i].getAdminState()) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            stringBuffer.append(this.myPortRenderer.getDwdmLineProtectionDescription(this.lineModels[i], false));
                            break;
                        }
                    }
                    stringBuffer.append("\n");
                }
            }
            catch (Exception exception) {
                db.println("Caught exception in getDwdmPortStateString");
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return stringBuffer.toString();
    }

    private String getPortType(InterfaceModel interfaceModel) {
        TdmLineModel tdmLineModel;
        String string;
        if (this.isOptical(interfaceModel) && (string = this.myPortRenderer.getMediumTypeStr(tdmLineModel = (TdmLineModel)interfaceModel)).length() > 0) {
            return " (" + string + ")";
        }
        return "";
    }

    private String getStateString() {
        switch (this.moduleM.getEqType()) {
            case 9: 
            case 10: 
            case 11: 
            case 60: 
            case 85: 
            case 86: 
            case 87: 
            case 106: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 146: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 243: 
            case 251: 
            case 274: 
            case 275: 
            case 276: 
            case 282: {
                return ElementDefaults.eqStateToOCNString(this.moduleM.getState());
            }
        }
        return ElementDefaults.eqStateToString(this.moduleM.getState());
    }

    private String getProtectString() {
        String string = "";
        ProtectionGroupModel protectionGroupModel = this.moduleM.getProtectionGroupModel();
        if (protectionGroupModel != null) {
            IModuleModel iModuleModel = protectionGroupModel.getProtectModuleModel();
            string = iModuleModel == null ? "<unknown role>/" : (this.moduleM == iModuleModel ? "Protect/" : "Working/");
        }
        return string;
    }

    public void update(Observable observable, Object object) {
        db.fine("update from " + observable + "arg obj is " + object);
        if (object instanceof ModuleModelUpdate && ((ModuleModelUpdate)object).isLineModelUpdate() || object.equals(ModelUpdateType.DELETED) && observable instanceof GfpLineModel) {
            this.populateInterfaces();
            this.refreshText();
        } else if (object.equals(ModelUpdateType.CHANGED)) {
            this.refreshText();
        }
    }

    private void unregisterWithModels() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.lineModels.length; ++i) {
                if (this.lineModels[i] != null) {
                    this.lineModels[i].deleteObserver(this);
                    db.fine("unregisterWithModels: Deleting me as an observer for " + i + ", lineModels[" + i + "] = " + this.lineModels[i]);
                    continue;
                }
                db.fine("unregisterWithModels: lineModel at " + i + " is NULL");
            }
            this.lineModels = null;
        } else {
            db.fine("unregisterWithModels: lineModels array is null");
        }
    }

    public void dispose() {
        this.nodeModel.deleteObserver(this);
        this.moduleM.deleteObserver(this);
        this.clearLineModels();
        if (this.tvObs != null) {
            this.tvObs.deleteObserver((Observer)this);
        }
        this.myPortRenderer = null;
        super.dispose();
    }

    private void clearLineModels() {
        this.unregisterWithModels();
        this.portModels = null;
    }
}

