/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import java.text.NumberFormat;

public class ConvertPwrToDb {
    public static final int LASER_POWER = 0;
    public static final int LASER_BIAS = 1;
    public static final int LASER_TEMP = 2;
    public static final int XCVR_VOLT = 3;
    public static final String N_A = "N/A";
    public static final int UNDEFINED = -1000000;
    private static final double[][] convFactor = new double[][]{{-400.0, 10.0}, {0.0, 10.0}, {-25600.0, 256.0}, {0.0, 10.0}};

    public static String formatDecimalNumber(int n) {
        String string = new Integer(n).toString();
        int n2 = string.startsWith("-") ? 2 : 1;
        string = string.length() > n2 ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (n2 == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
        return string;
    }

    public static String convertPwrToDb(int n) {
        String string = N_A;
        if (n != -1000000) {
            string = ConvertPwrToDb.formatDecimalNumber(n);
        }
        return string;
    }

    public static String converPmValue(long l, int n) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(1);
        return numberFormat.format(((double)l + convFactor[n][0]) / convFactor[n][1]);
    }
}

