/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.DuplicatedPatchCord;
import cerent.cms.model.EndPointInUse;
import cerent.cms.model.EndPointIncompatible;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticalPatchCordModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WavelengthIncompatible;
import cerent.cms.model.WavelengthNotSupported;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.ans.AnsConnDataSource;
import cerent.cms.ui.intpatch.IntPatchCreateOperator;
import cerent.cms.ui.intpatch.IntPatchCreationInfo;
import cerent.cms.ui.intpatch.IntPatchcdCardPane;
import cerent.cms.ui.intpatch.IntPatchcdDestRevPane;
import cerent.cms.ui.intpatch.IntPatchcdDestinationPane;
import cerent.cms.ui.intpatch.IntPatchcdOCHAttrsPane;
import cerent.cms.ui.intpatch.IntPatchcdOTSAttrsPane;
import cerent.cms.ui.intpatch.IntPatchcdSourcePane;
import cerent.cms.ui.intpatch.IntPatchcdSourceRevPane;
import cerent.cms.ui.intpatch.IntPatchcdTypeSelPane;
import cerent.cms.ui.shelf.SppAnsIntPatchPane;
import cerent.util.AnnotatedException;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class IntPatchCreationDialog
extends WzDialog
implements WindowListener {
    private static final String TITLE = "Internal Patchcord Creation";
    public static final int VIGN_WIDTH = 200;
    public static final String WZPANE_IntPatch_TYPE = "Internal Patchcord Type Selection";
    public static final String WZPANE_IntPatch_OCH_ATTRS = "Internal Patchcord OCH Attributes";
    public static final String WZPANE_IntPatch_OTS_ATTRS = "Internal Patchcord OTS Attributes";
    public static final String WZPANE_IntPatch_SRC = "Internal Patchcord Origination";
    public static final String WZPANE_IntPatch_DST = "Internal Patchcord Termination";
    public static final String WZPANE_IntPatch_SRC_REV = "Internal Patchcord Origination Reverse";
    public static final String WZPANE_IntPatch_DST_REV = "Internal Patchcord Destination Reverse";
    public static final String WZPANE_IntPatch_CARD = "Internal Patchcord Card List";
    private IntPatchCreationInfo info;
    private IntPatchCreateOperator operator;
    public JPanel currPanel = this.mainPanel;
    private HandleAutoNext autoNext = null;

    public static IntPatchCreationDialog instance(SppAnsIntPatchPane sppAnsIntPatchPane, INodeModel iNodeModel, AnsConnDataSource ansConnDataSource, OpticalPatchCordModel opticalPatchCordModel) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)sppAnsIntPatchPane));
        return new IntPatchCreationDialog(frame, iNodeModel, ansConnDataSource, opticalPatchCordModel);
    }

    public IntPatchCreationDialog(Frame frame, INodeModel iNodeModel, AnsConnDataSource ansConnDataSource, OpticalPatchCordModel opticalPatchCordModel) {
        super(frame, TITLE, new WzDiagDebug("IntPatchCreationDialog"), true, true);
        int n = 700;
        int n2 = 450;
        this.setSize(new Dimension(n, n2));
        this.info = new IntPatchCreationInfo(iNodeModel);
        this.operator = new IntPatchCreateOperator(ansConnDataSource, opticalPatchCordModel);
        this.createPanesAndSetCurrent();
        this.setLocationRelativeTo(frame);
        this.createAutorun(true);
    }

    protected void createPanesAndSetCurrent() {
        this.wzPaneMap.put(WZPANE_IntPatch_TYPE, new IntPatchcdTypeSelPane(this, this.db, WZPANE_IntPatch_TYPE));
        this.wzPaneMap.put(WZPANE_IntPatch_OCH_ATTRS, new IntPatchcdOCHAttrsPane(this, this.db, WZPANE_IntPatch_OCH_ATTRS));
        this.wzPaneMap.put(WZPANE_IntPatch_OTS_ATTRS, new IntPatchcdOTSAttrsPane(this, this.db, WZPANE_IntPatch_OTS_ATTRS));
        this.wzPaneMap.put(WZPANE_IntPatch_SRC, new IntPatchcdSourcePane(this, this.db, WZPANE_IntPatch_SRC));
        this.wzPaneMap.put(WZPANE_IntPatch_DST, new IntPatchcdDestinationPane(this, this.db, WZPANE_IntPatch_DST));
        this.wzPaneMap.put(WZPANE_IntPatch_SRC_REV, new IntPatchcdSourceRevPane(this, this.db, WZPANE_IntPatch_SRC_REV));
        this.wzPaneMap.put(WZPANE_IntPatch_DST_REV, new IntPatchcdDestRevPane(this, this.db, WZPANE_IntPatch_DST_REV));
        this.wzPaneMap.put(WZPANE_IntPatch_CARD, new IntPatchcdCardPane(this, this.db, WZPANE_IntPatch_CARD));
        this.setCurrentPane(WZPANE_IntPatch_TYPE);
    }

    protected void apply() throws Exception {
        if (this.db.on()) {
            this.db.println("calling operator.createLinks");
        }
        if (this.info.getPatchType() != IntPatchCreationInfo.eIntPatchCordType.CARD2CARD) {
            this.operator.createPatchcord(this.getInfo());
        }
    }

    protected void handleCancel() {
        if (this.db.on()) {
            this.db.println("calling handleCancel");
        }
        if (this.info.getPatchType() == IntPatchCreationInfo.eIntPatchCordType.CARD2CARD) {
            try {
                this.operator.deletePatchcord(this.getInfo());
            }
            catch (Exception exception) {
                this.handleFinishException(exception);
            }
        }
    }

    public boolean handleFinishException(Exception exception) {
        String string = exception.getMessage();
        if (exception instanceof AnnotatedException) {
            exception = ((AnnotatedException)((Object)exception)).getChild();
        }
        if (this.db.on()) {
            this.db.println("handleFinishException - Got exception: " + exception.getMessage());
            SDebug.printStackTrace((Throwable)exception);
        }
        if (exception instanceof NoSuchInterface) {
            ErrorMsg.displayDetailed((Component)this, EMC.EID_NO_SUCHINTERFACE, exception.getMessage());
        } else if (exception instanceof ProvisionError) {
            ErrorMsg.displayDetailed((Component)this, EMC.EID_PROVISION_ERROR, exception.getMessage() + ". Unable to provision patchcord");
        } else if (exception instanceof FeatureUnsupported) {
            ErrorMsg.displayDetailed((Component)this, EMC.EID_UNSUPPORTED_OPERATION, exception.getMessage() + ". Provisionable patchcords are not supported on this node.");
        } else if (exception instanceof EndPointIncompatible) {
            ErrorMsg.displayDetailed((Component)this, EMC.EID_END_POINT_INCOMPATIBLE, "This could be because the endpoints do not match, or because the patchcord is being placed between OCH filters that are on the same DWDM side.");
        } else if (exception instanceof EndPointInUse) {
            ErrorMsg.displayDetailed((Component)this, EMC.EID_PORT_IS_IN_USE, exception.getMessage() + "." + "One of the endpoint is in use.");
        } else if (exception instanceof DuplicatedPatchCord) {
            ErrorMsg.displayDetailed((Component)this, EMC.EID_DUPLICATED_PATCHCORD, this.getPrettyMessage(string));
        } else if (exception instanceof WavelengthIncompatible) {
            ErrorMsg.displayDetailed((Component)this, EMC.EID_WAVELENGTH_INCOMPATIPLE, this.getPrettyMessage(string));
        } else if (exception instanceof WavelengthNotSupported) {
            ErrorMsg.displayDetailed((Component)this, EMC.WAVELENGTH_NOT_SUPPORTED, this.getPrettyMessage(string));
        } else {
            CerentDialog.errorDialog((Component)this, (String)string, (String)"Error");
        }
        return true;
    }

    public void setFinishEnabled(boolean bl) {
        this.setButtonsEnabled(!bl, bl);
        if (this.finishButton.isEnabled()) {
            this.finishButton.requestFocus();
        }
    }

    public void setNextEnabled(boolean bl) {
        if (!bl) {
            if (this.autoNext != null) {
                this.autoNext.destroy();
            }
            this.autoNext = null;
        }
        if (this.info.isAutorun() && !bl) {
            this.info.setAutorun(false);
            this.backButtonVisible(true);
            this.nextButtonVisible(true);
        }
        this.setButtonsEnabled(bl, !bl);
    }

    public IntPatchCreationInfo getInfo() {
        return this.info;
    }

    public IntPatchCreateOperator getOperator() {
        return this.operator;
    }

    private String getPrettyMessage(String string) {
        int n = string.lastIndexOf("\n");
        return n == -1 ? string : string.substring(0, n);
    }

    public void nextButtonAutoRun(IntPatchcdSourcePane intPatchcdSourcePane, boolean bl) {
        if (bl && this.info.isAutorun()) {
            this.nextButtonVisible(false);
            this.backButtonVisible(false);
            this.autoNext.trigger();
        } else {
            this.nextButtonVisible(true);
            this.backButtonVisible(true);
            this.nextButton.setEnabled(true);
        }
    }

    private void nextButtonVisible(boolean bl) {
        this.nextButton.setVisible(bl);
    }

    private void backButtonVisible(boolean bl) {
        this.backButton.setVisible(bl);
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.autoNext.destroy();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void createAutorun(boolean bl) {
        if (bl && this.autoNext == null) {
            this.autoNext = new HandleAutoNext();
        }
    }

    private class HandleAutoNext
    implements Runnable {
        private Thread thread = new Thread((Runnable)this, "Raman Auto Next Button");
        private boolean trigger;
        private boolean noExit;
        private boolean doClick;

        public HandleAutoNext() {
            this.thread.start();
        }

        public synchronized void trigger() {
            this.trigger = true;
        }

        public void run() {
            this.trigger = false;
            this.noExit = true;
            this.doClick = true;
            do {
                try {
                    Thread.sleep(1000L);
                    if (!this.trigger) continue;
                    this.trigger = false;
                    Thread.sleep(100L);
                    if (!this.doClick) continue;
                    IntPatchCreationDialog.this.nextButton.setEnabled(true);
                    IntPatchCreationDialog.this.nextButton.doClick(300);
                }
                catch (InterruptedException interruptedException) {
                    SDebug.printStackTrace((Throwable)interruptedException);
                }
            } while (this.noExit);
        }

        public void destroy() {
            this.doClick = true;
            this.noExit = false;
        }
    }
}

