/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IBlsrProvision;
import cerent.cms.model.ILoSquelchTblEntry;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.SquelchTableDialog;
import cerent.util.ILoNum;
import cerent.util.SonetLoNum;
import cerent.util.TDMTerminology;
import cerent.util.gui.TableModelAdapter;
import cerent.util.gui.TablePrintPane;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class LoSquelchTableDialog
extends TablePrintPane
implements ActionListener {
    public static final String CLOSE = "Close";
    private JButton closeButton;
    private DefaultTableModel tableModel;
    private INodeModel node;
    private TDMTerminology terms;

    public LoSquelchTableDialog(SquelchTableDialog squelchTableDialog, INodeModel iNodeModel, int n, IBlsrProvision iBlsrProvision, Map map, Map map2) {
        super("");
        this.terms = iNodeModel.getTDMTerminology();
        this.setTitle(this.terms.getGeneralTerms(1) + " Squelch Table: " + this.terms.getGeneralTerms(0) + " " + (n + 1) + ", " + iNodeModel.getName() + " (Ring " + iBlsrProvision.getRingName() + ", Node " + iBlsrProvision.getNodeId() + ")");
        this.node = iNodeModel;
        this.initContentPane(this.getContentPane(), map, map2);
        this.setSize(320, 400);
        this.setLocationRelativeTo(squelchTableDialog);
    }

    private void initContentPane(Container container, Map map, Map map2) {
        JPanel jPanel = new JPanel();
        this.tableModel = new LoSquelchTableModel(map, map2);
        UTable uTable = new UTable((TableModel)this.tableModel);
        this.setTable((JTable)uTable);
        this.setAdapter(new TableModelAdapter((TableModel)this.tableModel, (JTable)uTable));
        uTable.setCellSelectionEnabled(false);
        uTable.setAutoResizeMode(4);
        ((DefaultTableCellRenderer)uTable.getDefaultRenderer(JLabel.class)).setHorizontalAlignment(0);
        UScrollPane uScrollPane = new UScrollPane((Component)uTable);
        int n = 5;
        container.setLayout(new BorderLayout(n, n));
        ((JComponent)container).setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        container.add((Component)uScrollPane, "Center");
        container.add((Component)jPanel, "South");
    }

    public void dispose() {
        this.tableModel = null;
        super.dispose();
    }

    class LoSquelchTableModel
    extends DefaultTableModel {
        private Map westLoSquelchMap = null;
        private Map eastLoSquelchMap = null;
        private List keyList;
        private String[] columnNames;

        private void initColumnNames() {
            this.columnNames = new String[3];
            this.columnNames[0] = LoSquelchTableDialog.this.terms.getGeneralTerms(1);
            this.columnNames[1] = "West Source";
            this.columnNames[2] = "East Source";
        }

        public LoSquelchTableModel(Map map, Map map2) {
            this.initColumnNames();
            this.westLoSquelchMap = map;
            this.eastLoSquelchMap = map2;
            TreeSet treeSet = new TreeSet(map.keySet());
            treeSet.addAll(map2.keySet());
            this.keyList = new ArrayList(treeSet);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.keyList == null ? 0 : this.keyList.size();
        }

        public Object getValueAt(int n, int n2) {
            ILoNum iLoNum = (ILoNum)this.keyList.get(n);
            ILoSquelchTblEntry iLoSquelchTblEntry = (ILoSquelchTblEntry)this.westLoSquelchMap.get(iLoNum);
            ILoSquelchTblEntry iLoSquelchTblEntry2 = (ILoSquelchTblEntry)this.eastLoSquelchMap.get(iLoNum);
            switch (n2) {
                case 0: {
                    return this.getLoNumDisplayString(iLoNum);
                }
                case 1: {
                    if (iLoSquelchTblEntry == null) break;
                    return this.getNodeIdString(iLoSquelchTblEntry.getSourceNodes());
                }
                case 2: {
                    if (iLoSquelchTblEntry2 == null) break;
                    return this.getNodeIdString(iLoSquelchTblEntry2.getSourceNodes());
                }
            }
            return null;
        }

        private String getLoNumDisplayString(ILoNum iLoNum) {
            if (iLoNum instanceof SonetLoNum) {
                SonetLoNum sonetLoNum = (SonetLoNum)iLoNum;
                return sonetLoNum.getGroupNum() + "-" + sonetLoNum.getNumInGroup();
            }
            return null;
        }

        private String getNodeIdString(short[] sArray) {
            StringBuffer stringBuffer = new StringBuffer();
            if (sArray[0] != 255) {
                stringBuffer.append(sArray[0]);
            }
            for (int i = 1; i < sArray.length; ++i) {
                if (sArray[i] == 255) continue;
                stringBuffer.append(", " + sArray[i]);
            }
            return stringBuffer.toString();
        }
    }
}

