/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IChassisModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractInvalidViewException;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.DefaultViewControllerLayout;
import cerent.cms.ui.EleViewController;
import cerent.cms.ui.FunctionalViewButton;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.cms.ui.InvalidViewException;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.event.MultishelfEventPanelController;
import cerent.cms.ui.functional.FunctionalEditDialog;
import cerent.cms.ui.ms.MultishelfTabbedView;
import cerent.cms.ui.ms.MultishelfViewPanel;
import cerent.cms.ui.ms.NodeVitalStatsPane;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MultishelfViewController
extends EleViewController {
    private static final SDebug db = new SDebug("MSVC");

    public MultishelfViewController(IViewController iViewController, INodeModel iNodeModel, IUiToolkit iUiToolkit) {
        super(iViewController, new ViewName(iNodeModel.getNodeId()), iUiToolkit, db, (NodeModelDelegate)iNodeModel.getDelegate(), true);
        db.fine("<init> " + this.getViewName());
        this.nmd.addObserver(this);
        this.nmd.getNcChassis().addObserver(this);
        this.cn = this.nmd.getConnectionNotifier();
        this.cn.addObserver((Observer)this);
    }

    protected ViewName localGetSelectedView(ViewName viewName) {
        IShelfViewModel iShelfViewModel = ((MultishelfViewPanel)this.sv).getSelectedShelf();
        db.fine("localGetSelectedView destView is " + viewName + " (selected shelf is " + iShelfViewModel + ")");
        if (iShelfViewModel != null) {
            ViewName viewName2 = new ViewName(new int[]{this.nmd.getNodeId(), iShelfViewModel.getShelfId()});
            db.fine("\t\tReturning " + viewName2);
            return viewName2;
        }
        return null;
    }

    protected JPanel createPanel(ViewName viewName) throws AbstractInvalidViewException {
        db.fine("createPanel destView is " + viewName);
        try {
            this.sv = new MultishelfViewPanel(this, this.nmd, this.uiToolkit);
            if (this.stv == null) {
                this.stv = new MultishelfTabbedView(this.nmd, new MultishelfEventPanelController(this), (IGuestPaneFactory)this.uiToolkit);
                this.stv.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
            }
            this.nvsp = new NodeVitalStatsPane(this.nmd);
            JPanel jPanel = new JPanel();
            this.svcl = new DefaultViewControllerLayout(jPanel, "node");
            this.svcl.setComponents((JComponent)new UScrollPane((Component)this.sv), (JComponent)((Object)this.stv), this.nvsp, this.uiToolkit.getGuestPane(13));
            this.fvButton = FunctionalViewButton.getInstance((INodeModel)this.nmd);
            if (this.fvButton != null) {
                this.fvButton.initFvButton((ActionListener)((MultishelfViewPanel)this.sv));
                FunctionalEditDialog.storeButton(this.nmd.getNodeModel().getName(), this.fvButton);
            }
            return jPanel;
        }
        catch (Exception exception) {
            db.warning("createPanel failed: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            this.localFlushViewPanel(null);
            throw new InvalidViewException(exception.getMessage(), 1);
        }
    }

    public AbstractViewController createChildContainerVC(ViewName viewName) throws AbstractInvalidViewException {
        int n = viewName.getShelfId();
        db.fine("Creating SVC for shelf #" + n);
        if (!this.nmd.isInited()) {
            this.throwInvalidViewException("Node is not ready yet: " + viewName, 1);
        }
        try {
            IChassisModel iChassisModel = this.nmd.getChassisModelsInstance().getChassisByShelfId(n);
            if (iChassisModel != null) {
                return new ShelfViewController((IViewController)this, iChassisModel, this.uiToolkit, true);
            }
            this.throwInvalidViewException("Cannot find ChassisModel for: " + viewName + " shelf " + n, 2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.throwInvalidViewException("Invalid shelfId for: " + viewName, 2);
        }
        return null;
    }

    protected String getName() {
        String string;
        block2: {
            string = this.name;
            try {
                string = this.nmd.getName();
            }
            catch (Exception exception) {
                db.println("Caught exception in getName()");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public void execFv() {
        AbstractProvPane abstractProvPane = (AbstractProvPane)((MultishelfTabbedView)this.stv).getProvisioningTab();
        abstractProvPane.setCursor(3);
        this.fed = FunctionalEditDialog.instance((JPanel)((Object)abstractProvPane), this.nmd);
        if (this.fed != null) {
            this.fed.setVisible(true);
        }
        abstractProvPane.setCursor(0);
    }
}

