/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.EqTypeListCellRenderer;
import cerent.cms.ui.MutablePortsPane;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.IgnorableDialog;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MutablePortCreationDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Create Port";
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox portNumCB;
    private JComboBox portTypeCB;
    private IPortContainer[] containers;
    private static final SDebug db = new SDebug("MutablePortCreationDialog");
    private static final String IB_5G_TITLE = "IB 5G Warning";
    private static final String IB_5G_MESSAGE = " IBM Certification for IB 5G is pending.\n Please check the following URL.. \n http://www.redbooks.ibm.com/portals/systemz \n for the latest GDPS certification status.";

    public static MutablePortCreationDialog instance(MutablePortsPane mutablePortsPane, IPortContainer[] iPortContainerArray) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)mutablePortsPane));
        MutablePortCreationDialog mutablePortCreationDialog = (MutablePortCreationDialog)MutablePortCreationDialog.getRecycledDialog((Frame)frame, (String)TITLE, MutablePortCreationDialog.class, (Object)iPortContainerArray);
        if (mutablePortCreationDialog == null) {
            mutablePortCreationDialog = new MutablePortCreationDialog(frame, iPortContainerArray);
            mutablePortCreationDialog.setSize(275, 150);
        }
        return mutablePortCreationDialog;
    }

    private MutablePortCreationDialog(Frame frame, Object object) {
        super(frame, TITLE, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        Object[] objectArray = (Object[])object;
        this.containers = (IPortContainer[])objectArray;
        jPanel.add((Component)this.getCreatePanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.containers = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.applyChangesToModel();
            this.dispose();
        } else if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.portNumCB) {
            this.portTypeCB.setEnabled(false);
            this.portTypeCB.removeAllItems();
            PortId portId = (PortId)this.portNumCB.getSelectedItem();
            Iterator iterator = this.getPortTypeList(portId.getContainer(), portId.getPortPosInParent()).iterator();
            while (iterator.hasNext()) {
                this.portTypeCB.addItem(iterator.next());
            }
            if (this.portTypeCB.getItemCount() > 0) {
                this.portTypeCB.setEnabled(true);
            }
        }
    }

    private JPanel getCreatePanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.fillHorizontal();
        if (this.containers != null) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.containers.length; ++i) {
                arrayList.addAll(this.getAvailablePorts(this.containers[i]));
            }
            PortId[] portIdArray = arrayList.toArray(new PortId[arrayList.size()]);
            Arrays.sort(portIdArray, new PortIdComparator());
            this.portNumCB = new JComboBox<PortId>(portIdArray);
            PortId portId = (PortId)this.portNumCB.getSelectedItem();
            this.portTypeCB = this.getPortTypeCB(portId.getContainer(), portId.getPortPosInParent());
            this.portNumCB.addActionListener(this);
        }
        gridBagPanel.add("Port", 0, 0);
        gridBagPanel.add((Component)this.portNumCB, 1, 0);
        gridBagPanel.add("Port Type ", 0, 1);
        gridBagPanel.add((Component)this.portTypeCB, 1, 1);
        return gridBagPanel;
    }

    private JComboBox getPortTypeCB(IPortContainer iPortContainer, int n) {
        JComboBox jComboBox = null;
        ArrayList arrayList = this.getPortTypeList(iPortContainer, n);
        jComboBox = new JComboBox(arrayList.toArray((T[])new eEqType[arrayList.size()][2]));
        jComboBox.setRenderer(new EqTypeListCellRenderer((NodeModelDelegate)iPortContainer.getNodeModel()));
        jComboBox.setEnabled(arrayList.size() > 0);
        return jComboBox;
    }

    private ArrayList getPortTypeList(IPortContainer iPortContainer, int n) {
        ArrayList<eEqType[]> arrayList;
        block5: {
            eEqType eEqType2 = ((ModuleModel)iPortContainer.getModuleModel()).getEqTypeEnum();
            arrayList = new ArrayList<eEqType[]>();
            try {
                eEqType[] eEqTypeArray = iPortContainer.getPortTypeList(n);
                if (eEqTypeArray == null || eEqTypeArray.length == 0) {
                    arrayList.add(new eEqType[]{eEqType.INVALID, eEqType2});
                } else {
                    for (int i = 0; i < eEqTypeArray.length; ++i) {
                        arrayList.add(new eEqType[]{eEqTypeArray[i], eEqType2});
                    }
                }
            }
            catch (ProvisionError provisionError) {
                db.fine("Exception while calling getPortTypeList() : " + provisionError.getMessage());
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)provisionError);
            }
        }
        return arrayList;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private List getAvailablePorts(IPortContainer iPortContainer) {
        List list = iPortContainer.getAvailablePortNumbers();
        ArrayList<PortId> arrayList = new ArrayList<PortId>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iPortContainer instanceof PpmModel ? PluggableHelper.getHierarchyNumString(((PpmModel)iPortContainer).getHierarchyNums(), '-') + '-' : "";
            arrayList.add(new PortId(iPortContainer, string + iterator.next().toString()));
        }
        return arrayList;
    }

    private void applyChangesToModel() {
        Object object = this.portTypeCB.getSelectedItem();
        PortId portId = (PortId)this.portNumCB.getSelectedItem();
        IPortContainer iPortContainer = portId.getContainer();
        int n = portId.getPortPosInParent();
        db.fine("applyChangesToModel, FOUND port = " + n);
        EntityTableModel entityTableModel = ((NodeModelDelegate)iPortContainer.getNodeModel()).getEntityTableModel();
        eEqType[] eEqTypeArray = (eEqType[])object;
        if (eEqTypeArray[0].value() == 325) {
            IgnorableDialog.warningDialog((Component)((Object)this), (String)IB_5G_MESSAGE, (String)IB_5G_TITLE, (String)"", (String)"");
        }
        try {
            if (object == null || object instanceof eEqType) {
                if (object == null || ((eEqType)object).equals(eEqType.INVALID)) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_APPLY_CHANGES);
                } else {
                    entityTableModel.provisionPort(iPortContainer, n, (eEqType)object);
                }
            } else {
                eEqType[] eEqTypeArray2 = (eEqType[])object;
                entityTableModel.provisionPort(iPortContainer, n, eEqTypeArray2[0]);
            }
        }
        catch (ProvisionError provisionError) {
            EID eID = provisionError.getEID();
            if (eID != null) {
                ErrorMsg.displayError((Component)((Object)this), (EID)eID, (Object[])provisionError.getEIDParams());
            } else {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, provisionError.getPrettyMessage());
            }
        }
        catch (ResourceInUse resourceInUse) {
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, resourceInUse.toString());
        }
    }

    private class PortId {
        private IPortContainer _container;
        private String _portNum;

        public PortId(IPortContainer iPortContainer, String string) {
            this._container = iPortContainer;
            this._portNum = string;
        }

        public String getPortNum() {
            return this._portNum;
        }

        public IPortContainer getContainer() {
            return this._container;
        }

        public String toString() {
            return this._portNum;
        }

        public int getPortPosInParent() {
            int n = this._portNum.lastIndexOf(45) + 1;
            return Integer.parseInt(this._portNum.substring(n));
        }
    }

    public class PortIdComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = object.toString();
            String string2 = object2.toString();
            try {
                int n;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
                int n2 = stringTokenizer.countTokens();
                Integer[] integerArray = new Integer[n2];
                for (int i = 0; i < n2; ++i) {
                    integerArray[i] = Integer.valueOf(stringTokenizer.nextToken());
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
                n2 = stringTokenizer2.countTokens();
                Integer[] integerArray2 = new Integer[n2];
                for (n = 0; n < n2; ++n) {
                    integerArray2[n] = Integer.valueOf(stringTokenizer2.nextToken());
                }
                n = integerArray.length < integerArray2.length ? integerArray.length : integerArray2.length;
                for (int i = 0; i < n; ++i) {
                    if (integerArray[i].compareTo(integerArray2[i]) == 0) continue;
                    return integerArray[i].compareTo(integerArray2[i]);
                }
                return integerArray.length < integerArray2.length ? -1 : (integerArray.length == integerArray2.length ? 0 : 1);
            }
            catch (NumberFormatException numberFormatException) {
                return string.compareTo(string2);
            }
        }

        public boolean equals(Object object) {
            return object instanceof PortIdComparator;
        }
    }
}

