/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Optics.sOpticsAlmThresholds;
import cerent.cms.idl.Optics.sOpticsTCAThresholds;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RamanOpticsLineModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.table.AbstractTableModel;

public class OpticalThresholdTableModel
extends AbstractTableModel {
    public static final int LINENUMBER_INDEX = 0;
    public static final int POWER_HIGH_INDEX = 1;
    public static final int POWER_LOW_INDEX = 2;
    public static final int POWER_FAILURE_LOW_INDEX = 3;
    public static final int VOA_HIGH_INDEX = 4;
    public static final int VOA_LOW_INDEX = 5;
    public static final int POWER_DEGRADE_HIGH_INDEX = 6;
    public static final int POWER_DEGRADE_LOW_INDEX = 7;
    public static final int VOA_DEGRADE_HIGH_INDEX = 8;
    public static final int VOA_DEGRADE_LOW_INDEX = 9;
    public static final int VOA_FAILURE_LOW_INDEX = 10;
    public static final int OTM_MAX_COLUMNS = 11;
    public static final int VALUE_OUT_OF_RANGE = 3;
    public static final String[] otmColumnNames = new String[]{"Port", "opwrMax (dBm)", "opwrMin (dBm)", "Power Failure Low (dBm)", "VOA High (dBm)", "VOA Low (dBm)", "Power Degrade High (dBm)", "Power Degrade Low (dBm)", "VOA Degrade High (dB)", "VOA Degrade Low (dB)", "VOA Failure Low (dB)"};
    public static final String[] otmRamanColumnNames = new String[]{"Port", "opwrMax (dBm)", "opwrMin (dBm)", "Power Failure Low (mW)", "VOA High (dBm)", "VOA Low (dBm)", "Power Degrade High (mW)", "Power Degrade Low (mW)", "VOA Degrade High (dB)", "VOA Degrade Low (dB)", "VOA Failure Low (dB)"};
    protected int thresholdLayer;
    protected sOpticsTCAThresholds[] thresholdsVal;
    protected sOpticsAlmThresholds[] AlmThresholdsVal;
    protected boolean[][] Flg_FeatureUnsupported;
    protected int numChars = 0;
    private String[] PowerH;
    private String[] PowerL;
    private String[] PowerFailureL;
    protected boolean raman;
    protected int numLines;
    protected AbstractOpticsLineModel[] model;
    protected boolean[][] isDirty;
    protected boolean FlgOkDialog = false;
    protected boolean FlgAdminStateChanged = false;
    protected String[] portNames;
    protected NodeModelDelegate node;
    protected ModuleModel eqpmtModel;
    private static final SDebug db = new SDebug("OpticalThresholdTableModel");

    protected OpticalThresholdTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray, int n) {
        this.thresholdLayer = n;
        this.model = abstractOpticsLineModelArray;
        this.numLines = this.model.length;
        this.init();
    }

    private void init() {
        try {
            this.eqpmtModel = this.model[0].getModuleModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        this.node = this.model[0].getNodeModelDelegate();
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.Flg_FeatureUnsupported = new boolean[this.numLines][this.getColumnCount()];
        this.thresholdsVal = new sOpticsTCAThresholds[this.numLines];
        this.AlmThresholdsVal = new sOpticsAlmThresholds[this.numLines];
        this.PowerL = new String[this.numLines];
        this.PowerH = new String[this.numLines];
        this.PowerFailureL = new String[this.numLines];
        this.portNames = new String[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.thresholdsVal[i] = null;
            this.AlmThresholdsVal[i] = null;
            this.PowerH[i] = null;
            this.PowerL[i] = null;
            this.PowerFailureL[i] = null;
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.Flg_FeatureUnsupported[i][j] = false;
            }
            this.portNames[i] = null;
        }
        this.raman = this.model[0] instanceof RamanOpticsLineModel;
        this.resetDirtyBits();
    }

    public int getRowCount() {
        return this.numLines;
    }

    protected void resetDirtyBits() {
        this.FlgOkDialog = false;
        this.FlgAdminStateChanged = false;
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public int getColumnCount() {
        return otmColumnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        if (n2 == 2 || n2 == 1 || n2 == 3) {
            return !this.Flg_FeatureUnsupported[n][n2];
        }
        return false;
    }

    public String getColumnName(int n) {
        if (!this.raman) {
            return otmColumnNames[n];
        }
        return otmRamanColumnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescription(n);
                }
                case 1: {
                    return this.getPowerHigh(n);
                }
                case 2: {
                    return this.getPowerLow(n);
                }
                case 3: {
                    return this.getFailureLow(n);
                }
                case 6: {
                    return this.getPowerDegradeH(n);
                }
                case 7: {
                    return this.getPowerDegradeL(n);
                }
                case 8: {
                    return this.getVOADegradeH(n);
                }
                case 9: {
                    return this.getVOADegradeL(n);
                }
                case 10: {
                    return this.getVOAFailureL(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            db.severe("OpticalThresholdTableModel: error in getValueAt() " + exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        db.info("Change in value " + n + " " + n2);
        boolean bl = false;
        try {
            switch (n2) {
                case 1: {
                    String string = (String)object;
                    this.PowerH[n] = (String)object;
                    if (OpticalThresholdTableModel.isValidNumber(string, "Power High")) {
                        int n3 = OpticalThresholdTableModel.ValPerTen(string);
                        if (this.thresholdsVal[n] != null) {
                            this.thresholdsVal[n].opticalPowerPMTh.high = n3;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.PowerH[n] = null;
                    this.getPowerHigh(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                case 2: {
                    String string = (String)object;
                    this.PowerL[n] = (String)object;
                    if (OpticalThresholdTableModel.isValidNumber(string, "Power Low")) {
                        int n4 = OpticalThresholdTableModel.ValPerTen(string);
                        if (this.thresholdsVal[n] != null) {
                            this.thresholdsVal[n].opticalPowerPMTh.low = n4;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.PowerL[n] = null;
                    this.getPowerLow(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                case 3: {
                    String string = (String)object;
                    this.PowerFailureL[n] = (String)object;
                    if (OpticalThresholdTableModel.isValidNumber(string, "Power failure Low")) {
                        int n5 = this.raman ? Integer.parseInt(string) : OpticalThresholdTableModel.ValPerTen(string);
                        if (this.AlmThresholdsVal[n] != null) {
                            this.AlmThresholdsVal[n].opticalPowerAlmTh.fail.low = n5;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.PowerFailureL[n] = null;
                    this.getFailureLow(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            db.severe(classCastException.toString());
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    protected String getPortDescription(int n) throws AbstractCmsNoSuchEntityException {
        String string;
        try {
            IPortModel iPortModel = this.model[n].getPortModel();
            string = PortHelper.getPortNumString((IPortModel)iPortModel);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.info("Anticipated exception in getPortDescription: " + (Object)((Object)abstractCmsNoSuchEntityException));
            string = String.valueOf(n + 1);
        }
        return string + " (" + this.getType(n) + ")";
    }

    protected String getType(int n) {
        try {
            return this.model[n].getOptPortTypeString();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    protected String getPowerHigh(int n) {
        int n2 = -1000000;
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.PowerH[n] == null) {
            this.Flg_FeatureUnsupported[n][1] = true;
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_15_MIN, AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.ThType.HIGHIDX);
                        break;
                    }
                    case 1: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_DAY, AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.ThType.HIGHIDX);
                    }
                }
                if (n2 != -1000000) {
                    this.PowerH[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][1] = false;
                } else {
                    this.PowerH[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.PowerH[n] = "N/A";
            }
        }
        return this.PowerH[n];
    }

    protected String getPowerLow(int n) {
        int n2 = 0;
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.PowerL[n] == null) {
            this.Flg_FeatureUnsupported[n][2] = true;
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_15_MIN, AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.ThType.LOWIDX);
                        break;
                    }
                    case 1: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_DAY, AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.ThType.LOWIDX);
                    }
                }
                if (n2 != -1000000) {
                    this.PowerL[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][2] = false;
                } else {
                    this.PowerL[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.PowerL[n] = "N/A";
            }
        }
        return this.PowerL[n];
    }

    protected String getFailureLow(int n) {
        int n2 = -1000000;
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.PowerFailureL[n] == null) {
            this.Flg_FeatureUnsupported[n][3] = true;
            try {
                n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.LevelType.FAIL, AbstractOpticsLineModel.ThType.LOWIDX);
                if (n2 != -1000000) {
                    if (this.raman) {
                        this.PowerFailureL[n] = String.valueOf(n2);
                    } else {
                        this.PowerFailureL[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                        this.Flg_FeatureUnsupported[n][3] = false;
                    }
                } else {
                    this.PowerFailureL[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.PowerFailureL[n] = "N/A";
            }
        }
        return this.PowerFailureL[n];
    }

    private String getPowerDegradeH(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.HIGHIDX);
            if (this.raman) {
                string = String.valueOf(n2);
            } else if (n2 != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getPowerDegradeL(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.LOWIDX);
            if (this.raman) {
                string = String.valueOf(n2);
            } else if (n2 != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getVOADegradeH(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.VOA, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.HIGHIDX);
            if (n2 != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getVOADegradeL(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.VOA, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.LOWIDX);
            if (n2 != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private String getVOAFailureL(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.VOA, AbstractOpticsLineModel.LevelType.FAIL, AbstractOpticsLineModel.ThType.LOWIDX);
            if (n2 != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    protected void refreshThresholds(int n) {
        if (this.thresholdsVal[n] == null) {
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_15_MIN);
                        break;
                    }
                    case 1: {
                        this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_DAY);
                    }
                }
                if (OpticalThresholdTableModel.db.on) {
                    db.println("---------------------------------------------------------");
                    db.info("Thresholds val got for line " + n);
                    this.dumpTCATh(this.thresholdsVal[n]);
                    db.println("---------------------------------------------------------");
                    db.println("");
                }
            }
            catch (Exception exception) {
                db.info("Anticipated exception in refreshThresholds, line " + n + ": " + exception);
            }
        }
    }

    protected void refreshAlarmThresholds(int n) {
        try {
            if (this.AlmThresholdsVal[n] == null) {
                this.AlmThresholdsVal[n] = this.model[n].getOpticsAlmThresholds();
                if (db.on()) {
                    db.println("---------------------------------------------------------");
                    db.println("Requested AlmThVal for line " + n);
                    this.dumpAlmThresholdVal(this.AlmThresholdsVal[n]);
                    db.println("---------------------------------------------------------");
                    db.println("");
                }
            }
            this.refreshAdditionalAlarmTh(n);
        }
        catch (Exception exception) {
            db.info("Anticipated Exception in refreshAlarmThresholds, line " + n + ": " + exception);
        }
    }

    private void dumpAlmThresholdVal(sOpticsAlmThresholds sOpticsAlmThresholds2) {
        db.println("Index " + Integer.toHexString(sOpticsAlmThresholds2.ifIndex));
        db.println("opticalPowerAlmTh.degrade.low " + Integer.toString(sOpticsAlmThresholds2.opticalPowerAlmTh.degrade.low));
        db.println("opticalPowerAlmTh.degrade.high " + Integer.toString(sOpticsAlmThresholds2.opticalPowerAlmTh.degrade.high));
        db.println("opticalPowerAlmTh.fail.low " + Integer.toString(sOpticsAlmThresholds2.opticalPowerAlmTh.fail.low));
        db.println("opticalPowerAlmTh.fail.high " + Integer.toString(sOpticsAlmThresholds2.opticalPowerAlmTh.fail.high));
        db.println("oscPowerAlmTh.degrade.low  " + Integer.toString(sOpticsAlmThresholds2.oscPowerAlmTh.degrade.low));
        db.println("oscPowerAlmTh.degrade.high " + Integer.toString(sOpticsAlmThresholds2.oscPowerAlmTh.degrade.high));
        db.println("oscPowerAlmTh.fail.low " + Integer.toString(sOpticsAlmThresholds2.oscPowerAlmTh.fail.low));
        db.println("oscPowerAlmTh.fail.high " + Integer.toString(sOpticsAlmThresholds2.oscPowerAlmTh.fail.high));
        db.println("voaAlmTh.degrade.low " + Integer.toString(sOpticsAlmThresholds2.voaAlmTh.degrade.low));
        db.println("voaAlmTh.degrade.high " + Integer.toString(sOpticsAlmThresholds2.voaAlmTh.degrade.high));
        db.println("voaAlmTh.fail.low " + Integer.toString(sOpticsAlmThresholds2.voaAlmTh.fail.low));
        db.println("voaAlmTh.fail.high " + Integer.toString(sOpticsAlmThresholds2.voaAlmTh.fail.high));
        db.println("gainAlmTh.degrade.low " + Integer.toString(sOpticsAlmThresholds2.gainAlmTh.degrade.low));
        db.println("gainAlmTh.degrade.high " + Integer.toString(sOpticsAlmThresholds2.gainAlmTh.degrade.high));
        db.println("gainAlmTh.fail.low " + Integer.toString(sOpticsAlmThresholds2.gainAlmTh.fail.low));
        db.println("gainAlmTh.fail.high " + Integer.toString(sOpticsAlmThresholds2.gainAlmTh.fail.high));
    }

    private void dumpTCATh(sOpticsTCAThresholds sOpticsTCAThresholds2) {
        db.println("Index " + Integer.toHexString(sOpticsTCAThresholds2.ifIndex));
        db.println("oscPowerPMTh.low " + Integer.toString(sOpticsTCAThresholds2.oscPowerPMTh.low));
        db.println("oscPowerPMTh.high " + Integer.toString(sOpticsTCAThresholds2.oscPowerPMTh.high));
        db.println("opticalPowerPMTh.low " + Integer.toString(sOpticsTCAThresholds2.opticalPowerPMTh.low));
        db.println("opticalPowerPMTh.high " + Integer.toString(sOpticsTCAThresholds2.opticalPowerPMTh.high));
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) throws Exception, xFeatureUnsupported {
        if (n > this.numLines || n < 0) {
            db.severe("Invalid lineNo for refresh " + n);
            return;
        }
        this.resetLineCache(n);
        try {
            switch (this.thresholdLayer) {
                case 0: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_15_MIN);
                    if (!OpticalThresholdTableModel.db.on) break;
                    db.println("---------------------------------------------------------");
                    db.info("Thresholds val got for line " + n);
                    this.dumpTCATh(this.thresholdsVal[n]);
                    db.println("---------------------------------------------------------");
                    db.println("");
                    break;
                }
                case 1: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_DAY);
                    if (!OpticalThresholdTableModel.db.on) break;
                    db.println("---------------------------------------------------------");
                    db.info("Thresholds val got for line " + n);
                    this.dumpTCATh(this.thresholdsVal[n]);
                    db.println("---------------------------------------------------------");
                    db.println("");
                    break;
                }
                case 2: {
                    this.AlmThresholdsVal[n] = this.model[n].getOpticsAlmThresholds();
                    this.refreshAdditionalAlarmTh(n);
                    if (!db.on()) break;
                    db.println("---------------------------------------------------------");
                    db.println("Requested AlmThVal for line " + n);
                    this.dumpAlmThresholdVal(this.AlmThresholdsVal[n]);
                    db.println("---------------------------------------------------------");
                    db.println("");
                }
            }
        }
        catch (Exception exception) {
            db.info("Anticipated exception, line " + n + ": " + exception);
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        this.thresholdsVal[n] = null;
        this.AlmThresholdsVal[n] = null;
        this.PowerH[n] = null;
        this.PowerL[n] = null;
        this.PowerFailureL[n] = null;
        this.resetDirtyBits(n);
    }

    protected void resetDirtyBits(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void applyToModel() throws Exception {
        db.info("applyToModel");
        int n = 0;
        try {
            if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)"The selected operation could be service affecting. Is it OK to apply the changes anyway?", (String)"Confirmation Dialog")) {
                block9: for (n = 0; n < this.numLines; ++n) {
                    if (!this.isRowDirty(n)) continue;
                    switch (this.thresholdLayer) {
                        case 0: {
                            this.model[n].setOpticsTCAThresholds(this.thresholdsVal[n], eIntervalType.INTERVAL_15_MIN);
                            continue block9;
                        }
                        case 1: {
                            this.model[n].setOpticsTCAThresholds(this.thresholdsVal[n], eIntervalType.INTERVAL_DAY);
                            continue block9;
                        }
                        case 2: {
                            if ((this.model[n].getFeatures() & 0x10) == 16) {
                                this.applyAdditionalAlarmTh(n);
                                continue block9;
                            }
                            this.model[n].setOpticsAlmThresholds(this.AlmThresholdsVal[n]);
                        }
                    }
                }
            }
            this.resetDirtyBits();
        }
        catch (ProvisionError provisionError) {
            this.displayError(provisionError);
            this.refreshFromModel();
            this.refreshFromModel();
        }
        catch (ConfigError configError) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            this.refreshFromModel();
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_WRONG_INPUT);
            this.refreshFromModel();
        }
    }

    protected Frame getFrame() {
        return this.node.getUiToolkit().getApplicationFrame();
    }

    protected boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    protected boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    protected void refreshAdditionalAlarmTh(int n) {
    }

    protected void applyAdditionalAlarmTh(int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError, ConfigError {
    }

    public static boolean isValidNumber(String string, String string2) {
        try {
            Float.valueOf(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            db.println(string2);
            SDebug.printStackTrace((Throwable)numberFormatException);
            return false;
        }
    }

    public static int ValPerTen(String string) {
        float f = Float.parseFloat(string);
        int n = (int)(f *= 10.0f);
        return n;
    }

    protected boolean isUserAuthorized(SecurityLevel securityLevel) {
        return this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], securityLevel);
    }

    private void displayError(ProvisionError provisionError) {
        int n = provisionError.getDiscriminator();
        switch (n) {
            case 3: {
                ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "Power Failure Low", ConvertPwrToDb.formatDecimalNumber(provisionError.getLoValue()), ConvertPwrToDb.formatDecimalNumber(provisionError.getHiValue()));
                break;
            }
            case 4: {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_POWER_FAILURE_LOW_VALUE);
                break;
            }
            case 0: {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_POWER_FAILURE_LOW_TH);
                break;
            }
            case 5: {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_POWER_FAILURE_LOW_TCA);
                break;
            }
            default: {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_GENERIC_PROV_ERROR);
            }
        }
    }
}

