/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.IPlatform;
import cerent.cms.idl.Common.sTime;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.Operation;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPmPane;
import cerent.cms.ui.AbstractPmTableModel;
import cerent.cms.ui.ClearStatsDialog;
import cerent.cms.ui.ElementPmCellRenderer;
import cerent.cms.ui.OpticsElementPmCellRenderer;
import cerent.cms.ui.PmCellRenderer;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UComboBox;
import cerent.util.gui.WindowHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class PmPane
extends AbstractPmPane
implements TableModelListener,
ActionListener {
    protected boolean nearEnd;
    protected NodeModelDelegate nodeModel;
    public static final String CLEAR = "Clear...";
    protected JRadioButton farRB;
    protected JRadioButton nearRB;
    private ArrayList choiceCB = new ArrayList(10);
    private ArrayList selectedItems = new ArrayList(10);
    private int slot;
    private boolean BaroloCard = false;
    private boolean XpdCard = false;
    private SecurityModel secModel;
    private Observer pmClearObserver;
    protected IPlatform pci;
    private int dayPmColumns;
    private int selectedIndex = 0;
    private String cachedAllPortsClearStatsPrompt = null;
    protected static final SDebug db = new SDebug("PmPane");

    public PmPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    protected void init() {
        super.init();
        this.nearEnd = true;
        if (this.model != null) {
            ((PmTableModel)this.model).setNearEnd(true);
        }
        this.zeroPB.setText(CLEAR);
        this.secModel = (SecurityModel)this.nodeModel.getSecurityModel();
        this.pmClearObserver = new Observer(){

            public void update(Observable observable, Object object) {
                PmPane.this.enableZeroPB();
            }
        };
        this.enableZeroPB();
        this.slot = ((ModuleModel)this.getUiModel()).getSlot();
        if (this.getParentView().getUiModel() instanceof OpticsModuleModel) {
            this.BaroloCard = true;
        }
        if (this.getParentView().getUiModel() instanceof DwdmModuleModel) {
            this.XpdCard = true;
        }
    }

    public void localActionPerformed(ActionEvent actionEvent) {
        block4: {
            Object object;
            block5: {
                block3: {
                    if (db.on()) {
                        db.println("actionPerformed " + actionEvent);
                    }
                    if ((object = actionEvent.getSource()) != this.farRB) break block3;
                    if (!this.nearEnd) break block4;
                    this.nearEnd = false;
                    ((PmTableModel)this.model).setNearEnd(false);
                    break block4;
                }
                if (object != this.nearRB) break block5;
                if (this.nearEnd) break block4;
                this.nearEnd = true;
                ((PmTableModel)this.model).setNearEnd(true);
                break block4;
            }
            for (int i = 0; i < this.getComponentLayerCount(); ++i) {
                if (object != this.getComponentForLayer(i)) continue;
                db.info("SetupControlBar for=" + object);
                this.model.tossData();
                this.reDraw();
                this.setupControlBar(i, ((JComboBox)object).getSelectedIndex());
                if (i == 0) {
                    this.selectedIndex = ((JComboBox)object).getSelectedIndex();
                }
                this.updateTimeLabel();
                break;
            }
        }
    }

    private PortModel getPortModel(InterfaceModel interfaceModel) {
        PortModel portModel = null;
        try {
            portModel = (PortModel)interfaceModel.getPortModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            portModel = null;
        }
        return portModel;
    }

    protected String helpGetAllPortsClearStatsTitle(InterfaceModel[] interfaceModelArray, String string) {
        if (this.cachedAllPortsClearStatsPrompt == null) {
            if (interfaceModelArray != null && interfaceModelArray.length > 0) {
                try {
                    if (interfaceModelArray[0].getModuleModel().isComboModule()) {
                        this.cachedAllPortsClearStatsPrompt = string;
                    }
                }
                catch (Exception exception) {
                    db.severe(exception.toString());
                }
            } else {
                this.cachedAllPortsClearStatsPrompt = string == null ? "All statistics on card" : string;
            }
        }
        return this.cachedAllPortsClearStatsPrompt;
    }

    protected String getAllPortsClearStatsTitle() {
        return this.helpGetAllPortsClearStatsTitle(null, "All statistics on card");
    }

    protected void clearStats() {
        try {
            int[] nArray = null;
            InterfaceModel interfaceModel = (InterfaceModel)this.getSelectedItem(0);
            PortModel portModel = this.getPortModel(interfaceModel);
            if (portModel != null) {
                nArray = portModel.getPortNum();
            }
            if (nArray != null) {
                ClearStatsDialog clearStatsDialog = this.BaroloCard ? new ClearStatsDialog(this.uiToolkit.getApplicationFrame(), nArray, 5) : new ClearStatsDialog(this.uiToolkit.getApplicationFrame(), nArray, this.pci.is600() ? 4 : 3);
                clearStatsDialog.setAllPortRadioButtonTitle(this.getAllPortsClearStatsTitle());
                clearStatsDialog.setVisible(true);
                int n = clearStatsDialog.getChoice();
                if (0 != n) {
                    if (1 == n) {
                        this.maybeClearCurrentStats();
                    } else if (2 == n) {
                        this.maybeClearPortStats(interfaceModel);
                    } else if (3 == n) {
                        this.maybeClearCardStats();
                    } else if (4 == n) {
                        this.maybeClearParamStats();
                    }
                }
                clearStatsDialog.dispose();
            } else {
                db.println("ERROR: port number is null in PmPane.clearStats!\n       Clearing the PM stats will not work.");
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in clearStats.");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_CLEAR_STATS);
        }
    }

    protected PmCellRenderer getPmCellRenderer() {
        if (this.getParentView().getUiModel() instanceof OpticsModuleModel) {
            return new OpticsElementPmCellRenderer();
        }
        return new ElementPmCellRenderer();
    }

    private void maybeClearParamStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        int[] nArray = this.table2.getSelectedRows();
        if (nArray.length == 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SELECT_AT_LEAST_ONE_ROW);
        } else if (CerentDialog.yesNoDialog((Component)((Object)this), (String)"Proceeding will clear these statistics on the card\nand cannot be undone.  Do you really want to initialize\nall selected registers to zero?", (String)"Zero Data")) {
            ((PmTableModel)this.model).clearStatsForParam(nArray);
            ((PmTableModel)this.model).tossData();
            this.reDraw();
            this.updateTimeLabel();
        }
    }

    private void maybeClearPortStats(InterfaceModel interfaceModel) throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        String string = ((PmTableModel)this.model).getPortName(interfaceModel);
        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)("Proceeding will clear these statistics on the card\nand cannot be undone.  Do you really want to initialize\nall current near-end and far-end registers on port " + string + " to zero?"), (String)"Zero Data")) {
            ((PmTableModel)this.model).clearStatsForPort(interfaceModel);
            ((PmTableModel)this.model).tossData();
            this.reDraw();
            this.updateTimeLabel();
        }
    }

    private void maybeClearCardStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        String string = this.BaroloCard ? "panel" : "card";
        String string2 = "Proceeding will clear these statistics on the card\nand cannot be undone.  Do you really want to initialize\nall current registers on all ports on the " + string + " to zero?";
        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)string2, (String)"Zero Data")) {
            ((PmTableModel)this.model).clearStatsForCard();
            ((PmTableModel)this.model).tossData();
            this.reDraw();
            this.updateTimeLabel();
        }
    }

    private JComboBox addCB(String string) {
        if (db.on()) {
            db.println("addCB " + string);
        }
        UComboBox uComboBox = new UComboBox();
        uComboBox.setName(string);
        uComboBox.setPreferredSize(new Dimension(200, uComboBox.getHeight()));
        uComboBox.addActionListener(this);
        return uComboBox;
    }

    protected JPanel getEndIntervalBars() {
        JPanel jPanel;
        Dimension dimension;
        JPanel jPanel2;
        JPanel jPanel3 = PmPane.createHorizontalPanel(null);
        ButtonGroup buttonGroup = new ButtonGroup();
        if (((PmTableModel)this.model).isRMON()) {
            jPanel2 = PmPane.createHorizontalPanel(null);
            dimension = new Dimension(140, 77);
            jPanel = PmPane.createVerticalPanel(null);
            this.oneMinuteRB = new JRadioButton("1 min");
            buttonGroup.add(this.oneMinuteRB);
            this.oneMinuteRB.addActionListener(this);
            jPanel.add(this.oneMinuteRB);
            this.minuteRB = new JRadioButton("15 min", true);
            buttonGroup.add(this.minuteRB);
            this.minuteRB.addActionListener(this);
            jPanel.add(this.minuteRB);
            jPanel2.add(jPanel);
            JPanel jPanel4 = PmPane.createVerticalPanel(null);
            this.hourRB = new JRadioButton("1 hour");
            buttonGroup.add(this.hourRB);
            this.hourRB.addActionListener(this);
            jPanel4.add(this.hourRB);
            this.dayRB = new JRadioButton("1 day");
            buttonGroup.add(this.dayRB);
            this.dayRB.addActionListener(this);
            jPanel4.add(this.dayRB);
            jPanel2.add(jPanel4);
        } else {
            jPanel2 = PmPane.createVerticalPanel(null);
            dimension = new Dimension(90, 77);
            this.minuteRB = new JRadioButton("15 min", true);
            buttonGroup.add(this.minuteRB);
            this.minuteRB.addActionListener(this);
            jPanel2.add(this.minuteRB);
            this.dayRB = new JRadioButton("1 day");
            buttonGroup.add(this.dayRB);
            this.dayRB.addActionListener(this);
            jPanel2.add(this.dayRB);
        }
        jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
        jPanel2.setPreferredSize(dimension);
        jPanel = this.getEndBar();
        if (!((PmTableModel)this.model).isRMON() && jPanel != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(" Directions "));
            jPanel.setPreferredSize(new Dimension(90, 77));
            jPanel3.add(Box.createHorizontalStrut(4));
            jPanel3.add(jPanel);
        }
        jPanel3.add(jPanel2);
        return jPanel3;
    }

    protected JPanel getEndBar() {
        JPanel jPanel = PmPane.createVerticalPanel(null);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.nearRB = new JRadioButton("Near End", true);
        buttonGroup.add(this.nearRB);
        this.farRB = new JRadioButton("Far End");
        buttonGroup.add(this.farRB);
        this.nearRB.addActionListener(this);
        this.farRB.addActionListener(this);
        jPanel.add(this.nearRB);
        jPanel.add(this.farRB);
        return jPanel;
    }

    protected AbstractPmTableModel getDataModel() {
        this.nodeModel = ((ModuleModel)this.getUiModel()).getNodeModelDelegate();
        this.pci = this.nodeModel.getPlatform();
        this.dayPmColumns = this.nodeModel.getPlatform().dayPmTableColumns();
        return this.createDataModel();
    }

    protected abstract PmTableModel createDataModel();

    protected void setupControlBar(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PmPane.this.updateControlBar(n, n2);
            }
        });
    }

    private void updateControlBar(int n, int n2) {
        ((PmTableModel)this.model).setChoice(n, n2);
        boolean bl = ((PmTableModel)this.model).hasFarEnd();
        this.nearRB.setEnabled(bl);
        this.farRB.setEnabled(bl);
        if (!bl) {
            this.nearEnd = true;
        }
        ((PmTableModel)this.model).setNearEnd(this.nearEnd);
        ((PmTableModel)this.model).setIntervalType(this.interval);
        int n3 = this.indexOfFirstCB + n * 3;
        while (n < this.getComponentLayerCount()) {
            this.choiceCB.remove(n);
            for (int i = 0; i < 3; ++i) {
                this.controlBar.remove(n3);
            }
        }
        ArrayList arrayList = ((PmTableModel)this.model).getItemList(this.nodeModel, n, this.slot);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n4;
            PmTableModel.Item item = (PmTableModel.Item)arrayList.get(i);
            JComboBox jComboBox = this.addCB("choiceCB");
            if (item.layer == 0) {
                jComboBox.setRenderer(new PortCellRenderer());
            } else if (this.needofWlCellRenderer()) {
                jComboBox.setRenderer(new WavelCellRenderer());
            }
            int n5 = item.contents.size();
            String string = item.label;
            jComboBox.setModel(new DefaultComboBoxModel());
            for (n4 = 0; n4 < item.contents.size(); ++n4) {
                jComboBox.addItem(item.contents.get(n4));
            }
            jComboBox.setEnabled(n5 > 1);
            jComboBox.setSelectedIndex(n2);
            n4 = this.indexOfFirstCB + (i + n) * 3;
            this.controlBar.add(Box.createHorizontalStrut(4), n4++);
            this.controlBar.add((Component)new JLabel(string, 4), n4++);
            this.controlBar.add((Component)jComboBox, n4++);
            this.choiceCB.add(jComboBox);
            n2 = 0;
        }
        this.enableZeroPB();
        this.controlBar.revalidate();
    }

    protected boolean needofWlCellRenderer() {
        return false;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == -100) {
            if (PmPane.db.on) {
                db.println("Updating the table as things have changed");
            }
            this.setupControlBar(0, this.selectedIndex);
        }
    }

    protected void updateTimeLabel() {
        sTime sTime2;
        try {
            sTime2 = this.nodeModel.getTime();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            sTime2 = new sTime(0, 0, 0, 1, 1, 1970, false);
        }
        String string = (this.interval == 0 ? "15-minute, " : "1-day, ") + (this.nearEnd ? "near-end registers for " : "far-end registers for ");
        if (this.choiceCB != null) {
            for (int i = 0; i < this.getComponentLayerCount(); ++i) {
                this.selectedItems.add(this.getSelectedItem(i));
            }
            string = string + ((PmTableModel)this.model).getLabel(this.selectedItems);
            this.selectedItems.clear();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(sTime2.year, sTime2.month - 1, sTime2.day, sTime2.hour, sTime2.minute, sTime2.second);
        string = string + "at " + DateFormat.getDateTimeInstance(1, 1).format(gregorianCalendar.getTime());
        if (((PmTableModel)this.model).isFromPeerCard()) {
            string = string + " from active protect card";
        }
        this.dateLB.setText(string);
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.secModel.addObserver(this.pmClearObserver);
        this.setupControlBar(0, 0);
        this.selectedIndex = 0;
        this.updateTimeLabel();
    }

    public void leavingPage() throws Exception {
        this.secModel.deleteObserver(this.pmClearObserver);
        super.leavingPage();
    }

    private SecurityLevel getPmClearingLevel() {
        return this.secModel.getOperationPrivilege(Operation.CLEAR_PM);
    }

    protected JComboBox getComponentForLayer(int n) {
        if (n >= 0 && n < this.getComponentLayerCount()) {
            return (JComboBox)this.choiceCB.get(n);
        }
        return null;
    }

    protected int getComponentLayerCount() {
        return this.choiceCB.size();
    }

    protected Object getSelectedItem(int n) {
        return this.getComponentForLayer(n).getSelectedItem();
    }

    protected int getSelectedIndex(int n) {
        return this.getComponentForLayer(n).getSelectedIndex();
    }

    protected int getSaveColumnsIndex() {
        return this.dayPmColumns;
    }

    private void enableZeroPB() {
        if (this.getComponentLayerCount() > 0) {
            super.enableComponent(this.zeroPB, this.secModel, this.getPmClearingLevel());
        } else {
            WindowHelper.setEnabled((JComponent)this.zeroPB, (boolean)false);
        }
    }

    class PortCellRenderer
    extends DefaultListCellRenderer {
        PortCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = ((PmTableModel)PmPane.this.model).getPortName((InterfaceModel)object);
            Component component = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            return component;
        }
    }

    class WavelCellRenderer
    extends DefaultListCellRenderer {
        WavelCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = ((PmTableModel)PmPane.this.model).getPortName((InterfaceModel)object);
            Component component = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            return component;
        }
    }
}

