/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.idl.Ds123Media.sThresholds;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractValidatingTableModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.util.SDebug;

public abstract class PmThresholdsTableModel
extends AbstractValidatingTableModel
implements ResettablePmThresholdsTableModel {
    protected Ds123LineModel[] model;
    protected boolean[] rowDirty;
    protected eThresholdType thresholdType;
    protected boolean nearEnd;
    protected sThresholds[] thresholdsVal;
    protected int numLines;
    protected String[] columnNames;
    protected EntityCellRenderer myPortRenderer;
    protected int pmType;
    private static final SDebug db = new SDebug("PmThresholdsTableModel");

    public PmThresholdsTableModel(Ds123LineModel[] ds123LineModelArray, int n, eThresholdType eThresholdType2, boolean bl) {
        super(ds123LineModelArray == null || ds123LineModelArray.length == 0 ? null : ds123LineModelArray[0].getNodeModelDelegate(), db);
        this.model = ds123LineModelArray;
        this.pmType = n;
        this.thresholdType = eThresholdType2;
        this.nearEnd = bl;
        this.rowDirty = null;
        this.thresholdsVal = null;
        if (this.model == null) {
            if (db.on()) {
                db.println("Model null");
            }
            this.numLines = 0;
            return;
        }
        this.numLines = this.model.length;
        this.init();
        this.initColumnNames();
    }

    public PmThresholdsTableModel(Ds123LineModel[] ds123LineModelArray, eThresholdType eThresholdType2, boolean bl) {
        this(ds123LineModelArray, -1, eThresholdType2, bl);
    }

    private void init() {
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sThresholds[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
            this.thresholdsVal[i] = null;
        }
        this.myPortRenderer = new EntityCellRenderer(true);
    }

    protected abstract void initColumnNames();

    protected abstract sThresholds getPmThreshold(Ds123LineModel var1) throws NoSuchInterface, WrongInterfaceType;

    protected abstract void setPmThreshold(Ds123LineModel var1, sThresholds var2) throws Exception;

    public Class getColumnClass(int n) {
        return Integer.class;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public boolean resetToDefaultByLine() {
        return false;
    }

    public sThresholds getThresholdsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.thresholdsVal[n];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        }
        return false;
    }

    public int getNumberOfLines() {
        return this.model.length;
    }

    public void markRowDirty(int n) {
        this.rowDirty[n] = true;
    }

    public Object getThresholdNeDefault(NeDefaultsModel neDefaultsModel, int n) throws Exception {
        eEqType eEqType2 = this.model[n].getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.model[n].getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefPmThr(eEqType2, eEqType3, this.nearEnd, this.thresholdType);
    }

    public void setThresholdValue(int n, Object object) {
        if (object instanceof sThresholds) {
            this.thresholdsVal[n] = (sThresholds)object;
        }
    }

    protected void refreshPmThresholds(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.thresholdsVal[n] == null) {
            this.thresholdsVal[n] = this.getPmThreshold(this.model[n]);
        }
    }

    public void refreshLineFromModel(int n) {
        if (db.on()) {
            db.println("Refreshing line from model");
        }
        this.thresholdsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.thresholdsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        if (db.on()) {
            db.println("Row dirty for " + n + " is " + this.rowDirty[n]);
        }
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        if (db.on()) {
            db.println("resetting dirty bits");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    protected int getCv(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].cv;
    }

    protected int getEs(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].es;
    }

    protected int getSes(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].ses;
    }

    protected int getLoss(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].loss;
    }

    protected int getSas(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].sas;
    }

    protected int getAis(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].ais;
    }

    protected int getUas(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].uas;
    }

    protected int getBbe(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].bbe;
    }
}

