/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IRamanDayZeroOperation;
import cerent.cms.model.IRamanModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RamanModuleModel;
import cerent.cms.model.RamanOpticsLineModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.APCCorrectionPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ampli.RamanMaintenancePane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.omg.CORBA.UserException;

public class RamanAPCPane
extends APCCorrectionPane
implements IRamanDayZeroOperation {
    private static final String RAMAN_FIBER_CUT = "Restore from Fiber Cut";
    private JButton ramanApcButton;
    private RamanOpticsLineModel[] ramanLineModels;
    private RamanMaintenancePane ramanMaintenancePane;

    public RamanAPCPane(String string, TabbedView tabbedView, OpticsModuleModel opticsModuleModel, RamanMaintenancePane ramanMaintenancePane) {
        super(string, tabbedView, opticsModuleModel);
        this.ramanLineModels = (RamanOpticsLineModel[])((RamanModuleModel)opticsModuleModel).getOpticsRamanLineModels(true);
        this.ramanMaintenancePane = ramanMaintenancePane;
    }

    protected void init() {
        if (db.on()) {
            db.println("Raman Apc init: start");
        }
        if (this.inited) {
            return;
        }
        this.inited = true;
        JPanel jPanel = RamanAPCPane.createVerticalPanel(null);
        this.add(jPanel);
        jPanel.add(Box.createVerticalStrut(10));
        this.apcButton = new JButton("Force APC Correction");
        this.apcButton.addActionListener(this);
        this.apcButton.setDefaultCapable(false);
        this.apcButton.setAlignmentX(0.5f);
        jPanel.add(this.apcButton);
        jPanel.add(Box.createVerticalStrut(10));
        this.ramanApcButton = new JButton(RAMAN_FIBER_CUT);
        this.ramanApcButton.addActionListener(this);
        this.ramanApcButton.setDefaultCapable(false);
        this.ramanApcButton.setAlignmentX(0.5f);
        jPanel.add(this.ramanApcButton);
        this.enableComponent(this.apcButton, this.uiModel, SecurityLevel.SUPERUSER);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        jPanel2.add(jPanel);
        this.setLayout(new BorderLayout());
        this.add(jPanel2, "North");
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.MaintApcCorrectionPane);
        this.add(Box.createVerticalGlue(), "Center");
        this.add(cSHelpButtonPane, "South");
        if (db.on()) {
            db.println("Raman Apc init: finish");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object == this.ramanApcButton && CerentDialog.questionDialog((Component)((Object)this), (String)"The procedure could be traffic affect.\n Do you want to proceed?", (String)RAMAN_FIBER_CUT) != 1) {
            boolean bl = false;
            try {
                this.uiModel.getNodeModel().getRamanModels().restoreFiberCut(this.ramanLineModels[0].getIndex(), 0, (IRamanDayZeroOperation)this);
                bl = true;
                this.objectsEnable(false);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                KDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (FeatureUnsupported featureUnsupported) {
                KDebug.printStackTrace((Throwable)featureUnsupported);
            }
            catch (NoSuchInterface noSuchInterface) {
                KDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (UserException userException) {
                KDebug.printStackTrace((Throwable)userException);
            }
            catch (ProvisionError provisionError) {
                KDebug.printStackTrace((Throwable)provisionError);
            }
            if (!bl) {
                ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FIBER_CUT_RECOVER, (Object)"Raman");
            }
        }
    }

    public void objChanged(int n, String string) {
        if (n != 2) {
            ErrorMsg.displayError((Component)((Object)this), EMC.EID_RAMAN_FC_ERROR, IRamanModel.COMMAND_TYPE_ERR[n], string);
        } else {
            CerentDialog.infoDialog((Component)((Object)this), (String)("Restoration procedure succeded on " + this.uiModel.getNodeModel().getName()), (String)"Restore from fiber cut");
            ((NodeModelDelegate)this.uiModel.getNodeModel()).getSpanCheckModels().ramanChanges();
        }
        this.objectsEnable(true);
    }

    public void timeOut(String string) {
        ErrorMsg.displayError((Component)((Object)this), EMC.EID_RAMAN_FC_ERROR, "TimeOut ", string);
        this.objectsEnable(true);
    }

    private void objectsEnable(boolean bl) {
        this.ramanApcButton.setEnabled(bl);
        this.ramanMaintenancePane.installationPaneEnable(bl);
    }
}

