/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.ui.AinsCountDown;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import cerent.util.gui.SoakTimePropertyEditor;
import cerent.util.gui.TimePeriodPropertyEditor;
import javax.swing.table.AbstractTableModel;

public class SoakTableModel
extends AbstractTableModel {
    public String[] columnNames;
    public static final int LINENUMBER_INDEX = 0;
    public static final int SOAK_TIME_INDEX = 1;
    public static final int SOAK_COUNTDOWN_INDEX = 2;
    private String[] portNums;
    private int[] soakTime;
    private short[] soakCountdownTime;
    private InterfaceModel[] model;
    private int numLines;
    private static final short COUNTDOWN_REFRESH = -2;
    private static final short SOAK_REFRESH = -1;
    private static final String INTERFACE_NOT_FOUND = "N/A";
    private static final String BAD_SIGNAL = "Bad Signal";
    private EntityCellRenderer myPortRenderer;
    private static final SDebug db = new SDebug("SoakTableModel");

    public SoakTableModel(InterfaceModel[] interfaceModelArray, NodeModelDelegate nodeModelDelegate) {
        this.model = interfaceModelArray;
        this.myPortRenderer = new EntityCellRenderer(true);
        String[] stringArray = new String[]{"Port", "AINS Soak", "Time Until " + nodeModelDelegate.getTDMTerminology().getTermForAdminState(0)};
        this.columnNames = stringArray;
        this.init();
    }

    protected void init() {
        if (this.model == null) {
            if (db.on()) {
                db.println("Model equals null.");
            }
            this.numLines = 0;
        } else {
            this.numLines = this.model.length;
        }
        this.portNums = new String[this.numLines];
        this.soakTime = new int[this.numLines];
        this.soakCountdownTime = new short[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.soakTime[i] = -1;
            this.soakCountdownTime[i] = -2;
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortNum(n);
                }
                case 1: {
                    return this.getSoakTimeAsHHMM(n);
                }
                case 2: {
                    return this.getSoakCountdownTime(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Caught exception in getValueAt");
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    String getPortNum(int n) {
        if (this.portNums[n] == null) {
            try {
                IPortModel iPortModel = this.model[n] instanceof AbstractDwdmLineModel ? (((AbstractDwdmLineModel)this.model[n]).getPayloadModel() != null ? ((AbstractDwdmLineModel)this.model[n]).getPayloadModel().getPortModel() : this.model[n].getPortModel()) : this.model[n].getPortModel();
                this.portNums[n] = this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return this.portNums[n];
    }

    public String getSoakCountdownTime(int n) {
        try {
            if (!AinsCountDown.isAinsState(this.model[n].getAdminStateEnum())) {
                return "";
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            return INTERFACE_NOT_FOUND;
        }
        if (this.soakCountdownTime[n] == -2) {
            try {
                this.soakCountdownTime[n] = this.model[n].getSoakCountdownTime();
            }
            catch (NoSuchInterface noSuchInterface) {
                return INTERFACE_NOT_FOUND;
            }
            catch (UnsupportedOperation unsupportedOperation) {
                return "UNSUPPORTED_OPERATION";
            }
            catch (InvalidState invalidState) {
                return "";
            }
        }
        if (this.soakCountdownTime[n] == -1) {
            return BAD_SIGNAL;
        }
        return TimePeriodPropertyEditor.toStringHHMM(this.soakCountdownTime[n]);
    }

    private String getSoakTimeAsHHMM(int n) {
        String string;
        try {
            string = SoakTimePropertyEditor.toStringHHMM(this.getSoakTime(n));
        }
        catch (NoSuchInterface noSuchInterface) {
            string = INTERFACE_NOT_FOUND;
        }
        return string;
    }

    protected int getSoakTime(int n) throws NoSuchInterface {
        if (this.soakTime[n] == -1) {
            this.soakTime[n] = this.model[n].getSoakTime();
        }
        return this.soakTime[n];
    }

    public void refreshMyLines(InterfaceModel[] interfaceModelArray) {
        this.model = interfaceModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public void refreshTable() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetDataCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetDataCache(int n) {
        this.portNums[n] = null;
        this.soakTime[n] = -1;
        this.soakCountdownTime[n] = -2;
    }
}

