/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.ui.Wavelength;
import cerent.util.gui.UComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WavelengthAttribute
implements ActionListener {
    private final DefaultComboBoxModel allBandsModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("C Band", 0), new Attribute("L Band", 1)});
    private final DefaultComboBoxModel cBandModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("C Band", 0)});
    private final DefaultComboBoxModel lBandModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("L Band", 1)});
    private final DefaultComboBoxModel allOdditiesModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("Odd", 0), new Attribute("Even", 1)});
    private final DefaultComboBoxModel oddChModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("Odd", 0)});
    private final DefaultComboBoxModel evenChModel = new DefaultComboBoxModel<Attribute>(new Attribute[]{new Attribute("Even", 1)});
    private Attribute[] channelAttrs = null;
    protected JPanel p;
    protected JLabel label;
    protected UComboBox channelsCB;
    protected UComboBox bandsCB;
    protected UComboBox oddityCB;

    public WavelengthAttribute() {
        this.commonInit();
        this.updateChannels();
    }

    public void setEnabled(boolean bl) {
        this.label.setEnabled(bl);
        this.channelsCB.setEnabled(bl);
        this.bandsCB.setEnabled(bl);
        this.oddityCB.setEnabled(bl);
    }

    public JPanel getUI() {
        return this.p;
    }

    public int getChannel() {
        Attribute attribute = (Attribute)this.channelsCB.getSelectedItem();
        if (attribute != null) {
            return attribute.getIntValue();
        }
        return -1;
    }

    public String getChannelString() {
        return Wavelength.getWavelengthStringFromWavelength(this.getChannel());
    }

    public String toString() {
        return "OCHNC Wavelength: " + Wavelength.getWavelengthStringFromWavelength(this.getChannel());
    }

    protected void commonInit() {
        this.p = new JPanel();
        this.p.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        this.label = new JLabel("OCHNC Wavelength: ");
        this.p.add((Component)this.label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.channelsCB = new UComboBox((Object[])this.getAttributes(0, 0));
        this.p.add((Component)this.channelsCB, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        this.bandsCB = new UComboBox((ComboBoxModel)this.allBandsModel);
        this.p.add((Component)this.bandsCB, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.oddityCB = new UComboBox((ComboBoxModel)this.allOdditiesModel);
        this.p.add((Component)this.oddityCB, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        this.p.add((Component)new JPanel(), gridBagConstraints);
        this.bandsCB.addActionListener((ActionListener)this);
        this.oddityCB.addActionListener((ActionListener)this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bandsCB || actionEvent.getSource() == this.oddityCB) {
            this.updateChannels();
        }
    }

    public int getBand() {
        Attribute attribute = (Attribute)this.bandsCB.getSelectedItem();
        return attribute.getIntValue();
    }

    public int getOddity() {
        Attribute attribute = (Attribute)this.oddityCB.getSelectedItem();
        return attribute.getIntValue();
    }

    public void setBandAndOddity(int n, int n2) {
        DefaultComboBoxModel defaultComboBoxModel;
        Attribute attribute = (Attribute)this.bandsCB.getSelectedItem();
        Attribute attribute2 = (Attribute)this.oddityCB.getSelectedItem();
        ComboBoxModel comboBoxModel = this.bandsCB.getModel();
        if (comboBoxModel != (defaultComboBoxModel = this.getBandModel(n))) {
            this.bandsCB.setModel((ComboBoxModel)defaultComboBoxModel);
            if (defaultComboBoxModel.getIndexOf(attribute) != -1) {
                defaultComboBoxModel.setSelectedItem(attribute);
            }
            this.bandsCB.setEnabled(defaultComboBoxModel.getSize() > 1);
        }
        if ((comboBoxModel = this.oddityCB.getModel()) != (defaultComboBoxModel = this.getOddityModel(n2))) {
            this.oddityCB.setModel((ComboBoxModel)defaultComboBoxModel);
            if (defaultComboBoxModel.getIndexOf(attribute2) != -1) {
                defaultComboBoxModel.setSelectedItem(attribute2);
            }
            this.oddityCB.setEnabled(defaultComboBoxModel.getSize() > 1);
        }
    }

    private DefaultComboBoxModel getBandModel(int n) {
        if (n == 0) {
            return this.cBandModel;
        }
        if (n == 1) {
            return this.lBandModel;
        }
        return this.allBandsModel;
    }

    private DefaultComboBoxModel getOddityModel(int n) {
        if (n == 0) {
            return this.oddChModel;
        }
        if (n == 1) {
            return this.evenChModel;
        }
        return this.allOdditiesModel;
    }

    protected Attribute[] getAttributes(int n, int n2) {
        return Wavelength.getWavelengthAttrs(n, n2, false);
    }

    private void updateChannels() {
        Attribute[] attributeArray = this.getAttributes(this.getBand(), this.getOddity());
        if (this.channelAttrs == null || !this.areEquals(this.channelAttrs, attributeArray)) {
            this.channelAttrs = attributeArray;
            Attribute attribute = (Attribute)this.channelsCB.getSelectedItem();
            DefaultComboBoxModel<Attribute> defaultComboBoxModel = new DefaultComboBoxModel<Attribute>(attributeArray);
            this.channelsCB.setModel(defaultComboBoxModel);
            if (defaultComboBoxModel.getIndexOf(attribute) != -1) {
                defaultComboBoxModel.setSelectedItem(attribute);
            }
        }
    }

    private boolean areEquals(Attribute[] attributeArray, Attribute[] attributeArray2) {
        boolean bl = true;
        if (attributeArray.length == attributeArray2.length) {
            for (int i = 0; bl && i < attributeArray.length; ++i) {
                Attribute attribute = attributeArray[i];
                Attribute attribute2 = attributeArray2[i];
                bl = attribute.equals(attribute2);
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

