/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.LeavePageException;
import cerent.cms.ui.NotApplicablePane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ampli.AmpliAlsTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class AmpliAlsPane
extends AbstractPane
implements TableModelListener,
ActionListener {
    protected OpticsModuleModel model;
    protected AmpliAlsTableModel dataModel = null;
    private AbstractOpticsLineModel[] lineModels;
    protected int numLines = 0;
    private boolean notInited = true;
    private NotApplicablePane nap;
    private int ampliRole = 0;
    private UScrollPane scrollPane = null;
    public static final String APPLY = "Apply";
    public static final String RESET = "Reset";
    public static final String HELP = "Help";
    private JButton applyButton;
    private JButton resetButton;
    private boolean isDirty = false;
    private JPanel buttonPanel = null;
    private CSHelpButton helpButton;
    protected static final SDebug db = new SDebug("AmpliAlsPane");

    public AmpliAlsPane(String string, TabbedView tabbedView, OpticsModuleModel opticsModuleModel) {
        super(string, tabbedView);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        this.model = opticsModuleModel;
        this.buttonPanel = this.getButtonPanel();
        this.add(this.buttonPanel, "East");
    }

    private void initAlsPane() {
        try {
            if (this.nap != null) {
                this.remove((Component)((Object)this.nap));
            }
            if (this.scrollPane != null) {
                this.remove((Component)this.scrollPane);
            }
            if (this.lineModels[0] != null) {
                this.buttonPanel.setVisible(true);
                this.numLines = this.lineModels.length;
                this.dataModel = this.getDataModel();
                this.dataModel.addTableModelListener(this);
                this.initColumns();
                this.nap = null;
                this.dataModel.refreshFromModel();
                this.table.setAutoResizeMode(0);
                this.add((Component)this.scrollPane, "Center");
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private void initColumns() throws NoSuchInterface, WrongInterfaceType {
        this.table = new JTable(this.dataModel);
        this.scrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[0]);
        TableColumn tableColumn2 = this.table.getColumn(AmpliAlsTableModel.columnNames[7]);
        int n = this.model.getEqType();
        if (n != 287 && n != 321) {
            this.table.removeColumn(tableColumn2);
        }
        if (this.isPortTobeDisplayed(n)) {
            tableColumn.setPreferredWidth(100);
        } else {
            this.table.removeColumn(tableColumn);
        }
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForOSRICommand()));
        tableColumn.setPreferredWidth(70);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[2]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForALSCommand()));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[3]);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[4]);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[5]);
        tableColumn.setPreferredWidth(250);
        tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[6]);
        tableColumn.setPreferredWidth(250);
        this.ampliRole = this.model.getAmpliRole().value();
        if (this.model.isOPT_PRE() || (this.model.isOPT_AMP_L() || this.model.isOPT_AMP_17_C_LINE_CARD() || this.model.isOPT_AMP_23_C_LINE_CARD() || this.model.isOPT_BST_L() || this.model.isOPT_BST_E() || this.model.isOPT_AMP_C() || this.model.isOPT_BST()) && this.ampliRole == 1) {
            tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[2]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[3]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[4]);
            this.table.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(AmpliAlsTableModel.columnNames[6]);
            this.table.removeColumn(tableColumn);
        }
    }

    private boolean isPortTobeDisplayed(int n) {
        boolean bl = false;
        switch (n) {
            case 129: 
            case 287: 
            case 294: 
            case 295: 
            case 296: 
            case 321: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    protected void init() throws Exception {
        int n = this.model.getALSInterfaces().length;
        if (n > 0) {
            this.lineModels = new AbstractOpticsLineModel[n];
            for (int i = 0; i < n; ++i) {
                this.lineModels[i] = this.model.getALSInterfaces()[i];
            }
        }
        this.registerWithModel();
        this.initAlsPane();
        this.notInited = false;
    }

    protected void registerWithModel() {
        if (this.model != null) {
            this.model.addObserver((Observer)((Object)this));
        }
        if (this.lineModels != null) {
            for (int i = 0; i < this.lineModels.length; ++i) {
                this.lineModels[i].addObserver((Observer)((Object)this));
            }
        }
    }

    protected JComboBox getComboBoxForALSCommand() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.getALSCommandStrings());
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected JComboBox getComboBoxForOSRICommand() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.getOSRICommandStrings());
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void dispose() {
        this.unRegisterWithModel();
        if (this.model != null) {
            this.model.deleteObserver((Observer)((Object)this));
        }
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
        }
    }

    private void unRegisterWithModel() {
        if (this.lineModels != null) {
            for (int i = 0; i < this.lineModels.length; ++i) {
                this.lineModels[i].deleteObserver((Observer)((Object)this));
            }
        }
    }

    public void leavingPage() throws Exception {
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        this.stopTableCellEditing();
        if (this.isDirty) {
            switch (CerentDialog.questionDialog((Component)((Object)this), (String)"Is it OK to apply these changes?", (String)"Changes Not Applied", (int)0)) {
                case 0: {
                    if (db.on()) {
                        db.println("leavingPage: applying " + this.getName());
                    }
                    this.apply();
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("leavingPage: abandoning changes to " + this.getName());
                    }
                    this.setDirty(false);
                    break;
                }
                default: {
                    if (db.on()) {
                        db.println("leavingPage: canceling change from " + this.getName());
                    }
                    throw this.createLeavePageException("Page change canceled by user");
                }
            }
        }
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        this.updateIfRoleChanged();
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromReset();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty(true);
        } else {
            this.setDirty(false);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            this.updateIfRoleChanged();
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if (this.dataModel != null) {
                this.dataModel.fireTableDataChanged();
                this.requestRefresh(observable, this.getRefreshThread(observable));
            }
        }
    }

    private void updateIfRoleChanged() {
        switch (this.model.getEqType()) {
            case 130: 
            case 196: 
            case 239: 
            case 240: 
            case 277: 
            case 278: 
            case 281: {
                int n = this.ampliRole;
                try {
                    n = ((OpticsModuleModel)this.getUiModel()).getAmpliRole().value();
                }
                catch (NoSuchInterface noSuchInterface) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_SUCH_INTERFACE_PARAM_1, (Object)((Object)noSuchInterface));
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_WRONG_INTERFACE_TYPE_PARAM_1, (Object)((Object)wrongInterfaceType));
                }
                if (this.ampliRole == n || this.ampliRole == 0) break;
                this.ampliRole = n;
                this.initAlsPane();
                break;
            }
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                AmpliAlsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = -1;
        if (this.lineModels != null) {
            n = Arrays.asList(this.lineModels).indexOf(observable);
        }
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            if (this.dataModel != null) {
                this.dataModel.refreshLineFromModel(n);
            }
        } else if (db.on()) {
            db.println("In AmpliAlsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        this.dataModel.applyToModel();
        this.setDirty(false);
    }

    protected AmpliAlsTableModel getDataModel() {
        return new AmpliAlsTableModel(this.model, this.lineModels);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.AmpliAlsPane;
    }

    public void refresh() {
    }

    private JPanel getButtonPanel() {
        Dimension dimension = new Dimension(75, 25);
        this.applyButton = new JButton(APPLY);
        this.applyButton.setEnabled(false);
        this.applyButton.setMinimumSize(dimension);
        this.applyButton.setMaximumSize(dimension);
        this.applyButton.addActionListener(this);
        this.resetButton = new JButton(RESET);
        this.resetButton.setMinimumSize(dimension);
        this.resetButton.setMaximumSize(dimension);
        this.resetButton.addActionListener(this);
        JPanel jPanel = AmpliAlsPane.createVerticalPanel(null);
        jPanel.add(this.applyButton);
        jPanel.add(Box.createVerticalStrut(this.applyButton.getPreferredSize().height / 3));
        jPanel.add(this.resetButton);
        this.helpButton = new CSHelpButton();
        this.helpButton.setMinimumSize(dimension);
        this.helpButton.setMaximumSize(dimension);
        this.helpButton.addActionListener(this);
        jPanel.add(Box.createVerticalStrut(this.applyButton.getPreferredSize().height / 3));
        jPanel.add(this.helpButton);
        return jPanel;
    }

    public final void setDirty(boolean bl) {
        if (db.on()) {
            db.println("setDirty: " + this.getName() + ": " + this.isDirty + " -> " + bl);
        }
        this.isDirty = bl;
        if (this.applyButton != null) {
            this.applyButton.setEnabled(this.isDirty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void apply() {
        try {
            if (this.isDirty) {
                this.setCursor(3);
                this.stopTableCellEditing();
                this.applyChangesToModel();
                this.setDirty(false);
            }
            EventBus.instance().notifyEvent((Object)this.getFullName(), (Object)APPLY);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.println("caught " + (Object)((Object)abstractCmsIOException) + " in Pane.apply");
            }
        }
        catch (EMCProvisionError eMCProvisionError) {
            if (db.on()) {
                db.println("caught " + (Object)((Object)eMCProvisionError) + " in Pane.apply");
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)eMCProvisionError.getEID(), (Object)eMCProvisionError.getEIDMsg());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.getMessage());
        }
        finally {
            this.setCursor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            if (object == this.resetButton) {
                this.dataModel.refreshFromModel();
            } else if (object == this.applyButton) {
                this.apply();
            } else if (object == this.helpButton) {
                this.helpButton.launchHelp(this.getHelpID());
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.uiToolkit.setCursor(0);
        }
    }

    protected AbstractLeavePageException createLeavePageException(String string) {
        if (db.on()) {
            db.println("createLeavePageException");
        }
        return new LeavePageException(string);
    }
}

