/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.OpticalThresholdTableModel;
import cerent.util.SDebug;

public class AmpliOpticalThresholdTableModel
extends OpticalThresholdTableModel {
    public static final int GAIN_DEGRADE_LOW_INDEX = 11;
    public static final int GAIN_DEGRADE_HIGH_INDEX = 12;
    public static final int PWR_OSC_DEGRADE_HIGH_INDEX = 13;
    public static final int PWR_OSC_DEGRADE_LOW_INDEX = 14;
    public static final int PWR_OSC_FAIL_LOW_INDEX = 15;
    public static final int PWR_OSC_HIGH_INDEX = 16;
    public static final int PWR_OSC_LOW_INDEX = 17;
    private String[] pwrFailL;
    private String[] pwrOSCDegH;
    private String[] pwrOSCDegL;
    private String[] opwrOscMax;
    private String[] opwrOscMin;
    private String[] gainDegL;
    private String[] gainDegH;
    public static final String[] columnNames = new String[]{"Gain Degrade Low (dBm)", "Gain Degrade High (dBm)", "Pwr OSC Degrade High (dBm)", "Pwr OSC Degrade Low (dBm)", "Pwr OSC Failure (dBm)", "opwrMax OSC (dBm)", "opwrMin OSC (dBm)"};
    public static final String[] ramanColumnNames = new String[]{"Gain Degrade Low ", "Gain Degrade High ", "", "", "", "", ""};
    private static final SDebug db = new SDebug("AmpliOpticalThresholdTableModel");

    public AmpliOpticalThresholdTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray, int n) {
        super(abstractOpticsLineModelArray, n);
        this.pwrFailL = new String[this.numLines];
        this.pwrOSCDegH = new String[this.numLines];
        this.pwrOSCDegL = new String[this.numLines];
        this.opwrOscMax = new String[this.numLines];
        this.opwrOscMin = new String[this.numLines];
        this.gainDegL = new String[this.numLines];
        this.gainDegH = new String[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.pwrFailL[i] = null;
            this.pwrOSCDegH[i] = null;
            this.pwrOSCDegL[i] = null;
            this.opwrOscMax[i] = null;
            this.opwrOscMin[i] = null;
            this.gainDegL[i] = null;
            this.gainDegH[i] = null;
        }
    }

    protected void resetLineCache(int n) {
        super.resetLineCache(n);
        this.pwrFailL[n] = null;
        this.pwrOSCDegH[n] = null;
        this.pwrOSCDegL[n] = null;
        this.opwrOscMax[n] = null;
        this.opwrOscMin[n] = null;
        this.gainDegL[n] = null;
        this.gainDegH[n] = null;
    }

    public int getColumnCount() {
        return super.getColumnCount() + columnNames.length;
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                if (!this.isUserAuthorized(SecurityLevel.PROVISIONING) || this.Flg_FeatureUnsupported[n][n2]) break;
                bl = true;
                break;
            }
            case 7: {
                try {
                    if (this.model[n].getOptPortType() != OpticalPortType.IN_RAMAN || !this.isUserAuthorized(SecurityLevel.PROVISIONING)) break;
                    bl = true;
                }
                catch (NoSuchInterface noSuchInterface) {
                }
                catch (WrongInterfaceType wrongInterfaceType) {}
                break;
            }
            default: {
                bl = super.isCellEditable(n, n2);
            }
        }
        return bl;
    }

    public String getColumnName(int n) {
        if (n < 11) {
            return super.getColumnName(n);
        }
        if (!this.raman) {
            return columnNames[n - 11];
        }
        return ramanColumnNames[n - 11];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 16: {
                    return this.getPwrOscHigh(n);
                }
                case 17: {
                    return this.getPwrOscLow(n);
                }
                case 13: {
                    return this.getAlmOscPwrDegradeHigh(n);
                }
                case 14: {
                    return this.getAlmOscPwrDegradeLow(n);
                }
                case 15: {
                    return this.getAlmOscPwrFailLow(n);
                }
                case 11: {
                    return this.getGainDegradeLow(n);
                }
                case 12: {
                    return this.getGainDegradeHigh(n);
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("AmpliOpticalThresholdTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    protected String getAlmOscPwrDegradeHigh(int n) {
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.pwrOSCDegH[n] == null) {
            this.Flg_FeatureUnsupported[n][13] = true;
            try {
                int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.OSC, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.HIGHIDX);
                if (n2 != -1000000) {
                    this.pwrOSCDegH[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][13] = false;
                } else {
                    this.pwrOSCDegH[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.pwrOSCDegH[n] = "N/A";
            }
        }
        return this.pwrOSCDegH[n];
    }

    protected String getAlmOscPwrDegradeLow(int n) {
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.pwrOSCDegL[n] == null) {
            this.Flg_FeatureUnsupported[n][14] = true;
            try {
                int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.OSC, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.LOWIDX);
                if (n2 != -1000000) {
                    this.pwrOSCDegL[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][14] = false;
                } else {
                    this.pwrOSCDegL[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.pwrOSCDegL[n] = "N/A";
            }
        }
        return this.pwrOSCDegL[n];
    }

    protected String getAlmOscPwrFailLow(int n) {
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.pwrFailL[n] == null) {
            this.Flg_FeatureUnsupported[n][15] = true;
            try {
                int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.OSC, AbstractOpticsLineModel.LevelType.FAIL, AbstractOpticsLineModel.ThType.LOWIDX);
                if (n2 != -1000000) {
                    this.pwrFailL[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][15] = false;
                } else {
                    this.pwrFailL[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.pwrFailL[n] = "N/A";
            }
        }
        return this.pwrFailL[n];
    }

    protected String getGainDegradeLow(int n) {
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.gainDegL[n] == null) {
            this.Flg_FeatureUnsupported[n][11] = true;
            try {
                int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.GAIN, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.LOWIDX);
                if (n2 != -1000000) {
                    this.gainDegL[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][11] = false;
                } else {
                    this.gainDegL[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.gainDegL[n] = "N/A";
            }
        }
        return this.gainDegL[n];
    }

    protected String getGainDegradeHigh(int n) {
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.gainDegH[n] == null) {
            this.Flg_FeatureUnsupported[n][12] = true;
            try {
                int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.GAIN, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.HIGHIDX);
                if (n2 != -1000000) {
                    this.gainDegH[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][12] = false;
                } else {
                    this.gainDegH[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.gainDegH[n] = "N/A";
            }
        }
        return this.gainDegH[n];
    }

    protected String getPwrOscHigh(int n) {
        int n2 = -1000000;
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.opwrOscMax[n] == null) {
            this.Flg_FeatureUnsupported[n][16] = true;
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_15_MIN, AbstractOpticsLineModel.TCAAlmType.OSC, AbstractOpticsLineModel.ThType.HIGHIDX);
                        break;
                    }
                    case 1: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_DAY, AbstractOpticsLineModel.TCAAlmType.OSC, AbstractOpticsLineModel.ThType.HIGHIDX);
                    }
                }
                if (n2 != -1000000) {
                    this.opwrOscMax[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][16] = false;
                } else {
                    this.opwrOscMax[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.opwrOscMax[n] = "N/A";
            }
        }
        return this.opwrOscMax[n];
    }

    protected String getPwrOscLow(int n) {
        int n2 = -1000000;
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.opwrOscMin[n] == null) {
            this.Flg_FeatureUnsupported[n][17] = true;
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_15_MIN, AbstractOpticsLineModel.TCAAlmType.OSC, AbstractOpticsLineModel.ThType.LOWIDX);
                        break;
                    }
                    case 1: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_DAY, AbstractOpticsLineModel.TCAAlmType.OSC, AbstractOpticsLineModel.ThType.LOWIDX);
                    }
                }
                if (n2 != -1000000) {
                    this.opwrOscMin[n] = ConvertPwrToDb.formatDecimalNumber(n2);
                    this.Flg_FeatureUnsupported[n][17] = false;
                } else {
                    this.opwrOscMin[n] = "N/A";
                }
            }
            catch (Exception exception) {
                this.opwrOscMin[n] = "N/A";
            }
        }
        return this.opwrOscMin[n];
    }

    public void setValueAt(Object object, int n, int n2) {
        db.info("Change in value " + n + " " + n2);
        boolean bl = false;
        try {
            switch (n2) {
                case 16: {
                    String string = (String)object;
                    this.opwrOscMax[n] = (String)object;
                    if (AmpliOpticalThresholdTableModel.isValidNumber(string, "OSC Power High")) {
                        int n3 = AmpliOpticalThresholdTableModel.ValPerTen(string);
                        if (this.thresholdsVal[n] != null) {
                            this.thresholdsVal[n].oscPowerPMTh.high = n3;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.opwrOscMax[n] = null;
                    this.getPwrOscHigh(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                case 17: {
                    String string = (String)object;
                    this.opwrOscMin[n] = (String)object;
                    if (AmpliOpticalThresholdTableModel.isValidNumber(string, "OSC Power Low")) {
                        int n4 = AmpliOpticalThresholdTableModel.ValPerTen(string);
                        if (this.thresholdsVal[n] != null) {
                            this.thresholdsVal[n].oscPowerPMTh.low = n4;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.opwrOscMin[n] = null;
                    this.getPwrOscLow(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                case 15: {
                    String string = (String)object;
                    this.pwrFailL[n] = (String)object;
                    if (AmpliOpticalThresholdTableModel.isValidNumber(string, "Power OSC failure Low")) {
                        int n5 = AmpliOpticalThresholdTableModel.ValPerTen(string);
                        if (this.AlmThresholdsVal[n] != null) {
                            this.AlmThresholdsVal[n].oscPowerAlmTh.fail.low = n5;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.pwrFailL[n] = null;
                    this.getAlmOscPwrFailLow(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                case 12: {
                    String string = (String)object;
                    this.gainDegH[n] = (String)object;
                    if (AmpliOpticalThresholdTableModel.isValidNumber(string, "Gain Deg High")) {
                        int n6 = AmpliOpticalThresholdTableModel.ValPerTen(string);
                        if (this.AlmThresholdsVal[n] != null) {
                            this.AlmThresholdsVal[n].gainAlmTh.degrade.high = n6;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.gainDegH[n] = null;
                    this.getGainDegradeHigh(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                case 11: {
                    String string = (String)object;
                    this.gainDegL[n] = (String)object;
                    if (AmpliOpticalThresholdTableModel.isValidNumber(string, "Gain Deg Low")) {
                        int n7 = AmpliOpticalThresholdTableModel.ValPerTen(string);
                        if (this.AlmThresholdsVal[n] != null) {
                            this.AlmThresholdsVal[n].gainAlmTh.degrade.low = n7;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.gainDegL[n] = null;
                    this.getGainDegradeLow(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                default: {
                    super.setValueAt(object, n, n2);
                    break;
                }
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("AmpliOpticalThresholdTableModel: error in setValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }
}

