/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ampli.AmpliParametersTableModel;
import cerent.cms.ui.ampli.ParametersProvPane;
import cerent.util.KDebug;
import cerent.util.gui.UTable;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class OTSParametersProvPane
extends ParametersProvPane
implements TableModelListener {
    protected AmpliParametersTableModel dataModel;
    protected OpticsModuleModel eqpmtModel;
    protected AbstractOpticsLineModel[] lineModels;
    protected int numLines;
    protected boolean notInited = true;

    public OTSParametersProvPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView, abstractOpticsLineModelArray);
        this.lineModels = abstractOpticsLineModelArray;
    }

    protected JTable getTable(TableModel tableModel) {
        UTable uTable = new UTable(tableModel){

            public TableCellEditor getCellEditor(int n, int n2) {
                if (this.convertColumnIndexToModel(n2) == 2) {
                    boolean bl = AdminState.isANSI(OTSParametersProvPane.this.getUiModel().getNodeModel().getTdmProtocolType());
                    AdminState[] adminStateArray = null;
                    try {
                        adminStateArray = OTSParametersProvPane.this.lineModels[n].getOptPortType() == OpticalPortType.IN_LINE || OTSParametersProvPane.this.lineModels[n].getOptPortType() == OpticalPortType.IN_OSC || OTSParametersProvPane.this.lineModels[n].getOptPortType() == OpticalPortType.OUT_LINE || OTSParametersProvPane.this.lineModels[n].getOptPortType() == OpticalPortType.OUT_OSC ? AdminState.getAdminStatesNoDSBLD(bl) : AdminState.getAdminStatesNoIS(bl);
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        KDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        KDebug.printStackTrace((Throwable)wrongInterfaceType);
                    }
                    JComboBox jComboBox = new JComboBox(adminStateArray);
                    jComboBox.setEditable(false);
                    return new DefaultCellEditor(jComboBox);
                }
                return super.getCellEditor(n, n2);
            }
        };
        return uTable;
    }

    protected void prepareColumns() {
        super.prepareColumns();
        TableColumn tableColumn = this.table.getColumn(this.getColumnName(22));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.getColumnName(24));
        tableColumn.setPreferredWidth(170);
        tableColumn = this.table.getColumn(this.getColumnName(23));
        tableColumn.setPreferredWidth(170);
        this.removeColumn(14);
        this.removeColumn(4);
        this.removeColumn(6);
        this.removeColumn(7);
        this.removeColumn(18);
        this.removeColumn(10);
        this.removeColumn(9);
        OpticsModuleModel opticsModuleModel = (OpticsModuleModel)this.getUiModel();
        if (opticsModuleModel.getEqType() != 294 && opticsModuleModel.getEqType() != 295 && opticsModuleModel.getEqType() != 296) {
            this.removeColumn(8);
            this.removeColumn(11);
            this.removeColumn(12);
        }
        this.removeColumn(16);
        this.removeColumn(20);
        this.removeColumn(23);
        this.removeColumn(24);
        this.removeColumn(21);
        this.removeColumn(22);
        this.removeColumn(19);
        this.removeColumn(17);
        if (opticsModuleModel.getEqType() == 129 || opticsModuleModel.getEqType() == 298 || opticsModuleModel.getEqType() == 299) {
            this.removeColumn(15);
        }
        if (opticsModuleModel.getEqType() == 287 || opticsModuleModel.getEqType() == 321) {
            this.removeColumn(24);
            this.removeColumn(15);
        }
    }

    protected String getColumnName(int n) {
        if (n >= 14) {
            return AmpliParametersTableModel.columnNames[n - 14];
        }
        return super.getColumnName(n);
    }

    protected void removeColumn(int n) {
        if (n >= 14) {
            String string = AmpliParametersTableModel.columnNames[n - 14];
            try {
                TableColumn tableColumn = this.getTable().getColumn(string);
                this.getTable().removeColumn(tableColumn);
            }
            catch (Exception exception) {
                if (OTSParametersProvPane.db.on) {
                    db.fine("Caught " + exception + " in removeColumn");
                }
            }
        } else {
            super.removeColumn(n);
        }
    }

    protected AmpliParametersTableModel getDataModel() {
        return new AmpliParametersTableModel(this.lineModels);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.AmpliOTSParametersProvPane;
    }
}

