/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.idl.Optics.sOChPowerAttributes;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CombosCellRenderer;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ampli.WlPowerDataSource;
import cerent.cms.ui.ampli.WlPowerTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class WlPowerPane
extends AbstractPane
implements ITabName,
TableModelListener,
ActionListener {
    private JButton retrieveButton;
    private boolean isDirty = false;
    private boolean notInited = true;
    private AbstractOpticsLineModel[] aolm;
    private DefaultComboBoxModel portModel;
    private JComboBox portCB;
    private sOChPowerAttributes[] ochpwr;
    private WlPowerDataSource dataSource;
    protected static final SDebug db = new SDebug("WlPowerPane");

    public WlPowerPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView.getUiModel(), tabbedView);
        this.aolm = abstractOpticsLineModelArray;
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.deleteObservers();
    }

    public final void refresh() {
    }

    protected void init() {
        this.portModel = new DefaultComboBoxModel();
        this.dataSource = new WlPowerDataSource();
        this.table = new JTable((TableModel)((Object)new WlPowerTableModel(this.dataSource)));
        ((WlPowerTableModel)((Object)this.table.getModel())).initTable(this.table);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(true);
        this.table.setCellSelectionEnabled(true);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
        this.createButtonPanel();
        this.getPortModels(this.portModel);
        this.notInited = false;
    }

    protected WlPowerTableModel getTableModel() {
        if (this.table != null) {
            return (WlPowerTableModel)((Object)this.table.getModel());
        }
        return null;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    public void destroy() {
        super.destroy();
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        if (this.isDirty && db.on()) {
            db.println("enteringPage: " + this.getName() + " is dirty");
        }
        if (db.on()) {
            db.println("enteringPage: refreshing " + this.getName());
        }
        ((WlPowerTableModel)((Object)this.table.getModel())).addTableModelListener(this);
        this.refresh();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected void createButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.OpticalPowerChannelPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.bottom = 15;
        jPanel.add((Component)new JLabel("Port: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.portCB = this.addCB(this.portModel, gridBagConstraints, jPanel);
        cSHelpButtonPane.addLeft(jPanel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.retrieveButton = new JButton("Retrieve");
        this.retrieveButton.addActionListener(this);
        jPanel.add((Component)this.retrieveButton, gridBagConstraints);
        this.add(cSHelpButtonPane, "South");
    }

    private void getPortModels(DefaultComboBoxModel defaultComboBoxModel) {
        int n;
        ArrayList<IPortModel> arrayList = new ArrayList<IPortModel>();
        for (n = 0; n < this.aolm.length; ++n) {
            try {
                arrayList.add(this.aolm[n].getPortModel());
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("No such entity");
            }
        }
        Collections.sort(arrayList, new EntityModel.EntityModelComparator());
        for (n = 0; n < this.aolm.length; ++n) {
            defaultComboBoxModel.addElement(arrayList.toArray()[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            if (object == this.retrieveButton) {
                this.uiToolkit.setCursor(3);
                if (this.portCB.getSelectedIndex() != -1) {
                    try {
                        this.ochpwr = ((AbstractOpticsLineModel)((OpticsPortModel)this.portCB.getSelectedItem()).getInterfaceModel()).getAllWlPower();
                        this.getTableModel().refreshFromModel(this.ochpwr, CombosCellRenderer.toString((PortModel)this.portCB.getSelectedItem()));
                    }
                    catch (FeatureUnsupported featureUnsupported) {
                        db.println("Feature unspported");
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        db.println("No Such interface");
                    }
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.uiToolkit.setCursor(0);
        }
    }

    public void dispose() {
        if (this.dataSource != null) {
            this.dataSource.dispose();
        }
    }

    private void deleteObservers() {
        if (this.getTableModel() != null) {
            this.getTableModel().removeTableModelListener(this);
        }
    }

    private JComboBox addCB(DefaultComboBoxModel defaultComboBoxModel, GridBagConstraints gridBagConstraints, JPanel jPanel) {
        JComboBox jComboBox = new JComboBox(defaultComboBoxModel){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 160;
                return dimension;
            }
        };
        jComboBox.setRenderer(new CombosCellRenderer());
        jComboBox.addActionListener(this);
        jPanel.add((Component)jComboBox, gridBagConstraints);
        return jComboBox;
    }
}

