/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.AttributeMaps;
import cerent.cms.ui.ans.AnsPathDataSource;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class AnsPathColumnRenderer
extends AbstractColumnRenderer {
    private static final String UNKNOWN = "Unknown";
    private static AttributeMaps attributeMap = new AttributeMaps();
    private JLabel label = new JLabel();
    private static final SDebug db = new SDebug("AnsPathColumnRenderer");

    public AnsPathColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        JLabel jLabel = this.label;
        if (!(object instanceof AnsPathDataSource.AnsPathRow)) {
            if (db.on()) {
                db.println("Cast error");
            }
            this.label.setText("");
            return jLabel;
        }
        AnsPathDataSource.AnsPathRow ansPathRow = (AnsPathDataSource.AnsPathRow)object;
        Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        switch (n2) {
            case 1: {
                string = ansPathRow.getSlot();
                break;
            }
            case 2: {
                string = ansPathRow.getParameter();
                break;
            }
            case 3: {
                string = ansPathRow.getStatus();
                break;
            }
            case 0: {
                string = ansPathRow.getSide();
                break;
            }
            default: {
                string = UNKNOWN;
            }
        }
        if (db.on()) {
            db.println("Cell @ [" + n + ", " + n2 + "] = " + string);
        }
        this.label.setToolTipText("");
        this.label.setText(string);
        if (ansPathRow.getSuccess() || ansPathRow.getStatus().equals(AnsPathDataSource.nodeSetupResult[3])) {
            Color color2 = bl ? jTable.getSelectionForeground() : jTable.getForeground();
            ((Component)jLabel).setForeground(color2);
        } else {
            ((Component)jLabel).setForeground(Color.red);
        }
        ((Component)jLabel).setBackground(color);
        return jLabel;
    }

    public int compareColumn(Object object, Object object2, int n) {
        if (object instanceof AnsPathDataSource.AnsPathRow && object instanceof AnsPathDataSource.AnsPathRow) {
            return ((AnsPathDataSource.AnsPathRow)object).compareTo((AnsPathDataSource.AnsPathRow)object2, n);
        }
        if (db.on()) {
            db.println("Cast error");
        }
        return 0;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[4];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = AnsPathColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 1: {
                string = "Port";
                n3 = 340;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Parameter";
                n3 = 200;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Link status";
                n3 = 200;
                bl = true;
                n2 = 2;
                break;
            }
            case 0: {
                string = "Side";
                n3 = 60;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new AnsPathColumnRenderer(string, n3, bl, n2);
    }

    public static AttributeMaps getTopologyAttributeMaps() {
        return attributeMap;
    }
}

