/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ctx;

import cerent.cms.model.BbeSlot;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CtxClModuleModel;
import cerent.cms.model.CtxMaModuleModel;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WbeSlot;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.MutablePortsProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.aic.EnvAlarmPanesFactory;
import cerent.cms.ui.aic.EnvControlPanesFactory;
import cerent.cms.ui.ds1.Ds1ProvPane;
import cerent.cms.ui.ds3e.Ds3eProvPane;
import cerent.cms.ui.ec1.Ec1ProvPane;
import cerent.cms.ui.ppm.PpmProvPane;
import cerent.cms.ui.shelf.UserDefinedAlarmPane;
import cerent.cms.ui.sonet.TdmProvPane;
import cerent.util.SDebug;
import java.awt.Component;

public class CtxProvPane
extends AbstractSubTabbedPane
implements ITabName {
    protected Ds123LineModel[] ds3Lines;
    protected TdmLineModel[] ec1Lines;
    protected TdmLineModel[] ocnLines;
    protected Ds123LineModel[] ds1Lines;
    protected EnvAlarmModel[] alarmInputs;
    protected EnvControlModel[] controlOutputs;
    private static final SDebug dbg = new SDebug("CtxProvPane");

    public CtxProvPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray) {
        this(string, tabbedView, null, null, null, tdmLineModelArray, null, null);
    }

    public CtxProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, TdmLineModel[] tdmLineModelArray, TdmLineModel[] tdmLineModelArray2, EnvAlarmModel[] envAlarmModelArray, EnvControlModel[] envControlModelArray) {
        super(string, tabbedView);
        this.ds1Lines = ds123LineModelArray;
        this.ds3Lines = ds123LineModelArray2;
        this.ec1Lines = tdmLineModelArray;
        this.ocnLines = tdmLineModelArray2;
        this.alarmInputs = envAlarmModelArray;
        this.controlOutputs = envControlModelArray;
        this.registerWithModel();
    }

    protected void createSubTabs() {
        ModuleModel moduleModel;
        boolean bl;
        if (dbg.on()) {
            dbg.info("Creating SubTabs");
        }
        if (bl = (moduleModel = (ModuleModel)this.getUiModel()) instanceof CtxClModuleModel) {
            CtxClModuleModel ctxClModuleModel = (CtxClModuleModel)this.getUiModel();
            this.subTabs.addTab("Broadband Ports", (Component)this.getBbeTab(ctxClModuleModel));
        }
        this.subTabs.addTab("Pluggable Port Modules", (Component)this.getPpmTab(moduleModel));
        if (bl) {
            this.subTabs.addTab("DS1", (Component)this.getDs1Tab(this.ds1Lines));
            this.subTabs.addTab("DS3", (Component)this.getDs3Tab(this.ds3Lines));
            this.subTabs.addTab("EC1", (Component)this.getEc1Tab(this.ec1Lines));
        }
        this.subTabs.addTab("Optical", (Component)this.getOpticalTab(this.ocnLines));
        if (bl) {
            this.subTabs.addTab("External Alarms", (Component)this.getExtAlarmsTab(moduleModel, this.alarmInputs));
            this.subTabs.addTab("External Controls", (Component)this.getExtControlsTab(moduleModel, this.controlOutputs));
            this.subTabs.addTab("User Defined Alarms", (Component)((Object)new UserDefinedAlarmPane(this.getParentView())));
        }
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
    }

    private Pane getWbeTab(CtxClModuleModel ctxClModuleModel) {
        WbeSlot wbeSlot;
        IPortContainer[] iPortContainerArray;
        block2: {
            iPortContainerArray = null;
            wbeSlot = null;
            try {
                wbeSlot = ctxClModuleModel.getWbeSlot();
                iPortContainerArray = new IPortContainer[]{wbeSlot};
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                iPortContainerArray = new IPortContainer[]{};
                if (!dbg.on()) break block2;
                dbg.println("Failed to retrieve WbeSlot");
            }
        }
        return new ProtCardDualPane(this.subTabs, ctxClModuleModel, new MutablePortsProvPane("Wideband Ports", this.subTabs, iPortContainerArray, wbeSlot.getEqType(), false, CSHelpConst.WbePortProvPane, dbg));
    }

    private Pane getBbeTab(CtxClModuleModel ctxClModuleModel) {
        BbeSlot bbeSlot;
        IPortContainer[] iPortContainerArray;
        block2: {
            iPortContainerArray = null;
            bbeSlot = null;
            try {
                bbeSlot = ctxClModuleModel.getBbeSlot();
                iPortContainerArray = new IPortContainer[]{bbeSlot};
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                iPortContainerArray = new IPortContainer[]{};
                if (!dbg.on()) break block2;
                dbg.println("Failed to retrieve BbeSlot");
            }
        }
        return new ProtCardDualPane(this.subTabs, ctxClModuleModel, new MutablePortsProvPane("Broadband Ports", this.subTabs, iPortContainerArray, bbeSlot.getEqType(), false, CSHelpConst.BbePortProvPane, dbg));
    }

    private Pane getPpmTab(ModuleModel moduleModel) {
        return new ProtCardDualPane(this.subTabs, moduleModel, new PpmProvPane("Pluggable Port Modules", this.subTabs, true));
    }

    private Pane getEc1Tab(TdmLineModel[] tdmLineModelArray) {
        return new Ec1ProvPane("EC1", this.subTabs, tdmLineModelArray, false, false);
    }

    private Pane getOpticalTab(TdmLineModel[] tdmLineModelArray) {
        ModuleModel moduleModel = (ModuleModel)this.getUiModel();
        boolean bl = moduleModel instanceof CtxMaModuleModel;
        boolean bl2 = bl;
        return new TdmProvPane("Optical", this.subTabs, tdmLineModelArray, false, bl2);
    }

    private Pane getExtAlarmsTab(ModuleModel moduleModel, EnvAlarmModel[] envAlarmModelArray) {
        EnvAlarmPanesFactory envAlarmPanesFactory = new EnvAlarmPanesFactory(this.subTabs, envAlarmModelArray);
        return new ProtCardDualPane(this.subTabs, moduleModel, envAlarmPanesFactory.getEnvAlarmProvTab());
    }

    private Pane getExtControlsTab(ModuleModel moduleModel, EnvControlModel[] envControlModelArray) {
        EnvControlPanesFactory envControlPanesFactory = new EnvControlPanesFactory(this.subTabs, envControlModelArray);
        return new ProtCardDualPane(this.subTabs, moduleModel, envControlPanesFactory.getEnvControlProvTab());
    }

    private Pane getDs1Tab(Ds123LineModel[] ds123LineModelArray) {
        return new Ds1ProvPane("DS1", this.subTabs, ds123LineModelArray, false);
    }

    private Pane getDs3Tab(Ds123LineModel[] ds123LineModelArray) {
        return new Ds3eProvPane("DS3", this.subTabs, ds123LineModelArray, false);
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ds3LineUpdate..");
            }
            this.ds3Lines = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
        } else if (object instanceof Ec1LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ec1LineUpdate...");
            }
            this.ec1Lines = (TdmLineModel[])((Ec1LineUpdate)object).getModels();
        } else if (object instanceof OcnLineUpdate) {
            if (dbg.on()) {
                dbg.info("Received OcnLineUpdate...");
            }
            this.ocnLines = (TdmLineModel[])((OcnLineUpdate)object).getModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }
}

