/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.download;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISecurityModel;
import cerent.cms.model.Operation;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeVersionInfo;
import cerent.cms.ui.SoftMaintDataSource;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.download.DelayedUpgradeDialog;
import cerent.cms.ui.download.SoftMaintActiveRevertDialog;
import cerent.cms.ui.download.SoftMaintCancelDialog;
import cerent.cms.ui.download.SoftMaintSelDialog;
import cerent.cms.ui.download.SoftMaintTableModel;
import cerent.util.BuildInfo;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.StringHolder;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import cerent.util.job.JobStatus;
import cerent.version.VersionFormatEnum;
import cerent.version.VersionFormatFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public abstract class AbstractSoftMaintPane
extends AbstractPane
implements ActionListener,
IJobListener {
    private static final String DOWNLOAD = "Download...";
    private static final String CANCEL = "Cancel...";
    private static final String ACTIVATE = "Activate...";
    private static final String REVERT = "Revert...";
    private static final String ACCEPT = "Accept...";
    private static final String FLASH_INFO = "Info...";
    private static final String DOWNLOAD_TIP = "Download package file as protect software";
    private static final String CANCEL_TIP = "Cancel the currently running download";
    private static final String ACTIVATE_TIP = "Mark newer protect software as working, and run it";
    private static final String REVERT_TIP = "Mark older protect software as working, and run it";
    private static final String ACCEPT_TIP = "Accept newer software for standby TSC as working";
    private static final String FLASH_INFO_TIP = "Current working and protect software flash info";
    protected static final String ACTIVATE_TITLE = "Activating";
    protected static final String REVERT_TITLE = "Reverting";
    protected static final String REVERT_WITH_WARNING_TITLE = "Reverting May Cause Traffic Loss";
    private String operationString = "";
    private static final String ACTIVATION_STRING = "Activation";
    private static final String REVERT_STRING = "Revert";
    private String activeVersion = "";
    private String protectVersion = "";
    private static final String OK_TO_CONTINUE = "Is it OK to continue?";
    private static final String FPGA_UPGRADE = "Any FPGA upgrades that occur during this activation\nmight affect traffic.\n\n";
    private static final String FPGA_DOWNGRADE = "Any FPGA downgrades that occur while reverting\nmight affect traffic.\n\n";
    private static final String FPGA_DOWNGRADE_2 = "<br>Also, any FPGA downgrades that occur while reverting might affect<br>traffic.";
    private static final String IOS_SAVE_CFG_MSG = "Unsaved configurations of any Cisco-IOS-based cards that are \npresent in the NE will be lost upon activating the new image.\n\n";
    protected static final String ACCEPT_ERROR_MSG = "The NE has already accepted the new software.";
    private static final String rebootMinutes15327 = "12";
    private static final String rebootMinutes15454 = "4";
    protected JButton downloadButton;
    protected JButton cancelButton;
    protected JButton activateButton;
    protected JButton revertButton;
    protected JButton acceptButton;
    protected JButton infoButton;
    protected SoftMaintDataSource dataSource;
    protected boolean buttonState = true;
    protected JobProgressDialog localProgressDialog;
    private SoftMaintTableModel tableModel;
    protected INodeModel nodeModel;
    protected ISecurityModel secModel;
    protected boolean forcedJobFinish = false;
    protected boolean isNetworkView;
    protected ArrayList<INodeModel> selectedNodes;
    private HashMap<INodeModel, JobController> jobsControllerMap;
    private HashMap<IJobControl, INodeModel> jobsMap;
    private HashMap<INodeModel, IJobProgressControl> jobProgessMap;
    protected static final SDebug db = new SDebug("SoftMaintPane");

    public AbstractSoftMaintPane(String string, INodeModel iNodeModel, TabbedView tabbedView) {
        super(string, (IModel)iNodeModel, tabbedView);
        this.nodeModel = iNodeModel;
        if (this.nodeModel != null) {
            this.secModel = this.nodeModel.getSecurityModel();
        } else {
            this.isNetworkView = true;
            this.jobsMap = new HashMap();
            this.jobProgessMap = new HashMap();
        }
        this.jobsControllerMap = new HashMap();
        if (this.secModel != null) {
            this.secModel.addObserver((Observer)((Object)this));
        }
        this.forcedJobFinish = false;
        this.dataSource = SoftMaintDataSource.instance();
        this.tableModel = new SoftMaintTableModel(this.dataSource);
        this.table = new UTable((TableModel)((Object)this.tableModel));
        ((SoftMaintTableModel)((Object)this.table.getModel())).initTable(this.table);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setAlignmentX(0.0f);
        this.setLayout(new BorderLayout());
        this.add(this.makeButtonPanel(), "South");
        this.add((Component)uScrollPane, "Center");
    }

    protected JPanel makeButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        this.downloadButton = this.makeActionButton(DOWNLOAD);
        this.downloadButton.setToolTipText(DOWNLOAD_TIP);
        this.cancelButton = this.makeActionButton(CANCEL);
        this.cancelButton.setToolTipText(CANCEL_TIP);
        jPanel2.add(this.downloadButton);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.cancelButton);
        jPanel.add((Component)jPanel2, "West");
        CSHelpID cSHelpID = this.getHelpID();
        if (this.nodeModel != null || this.isNetworkView) {
            this.activateButton = this.makeActionButton(ACTIVATE);
            this.activateButton.setToolTipText(ACTIVATE_TIP);
            this.revertButton = this.makeActionButton(REVERT);
            this.revertButton.setToolTipText(REVERT_TIP);
            jPanel3.add(this.activateButton);
            jPanel3.add(Box.createHorizontalGlue());
            jPanel3.add(this.revertButton);
            if (this.getUiModel() instanceof INodeModel && ((INodeModel)this.getUiModel()).provides(Feature.DETAILED_SW_UPGRADE)) {
                this.acceptButton = this.makeActionButton(ACCEPT);
                this.acceptButton.setToolTipText(ACCEPT_TIP);
                this.infoButton = this.makeActionButton(FLASH_INFO);
                this.infoButton.setToolTipText(FLASH_INFO_TIP);
                jPanel3.add(Box.createHorizontalGlue());
                jPanel3.add(this.acceptButton);
                jPanel3.add(Box.createHorizontalGlue());
                jPanel3.add(this.infoButton);
            }
            if (cSHelpID != null) {
                jPanel3.add(Box.createHorizontalGlue());
                jPanel3.add(new CSHelpButton(cSHelpID));
            }
            jPanel.add((Component)jPanel3, "East");
        } else if (cSHelpID != null) {
            jPanel3.add(new CSHelpButton(cSHelpID));
            jPanel.add((Component)jPanel3, "East");
        }
        return jPanel;
    }

    public CSHelpID getHelpID() {
        return null;
    }

    protected JButton makeActionButton(String string) {
        SecurityLevel securityLevel = SecurityLevel.SUPERUSER;
        JButton jButton = new JButton(string, null);
        if (string.equals(FLASH_INFO)) {
            securityLevel = SecurityLevel.RETRIEVE;
        }
        if (string.equals(DOWNLOAD) || string.equals(CANCEL)) {
            if (this.nodeModel != null) {
                if (this.nodeModel.provides(Feature.SUPPORTS_MAINTENANCE_DOWNLOAD)) {
                    securityLevel = SecurityLevel.MAINTENANCE;
                }
            } else {
                securityLevel = SecurityLevel.RETRIEVE;
            }
        }
        if (string.equals(ACTIVATE) || string.equals(REVERT) || string.equals(ACCEPT)) {
            this.enableOperationButton(jButton, Operation.ACTIVATE_REVERT_SW);
            jButton.addActionListener(this);
        } else if (this.isUserAuthorized(securityLevel)) {
            jButton.addActionListener(this);
        } else {
            jButton.setEnabled(false);
        }
        return jButton;
    }

    protected void enableOperationButton(JComponent jComponent, Operation operation) {
        block8: {
            if (!this.buttonState) {
                jComponent.setEnabled(false);
            }
            if (this.isNetworkView) {
                this.enableComponent(jComponent);
            } else if (this.nodeModel.isInited() && this.secModel != null) {
                try {
                    if (this.nodeModel != null && this.nodeModel.provides(Feature.MULTISHELF)) {
                        SecurityLevel securityLevel = this.secModel.getOperationPrivilege(operation);
                        this.enableComponent(jComponent, (IModel)this.nodeModel, securityLevel);
                    } else {
                        this.enableComponent(jComponent, (IModel)this.nodeModel);
                    }
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    if (!db.on()) break block8;
                    SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
                }
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: start");
        }
        this.requestRefresh(this, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.downloadButton) {
            SoftMaintSelDialog softMaintSelDialog = new SoftMaintSelDialog(this, this.dataSource);
            if (softMaintSelDialog.getSelectedItems().length > 0) {
                this.dataSource.download(softMaintSelDialog.getSelectedFile(), softMaintSelDialog.getSelectedItems(), softMaintSelDialog.getNumThreads());
            }
        } else if (object == this.cancelButton) {
            if (this.getUiModel() instanceof INodeModel && ((INodeModel)this.getUiModel()).provides(Feature.DETAILED_SW_UPGRADE)) {
                this.handleCancelPressDetailed();
            } else {
                this.handleCancelPress();
            }
        } else if (object == this.activateButton) {
            this.operationString = ACTIVATION_STRING;
            if (this.isNetworkView && !this.isOneNodeSelected(0)) {
                return;
            }
            this.swapVersion(4);
        } else if (object == this.revertButton) {
            this.operationString = REVERT_STRING;
            if (this.isNetworkView) {
                if (!this.isOneNodeSelected(1)) {
                    return;
                }
                this.swapVersion(5);
            } else if (this.getUiModel() instanceof INodeModel && ((INodeModel)this.getUiModel()).provides(Feature.DETAILED_SW_UPGRADE)) {
                this.handleRevertPressDetailed();
            } else {
                this.swapVersion(5);
            }
        } else if (object == this.acceptButton) {
            this.acceptSw();
        } else if (object == this.infoButton) {
            this.displayFlashInfo();
        }
    }

    private boolean isOneNodeSelected(int n) {
        SoftMaintActiveRevertDialog softMaintActiveRevertDialog = new SoftMaintActiveRevertDialog(this, this.dataSource, n);
        if (softMaintActiveRevertDialog.getSelectedItems().length > 0) {
            Object[] objectArray = softMaintActiveRevertDialog.getSelectedItems();
            this.selectedNodes = new ArrayList();
            for (int i = 0; i < objectArray.length; ++i) {
                this.selectedNodes.add(((NodeVersionInfo)objectArray[i]).getNodeModel());
            }
        } else {
            return false;
        }
        return true;
    }

    protected void handleCancelPress() {
        if (this.dataSource.isDownloadInProgress()) {
            SoftMaintCancelDialog softMaintCancelDialog = new SoftMaintCancelDialog(this, this.dataSource);
            if (softMaintCancelDialog.getSelectedItems().length > 0) {
                this.dataSource.cancelDownload(softMaintCancelDialog.getSelectedItems());
            }
        } else {
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_DOWNLOAD_NOT_INITIATED);
        }
    }

    protected abstract void handleCancelPressDetailed();

    protected abstract void handleRevertPressDetailed();

    public abstract void cancelSwUpgrade();

    public abstract void acceptSw();

    protected abstract void displayFlashInfo();

    protected void swapVersion(int n) {
        if (this.nodeModel != null) {
            Object object;
            String string;
            String string2 = "";
            boolean bl = false;
            if (n == 4) {
                string = ACTIVATE_TITLE;
                string2 = this.getMessage(ErrorMsg.getString((EID)CEMC.WID_ACTIVATE_MESSAGE), FPGA_UPGRADE, string, new INodeModel[]{this.nodeModel});
                string2 = string2.concat(OK_TO_CONTINUE);
            } else if (this.nodeModel.getNeType().startsWith("15600")) {
                string = REVERT_TITLE;
                bl = true;
            } else {
                string = REVERT_WITH_WARNING_TITLE;
                string2 = this.getRevertMessage(new INodeModel[]{this.nodeModel});
            }
            if (n == 4 && this.nodeModel.provides(Feature.ML_VERSION_UP) && this.nodeModel.getNeType().startsWith("15454") && this.nodeModel.getDelayedUpgradeModel().getAllowDelayedUpgrades()) {
                object = new DelayedUpgradeDialog((Component)((Object)this), this.nodeModel);
            }
            if (!bl && !CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)string2, (String)string)) {
                return;
            }
            try {
                this.dataReboot(this.nodeModel, n);
                object = n == 4 ? ACTIVATE_TITLE : REVERT_TITLE;
                this.dataSource.setStatusString(this.nodeModel, (String)object);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_COMMUNICATION_ERROR_PARAM_1, abstractCmsIOException.getMessage());
            }
        } else if (this.isNetworkView) {
            String string;
            String string3 = "";
            boolean bl = false;
            if (n == 4) {
                string = ACTIVATE_TITLE;
                string3 = this.getMessage(ErrorMsg.getString((EID)CEMC.WID_ACTIVATE_MESSAGE), FPGA_UPGRADE, string, this.selectedNodes.toArray(new INodeModel[0]));
                string3 = string3.concat(OK_TO_CONTINUE);
            } else if (n == 4) {
                string = ACTIVATE_TITLE;
            } else {
                string = REVERT_TITLE;
                for (INodeModel iNodeModel : this.selectedNodes) {
                    if (iNodeModel.getNeType().startsWith("15600")) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    string3 = this.getRevertMessage(this.selectedNodes.toArray(new INodeModel[0]));
                }
            }
            if (!bl && !CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)string3, (String)string)) {
                return;
            }
            for (INodeModel iNodeModel : this.selectedNodes) {
                try {
                    this.dataReboot(iNodeModel, n);
                    String string4 = n == 4 ? ACTIVATE_TITLE : REVERT_TITLE;
                    this.dataSource.setStatusString(iNodeModel, string4);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_COMMUNICATION_ERROR_PARAM_1, abstractCmsIOException.getMessage());
                }
            }
        }
    }

    private void dataReboot(INodeModel iNodeModel, int n) {
        IJobControl iJobControl;
        NodeVersionInfo nodeVersionInfo;
        String string = "";
        JobController jobController = null;
        string = n == 4 ? ACTIVATE_TITLE : REVERT_TITLE;
        String string2 = this.getLabelText(iNodeModel, this.operationString);
        if (!iNodeModel.getNeType().startsWith("15600")) {
            this.localProgressDialog = new JobProgressDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), string, string2, false, false, 2000);
            nodeVersionInfo = this.localProgressDialog;
        } else {
            nodeVersionInfo = this.dataSource.getNodeVerInfo(iNodeModel);
        }
        jobController = JobControllerFactory.createJC((int)1);
        this.jobsControllerMap.put(iNodeModel, jobController);
        if (this.isNetworkView) {
            this.jobProgessMap.put(iNodeModel, nodeVersionInfo);
            if (this.localProgressDialog != null) {
                this.localProgressDialog.setLocation(this.localProgressDialog.getLocation().x, this.localProgressDialog.getLocation().y + this.jobProgessMap.size() * 50);
            }
        }
        try {
            iJobControl = iNodeModel.createDataRebootJob(n, (IJobProgressControl)nodeVersionInfo);
            if (this.isNetworkView) {
                this.jobsMap.put(iJobControl, iNodeModel);
            }
        }
        catch (Exception exception) {
            if (this.localProgressDialog != null && !this.isNetworkView) {
                this.localProgressDialog.dispose();
                this.localProgressDialog = null;
                JobControllerFactory.disposeJC((JobController)jobController);
                this.jobsControllerMap.remove(iNodeModel);
            } else if (this.isNetworkView) {
                if (this.jobProgessMap.get(iNodeModel) instanceof JobProgressDialog) {
                    ((JobProgressDialog)this.jobProgessMap.get(iNodeModel)).dispose();
                    this.jobProgessMap.remove(iNodeModel);
                }
                JobControllerFactory.disposeJC((JobController)jobController);
                this.jobsControllerMap.remove(iNodeModel);
            }
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_REBOOT_FAILED_PARAM_1, (Object)exception.getMessage());
            return;
        }
        jobController.submitJob(new JobGroup(iJobControl, (IJobListener)this, (Object)jobController));
        this.buttonState = false;
        this.runToggleButtons(false);
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobFinished(JobGroup jobGroup, final IJobControl iJobControl, final JobStatus jobStatus, final Object object) {
        if (this.isNetworkView) {
            INodeModel iNodeModel = this.jobsMap.get(iJobControl);
            if (this.jobProgessMap.get(iNodeModel) instanceof JobProgressDialog) {
                ((JobProgressDialog)this.jobProgessMap.get(iNodeModel)).dispose();
            }
        } else if (this.localProgressDialog != null) {
            this.localProgressDialog.dispose();
            this.localProgressDialog = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractSoftMaintPane.this.finishJob(jobStatus, (JobController)object, iJobControl);
            }
        });
    }

    public void forceJobFinish(INodeModel iNodeModel) {
        NodeVersionInfo nodeVersionInfo;
        if (this.isNetworkView) {
            if (this.jobProgessMap.get(iNodeModel) instanceof JobProgressDialog) {
                ((JobProgressDialog)this.jobProgessMap.get(iNodeModel)).dispose();
                this.jobProgessMap.remove(iNodeModel);
            }
        } else if (this.localProgressDialog != null) {
            this.localProgressDialog.dispose();
            this.forcedJobFinish = true;
            this.localProgressDialog = null;
        } else {
            this.forcedJobFinish = false;
            return;
        }
        if ((nodeVersionInfo = this.dataSource.getNodeVerInfo(iNodeModel)) != null) {
            nodeVersionInfo.forceDefault();
        }
        this.buttonState = true;
        this.toggleButtons();
        JobController jobController = this.jobsControllerMap.remove(iNodeModel);
        JobControllerFactory.disposeJC((JobController)jobController);
        String string = "???";
        try {
            string = iNodeModel.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ErrorMsg.displayWarning((Component)((Object)this), (EID)CEMC.WID_UNKNOWN_DOWNLOAD_OP_STATUS_PARAM_2, this.operationString, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishJob(JobStatus jobStatus, JobController jobController, IJobControl iJobControl) {
        Object object;
        INodeModel iNodeModel = this.nodeModel;
        String string = "???";
        if (this.isNetworkView) {
            object = this;
            synchronized (object) {
                iNodeModel = this.jobsMap.remove(iJobControl);
                this.jobProgessMap.remove(iNodeModel);
            }
        }
        try {
            string = iNodeModel.getName();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        if (jobStatus.value() == 2) {
            object = (Exception)jobStatus.getResult();
            if (object != null) {
                if (object instanceof IOException) {
                    ErrorMsg.displayWarning((Component)((Object)this), (EID)CEMC.WID_UNKNOWN_DOWNLOAD_OP_STATUS_PARAM_2, this.operationString, string);
                } else {
                    SDebug.printStackTrace((Throwable)object);
                    if (!this.forcedJobFinish) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_JOB_FAIL_MESSAGE_PARAM_1, (Object)("Node " + string + ":" + "\n" + ((Throwable)object).getMessage()));
                    } else {
                        this.forcedJobFinish = false;
                    }
                }
            }
        } else if (jobStatus.value() == 4) {
            object = rebootMinutes15454;
            if (iNodeModel != null && iNodeModel.getNeType().equals("15327")) {
                object = rebootMinutes15327;
            }
            String string2 = this.getLabelText(iNodeModel, this.operationString) + " successful, node will reboot.\n" + "This might take up to " + (String)object + " minutes ...";
            CerentDialog.infoDialog((Component)((Object)this), (String)string2, (String)"Rebooting");
        }
        this.buttonState = true;
        this.toggleButtons();
        this.dataSource.setStatusString(iNodeModel, "");
        if (jobController != null && jobController.isIdle() && !this.isNetworkView) {
            JobControllerFactory.disposeJC((JobController)jobController);
        } else if (this.isNetworkView && this.jobProgessMap.isEmpty()) {
            JobControllerFactory.disposeJC((JobController)jobController);
        }
    }

    private void runToggleButtons(boolean bl) {
        this.buttonState = bl;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractSoftMaintPane.this.toggleButtons();
            }
        });
    }

    protected void toggleButtons() {
        this.downloadButton.setEnabled(this.buttonState);
        this.cancelButton.setEnabled(this.buttonState);
        if (this.activateButton != null) {
            this.enableOperationButton(this.activateButton, Operation.ACTIVATE_REVERT_SW);
            this.enableOperationButton(this.revertButton, Operation.ACTIVATE_REVERT_SW);
        }
        if (this.acceptButton != null) {
            this.enableOperationButton(this.acceptButton, Operation.ACTIVATE_REVERT_SW);
        }
    }

    protected INodeModel getNodeModel() {
        IModel iModel = this.getUiModel();
        return iModel instanceof INodeModel ? (INodeModel)iModel : null;
    }

    public void enteringPage() {
        this.dataSource.setNodeModel(this.nodeModel);
        this.dataSource.update();
    }

    public void leavingPage() throws Exception {
        this.dataSource.setNodeModel(null);
    }

    public void refresh() {
        if (db.on()) {
            db.println("Refreshing pane");
        }
        if (this.activateButton != null) {
            this.enableOperationButton(this.activateButton, Operation.ACTIVATE_REVERT_SW);
            this.enableOperationButton(this.revertButton, Operation.ACTIVATE_REVERT_SW);
        }
        if (this.acceptButton != null) {
            this.enableOperationButton(this.acceptButton, Operation.ACTIVATE_REVERT_SW);
        }
    }

    private String getActiveVersion() {
        if (this.activeVersion.equals("DEV")) {
            return this.activeVersion;
        }
        return this.getVersionString(this.activeVersion);
    }

    private int getMajorVersion(String string) {
        try {
            String string2 = string.substring(0, 1);
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private int getMinorVersion(String string) {
        try {
            String string2 = string.substring(2, 3);
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private String getProtectVersion() {
        try {
            if (this.protectVersion.equals("DEV")) {
                return this.protectVersion;
            }
            return this.getVersionString(this.protectVersion);
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    private String getVersionString(String string) {
        return VersionFormatFactory.parseIntoString((VersionFormatEnum)VersionFormatEnum.FULL_VERSION, (String)string);
    }

    private String getHtmlMessage(String string, String string2, INodeModel iNodeModel) {
        String string3 = "";
        if (iNodeModel == null || !iNodeModel.getNeType().startsWith("15600")) {
            string3 = FPGA_DOWNGRADE_2;
        }
        if (string2 != null) {
            string2 = string2.concat("<br>");
            return ErrorMsg.getString((EID)CEMC.WID_REVERT_MESSAGE_4, (Object)string, (Object)string3, (Object)string2, (Object)OK_TO_CONTINUE);
        }
        return ErrorMsg.getString((EID)CEMC.WID_REVERT_MESSAGE_3, (Object)string, (Object)string3, (Object)OK_TO_CONTINUE);
    }

    private String getMessage(String string, String string2, String string3, INodeModel[] iNodeModelArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (INodeModel iNodeModel : iNodeModelArray) {
            if (iNodeModel != null && iNodeModel.getNeType().startsWith("15600")) continue;
            stringBuffer.append(string2);
            if (!string3.equals(ACTIVATE_TITLE)) break;
            stringBuffer.append(IOS_SAVE_CFG_MSG);
            break;
        }
        return stringBuffer.toString();
    }

    public String getRevertMessage(INodeModel[] iNodeModelArray) {
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (INodeModel iNodeModel : iNodeModelArray) {
            Object object;
            if (iNodeModel.provides(Feature.BERT) && iNodeModel.getNeType().equals("15454")) {
                object = iNodeModel.getChassisModels();
                block1: for (int i = 0; i < ((IEntityModel[])object).length; ++i) {
                    IEntityModel iEntityModel = object[i];
                    if (iEntityModel == null) continue;
                    List list = iEntityModel.getDescendantsOfClassType(1);
                    IEntityModel iEntityModel2 = (IEntityModel)list.get(0);
                    List list2 = iEntityModel2.getDescendantsOfClassType(6);
                    for (IEntityModel iEntityModel3 : list2) {
                        if (iEntityModel3.getEqType() != 218 && iEntityModel3.getEqType() != 145) continue;
                        bl = true;
                        continue block1;
                    }
                }
                if (bl && !bl2) {
                    stringBuffer2.append("Traffic will be affected if BERT is not disabled on the DS3XM-12 and the DS1/E1-56 cards.\n");
                    bl2 = true;
                }
            } else if (((INodeModel)this.getUiModel()).provides(Feature.BERT) && iNodeModel.getNeType().equalsIgnoreCase("15310MA")) {
                object = iNodeModel.getChassisModels();
                block3: for (int i = 0; i < ((IEntityModel[])object).length; ++i) {
                    Object object2 = object[i];
                    if (object2 == null) continue;
                    List list = object2.getDescendantsOfClassType(1);
                    IEntityModel iEntityModel = (IEntityModel)list.get(0);
                    List list3 = iEntityModel.getDescendantsOfClassType(6);
                    for (IEntityModel iEntityModel3 : list3) {
                        if (iEntityModel3.getEqType() != 234 && iEntityModel3.getEqType() != 233) continue;
                        bl = true;
                        continue block3;
                    }
                }
                if (bl && !bl3) {
                    stringBuffer2.append("Traffic will be affected if BERT is not disabled on the WBBE-28 and WBBE-84 cards.\n");
                    bl3 = true;
                }
            }
            if (!this.getNeVersion(iNodeModel) || stringBuffer != null) continue;
            object = this.getActiveVersion();
            String string = this.getProtectVersion();
            if (((String)object).length() <= 3 || string.length() <= 3) continue;
            int n = this.getMajorVersion((String)object);
            int n2 = this.getMinorVersion((String)object);
            int n3 = this.getMajorVersion(string);
            int n4 = this.getMinorVersion(string);
            if (AbstractSoftMaintPane.db.on) {
                db.println("Active[Major=" + n + " Minor=" + n2 + "] Prot[Major=" + n3 + " Minor=" + n4 + "]");
            }
            if (n == n3 && n2 == n4) continue;
            stringBuffer = new StringBuffer();
            stringBuffer.append(this.getHtmlMessage(string, stringBuffer2.toString(), iNodeModel));
        }
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(this.getMessage(ErrorMsg.getString((EID)CEMC.WID_REVERT_MESSAGE_0), FPGA_DOWNGRADE, REVERT_TITLE, iNodeModelArray));
            if (stringBuffer2.length() > 0) {
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append("\n\n");
            }
            stringBuffer.append(OK_TO_CONTINUE);
        }
        return stringBuffer.toString();
    }

    public boolean getNeVersion(INodeModel iNodeModel) {
        StringHolder[] stringHolderArray = new StringHolder[]{new StringHolder(), new StringHolder()};
        int n = -1;
        if (iNodeModel == null) {
            if (AbstractSoftMaintPane.db.on) {
                db.println("refresh: nodeModel is null");
            }
            return false;
        }
        try {
            if (iNodeModel.provides(Feature.REMOTE_ELE_V1)) {
                n = iNodeModel.queryCodeVol(stringHolderArray[0], stringHolderArray[1]);
            } else {
                org.omg.CORBA.StringHolder[] stringHolderArray2 = new org.omg.CORBA.StringHolder[]{new org.omg.CORBA.StringHolder(), new org.omg.CORBA.StringHolder()};
                n = iNodeModel.queryCodeVol(stringHolderArray2[0], stringHolderArray2[1]);
                stringHolderArray[0].setValue(stringHolderArray2[0].value);
                stringHolderArray[1].setValue(stringHolderArray2[1].value);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return false;
        }
        if (AbstractSoftMaintPane.db.on) {
            db.println("Flash volume " + n + " is active" + "\nSoftware Version in partition flash0: " + BuildInfo.sanitize(stringHolderArray[0].toString()) + "\nSoftware Version in partition flash1: " + BuildInfo.sanitize(stringHolderArray[1].toString()));
        }
        if (n == 0 || n == 1) {
            if (stringHolderArray[n].toString() != null) {
                this.activeVersion = BuildInfo.sanitize(stringHolderArray[n].toString());
            }
            if (stringHolderArray[1 - n].toString() != null) {
                this.protectVersion = BuildInfo.sanitize(stringHolderArray[1 - n].toString());
            }
            if (AbstractSoftMaintPane.db.on) {
                db.println("Active Version is " + this.activeVersion);
                db.println("Protect Version is" + this.protectVersion);
            }
            return true;
        }
        return false;
    }

    public SecurityLevel getPrivilegeLevel() {
        return this.getDefaultPrivilegeLevel();
    }

    public void destroy() {
        this.tableModel.release();
        if (this.secModel != null) {
            this.secModel.deleteObserver((Observer)((Object)this));
            this.secModel = null;
        }
        if (this.activateButton != null) {
            this.activateButton.removeActionListener(this);
        }
        if (this.revertButton != null) {
            this.revertButton.removeActionListener(this);
        }
        if (this.acceptButton != null) {
            this.acceptButton.removeActionListener(this);
        }
        super.destroy();
    }

    public boolean isActivationRevert() {
        return this.operationString.equals(REVERT_STRING) || this.operationString.equals(ACTIVATION_STRING);
    }

    private String getLabelText(INodeModel iNodeModel, String string) {
        String string2 = string.equals(ACTIVATION_STRING) ? ACTIVATE_TITLE : REVERT_TITLE;
        String string3 = "";
        try {
            string3 = iNodeModel.getName() + ": " + string2;
        }
        catch (Exception exception) {
            string3 = string2;
        }
        if (this.getNeVersion(iNodeModel)) {
            string3 = string3 + " to " + this.protectVersion;
        }
        return string3;
    }
}

