/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds123;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Ds123Media.eClockSource;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSignalMode;
import cerent.cms.idl.Ds123Media.sConfig;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.IAdminTableAccess;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.SoakTimePropertyEditor;
import javax.swing.table.AbstractTableModel;

public class Ds123LineTableModel
extends AbstractTableModel
implements IAdminTableAccess {
    protected Ds123LineModel[] model;
    protected boolean[][] isDirty;
    protected INodeModel node;
    private AdminState[] adminState;
    private IServiceState[] serviceState;
    private Attribute[] clockSource;
    private Attribute[] lineType;
    private Attribute[] detectedLineType;
    private Attribute[] lineCoding;
    private Attribute[] lineLength;
    private Attribute[] signalMode;
    private Attribute[] sfBerLevel;
    private Attribute[] sdBerLevel;
    private Attribute[] fdlMode;
    private int[] soakTime;
    private Boolean[] sendAISVForDefects;
    private Boolean[] treatLOFAsDefect;
    protected int numLines;
    private sConfig[] configStructures;
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int SERVICE_STATE_INDEX = 3;
    public static final int CLOCKSOURCE_INDEX = 4;
    public static final int SFBERLEVEL_INDEX = 5;
    public static final int SDBERLEVEL_INDEX = 6;
    public static final int LINETYPE_INDEX = 7;
    public static final int DETECTED_LINETYPE_INDEX = 8;
    public static final int LINECODING_INDEX = 9;
    public static final int SIGNALMODE_INDEX = 10;
    public static final int LINELENGTH_INDEX = 11;
    public static final int SOAK_TIME_INDEX = 12;
    public static final int FDL_MODE_INDEX = 13;
    public static final int SNDAISVONDEFS_INDEX = 14;
    public static final int TREATLOFASDEF_INDEX = 15;
    public static final int DS123_LAST_COLUMN = 15;
    public static final String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Service State", "Clock Source", "SF BER", "SD BER", "Line Type", "Detected Line Type", "Line Coding", "Signal Mode", "Line Length", "AINS Soak", "FDL Mode", "Send AIS-V On Defects", "Treat LOF As Defect"};
    protected String[] portNums;
    private String[] portNames;
    protected String sdString;
    protected String sfString;
    protected static final SDebug db = new SDebug("Ds123LineTable");

    public Ds123LineTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        this.model = ds123LineModelArray;
        this.node = iNodeModel;
        this.init();
    }

    protected void init() {
        if (this.model != null) {
            this.numLines = this.model.length;
        }
        this.portNums = new String[this.numLines];
        this.portNames = new String[this.numLines];
        this.sfBerLevel = new Attribute[this.numLines];
        this.sdBerLevel = new Attribute[this.numLines];
        this.clockSource = new Attribute[this.numLines];
        this.lineType = new Attribute[this.numLines];
        this.detectedLineType = new Attribute[this.numLines];
        this.lineCoding = new Attribute[this.numLines];
        this.signalMode = new Attribute[this.numLines];
        this.lineLength = new Attribute[this.numLines];
        this.configStructures = new sConfig[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.soakTime = new int[this.numLines];
        this.sendAISVForDefects = new Boolean[this.numLines];
        this.treatLOFAsDefect = new Boolean[this.numLines];
        this.fdlMode = new Attribute[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.sdString = "declareSdBerLevel";
        this.sfString = "declareSfBerLevel";
        for (int i = 0; i < this.numLines; ++i) {
            this.soakTime[i] = -1;
        }
        this.resetDirtyBits();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 14: 
            case 15: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(n);
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap((IModel)this.node);
    }

    protected Attribute getAttributeFor(Object object, int n) {
        return this.getAttributeMap().getAttributeForVal("DS123." + object.getClass().getName(), n);
    }

    protected Attribute getDetectedAttributeFor(Object object, int n) {
        return this.getAttributeMap().getAttributeForVal("DS123." + object.getClass().getName() + ".detected", n);
    }

    protected Attribute getLineLengthAttributeFor(int n) {
        return this.getAttributeMap().getAttributeForVal("DS123.Line Length", n);
    }

    protected Attribute getFdlModeAttributeFor(int n) {
        return this.getAttributeMap().getAttributeForVal("DS123.FdlModeMask", n);
    }

    private Attribute getClockSource(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.clockSource[n] == null) {
            eClockSource eClockSource2 = this.getConfigStructure((int)n).clockSource;
            this.clockSource[n] = this.getAttributeFor(eClockSource2, eClockSource2.value());
        }
        return this.clockSource[n];
    }

    protected Attribute getLineType(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineType[n] == null) {
            eLineType eLineType2 = this.getConfigStructure((int)n).lineType;
            this.lineType[n] = this.getAttributeFor(eLineType2, eLineType2.value());
        }
        return this.lineType[n];
    }

    private Attribute getDetectedLineType(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.detectedLineType[n] == null) {
            eLineType eLineType2 = this.model[n].getReceivedFrameFormat();
            this.detectedLineType[n] = this.getDetectedAttributeFor(eLineType2, eLineType2.value());
        }
        return this.detectedLineType[n];
    }

    protected Attribute getLineCoding(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineCoding[n] == null) {
            eLineCoding eLineCoding2 = this.getConfigStructure((int)n).lineCoding;
            this.lineCoding[n] = this.getAttributeFor(eLineCoding2, eLineCoding2.value());
        }
        return this.lineCoding[n];
    }

    protected Boolean getSndAISVForDefects(int n) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, AbstractCmsNoSuchEntityException {
        if (this.sendAISVForDefects[n] == null) {
            this.sendAISVForDefects[n] = new Boolean(((Ds1LineModel)this.model[n]).getSndAISVForDs1AISEnabled());
        }
        return this.sendAISVForDefects[n];
    }

    protected Boolean getTreatLOFAsDefect(int n) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType {
        if (this.treatLOFAsDefect[n] == null) {
            this.treatLOFAsDefect[n] = new Boolean(((Ds1LineModel)this.model[n]).getRaiseDs1AISForLOFEnabled());
        }
        return this.treatLOFAsDefect[n];
    }

    private Attribute getSignalMode(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.signalMode[n] == null) {
            eSignalMode eSignalMode2 = this.getConfigStructure((int)n).signalMode;
            this.signalMode[n] = this.getAttributeFor(eSignalMode2, eSignalMode2.value());
        }
        return this.signalMode[n];
    }

    protected Attribute getLineLength(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineLength[n] == null) {
            int n2 = this.getConfigStructure((int)n).lineLength;
            int n3 = this.getRangeFor(n2);
            if (db.on()) {
                db.println("line Length from switch for " + n + " is : " + n2);
            }
            this.lineLength[n] = this.getLineLengthAttributeFor(n3);
        }
        return this.lineLength[n];
    }

    private Attribute getFdlMode(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.fdlMode[n] == null) {
            int n2 = this.getConfigStructure((int)n).fdlModeMask;
            this.fdlMode[n] = this.getFdlModeAttributeFor(n2);
        }
        return this.fdlMode[n];
    }

    private sConfig getConfigStructure(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.configStructures[n] == null) {
            this.configStructures[n] = this.model[n].getConfig();
        }
        return this.configStructures[n];
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 1: {
                this.portNames[n] = (String)object;
                break;
            }
            case 2: {
                this.adminState[n] = (AdminState)object;
                break;
            }
            case 5: {
                this.sfBerLevel[n] = (Attribute)object;
                break;
            }
            case 6: {
                this.sdBerLevel[n] = (Attribute)object;
                break;
            }
            case 7: {
                this.lineType[n] = (Attribute)object;
                break;
            }
            case 9: {
                this.lineCoding[n] = (Attribute)object;
                break;
            }
            case 11: {
                this.lineLength[n] = (Attribute)object;
                break;
            }
            case 12: {
                try {
                    this.soakTime[n] = SoakTimePropertyEditor.toIntValue((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    db.fine("Number Format Exception on " + (String)object);
                }
                break;
            }
            case 13: {
                this.fdlMode[n] = (Attribute)object;
                break;
            }
            case 14: {
                this.sendAISVForDefects[n] = (Boolean)object;
                break;
            }
            case 15: {
                this.treatLOFAsDefect[n] = (Boolean)object;
                break;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getSoakTime(int n) throws NoSuchInterface {
        if (this.soakTime[n] == -1) {
            this.soakTime[n] = this.model[n].getSoakTime();
        }
        return this.soakTime[n];
    }

    protected boolean canEditAdminState(int n) {
        return true;
    }

    protected boolean isPhysicalPort(int n) {
        return true;
    }

    protected boolean canEditSendAISVOnDefects(int n) {
        try {
            ModuleModel moduleModel = this.model[0].getModuleModel();
            return !moduleModel.mustTheBoardAlwaysSendAISVOnDefects();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.println("Caught exception in canEditSendAISVOnDefects!");
            if (db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return false;
        }
    }

    protected boolean canEditLineType(int n) {
        return true;
    }

    public boolean isCellEditable(int n, int n2) {
        block8: {
            if (this.model != null && this.numLines > 0 && n2 != 3) {
                try {
                    if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                        if (n2 == 2) {
                            return this.canEditAdminState(n);
                        }
                        if (n2 == 9 || n2 == 11 || n2 == 5 || n2 == 6) {
                            return this.isPhysicalPort(n);
                        }
                        if (n2 == 14) {
                            return this.canEditSendAISVOnDefects(n);
                        }
                        if (n2 == 7) {
                            return this.canEditLineType(n);
                        }
                        return n2 > 0 && n2 != 8;
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Caught exception in isCellEditable!");
                    if (!db.on()) break block8;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public static boolean between(int n, int n2, int n3) {
        return n3 > n && n3 <= n2;
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortNum(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 2: {
                    return this.getAdminState(n).toString(this.getTerms());
                }
                case 3: {
                    return this.getServiceState(n).toString(this.getTerms());
                }
                case 5: {
                    return this.getSfBerLevelIndex(n);
                }
                case 6: {
                    return this.getSdBerLevelIndex(n);
                }
                case 7: {
                    return this.getLineType(n);
                }
                case 8: {
                    return this.getDetectedLineType(n);
                }
                case 9: {
                    return this.getLineCoding(n);
                }
                case 11: {
                    return this.getLineLength(n);
                }
                case 12: {
                    return this.getSoakTimeString(n);
                }
                case 13: {
                    return this.getFdlMode(n);
                }
                case 14: {
                    return this.getSndAISVForDefects(n);
                }
                case 15: {
                    return this.getTreatLOFAsDefect(n);
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in getValueAt in Ds123LineTableModel " + exception);
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    protected String getPortNum(int n) {
        if (this.portNums[n] == null) {
            try {
                this.portNums[n] = PortHelper.getPortNumAndTypeString((IPortModel)this.model[n].getPortModel(), (boolean)false, (boolean)true);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return this.portNums[n];
    }

    public String getPortName(int n) throws NoSuchInterface {
        if (this.portNames[n] == null) {
            this.portNames[n] = this.model[n].getAlias();
        }
        return this.portNames[n];
    }

    protected Attribute getSdBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sdBerLevel[n] == null) {
            this.sdBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sdString, this.model[n].getSdBerLevel());
        }
        return this.sdBerLevel[n];
    }

    protected Attribute getSfBerLevelIndex(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.sfBerLevel[n] == null) {
            this.sfBerLevel[n] = this.getAttributeMap().getAttributeForVal(this.sfString, this.model[n].getSfBerLevel());
        }
        return this.sfBerLevel[n];
    }

    public sConfig getConfig(int n) throws NoSuchInterface, WrongInterfaceType {
        eClockSource eClockSource2 = eClockSource.LOCAL_TIMING;
        if (this.lineType[n] == null) {
            this.getLineType(n);
        }
        eLineType eLineType2 = eLineType.from_int(this.lineType[n].getIntValue());
        eSignalMode eSignalMode2 = eSignalMode.NO_SIGNALING;
        if (this.lineCoding[n] == null) {
            this.getLineCoding(n);
        }
        eLineCoding eLineCoding2 = eLineCoding.from_int(this.lineCoding[n].getIntValue());
        if (this.lineLength[n] == null) {
            this.getLineLength(n);
        }
        int n2 = this.lineLength[n].getIntValue();
        if (db.on()) {
            db.println("Value for line length for row " + n + " is " + n2);
        }
        if (this.fdlMode[n] == null) {
            this.getFdlMode(n);
        }
        int n3 = this.fdlMode[n].getIntValue();
        return new sConfig(eClockSource2, eLineType2, eLineCoding2, eSignalMode2, n2, n3);
    }

    public AdminState getAdminState(int n) throws NoSuchInterface {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private String getSoakTimeString(int n) throws NoSuchInterface {
        return SoakTimePropertyEditor.toStringHHMM(this.getSoakTime(n));
    }

    public void refreshFromModel() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            this.portNums[i] = null;
            this.sfBerLevel[i] = null;
            this.sdBerLevel[i] = null;
            this.portNames[i] = null;
            this.signalMode[i] = null;
            this.clockSource[i] = null;
            this.lineType[i] = null;
            this.detectedLineType[i] = null;
            this.lineCoding[i] = null;
            this.lineLength[i] = null;
            this.fdlMode[i] = null;
            this.configStructures[i] = null;
            this.adminState[i] = null;
            this.serviceState[i] = null;
            this.soakTime[i] = -1;
            this.sendAISVForDefects[i] = null;
            this.treatLOFAsDefect[i] = null;
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        this.portNums[n] = null;
        this.portNames[n] = null;
        this.sfBerLevel[n] = null;
        this.sdBerLevel[n] = null;
        this.signalMode[n] = null;
        this.clockSource[n] = null;
        this.lineType[n] = null;
        this.detectedLineType[n] = null;
        this.lineCoding[n] = null;
        this.lineLength[n] = null;
        this.fdlMode[n] = null;
        this.configStructures[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.soakTime[n] = -1;
        this.sendAISVForDefects[n] = null;
        this.treatLOFAsDefect[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    protected int getRangeFor(int n) {
        if (Ds123LineTableModel.between(0, 225, n)) {
            return 225;
        }
        return 450;
    }

    protected eAdminState getAdminStateFor(int n) throws NoSuchInterface {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isAdminStateDirty(int n) {
        boolean bl = false;
        try {
            bl = this.isRowDirty(n) && this.getAdminStateFor(n) != this.model[n].getAdminStateEnum();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private TDMTerminology getTerms() {
        return this.node.getTDMTerminology();
    }
}

