/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds123;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.InterfaceModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.GeneralPmThresholdsPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PmThresholdButtonPanel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.sonet.HoPathPmThresholdsPane;
import cerent.cms.ui.sonet.LoPathPmThresholdsPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public abstract class Ds123SonetPmThresholdsPane
extends AbstractPane {
    protected InterfaceModel[] models;
    protected SonetThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected GeneralPmThresholdsPane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected static final String FE_VT_1DAY_PANEL = "FE_VT_1DAY";
    protected static final String FE_VT_15MIN_PANEL = "FE_VT_15MIN";
    protected static final String FE_STS_1DAY_PANEL = "FE_STS_1DAY";
    protected static final String FE_STS_15MIN_PANEL = "FE_STS_15MIN";
    protected static final String NE_VT_1DAY_PANEL = "NE_VT_1DAY";
    protected static final String NE_VT_15MIN_PANEL = "NE_VT_15MIN";
    protected static final String NE_STS_1DAY_PANEL = "NE_STS_1DAY";
    protected static final String NE_STS_15MIN_PANEL = "NE_STS_15MIN";
    protected static final int FE_VT_1DAY = 7;
    protected static final int FE_VT_15MIN = 6;
    protected static final int FE_STS_1DAY = 5;
    protected static final int FE_STS_15MIN = 4;
    protected static final int NE_VT_1DAY = 3;
    protected static final int NE_VT_15MIN = 2;
    protected static final int NE_STS_1DAY = 1;
    protected static final int NE_STS_15MIN = 0;
    private static final SDebug db = new SDebug("Pane.Ds123SonetPmThresholdsPane");

    public Ds123SonetPmThresholdsPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray) {
        super(string, tabbedView);
        if (db.on()) {
            db.println("<init>( " + string + ", " + tabbedView.getClass().getName() + ", " + "InterfaceModels[ " + interfaceModelArray.length + "] )");
        }
        this.models = interfaceModelArray;
        this.panes = new GeneralPmThresholdsPane[8];
        this.initializeLayout();
        this.showPanel(0);
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "North");
        this.add(this.getTablePanel(), "Center");
    }

    protected SonetThresholdButtonPanel getButtonPanel() {
        this.buttonPanel = new SonetThresholdButtonPanel();
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        return this.tablePanel;
    }

    protected HoPathPmThresholdsPane getHoPathPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new HoPathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, this.getStsLevel(), true);
    }

    protected LoPathPmThresholdsPane getLoPathPmThresholdsPane(String string, eIntervalType eIntervalType2, boolean bl) {
        return new LoPathPmThresholdsPane(string, this.getParentView(), this.models, eIntervalType2, bl, this.getVtLevel());
    }

    protected abstract int getVtLevel();

    protected abstract int getStsLevel();

    protected boolean showVts() {
        return true;
    }

    protected boolean showFarEnd() {
        return true;
    }

    protected GeneralPmThresholdsPane createAndAddPanel(int n) {
        GeneralPmThresholdsPane generalPmThresholdsPane = this.panes[n];
        if (generalPmThresholdsPane == null) {
            switch (n) {
                case 7: {
                    generalPmThresholdsPane = this.getLoPathPmThresholdsPane(FE_VT_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false);
                    break;
                }
                case 6: {
                    generalPmThresholdsPane = this.getLoPathPmThresholdsPane(FE_VT_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false);
                    break;
                }
                case 5: {
                    generalPmThresholdsPane = this.getHoPathPmThresholdsPane(FE_STS_1DAY_PANEL, eIntervalType.INTERVAL_DAY, false);
                    break;
                }
                case 4: {
                    generalPmThresholdsPane = this.getHoPathPmThresholdsPane(FE_STS_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, false);
                    break;
                }
                case 3: {
                    generalPmThresholdsPane = this.getLoPathPmThresholdsPane(NE_VT_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true);
                    break;
                }
                case 2: {
                    generalPmThresholdsPane = this.getLoPathPmThresholdsPane(NE_VT_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
                    break;
                }
                case 1: {
                    generalPmThresholdsPane = this.getHoPathPmThresholdsPane(NE_STS_1DAY_PANEL, eIntervalType.INTERVAL_DAY, true);
                    break;
                }
                default: {
                    generalPmThresholdsPane = this.getHoPathPmThresholdsPane(NE_STS_15MIN_PANEL, eIntervalType.INTERVAL_15_MIN, true);
                }
            }
            this.panes[n] = generalPmThresholdsPane;
            if (db.on()) {
                db.println("adding " + (Object)((Object)generalPmThresholdsPane));
            }
            this.tablePanel.add((Component)((Object)generalPmThresholdsPane), generalPmThresholdsPane.getName());
        }
        return generalPmThresholdsPane;
    }

    protected void showPanel(int n) {
        if (db.on()) {
            db.println("showPanel( " + n + " )");
        }
        try {
            if (this.currentPane != null) {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in showPanel " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
        }
        GeneralPmThresholdsPane generalPmThresholdsPane = this.createAndAddPanel(n);
        try {
            generalPmThresholdsPane.enteringPage();
            TablePropertyMgr.getColumnPrefs(generalPmThresholdsPane.getTable(), ((Object)((Object)this)).getClass().getName() + generalPmThresholdsPane.getName());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.cl.show(this.tablePanel, generalPmThresholdsPane.getName());
        this.currentPane = generalPmThresholdsPane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (this.panes[i] == null) continue;
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + this.panes[i].getName());
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected class SonetThresholdButtonPanel
    extends PmThresholdButtonPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonNE;
        public JRadioButton buttonFE;
        public JRadioButton buttonVt;
        public JRadioButton buttonSts;
        public ButtonGroup periodButtonGroup;
        public ButtonGroup endButtonGroup;
        public ButtonGroup secStsButtonGroup;
        protected int FE_MASK = 4;
        protected int VT_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        public SonetThresholdButtonPanel() {
            this.initialize();
            if (!Ds123SonetPmThresholdsPane.this.showVts()) {
                this.buttonVt.setEnabled(false);
            }
            if (!Ds123SonetPmThresholdsPane.this.showFarEnd()) {
                this.buttonFE.setEnabled(false);
            }
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonNE = new JRadioButton("Near End", true);
            this.buttonFE = new JRadioButton("Far End");
            this.buttonVt = new JRadioButton("VT");
            this.buttonSts = new JRadioButton("STS", true);
            this.secStsButtonGroup = new ButtonGroup();
            this.secStsButtonGroup.add(this.buttonVt);
            this.secStsButtonGroup.add(this.buttonSts);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.endButtonGroup = new ButtonGroup();
            this.endButtonGroup.add(this.buttonNE);
            this.endButtonGroup.add(this.buttonFE);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buttonNE, "North");
            jPanel.add((Component)this.buttonFE, "South");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)this.buttonSts, "North");
            jPanel3.add((Component)this.buttonVt, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(jPanel3);
            this.addShowButton();
            this.addResetToDefaultButton();
            this.setPreferredSize(new Dimension(800, 50));
        }

        protected int getUserRadioButtonChoiceMask() {
            int n = 0;
            if (this.endButtonGroup.getSelection() == this.buttonFE.getModel()) {
                n |= this.FE_MASK;
            }
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                n |= this.ONE_DAY_MASK;
            }
            if (this.secStsButtonGroup.getSelection() == this.buttonVt.getModel()) {
                n |= this.VT_MASK;
            }
            return n;
        }

        protected GeneralPmThresholdsPane getPanel(int n) {
            return Ds123SonetPmThresholdsPane.this.createAndAddPanel(n);
        }

        protected void displayPanel(int n) {
            Ds123SonetPmThresholdsPane.this.showPanel(n);
        }
    }
}

