/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1e1;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.model.Attribute;
import cerent.cms.model.Busy;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds1.Ds1LineMaintenancePane;
import cerent.cms.ui.ds123.Ds123LineMaintTableModel;
import cerent.cms.ui.ds1e1.Ds1E1MaintenanceTableModel;
import javax.swing.table.TableColumn;

public class Ds1E1LineMaintenancePane
extends Ds1LineMaintenancePane {
    protected TableColumn sendCodeColumn = this.table.getColumn(this.dataModel.getColumnName(4));
    protected TableColumn inhibitLpbkColumn = this.table.getColumn(this.dataModel.getColumnName(7));
    protected TableColumn inhibitBackplaneLpbkColumn = this.table.getColumn(this.dataModel.getColumnName(8));
    protected boolean columnsInitialized = false;
    protected eCardOperMode oldOperMode = null;

    public Ds1E1LineMaintenancePane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView, ds123LineModelArray);
        if (((ModuleModel)this.getUiModel()).getEqType() == 218) {
            this.table.removeColumn(this.inhibitBackplaneLpbkColumn);
        }
    }

    protected Ds123LineMaintTableModel getDataModel() {
        switch (((ModuleModel)this.getUiModel()).getEqType()) {
            case 157: 
            case 218: 
            case 233: 
            case 234: {
                INodeModel iNodeModel = this.uiModel.getNodeModel();
                return new Ds1E1MaintenanceTableModel(iNodeModel, this.lineModels);
            }
        }
        return super.getDataModel();
    }

    protected Attribute[] getAttributeArray(Class clazz) {
        return this.getAttributeMap().getAttributeArray("DS1_E1_56_LINE_CARD." + clazz.getName());
    }

    protected void applyDerivativeChangesToModel(int n) throws WrongInterfaceType, NoSuchInterface, UnsupportedOperation, InvalidState, Busy, EMCProvisionError {
        if (this.dataModel.isDirty(n, 4)) {
            this.lineModels[n].setSendCode(this.dataModel.getSendCodeValFor(n));
        }
        this.lineModels[n].setInhibitLoopback(((Ds1E1MaintenanceTableModel)this.dataModel).getInhibitLoopback(n));
        if (this.dataModel.isDirty(n, 8)) {
            this.lineModels[n].setInhibitBackplaneLoopback(((Ds1E1MaintenanceTableModel)this.dataModel).getInhibitBackplaneLoopback(n));
        }
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        eCardOperMode eCardOperMode2 = ((ModuleModel)this.getUiModel()).getCardOperMode();
        if (this.oldOperMode != eCardOperMode2) {
            this.oldOperMode = eCardOperMode2;
            if (eCardOperMode2 == eCardOperMode.OPER_MODE_DS1E1_E1_ONLY) {
                this.table.removeColumn(this.sendCodeColumn);
                this.table.removeColumn(this.inhibitLpbkColumn);
                this.table.removeColumn(this.inhibitBackplaneLpbkColumn);
            } else if (this.columnsInitialized) {
                this.table.addColumn(this.sendCodeColumn);
                this.table.addColumn(this.inhibitLpbkColumn);
                if (((ModuleModel)this.getUiModel()).getEqType() == 233 || ((ModuleModel)this.getUiModel()).getEqType() == 234) {
                    this.table.addColumn(this.inhibitBackplaneLpbkColumn);
                }
            }
        }
        this.columnsInitialized = true;
    }
}

